package com.elitesland.yst.production.sale.controller.item;
import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.vo.resp.itm.ItmItemBusionessPagingDTO;

import com.elitesland.yst.production.sale.rmi.ystsupport.RmiItemService;
import com.elitesland.yst.production.support.provider.item.dto.ItmItemBusinessRpcPagingDTO;
import com.elitesland.yst.production.support.provider.item.param.ItmItemBusinessRpcPagingParam;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/8/23 19:19
 */
@RestController
@RequestMapping(value = "/item/opera", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(tags = "商品经营目录")
@Slf4j
public class ItemOperaCatalogueController {

    @Autowired
    private RmiItemService rmiItemService;

    @PostMapping(value = "/query")
    @ApiOperation(value = "查询商品经营目录信息")
    @ApiOperationSupport(order = 1)
    public ApiResult<PagingVO<ItmItemBusionessPagingDTO>> query(@RequestBody ItmItemBusinessRpcPagingParam itmItemBusinessRpcPagingParam) {

        PagingVO<ItmItemBusinessRpcPagingDTO> itemBusinessRpcDtoByParam = rmiItemService.findItemBusinessRpcDtoByParam(itmItemBusinessRpcPagingParam);
        AtomicLong id = new AtomicLong(1L);
        List<ItmItemBusinessRpcPagingDTO> records = itemBusinessRpcDtoByParam.getRecords();
        List<ItmItemBusionessPagingDTO> itemBusionessDTOList = records.stream().map(i -> {
            ItmItemBusionessPagingDTO itmItemBusionessPagingDTO = new ItmItemBusionessPagingDTO();
            BeanUtils.copyProperties(i, itmItemBusionessPagingDTO);
            itmItemBusionessPagingDTO.setId(id.getAndAdd(1));
            String lifeStatus = i.getItemLifeStatus();
            itmItemBusionessPagingDTO.setFreeze(false);
            if (!StringUtils.isEmpty(lifeStatus)){
                if (lifeStatus.contains("SALE_FREEZE")){
                    itmItemBusionessPagingDTO.setFreeze(true);
                };
            }
            return itmItemBusionessPagingDTO;
        }).collect(Collectors.toList());
        return ApiResult.ok(new PagingVO<>(itemBusinessRpcDtoByParam.getTotal(), itemBusionessDTOList));
    }
}

