package com.elitesland.yst.production.sale.controller.statistics.app;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.service.SaleStatisticsService;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.SaleStatisticsStoreQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.SaleStatisticsStoreRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.SaleStatisticsTeamRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.StatisticsStoreSumRespVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.util.List;


/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author joker XingShixiang
 * @since 2021-09-01 14:43:56
 */
@RestController
@RequestMapping("/app/statistics")
@Api(value = "销售业绩统计App端", tags = {"销售业绩统计App端"})
@RequiredArgsConstructor
@Slf4j
public class StatisticsAppController {

    private final SaleStatisticsService saleStatisticsService;



    @PostMapping("/page")
    @ApiOperation("销售业绩统计-分页")
    ApiResult<PagingVO<SaleStatisticsStoreRespVO>> page(@RequestBody SaleStatisticsStoreQueryVO paramVO) {
        return ApiResult.ok(saleStatisticsService.appPage(paramVO));
    }

    @PostMapping("/leaderPage")
    @ApiOperation("leaderPage销售业绩统计-分页")
    ApiResult<PagingVO<SaleStatisticsStoreRespVO>> leaderPage(@RequestBody SaleStatisticsStoreQueryVO paramVO) {
        return ApiResult.ok(saleStatisticsService.leaderPage(paramVO));
    }

    @PostMapping("/pageSum")
    @ApiOperation("销售业绩统计-汇总")
    ApiResult<StatisticsStoreSumRespVO> pageSum(@RequestBody SaleStatisticsStoreQueryVO paramVO) {
        return ApiResult.ok(saleStatisticsService.appQerySum(paramVO));
    }


    @PostMapping("/leaderPageSum")
    @ApiOperation("leaderPageSum销售业绩统计-汇总")
    ApiResult<StatisticsStoreSumRespVO> leaderPageSum(@RequestBody SaleStatisticsStoreQueryVO paramVO) {
        return ApiResult.ok(saleStatisticsService.leaderPageSum(paramVO));
    }

    @PostMapping("/detail")
    @ApiOperation("销售业绩统计-详情")
    ApiResult<List<SaleStatisticsStoreRespVO>> detail(@RequestBody SaleStatisticsStoreQueryVO paramVO) {
        return ApiResult.ok(saleStatisticsService.detail(paramVO));
    }

    @PostMapping("/queryByCodes")
    @ApiOperation("销售业绩统计-根据年月查询团队/个人业绩")
    ApiResult<List<SaleStatisticsTeamRespVO>> queryByCodes(@RequestBody SaleStatisticsStoreQueryVO paramVO) {
        return ApiResult.ok(saleStatisticsService.queryByCodes(paramVO));
    }





}


