package com.elitesland.yst.production.sale.convert;

import com.elitescloud.cloudt.core.common.BaseMapperConfig;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.SaleStatisticsDealerRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.SaleStatisticsStoreRespVO;
import com.elitesland.yst.production.sale.api.vo.save.SaleStatisticsDealerSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.SaleStatisticsStoreSaveVO;
import com.elitesland.yst.production.sale.entity.SaleStatisticsDealerDO;
import com.elitesland.yst.production.sale.entity.SaleStatisticsStoreDO;
import com.elitesland.yst.production.sale.search.bean.StatisticsDealerAppDetailsSearchBean;
import com.elitesland.yst.production.sale.search.bean.StatisticsDealerAppSearchBean;
import com.elitesland.yst.production.sale.search.bean.StatisticsDealerSearchBean;
import com.elitesland.yst.production.sale.search.store.bean.StatisticsStoreAppDetailsSearchBean;
import com.elitesland.yst.production.sale.search.store.bean.StatisticsStoreAppSearchBean;
import com.elitesland.yst.production.sale.search.store.bean.StatisticsStoreSearchBean;
import org.mapstruct.Mapper;
import org.mapstruct.factory.Mappers;

/**
 * <p>
 * 功能说明:销售业绩统计-门店
 * </p>
 *
 * @Author wz
 * @Date 2023/06/02
 * @Version 1.0
 * @Content:
 */
@Mapper(config = BaseMapperConfig.class)
public interface StatisticsStoreConvert {
    StatisticsStoreConvert INSTANCE = Mappers.getMapper(StatisticsStoreConvert.class);

    /**
     * saveVO转换DO
     *
     * @param saveVO 入参
     * @return DO
     */
    SaleStatisticsStoreDO saveVoToDo(SaleStatisticsStoreSaveVO saveVO);

    /**
     * DO转换RespVO
     *
     * @param taskInfoDO 入参
     * @return RespVO
     */
    SaleStatisticsDealerRespVO doToRespVo(SaleStatisticsDealerDO taskInfoDO);

    /**
     * BeanSearch转换RespVO
     *
     * @param searchBean 入参
     * @return RespVO
     */
    SaleStatisticsStoreRespVO beanSearchToRespVo(StatisticsStoreSearchBean searchBean);

    /**
     * appBeanSearch转换RespVO
     *
     * @param searchBean 入参
     * @return RespVO
     */
    SaleStatisticsStoreRespVO appBeanSearchToRespVo(StatisticsStoreAppSearchBean searchBean);

    /**
     * appDetailsBeanSearch转换RespVO
     *
     * @param searchBean 入参
     * @return RespVO
     */
    SaleStatisticsStoreRespVO appDetailsBeanSearchToRespVo(StatisticsStoreAppDetailsSearchBean searchBean);
}
