package com.elitesland.yst.production.sale.convert.shop;

import com.elitesland.yst.production.sale.api.dto.BipItemDTO;
import com.elitesland.yst.production.sale.api.dto.BipItemSkuDTO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.*;
import com.elitesland.yst.production.sale.api.vo.resp.shop.app.BipItemAttrAppRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.app.BipItemPicAppRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.app.BipItemRecGoodAppRespVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.*;
import com.elitesland.yst.production.sale.core.mapstruct.CustomMapperConfig;
import com.elitesland.yst.production.sale.entity.BipItemDO;
import com.elitesland.yst.production.sale.entity.BipItemExtDO;
import com.elitesland.yst.production.sale.entity.BipItemPicDO;
import com.elitesland.yst.production.sale.entity.BipItemSkuDO;
import com.elitesland.yst.production.support.provider.item.dto.ItmItemUomConvRpcDTO;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;
import org.mapstruct.factory.Mappers;

import java.util.List;

/**
 * @author Shadow
 * @since 2021-08-10 16:24:35
 */
@Mapper(config = CustomMapperConfig.class)
public interface BipItemConvert {

    BipItemConvert INSTANCE = Mappers.getMapper(BipItemConvert.class);

    /**
     * vo转do
     *
     * @param saveVO vo
     * @return do
     */
    BipItemDO saveVO2DO(BipItemSaveVO saveVO);

    /**
     * vo转do
     *
     * @param updateVO vo
     * @return do
     */
    BipItemDO updateVO2DO(BipItemUpdateVO updateVO);

    /**
     * vo转do
     *
     * @param updateVO vo
     * @param itemDO   itemDO
     */
    void copyUpdateVO2DO(BipItemUpdateVO updateVO, @MappingTarget BipItemDO itemDO);

    /**
     * do转dto
     *
     * @param itemDO do
     * @return dto
     */
    BipItemDTO do2DTO(BipItemDO itemDO);

    /**
     * sku vo 转do
     *
     * @param saveVO sku vo
     * @return do
     */
    BipItemSkuDO skuSaveVO2DO(BipItemSkuSaveVO saveVO);

    /**
     * sku vo 转do
     *
     * @param updateVO sku vo
     * @return do
     */
    BipItemSkuDO skuUpdateVO2DO(BipItemSkuUpdateVO updateVO);

    /**
     * vo转do
     *
     * @param updateVO vo
     * @param skuDO do
     */
    @Mappings({
            @Mapping(target = "id", ignore = true)
    })
    void copySkuVO2DO(BipItemSkuUpdateVO updateVO, @MappingTarget BipItemSkuDO skuDO);

    /**
     * 属性do转vo
     *
     * @param skuDO do
     * @return vo
     */
    BipItemSkuRespVO sku2DetailRespVO(BipItemSkuDO skuDO);

    /**
     * 属性do转vo
     *
     * @param skuDO do
     * @return vo
     */
    BipItemAttrAppRespVO.Sku skuDO2VO(BipItemSkuDO skuDO);

    /**
     * sku do转dto
     *
     * @param skuDO do
     * @return dto
     */
    BipItemSkuDTO skuDO2DTO(BipItemSkuDO skuDO);

    /**
     * pic vo 转 do
     *
     * @param saveVO vo
     * @return do
     */
    BipItemPicDO itemPicSaveVO2DO(BipItemPicSaveVO saveVO);

    /**
     * 商品do转vo
     *
     * @param itemDO do
     * @return vo
     */
    BipItemDetailRespVO itemDO2DetailVO(BipItemDO itemDO);

    /**
     * 商品do转vo
     *
     * @param itemDO do
     * @return vo
     */
    BipItemToShelfRespVO itemDO2ToShelfVO(BipItemDO itemDO);

    /**
     * 商品do转vo
     *
     * @param itemDO do
     * @return vo
     */
    BipItemApproveRespVO itemDO2ToApproveVO(BipItemDO itemDO);

    /**
     * 扩展信息往商品中复制
     *
     * @param extDO  扩展信息
     * @param respVO 商品信息
     */
    @Mappings({
            @Mapping(target = "id", ignore = true),
            @Mapping(target = "creator", ignore = true),
            @Mapping(target = "createTime", ignore = true)
    })
    void do2ApproveVO(BipItemExtDO extDO, @MappingTarget BipItemApproveRespVO respVO);

    /**
     * 商品do转vo
     *
     * @param itemDO do
     * @return vo
     */
    BipItemOnShelfRespVO itemDO2OnShelfVO(BipItemDO itemDO);

    /**
     * 商品do转vo
     *
     * @param itemDO do
     * @return vo
     */
    BipItemOffShelfRespVO itemDO2OffShelfVO(BipItemDO itemDO);


    /**
     * 商品图片do转vo
     *
     * @param itemPicDO do
     * @return vo
     */
    BipItemPicRespVO itemPic2DetailRespVO(BipItemPicDO itemPicDO);

    /**
     * 商品图片do转vo
     *
     * @param itemPicDO do
     * @return vo
     */
    BipItemPicAppRespVO itemPic2RespVO(BipItemPicDO itemPicDO);

    /**
     * 商品DO转VO
     *
     * @param itemDO do
     * @return vo
     */
    BipItemRecGoodAppRespVO itemDOS2RecomVO(BipItemDO itemDO);

    /**
     * 单位dto转vo
     *
     * @param dto dto
     * @return vo
     */
    List<BipItemUomConvertRespVO> itemConvertDTO2VO(List<ItmItemUomConvRpcDTO> dto);
}

