package com.elitesland.yst.production.sale.entity;

import com.elitesland.yst.production.sale.core.convert.BigDecimalConvert;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/08/04/11:23
 * @Description:商品实体类
 */

@Entity
@Table(name = "bip_item", indexes = {
        @Index(name = "idx_bip_item_shelf_code", columnList = "shelf_code"),
        @Index(name = "idx_bip_item_category_id1", columnList = "category_id1"),
        @Index(name = "idx_bip_item_category_id2", columnList = "category_id2"),
        @Index(name = "idx_bip_item_category_id3", columnList = "category_id3"),
        @Index(name = "idx_bip_item_item_id", columnList = "item_id", unique = true),
        @Index(name = "idx_bip_item_fare_tmpl_id", columnList = "fare_tmpl_id"),
        @Index(name = "idx_bip_item_state", columnList = "state"),
        @Index(name = "idx_bip_item_ou_id", columnList = "ou_id"),
})
@org.hibernate.annotations.Table(appliesTo = "bip_item", comment = "商品")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class BipItemDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = -4441535653912235097L;

    @Column(name = "shelf_code", columnDefinition = "varchar(64) default '' comment '上架编码'")
    private String shelfCode;

    @Column(name = "category_id1", columnDefinition = "bigint(20) comment '一级商品分类'")
    private Long categoryId1;

    @Column(name = "category_name1", columnDefinition = "varchar(64) default '' comment '一级商品分类'")
    private String categoryName1;

    @Column(name = "category_id2", columnDefinition = "bigint(20) comment '二级商品分类'")
    private Long categoryId2;

    @Column(name = "category_name2", columnDefinition = "varchar(64) default '' comment '二级商品分类'")
    private String categoryName2;

    @Column(name = "category_id3", columnDefinition = "bigint(20) comment '三级商品分类'")
    private Long categoryId3;

    @Column(name = "category_name3", columnDefinition = "varchar(64) default '' comment '三级商品分类'")
    private String categoryName3;

    @Column(name = "item_id", columnDefinition = "bigint(20) not null comment '商品ID'")
    private Long itemId;

    @Column(name = "item_code", columnDefinition = "varchar(64) not null comment '商品编码，SPU'")
    private String itemCode;

    @Column(name = "item_name", columnDefinition = "varchar(256) not null comment '商品名称'")
    private String itemName;

    @Column(name = "ou_id", columnDefinition = "bigint(20) not null comment '所属公司ID'")
    private Long ouId;

    @Column(name = "ou_code", columnDefinition = "varchar(32) comment '所属公司编码'")
    private String ouCode;

    @Column(name = "ou_name", columnDefinition = "varchar(128) not null comment '所属公司名称'")
    private String ouName;

    @Column(name = "bu_id", columnDefinition = "bigint(20) comment '组织ID'")
    private Long buId;

    @Column(name = "bu_code", columnDefinition = "varchar(32) comment '组织编码'")
    private String buCode;

    @Column(name = "bu_name", columnDefinition = "varchar(128) comment '组织名称'")
    private String buName;

    @Column(name = "title", columnDefinition = "varchar(256) not null comment '商品标题'")
    private String title;

    @Column(name = "fare_free", columnDefinition = "tinyint(1) default 0 comment '是否包邮'")
    private Boolean fareFree;

    @Column(name = "fare_tmpl_id", columnDefinition = "bigint(20) comment '运费模板ID'")
    private Long fareTmplId;

    @Column(name = "fare_tmpl_code", columnDefinition = "varchar(128) default '' comment '运费模板编号'")
    private String fareTmplCode;

    @Column(name = "fare_tmpl_name", columnDefinition = "varchar(256)  default '' comment '运费模板名称'")
    private String fareTmplName;

    @Column(name = "main_pic_id", columnDefinition = "bigint(20) comment '主图ID'")
    private Long mainPicId;

    @Column(name = "main_pic_file_code", columnDefinition = "varchar(64) default '' comment '主图的文件编码'")
    private String mainPicFileCode;

    @Column(name = "main_pic_url", columnDefinition = "varchar(2048) default '' comment '主图的访问链接'")
    private String mainPicUrl;

    @Column(name = "ext_id", columnDefinition = "bigint(20) comment '商品扩展信息ID'")
    private Long extId;

    @Column(name = "state", columnDefinition = "varchar(32) comment '商品状态，[UDC]SAL:ITEM_STATE'")
    private String state;

    @Column(name = "on_shelf", columnDefinition = "tinyint(1) default 0 comment '是否已上架'")
    private Boolean onShelf;

    @Column(name = "shelf", columnDefinition = "tinyint(1) default 0 comment '是否上架过，上架过的商品不可删除'")
    private Boolean shelf;

    @Column(name = "lack_stock", columnDefinition = "tinyint(1) default 0 comment '是否存在库存为0的SKU'")
    private Boolean lackStock;

    @Convert(converter = BigDecimalConvert.class)
    @Column(name = "price", columnDefinition = "decimal(20, 2) default null  comment '基础价'")
    private BigDecimal price;

    @Column(name = "num_sale", columnDefinition = "bigint(20) default 0 comment '总销量'")
    private Long numSale;

    @Column(name = "num_sale_90", columnDefinition = "bigint(20) default 0 comment '最近90天的销量'")
    private Long numSale90;

    @Column(name = "num_eval", columnDefinition = "bigint(20) default 0 comment '总评价数'")
    private Long numEval;

    @Column(name = "num_eval_good", columnDefinition = "bigint(20) default 0 comment '好评数量'")
    private Long numEvalGood;

    @Column(name = "rate_eval_good", columnDefinition = "decimal(8, 2) default 0  comment '好评率，好评数/总评价数'")
    private BigDecimal rateEvalGood;

    @Column(name = "score_eval", columnDefinition = "decimal(8, 2) default 0  comment '好评率，分值形式'")
    private BigDecimal scoreEval;

    @Column(name = "time_on_shelf", columnDefinition = "datetime default null  comment '上架时间'")
    private LocalDateTime timeOnShelf;

    @Column(name = "time_off_shelf", columnDefinition = "datetime default null  comment '下架时间'")
    private LocalDateTime timeOffShelf;

    @Column(name = "off_shelf_reason", columnDefinition = "varchar(32) default null comment '商品下架原因，[UDC]SAL:ITEM_OFF_SHELF'")
    private String offShelfReason;
}
