package com.elitesland.yst.production.sale.entity;

import com.elitesland.yst.production.sale.core.convert.BigDecimalConvert;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.boot.common.convert.BooleanToIntegerConverter;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/6/8 8:07 下午
 */
@Entity
@Table(name = "sal_contract_d")
@org.hibernate.annotations.Table(appliesTo = "sal_contract_d", comment = "销售合同明细")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class SalContractDDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = -4276001312464511760L;

    @ApiModelProperty(value = "主表ID")
    @Column(name = "mas_id", columnDefinition = "bigint(20) default null comment '主表ID'")
    private Long masId;

    @Convert(converter = BigDecimalConvert.class)
    @Column(name = "line_no", columnDefinition = "decimal(20, 2) default null  comment '行号'")
    private BigDecimal lineNo;

    @ApiModelProperty(value = "商品ID")
    @Column(name = "item_id", columnDefinition = "bigint(20) default null comment '商品ID'")
    private Long itemId;

    @ApiModelProperty(value = "商品编号")
    @Column(name = "item_code", columnDefinition = "varchar(40) default null comment '商品编号'")
    private String itemCode;

    @ApiModelProperty(value = "商品名称")
    @Column(name = "item_name", columnDefinition = "varchar(255) default null  comment '商品名称'")
    private String itemName;

    @ApiModelProperty(value = "商品名称2")
    @Column(name = "item_name2", columnDefinition = "varchar(255) default null  comment '商品名称2'")
    private String itemName2;

    @ApiModelProperty(value = "商品规格")
    @Column(name = "item_spec", columnDefinition = "varchar(255) default null comment '商品规格'")
    private String itemSpec;

    @ApiModelProperty(value = "品牌")
    @Column(name = "item_brand", columnDefinition = "varchar(60) default null comment '品牌'")
    private String itemBrand;

    @ApiModelProperty(value = "客户商品编号")
    @Column(name = "cust_item_code", columnDefinition = "varchar(40) default null comment '客户商品编号'")
    private String custItemCode;

    @ApiModelProperty(value = "是否供应商代发")
    @Column(name = "supp_flag", columnDefinition = "tinyint(1) default null comment '是否供应商代发'")
    @Convert(converter = BooleanToIntegerConverter.class)
    private Boolean suppFlag;

    @ApiModelProperty(value = "供应商ID")
    @Column(name = "supp_id", columnDefinition = "bigint(20) default 0 comment '供应商ID'")
    private Integer suppId;

    @ApiModelProperty(value = "数量")
    @Column(name = "qty", columnDefinition = "decimal(20, 8) default null comment '数量'")
    private BigDecimal qty;

    @ApiModelProperty(value = "计量单位")
    @Column(name = "uom", columnDefinition = "varchar(10) default null comment '计量单位'")
    private String uom;

    @ApiModelProperty(value = "含税价格")
    @Column(name = "price", columnDefinition = "decimal(20, 8) default null comment '含税价格'")
    private BigDecimal price;

    @ApiModelProperty(value = "不含税价格")
    @Column(name = "net_price", columnDefinition = "decimal(20, 8) default null comment '不含税价格'")
    private BigDecimal netPrice;

    @ApiModelProperty(value = "税码")
    @Column(name = "tax_code", columnDefinition = "varchar(40) default null comment '税码'")
    private String taxCode;

    @ApiModelProperty(value = "税率编号")
    @Column(name = "tax_rate_no", columnDefinition = "varchar(40) default null comment '税率编号'")
    private String taxRateNo;

    @ApiModelProperty("税率描述")
    @Column(name = "tax_rate_desc", columnDefinition = "varchar(40) default null comment '税率描述'")
    private String taxRateDesc;

    @ApiModelProperty(value = "税率")
    @Column(name = "tax_rate", columnDefinition = "decimal(20, 8) default null comment '税率'")
    private BigDecimal taxRate;

    @ApiModelProperty(value = "税额")
    @Column(name = "tax_amt", columnDefinition = "decimal(20, 2) default null comment '税额'")
    private BigDecimal taxAmt;

    @ApiModelProperty(value = "含税金额")
    @Column(name = "amt", columnDefinition = "decimal(20, 2) default null comment '含税金额'")
    private BigDecimal amt;

    @ApiModelProperty(value = "不含税金额")
    @Column(name = "net_amt", columnDefinition = "decimal(20, 2) default null comment '不含税金额'")
    private BigDecimal netAmt;

    @ApiModelProperty(value = "折扣率")
    @Column(name = "disc_ratio", columnDefinition = "decimal(20, 8) default null comment '折扣率'")
    private BigDecimal discRatio;

    @ApiModelProperty(value = "折扣未税额")
    @Column(name = "disc_net_amt", columnDefinition = "decimal(20, 2) default null comment '折扣未税额'")
    private BigDecimal discNetAmt;

    @ApiModelProperty(value = "折扣含税额")
    @Column(name = "disc_amt", columnDefinition = "decimal(20, 2) default null comment '折扣含税额'")
    private BigDecimal discAmt;

    @ApiModelProperty(value = "基础价格")
    @Column(name = "base_price", columnDefinition = "decimal(20, 8) default null comment '基础价格'")
    private BigDecimal basePrice;

    @ApiModelProperty(value = "单个净重")
    @Column(name = "single_net_weight", columnDefinition = "decimal(20, 8) default null comment '单个净重'")
    private BigDecimal singleNetWeight;

    @ApiModelProperty(value = "净重")
    @Column(name = "net_weight", columnDefinition = "decimal(20, 8) default null comment '净重'")
    private BigDecimal netWeight;

    @ApiModelProperty(value = "单个毛重")
    @Column(name = "single_gross_weight", columnDefinition = "decimal(20, 8) default null comment '单个毛重'")
    private BigDecimal singleGrossWeight;

    @ApiModelProperty(value = "毛重")
    @Column(name = "gross_weight", columnDefinition = "decimal(20, 8) default null comment '毛重'")
    private BigDecimal grossWeight;

    @ApiModelProperty(value = "重量单位")
    @Column(name = "weight_uom", columnDefinition = "varchar(10) default null comment '重量单位'")
    private String weightUom;

    @ApiModelProperty(value = "单个体积")
    @Column(name = "single_volume", columnDefinition = "decimal(20, 8) default null comment '单个体积'")
    private BigDecimal singleVolume;

    @ApiModelProperty(value = "体积")
    @Column(name = "volume", columnDefinition = "decimal(20, 8) default null comment '体积'")
    private BigDecimal volume;

    @ApiModelProperty(value = "体积单位")
    @Column(name = "volume_uom", columnDefinition = "varchar(10) default null  comment '体积单位'")
    private String volumeUom;

    @ApiModelProperty(value = "运输方式")
    @Column(name = "trans_type", columnDefinition = "varchar(40) default null  comment '运输方式 [UDC]COM:TP_TYPE'")
    private String transType;

}
