package com.elitesland.yst.production.sale.event.listener;

import com.elitesland.yst.production.sale.api.dto.PriceAlterDTO;
import com.elitesland.yst.production.sale.entity.BipItemSkuDO;
import com.elitesland.yst.production.sale.event.ItemPriceAlterEvent;
import com.elitesland.yst.production.sale.repo.shop.BipItemSkuRepo;
import com.elitesland.yst.production.sale.repo.shop.BipItemSkuRepoProc;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

import java.util.concurrent.CompletableFuture;

/**
 * @author Shadow（li qun）
 * @since 2021-12-07 10:08
 */
@Slf4j
@Component
public class ItemPriceAlterListener implements ApplicationListener<ItemPriceAlterEvent> {

    @Autowired
    private BipItemSkuRepoProc bipItemSkuRepoProc;

    @Autowired
    private BipItemSkuRepo bipItemSkuRepo;

    @Override
    public void onApplicationEvent(ItemPriceAlterEvent event) {
        log.info("监听到价格变更事件：{}", event.getPriceAlterDTOS());

        CompletableFuture.runAsync(() -> handlePriceAlter(event))
                .exceptionally(e -> {
                    log.error("处理商品价格变更事件失败", e);
                    return null;
                });
    }

    private void handlePriceAlter(ItemPriceAlterEvent event){
        for (PriceAlterDTO alterDTO : event.getPriceAlterDTOS()) {
            BipItemSkuDO sku = bipItemSkuRepoProc.findSkuOnOuId(alterDTO.getOuId(), alterDTO.getSkuCode());
            if (sku!=null){
                sku.setPriceOld(sku.getPrice());
                sku.setPrice(alterDTO.getPrice());
                bipItemSkuRepo.save(sku);
            }
        }
    }
}
