package com.elitesland.yst.production.sale.repo;

import com.elitesland.yst.production.sale.api.vo.param.menu.BusFirstMenuConfPagingParam;
import com.elitesland.yst.production.sale.api.vo.resp.menu.BusFirstMenuConfVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.entity.BusFirstMenuConfDO;
import com.elitesland.yst.production.sale.entity.QBusFirstMenuConfDO;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.security.util.DataAuthJpaUtil;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.List;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

@Component
@RequiredArgsConstructor
public class BusFirstMenuConfRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private final QBusFirstMenuConfDO qBusFirstMenuConfDO = QBusFirstMenuConfDO.busFirstMenuConfDO;

    public PagingVO<BusFirstMenuConfVO> findMenuConfPagingResult(BusFirstMenuConfPagingParam param){
        JPAQuery<BusFirstMenuConfVO> query = selectFromWhere(BusFirstMenuConfVO.class,param);
        param.setPaging(query);
        param.fillOrders(query,qBusFirstMenuConfDO);
        return PagingVO.<BusFirstMenuConfVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }

    private <T> JPAQuery<T> selectFromWhere(Class<T> cls, BusFirstMenuConfPagingParam param){
        return jpaQueryFactory.select(Projections.bean(cls,
                qBusFirstMenuConfDO.id,
                qBusFirstMenuConfDO.imgSign,
                qBusFirstMenuConfDO.menuNo,
                qBusFirstMenuConfDO.menuName,
                qBusFirstMenuConfDO.menuSort,
                qBusFirstMenuConfDO.status,
                qBusFirstMenuConfDO.modifyTime,
                qBusFirstMenuConfDO.createTime,
                qBusFirstMenuConfDO.createUserId,
                qBusFirstMenuConfDO.ouId,
                qBusFirstMenuConfDO.ouName,
                qBusFirstMenuConfDO.creator,
                qBusFirstMenuConfDO.remark)).from(qBusFirstMenuConfDO).where(where(param));
    }

    public Predicate where(BusFirstMenuConfPagingParam param){
        List<Predicate> predicate = new ArrayList<>();
        if(null != param.getOuId()){
            predicate.add(qBusFirstMenuConfDO.ouId.eq(param.getOuId()));
        }else {
            predicate.add(DataAuthJpaUtil.dataAuthJpaPredicate(qBusFirstMenuConfDO.getMetadata()));
        }
        if(StringUtils.isNotBlank(param.getMenuNo())){
            predicate.add(qBusFirstMenuConfDO.menuNo.like("%" + param.getMenuNo() + "%"));
        }
        if(StringUtils.isNotBlank(param.getMenuName())){
            predicate.add(qBusFirstMenuConfDO.menuName.like("%" + param.getMenuName() + "%"));
        }
        if(StringUtils.isNotBlank(param.getStatus())){
            predicate.add(qBusFirstMenuConfDO.status.eq(param.getStatus()));
        }
        predicate.add(qBusFirstMenuConfDO.deleteFlag.isNull().or(qBusFirstMenuConfDO.deleteFlag.eq(0)));
        return ExpressionUtils.allOf(predicate);
    }


    public List<BusFirstMenuConfDO> randomSelect(){
        List<BusFirstMenuConfDO> fetch = jpaQueryFactory.select(qBusFirstMenuConfDO).from(qBusFirstMenuConfDO)
                .where(qBusFirstMenuConfDO.status.eq(UdcEnum.COM_STATUS_ACTIVEORNO_ACTIVE.getValueCode())
                        .and(qBusFirstMenuConfDO.deleteFlag.isNull().or(qBusFirstMenuConfDO.deleteFlag.eq(0)))).limit(10)
                .fetch();

        return fetch;
    }


    public List<BusFirstMenuConfDO> selectForHome(Long ouId){
        List<BusFirstMenuConfDO> fetch = jpaQueryFactory.select(qBusFirstMenuConfDO).from(qBusFirstMenuConfDO)
                .where(qBusFirstMenuConfDO.status.eq(UdcEnum.COM_STATUS_ACTIVEORNO_ACTIVE.getValueCode())
                        .and(qBusFirstMenuConfDO.ouId.eq(ouId))
                        .and(qBusFirstMenuConfDO.deleteFlag.isNull().or(qBusFirstMenuConfDO.deleteFlag.eq(0))))
                .fetch();

        return fetch;
    }



}
