package com.elitesland.yst.production.sale.repo;

import com.elitesland.yst.production.sale.common.constant.ConstantsSale;
import com.elitesland.yst.production.sale.entity.QSalAcceptanceDO;
import com.elitesland.yst.production.sale.entity.QSalQuotationDO;
import com.querydsl.jpa.impl.JPAQueryFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/9/1 10:02
 */
@Repository
public class SalAcceptanceRepoProc {

    @Autowired
    private JPAQueryFactory jpaQueryFactory;

    private final QSalAcceptanceDO qSalAcceptanceDO = QSalAcceptanceDO.salAcceptanceDO;

    public Long getOuIdById(Long id) {
        return jpaQueryFactory.select(qSalAcceptanceDO.ouId)
                .from(qSalAcceptanceDO)
                .where(qSalAcceptanceDO.id.eq(id).and(qSalAcceptanceDO.deleteFlag.ne(ConstantsSale.COMMON_DELETE_YSE)))
                .fetchOne();
    }
}
