package com.elitesland.yst.production.sale.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.SaleStatisticsDealerDtlQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.SaleStatisticsDealerDtlRespVO;
import com.elitesland.yst.production.sale.entity.QSaleStatisticsDealerDO;
import com.elitesland.yst.production.sale.entity.QSaleStatisticsDealerDtlDO;
import com.elitesland.yst.production.sale.entity.SaleStatisticsDealerDtlDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;


/**
 * @author : WWW
 * @date : 2023-6-1
 * @desc : 销售业绩统计-经销商-明细RepoProc
 */

@Component
public class SaleStatisticsDealerDtlRepoProc extends BaseRepoProc<SaleStatisticsDealerDtlDO> {

    private static final QSaleStatisticsDealerDtlDO qSaleStatisticsDealerDtlDO = QSaleStatisticsDealerDtlDO.saleStatisticsDealerDtlDO;
    private static final QSaleStatisticsDealerDO qSaleStatisticsDealerDO = QSaleStatisticsDealerDO.saleStatisticsDealerDO;

    protected SaleStatisticsDealerDtlRepoProc() {
        super(qSaleStatisticsDealerDtlDO);
    }

    public List<SaleStatisticsDealerDtlRespVO> selectByQueryVO(SaleStatisticsDealerDtlQueryVO queryVO) {
        List<Predicate> where = where(queryVO);
        JPAQuery<SaleStatisticsDealerDtlRespVO> jpaQuery = select(SaleStatisticsDealerDtlRespVO.class).where(ExpressionUtils.allOf(where));
        return jpaQuery.fetch();
    }

    public PagingVO<SaleStatisticsDealerDtlRespVO> page(SaleStatisticsDealerDtlQueryVO queryVO) {
        List<Predicate> where = where(queryVO);
        JPAQuery<SaleStatisticsDealerDtlRespVO> query = select(SaleStatisticsDealerDtlRespVO.class).where(ExpressionUtils.allOf(where));
        queryVO.setPaging(query);
        queryVO.fillOrders(query, qSaleStatisticsDealerDtlDO);
        return PagingVO.<SaleStatisticsDealerDtlRespVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }

    private List<Predicate> where(SaleStatisticsDealerDtlQueryVO queryVO) {
        List<Predicate> predicates = new ArrayList<>();
        //predicates.add(qSaleStatisticsDealerDtlDO.deleteFlag.eq(0).or(qSaleStatisticsDealerDtlDO.deleteFlag.isNull()));

        if (!Objects.isNull(queryVO.getId())) {
            predicates.add(qSaleStatisticsDealerDtlDO.id.eq(queryVO.getId()));
        }
        if (!CollectionUtils.isEmpty(queryVO.getIds())) {
            predicates.add(qSaleStatisticsDealerDtlDO.id.in(queryVO.getIds()));
        }
        if (!Objects.isNull(queryVO.getMasId())) {
            predicates.add(qSaleStatisticsDealerDtlDO.masId.eq(queryVO.getMasId()));
        }
        if (!CollectionUtils.isEmpty(queryVO.getMasIds())) {
            predicates.add(qSaleStatisticsDealerDtlDO.masId.in(queryVO.getMasIds()));
        }
        if (!StringUtils.isEmpty(queryVO.getLevel())) {
            predicates.add(qSaleStatisticsDealerDtlDO.level.eq(queryVO.getLevel()));
        }
        if (!CollectionUtils.isEmpty(queryVO.getLevels())) {
            predicates.add(qSaleStatisticsDealerDtlDO.level.in(queryVO.getLevels()));
        }
        if (!StringUtils.isEmpty(queryVO.getCode())) {
            predicates.add(qSaleStatisticsDealerDtlDO.code.eq(queryVO.getCode()));
        }
        if (!CollectionUtils.isEmpty(queryVO.getCodes())) {
            predicates.add(qSaleStatisticsDealerDtlDO.code.in(queryVO.getCodes()));
        }
        if (!StringUtils.isEmpty(queryVO.getName())) {
            predicates.add(qSaleStatisticsDealerDtlDO.name.like("%" + queryVO.getName() + "%"));
        }
        if (!StringUtils.isEmpty(queryVO.getType())) {
            predicates.add(qSaleStatisticsDealerDtlDO.type.eq(queryVO.getType()));
        }
        if (!CollectionUtils.isEmpty(queryVO.getTypes())) {
            predicates.add(qSaleStatisticsDealerDtlDO.type.in(queryVO.getTypes()));
        }


        return predicates;
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qSaleStatisticsDealerDtlDO.id,
                qSaleStatisticsDealerDtlDO.masId,
                qSaleStatisticsDealerDtlDO.level,
                qSaleStatisticsDealerDtlDO.code,
                qSaleStatisticsDealerDtlDO.name,
                qSaleStatisticsDealerDtlDO.type,
                qSaleStatisticsDealerDtlDO.remark,
                qSaleStatisticsDealerDtlDO.createTime,
                qSaleStatisticsDealerDtlDO.createUserId,
                qSaleStatisticsDealerDtlDO.creator,
                qSaleStatisticsDealerDtlDO.modifyTime,
                qSaleStatisticsDealerDtlDO.modifyUserId,
                qSaleStatisticsDealerDtlDO.updater,
                qSaleStatisticsDealerDtlDO.tenantId,
                qSaleStatisticsDealerDtlDO.deleteFlag
        )).from(qSaleStatisticsDealerDtlDO);
    }

    public void updateDeleteFlag(Integer deleteFlag, Long masId) {
        jpaQueryFactory.update(qSaleStatisticsDealerDtlDO)
                .set(qSaleStatisticsDealerDtlDO.deleteFlag, deleteFlag)
                .where(qSaleStatisticsDealerDtlDO.masId.eq(masId))
                .execute();
    }

    public void updateDeleteFlagBatch(Integer deleteFlag, List<Long> masIds) {
        jpaQueryFactory.update(qSaleStatisticsDealerDtlDO)
                .set(qSaleStatisticsDealerDtlDO.deleteFlag, deleteFlag)
                .where(qSaleStatisticsDealerDtlDO.masId.in(masIds))
                .execute();
    }

    public List<SaleStatisticsDealerDtlRespVO> selectPidByQueryVO(SaleStatisticsDealerDtlQueryVO queryVO) {
        List<Predicate> where = where(queryVO);
        JPAQuery<SaleStatisticsDealerDtlRespVO> jpaQuery = selectPid(SaleStatisticsDealerDtlRespVO.class).where(ExpressionUtils.allOf(where));
        jpaQuery.groupBy(qSaleStatisticsDealerDO.id);
        return jpaQuery.fetch();
    }

    private <T> JPAQuery<T> selectPid(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qSaleStatisticsDealerDO.id.as("pid")
        )).from(qSaleStatisticsDealerDO).leftJoin(qSaleStatisticsDealerDtlDO)
                .on(qSaleStatisticsDealerDO.id.eq(qSaleStatisticsDealerDtlDO.masId))
                .where(qSaleStatisticsDealerDO.deleteFlag.eq(0));
    }
}

