package com.elitesland.yst.production.sale.repo.shop;

import com.elitesland.yst.production.sale.api.vo.param.shop.BipRotationChartQueryParamVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipRetationChartVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.entity.BipRetationChartDO;
import com.elitesland.yst.production.sale.entity.QBipRetationChartDO;
import com.querydsl.core.types.dsl.Expressions;
import org.springframework.util.StringUtils;

import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import lombok.val;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Shadow
 * @since 2021-08-11 15:20:07
 */
@Component
@RequiredArgsConstructor
public class BipRotationChartRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    /**
     * 查询字段
     */
    public JPAQuery<BipRetationChartVO> select(BipRotationChartQueryParamVO param) {
        QBipRetationChartDO jpaQDo = QBipRetationChartDO.bipRetationChartDO;
        JPAQuery<BipRetationChartVO> jpaQuery = jpaQueryFactory.select(Projections.bean(BipRetationChartVO.class,
                jpaQDo.id,
                jpaQDo.offsetId,
                jpaQDo.offsetCode,
                jpaQDo.offsetName,
                jpaQDo.giftId,
                jpaQDo.status,
                jpaQDo.giftCode,
                jpaQDo.giftName,
                jpaQDo.retationDesc,
                jpaQDo.priority,
                jpaQDo.picId,
                jpaQDo.imageSize,
                jpaQDo.lastTime,
                jpaQDo.stime,
                jpaQDo.etime
        )).from(jpaQDo);
        if (param != null) {
            jpaQuery.where(where(param));
        }
        return jpaQuery;
    }

    /**
     * 条件查询
     *
     * @param param 查询条件
     */
    public Predicate where(BipRotationChartQueryParamVO param) {
        val jpaQDo = QBipRetationChartDO.bipRetationChartDO;
        Predicate predicate = Expressions.ONE.eq(Expressions.ONE);
        if (!StringUtils.isEmpty(param.getId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.id.eq(param.getId()));
        }
        if (!StringUtils.isEmpty(param.getOuId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.ouId.eq(param.getOuId()));
        }
        if (!StringUtils.isEmpty(param.getOuCode())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.ouCode.eq(param.getOuCode()));
        }
        if (!StringUtils.isEmpty(param.getOffsetId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.offsetId.eq(param.getOffsetId()));
        }
        if (!StringUtils.isEmpty(param.getOffsetCode())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.offsetCode.eq(param.getOffsetCode()));
        }
        if (!StringUtils.isEmpty(param.getStatus())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.status.eq(param.getStatus()));
        }
        if (!StringUtils.isEmpty(param.getOffsetName())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.offsetName.eq(param.getOffsetName()));
        }
        if (!StringUtils.isEmpty(param.getGiftId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.giftId.eq(param.getGiftId()));
        }
        if (!StringUtils.isEmpty(param.getGiftCode())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.giftCode.eq(param.getGiftCode()));
        }
        if (!StringUtils.isEmpty(param.getGiftCname())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.giftName.eq(param.getGiftCname()));
        }
        if (!StringUtils.isEmpty(param.getRetationDesc())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.retationDesc.eq(param.getRetationDesc()));
        }
        if (!StringUtils.isEmpty(param.getPriority())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.priority.eq(param.getPriority()));
        }
        if (!StringUtils.isEmpty(param.getPicId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.picId.eq(param.getPicId()));
        }
        if (!StringUtils.isEmpty(param.getLastTime())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.lastTime.eq(param.getLastTime()));
        }
        if ((!StringUtils.isEmpty(param.getStime()))&&(!StringUtils.isEmpty(param.getEtime()))) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.stime.after(param.getStime()).and(jpaQDo.etime.before(param.getEtime())));
        }
        if ((!StringUtils.isEmpty(param.getStime()))&&StringUtils.isEmpty(param.getEtime())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.stime.after(param.getStime()));
        }
        if (StringUtils.isEmpty(param.getStime())&&(!StringUtils.isEmpty(param.getEtime()))) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.etime.before(param.getEtime()));
        }

        return predicate;
    }

    /**
     * 更新状态 标记
     *
     * @param ids id列表
     * @param status 轮播图状态
     */
    public void updateStatusBatch(List<Long> ids, String status) {
        val jpaQDo = QBipRetationChartDO.bipRetationChartDO;
        jpaQueryFactory.update(jpaQDo)
                .set(jpaQDo.status, status)
                .where(jpaQDo.id.in(ids))
                .execute();
    }


    public List<BipRetationChartVO> homeSlideshow(Long ouId){
        val jpaQDo = QBipRetationChartDO.bipRetationChartDO;
        JPAQuery<BipRetationChartVO> jpaQuery = jpaQueryFactory.select(Projections.bean(BipRetationChartVO.class,
                jpaQDo.id,
                jpaQDo.ouId,
                jpaQDo.ouCode,
                jpaQDo.ouName,
                jpaQDo.offsetCode,
                jpaQDo.offsetName,
                jpaQDo.status,
                jpaQDo.retationDesc,
                jpaQDo.priority,
                jpaQDo.picId,
                jpaQDo.imageSize,
                jpaQDo.lastTime,
                jpaQDo.stime,
                jpaQDo.etime
        )).from(jpaQDo)
                .where(jpaQDo.status.eq(UdcEnum.COM_STATUS_ACTIVEORNO_ACTIVE.getValueCode())
                        .and(jpaQDo.stime.before(LocalDateTime.now()))
                        .and(jpaQDo.etime.after(LocalDateTime.now()))
                        .and(jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()))
                        .and(jpaQDo.priority.isNotNull())
                        .and(jpaQDo.priority.isNotEmpty())
                        .and(jpaQDo.ouId.eq(ouId)))
                .orderBy(jpaQDo.priority.asc());

        return jpaQuery.fetch();
    }

    public boolean judgeActive(BipRetationChartDO rotationChartDO){
        val jpaQDo = QBipRetationChartDO.bipRetationChartDO;

        LocalDateTime now = LocalDateTime.now();

        // 时间冲突 优先级冲突 公司冲突 状态冲突
        return jpaQueryFactory.select(jpaQDo.count()).from(jpaQDo)
                .where(jpaQDo.status.eq(UdcEnum.COM_STATUS_ACTIVEORNO_ACTIVE.getValueCode())
                        .and(jpaQDo.stime.loe(now))
                        .and(jpaQDo.etime.goe(now))
                        .and(jpaQDo.id.ne(rotationChartDO.getId()))
                        .and(jpaQDo.ouId.eq(rotationChartDO.getOuId()))
                        .and(jpaQDo.priority.eq(rotationChartDO.getPriority()))
                        .and(jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull())))
                .limit(1)
                .fetchOne()==0;
    }
}

