package com.elitesland.yst.production.sale.repo.shop;

import com.elitesland.yst.production.sale.entity.MktGiftDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * <p>
 * 赠品 repo
 * </p>
 *
 * @author ssy
 * @since 2021/8/23
 */
public interface MktGiftRepo extends JpaRepository<MktGiftDO, Long>, QuerydslPredicateExecutor<MktGiftDO> {

    MktGiftDO findMktGiftDOByIdAndSkuCode(Long id,String skuCode);

    List<MktGiftDO> findByIdIn(List<Long> ids);

    @Transactional//事务的注解
    @Modifying//增删改必须有这个注解
    @Query(value = "update mkt_gift set stockNum=stockNum- ?1 where item_id=?2 and sku_code=?3 and stock>?1", nativeQuery = true)
    public void updateMktGiftStoucNum(Long num,Long itemId,String skuCode);

    @Transactional//事务的注解
    @Modifying//增删改必须有这个注解
    @Query(value = "update mkt_gift set stock_now_num=stock_now_num - 1 where id in ?1 ", nativeQuery = true)
    public void updateMktGiftById(List<Long> ids);

    @Transactional//事务的注解
    @Modifying//增删改必须有这个注解
    @Query(value = "update mkt_gift set stock_now_num=stock_now_num + 1 where id in ?1 ", nativeQuery = true)
    public void addMktGiftById(List<Long> ids);
}
