/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.config.cas;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.provider.TenantDataIsolateProvider;
import com.elitescloud.boot.tenant.client.common.TenantProvider;
import com.elitescloud.cloudt.authorization.sdk.cas.model.AuthUserDTO;
import com.elitescloud.cloudt.common.common.CloudtOptional;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.yst.production.sale.api.service.ComSaleFileInfoService;
import com.elitesland.yst.production.sale.api.vo.resp.com.ComSaleFileComVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CustAccountVO;
import com.elitesland.yst.production.sale.config.cas.UserSourceService;
import com.elitesland.yst.production.sale.entity.CustAccountDO;
import com.elitesland.yst.production.sale.repo.CustAccountRepo;
import com.elitesland.yst.production.sale.repo.CustAccountRepoProc;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysRoleService;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class UserSourceServiceImpl
implements UserSourceService {
    private static final Logger log = LogManager.getLogger(UserSourceServiceImpl.class);
    @Autowired
    private CustAccountRepoProc custAccountRepoProc;
    @Autowired
    private CustAccountRepo custAccountRepo;
    @Autowired
    private TenantProvider tenantProvider;
    @Autowired
    private RmiSysRoleService rmiSysRoleService;
    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    private TenantDataIsolateProvider tenantDataIsolateProvider;
    @Autowired
    private ComSaleFileInfoService ComSaleFileInfoService;

    @Override
    public SysUserDTO loadUserByUsername(String username) {
        CloudtOptional providerById;
        if (StringUtils.isEmpty((CharSequence)username)) {
            throw new BusinessException("\u8d26\u53f7/\u624b\u673a\u53f7\u4e3a\u7a7a");
        }
        CustAccountVO custAccount = this.custAccountRepoProc.getAccountByUserName(username);
        log.info("\u67e5\u770b\u6240\u767b\u5f55\u7684\u8d26\u53f7\u4fe1\u606f\u4e3a:\u3010" + custAccount + "\u3011");
        if (custAccount == null) {
            return null;
        }
        SysUserDTO sysUser = new SysUserDTO();
        sysUser.setUsername(username);
        sysUser.setId(custAccount.getUserId());
        sysUser.setMobile(custAccount.getMobile());
        sysUser.setEnabled(Boolean.valueOf(true));
        if (!ObjectUtils.isEmpty((Object)custAccount.getRoleId())) {
            sysUser.setRoleIds(Set.of(custAccount.getRoleId()));
            sysUser.setRoleCodes(Set.of(custAccount.getRoleCode()));
        }
        sysUser.setLastName(custAccount.getNickName());
        List byBusinessId = this.ComSaleFileInfoService.findFileByBusinessId("ACCOUNT_IMAGE", custAccount.getId());
        if (!ObjectUtils.isEmpty((Object)byBusinessId)) {
            sysUser.setAvatarUrl(((ComSaleFileComVO)byBusinessId.get(0)).getFileCode());
        }
        if ((providerById = this.tenantProvider.getById(custAccount.getTenantId())).isPresent()) {
            sysUser.setSysTenantDTOList(Collections.singletonList((SysTenantDTO)providerById.get()));
            sysUser.setSysTenantVO((SysTenantDTO)providerById.get());
        }
        return sysUser;
    }

    @Override
    public SysUserDTO loadUserByMobile(String mobile) {
        CloudtOptional providerById;
        if (StringUtils.isEmpty((CharSequence)mobile)) {
            throw new BusinessException("\u8d26\u53f7/\u624b\u673a\u53f7\u4e3a\u7a7a");
        }
        CustAccountVO custAccount = this.custAccountRepoProc.getAccountByMobile(mobile);
        log.info("\u67e5\u770b\u6240\u767b\u5f55\u7684\u8d26\u53f7\u4fe1\u606f\u4e3a:\u3010" + custAccount + "\u3011");
        if (custAccount == null) {
            return null;
        }
        SysUserDTO sysUser = new SysUserDTO();
        sysUser.setUsername(mobile);
        sysUser.setId(custAccount.getUserId());
        sysUser.setMobile(custAccount.getMobile());
        sysUser.setEnabled(Boolean.valueOf(true));
        if (!ObjectUtils.isEmpty((Object)custAccount.getRoleId())) {
            sysUser.setRoleIds(Set.of(custAccount.getRoleId()));
            sysUser.setRoleCodes(Set.of(custAccount.getRoleCode()));
        }
        sysUser.setLastName(custAccount.getNickName());
        List byBusinessId = this.ComSaleFileInfoService.findFileByBusinessId("ACCOUNT_IMAGE", custAccount.getId());
        if (!ObjectUtils.isEmpty((Object)byBusinessId)) {
            sysUser.setAvatarUrl(((ComSaleFileComVO)byBusinessId.get(0)).getFileCode());
        }
        if ((providerById = this.tenantProvider.getById(custAccount.getTenantId())).isPresent()) {
            sysUser.setSysTenantDTOList(Collections.singletonList((SysTenantDTO)providerById.get()));
            sysUser.setSysTenantVO((SysTenantDTO)providerById.get());
        }
        return sysUser;
    }

    @Override
    public SysUserDTO loadUserById(Long id) {
        CloudtOptional providerById;
        if (ObjectUtils.isEmpty((Object)id)) {
            throw new BusinessException("\u8d26\u53f7/\u624b\u673a\u53f7\u4e3a\u7a7a");
        }
        CustAccountVO custAccount = this.custAccountRepoProc.getAccountByUserId(id);
        log.info("\u67e5\u770b\u6240\u767b\u5f55\u7684\u8d26\u53f7\u4fe1\u606f\u4e3a:\u3010" + custAccount + "\u3011");
        if (custAccount == null) {
            return null;
        }
        SysUserDTO sysUser = new SysUserDTO();
        sysUser.setUsername(custAccount.getUserName());
        sysUser.setUserType(custAccount.getDealerType());
        sysUser.setId(custAccount.getUserId());
        sysUser.setMobile(custAccount.getMobile());
        sysUser.setEnabled(Boolean.valueOf(true));
        if (!ObjectUtils.isEmpty((Object)custAccount.getRoleId())) {
            sysUser.setRoleIds(Set.of(custAccount.getRoleId()));
            sysUser.setRoleCodes(Set.of(custAccount.getRoleCode()));
        }
        sysUser.setLastName(custAccount.getNickName());
        List byBusinessId = this.ComSaleFileInfoService.findFileByBusinessId("ACCOUNT_IMAGE", custAccount.getId());
        if (!ObjectUtils.isEmpty((Object)byBusinessId)) {
            sysUser.setAvatarUrl(((ComSaleFileComVO)byBusinessId.get(0)).getFileCode());
        }
        if ((providerById = this.tenantProvider.getById(custAccount.getTenantId())).isPresent()) {
            sysUser.setSysTenantDTOList(Collections.singletonList((SysTenantDTO)providerById.get()));
            sysUser.setSysTenantVO((SysTenantDTO)providerById.get());
        }
        return sysUser;
    }

    @Override
    public List<AuthUserDTO> queryUser(int size) {
        return null;
    }

    @Override
    public void updateCasUserId(String username, long userId) {
        CustAccountDO custAccountDO = this.custAccountRepoProc.getByUserName(username);
        custAccountDO.setUserId(userId);
        custAccountDO.setIsOpenAccount(true);
        custAccountDO.setCreateAccountTime(LocalDateTime.now());
        custAccountDO.setUserName(username);
        custAccountDO.setEnable(true);
        this.custAccountRepo.save(custAccountDO);
        CompletableFuture.runAsync(() -> {
            if (!ObjectUtils.isEmpty((Object)custAccountDO.getRoleId())) {
                this.rmiSysRoleService.generateCode(custAccountDO.getUserId(), Collections.singletonList(custAccountDO.getRoleId()));
            }
        }, (Executor)this.taskExecutor);
    }
}

