/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.repo;

import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.dto.CustDTO;
import com.elitesland.yst.production.sale.api.vo.param.crm.CrmCustBaseParamVO;
import com.elitesland.yst.production.sale.api.vo.param.crm.CrmCustQueryLmParam;
import com.elitesland.yst.production.sale.api.vo.param.crm.CrmCustQueryParam;
import com.elitesland.yst.production.sale.api.vo.param.crm.CrmCustSimpleParam;
import com.elitesland.yst.production.sale.api.vo.param.crm.CustAddrFindParam;
import com.elitesland.yst.production.sale.api.vo.param.crm.CustCode2BaseParam;
import com.elitesland.yst.production.sale.api.vo.param.crm.CustPredictionParamVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CrmCustBasePageVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CrmCustBaseRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CrmCustPageLmVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CrmCustSimpleVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CustCode2BaseDTO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CustCorOuResVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CustPrentInfoDTO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CustSalePredictionVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.LmSaveCustRespVO;
import com.elitesland.yst.production.sale.dto.CrmCustRespDTO;
import com.elitesland.yst.production.sale.dto.CrmCustSimpleDTO;
import com.elitesland.yst.production.sale.dto.CustBaseInfoDTO;
import com.elitesland.yst.production.sale.entity.CrmCustDO;
import com.elitesland.yst.production.sale.entity.QCrmCustDO;
import com.elitesland.yst.production.sale.repo.CrmCustRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Repository
public class CrmCustRepoProc {
    @Autowired
    private JPAQueryFactory jpaQueryFactory;
    private final QCrmCustDO qCrmCustDO = QCrmCustDO.crmCustDO;
    @Autowired
    private CrmCustRepo crmCustRepo;

    public PagingVO<CrmCustPageLmVO> findPageCust(CrmCustQueryLmParam searchParam) {
        JPAQuery<CrmCustPageLmVO> query = this.selectFromWhere(CrmCustPageLmVO.class, searchParam);
        searchParam.setPaging(query);
        searchParam.fillOrders(query, (EntityPathBase)this.qCrmCustDO);
        return PagingVO.builder().total(query.fetchCount()).records(query.fetch()).build();
    }

    public PagingVO<CustSalePredictionVO> queryCustSalePrediction(CustPredictionParamVO param) {
        JPAQuery<CustSalePredictionVO> query = this.selectSalePrediction(CustSalePredictionVO.class, param);
        param.setPaging(query);
        param.fillOrders(query, (EntityPathBase)this.qCrmCustDO);
        return PagingVO.builder().total(query.fetchCount()).records(query.fetch()).build();
    }

    public PagingVO<CrmCustBasePageVO> getCustBasePage(CrmCustBaseParamVO param) {
        JPAQuery<CrmCustBasePageVO> query = this.selectBaseFromWhere(CrmCustBasePageVO.class, param);
        param.setPaging(query);
        param.fillOrders(query, (EntityPathBase)this.qCrmCustDO);
        return PagingVO.builder().total(query.fetchCount()).records(query.fetch()).build();
    }

    public List<CrmCustPageLmVO> searchExoprt(CrmCustQueryParam crmCustQueryParam) {
        JPAQuery<CrmCustPageLmVO> query = this.selectExport(CrmCustPageLmVO.class, crmCustQueryParam);
        return query.fetch();
    }

    private <T> JPAQuery<T> selectSalePrediction(Class<T> cls, CustPredictionParamVO param) {
        return (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{this.qCrmCustDO.id, this.qCrmCustDO.custCode, this.qCrmCustDO.pid, this.qCrmCustDO.custGroup, this.qCrmCustDO.custName, this.qCrmCustDO.outerCode, this.qCrmCustDO.custCode2, this.qCrmCustDO.custAbbr, this.qCrmCustDO.custType2, this.qCrmCustDO.custType, this.qCrmCustDO.region, this.qCrmCustDO.agentEmpId, this.qCrmCustDO.custLevel, this.qCrmCustDO.certNo, this.qCrmCustDO.custCurr, this.qCrmCustDO.country, this.qCrmCustDO.taxpayerType, this.qCrmCustDO.contactName, this.qCrmCustDO.contactPhone, this.qCrmCustDO.custStatus, this.qCrmCustDO.isCreateOu, this.qCrmCustDO.es1, this.qCrmCustDO.corOu})).from((EntityPath)this.qCrmCustDO)).where(this.whereSalePrediction(param));
    }

    public Predicate whereSalePrediction(CustPredictionParamVO param) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        list.add(this.qCrmCustDO.deleteFlag.eq((Object)0));
        if (CollectionUtil.isNotEmpty((Collection)param.getCustCodes())) {
            list.add(this.qCrmCustDO.custCode.in((Collection)param.getCustCodes()));
        }
        if (CollectionUtil.isNotEmpty((Collection)param.getNotInCustCode())) {
            list.add(this.qCrmCustDO.custCode.notIn((Collection)param.getNotInCustCode()));
        }
        if (CollectionUtil.isNotEmpty((Collection)param.getCustTypes())) {
            list.add(this.qCrmCustDO.custType.in((Collection)param.getCustTypes()));
        }
        if (StringUtil.isNotBlank((CharSequence)param.getCustCode())) {
            list.add(this.qCrmCustDO.custCode.contains(param.getCustCode()));
        }
        if (StringUtil.isNotBlank((CharSequence)param.getCustName())) {
            list.add(this.qCrmCustDO.custName.contains(param.getCustName()));
        }
        if (StringUtil.isNotBlank((CharSequence)param.getCustStatus())) {
            list.add(this.qCrmCustDO.custStatus.eq((Object)param.getCustStatus()));
        }
        if (CollectionUtil.isNotEmpty((Collection)param.getIds())) {
            list.add(this.qCrmCustDO.id.in((Collection)param.getIds()));
        }
        return ExpressionUtils.allOf(list);
    }

    private <T> JPAQuery<T> selectExport(Class<T> cls, CrmCustQueryParam param) {
        return (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{this.qCrmCustDO.id, this.qCrmCustDO.custCode, this.qCrmCustDO.custName, this.qCrmCustDO.outerCode, this.qCrmCustDO.custCode2, this.qCrmCustDO.custAbbr, this.qCrmCustDO.custType2, this.qCrmCustDO.custType, this.qCrmCustDO.region, this.qCrmCustDO.agentEmpId, this.qCrmCustDO.custLevel, this.qCrmCustDO.certNo, this.qCrmCustDO.custCurr, this.qCrmCustDO.country, this.qCrmCustDO.taxpayerType, this.qCrmCustDO.contactName, this.qCrmCustDO.contactPhone, this.qCrmCustDO.custStatus})).from((EntityPath)this.qCrmCustDO)).where(this.whereExport(param));
    }

    public Predicate whereExport(CrmCustQueryParam param) {
        ArrayList<BooleanExpression> predicate = new ArrayList<BooleanExpression>();
        if (StringUtil.isNotBlank((CharSequence)param.getCustName())) {
            predicate.add(this.qCrmCustDO.custCode.like("%" + param.getCustCode() + "%"));
        }
        if (StringUtil.isNotBlank((CharSequence)param.getCustName())) {
            predicate.add(this.qCrmCustDO.custName.like("%" + param.getCustName() + "%"));
        }
        if (StringUtil.isNotBlank((CharSequence)param.getOuterCode())) {
            predicate.add(this.qCrmCustDO.outerCode.like("%" + param.getOuterCode() + "%"));
        }
        if (StringUtil.isNotBlank((CharSequence)param.getCustAbbr())) {
            predicate.add(this.qCrmCustDO.custAbbr.like("%" + param.getCustAbbr() + "%"));
        }
        if (StringUtil.isNotBlank((CharSequence)param.getCustCode2())) {
            predicate.add(this.qCrmCustDO.custCode2.eq((Object)param.getCustCode2()));
        }
        if (StringUtil.isNotBlank((CharSequence)param.getCustType2())) {
            predicate.add(this.qCrmCustDO.custType2.eq((Object)param.getCustType2()));
        }
        if (StringUtil.isNotBlank((CharSequence)param.getCustType())) {
            predicate.add(this.qCrmCustDO.custType.eq((Object)param.getCustType()));
        }
        if (StringUtil.isNotBlank((CharSequence)param.getCustStatus())) {
            predicate.add(this.qCrmCustDO.custStatus.eq((Object)param.getCustStatus()));
        }
        if (StringUtil.isNotBlank((CharSequence)param.getRegion())) {
            predicate.add(this.qCrmCustDO.region.like("%" + param.getRegion() + "%"));
        }
        if (!ObjectUtils.isEmpty((Object)param.getAgentEmpId())) {
            predicate.add(this.qCrmCustDO.agentEmpId.eq((Object)param.getAgentEmpId()));
        }
        if (StringUtil.isNotBlank((CharSequence)param.getContactName())) {
            predicate.add(this.qCrmCustDO.contactName.like("%" + param.getContactName() + "%"));
        }
        if (StringUtil.isNotBlank((CharSequence)param.getContactPhone())) {
            predicate.add(this.qCrmCustDO.contactPhone.like("%" + param.getContactPhone() + "%"));
        }
        if (StringUtil.isNotBlank((CharSequence)param.getPid())) {
            predicate.add(this.qCrmCustDO.pid.like("%" + param.getPid() + "%"));
        }
        predicate.add(this.qCrmCustDO.deleteFlag.isNull().or((Predicate)this.qCrmCustDO.deleteFlag.eq((Object)0)));
        return ExpressionUtils.allOf(predicate);
    }

    private <T> JPAQuery<T> selectFromWhere(Class<T> cls, CrmCustQueryLmParam param) {
        return (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{this.qCrmCustDO.id, this.qCrmCustDO.custCode, this.qCrmCustDO.pid, this.qCrmCustDO.custGroup, this.qCrmCustDO.custName, this.qCrmCustDO.outerCode, this.qCrmCustDO.custCode2, this.qCrmCustDO.custAbbr, this.qCrmCustDO.custType2, this.qCrmCustDO.custType, this.qCrmCustDO.region, this.qCrmCustDO.agentEmpId, this.qCrmCustDO.custLevel, this.qCrmCustDO.certNo, this.qCrmCustDO.custCurr, this.qCrmCustDO.country, this.qCrmCustDO.taxpayerType, this.qCrmCustDO.contactName, this.qCrmCustDO.contactPhone, this.qCrmCustDO.custStatus, this.qCrmCustDO.isCreateOu, this.qCrmCustDO.es1, this.qCrmCustDO.corOu})).from((EntityPath)this.qCrmCustDO)).where(this.where(param));
    }

    private <T> JPAQuery<T> selectBaseFromWhere(Class<T> cls, CrmCustBaseParamVO param) {
        return (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{this.qCrmCustDO.id, this.qCrmCustDO.custCode, this.qCrmCustDO.custName, this.qCrmCustDO.custCode2, this.qCrmCustDO.custAbbr, this.qCrmCustDO.custType2, this.qCrmCustDO.custType, this.qCrmCustDO.region, this.qCrmCustDO.agentEmpId, this.qCrmCustDO.country, this.qCrmCustDO.custStatus, this.qCrmCustDO.addrNo, this.qCrmCustDO.cancelCustFlag})).from((EntityPath)this.qCrmCustDO)).where(this.whereBase(param));
    }

    public Predicate whereBase(CrmCustBaseParamVO param) {
        ArrayList<BooleanExpression> predicate = new ArrayList<BooleanExpression>();
        predicate.add(this.qCrmCustDO.deleteFlag.eq((Object)0));
        if (StringUtil.isNotBlank((CharSequence)param.getRegion())) {
            predicate.add(this.qCrmCustDO.region.eq((Object)param.getRegion()));
        }
        if (!ObjectUtils.isEmpty((Object)param.getAgentEmpId())) {
            predicate.add(this.qCrmCustDO.agentEmpId.eq((Object)param.getAgentEmpId()));
        }
        if (!ObjectUtils.isEmpty((Object)param.getCustType()) && !CollectionUtils.isEmpty((Collection)param.getCustType())) {
            predicate.add(this.qCrmCustDO.custType.in((Collection)param.getCustType()));
        }
        if (!StringUtil.isBlank((CharSequence)param.getCustStatus())) {
            predicate.add(this.qCrmCustDO.custStatus.eq((Object)param.getCustStatus()));
        }
        if (StringUtil.isNotBlank((CharSequence)param.getCust())) {
            predicate.add(this.qCrmCustDO.custCode.contains(param.getCust()).or((Predicate)this.qCrmCustDO.custName.contains(param.getCust())));
        }
        if (!ObjectUtils.isEmpty((Object)param.getCancelCustFlag())) {
            predicate.add(this.qCrmCustDO.cancelCustFlag.eq(param.getCancelCustFlag()));
        }
        if (StringUtil.isNotBlank((CharSequence)param.getCustType1())) {
            predicate.add(this.qCrmCustDO.custType.contains(param.getCustType1()));
        }
        return ExpressionUtils.allOf(predicate);
    }

    public Predicate where(CrmCustQueryLmParam param) {
        ArrayList<BooleanExpression> predicate = new ArrayList<BooleanExpression>();
        if (StringUtil.isNotBlank((CharSequence)param.getCust())) {
            predicate.add(this.qCrmCustDO.custCode.contains(param.getCust()).or((Predicate)this.qCrmCustDO.custCode2.contains(param.getCust())).or((Predicate)this.qCrmCustDO.custName.contains(param.getCust())));
        }
        if (!CollectionUtils.isEmpty((Collection)param.getCustTypes())) {
            predicate.add(this.qCrmCustDO.custType.in((Collection)param.getCustTypes()));
        }
        if (!ObjectUtils.isEmpty((Object)param.getIsSearchPid()) && Boolean.TRUE.equals(param.getIsSearchPid()) && StringUtil.isNotBlank((CharSequence)param.getCustCode())) {
            predicate.add(this.qCrmCustDO.pid.eq((Object)param.getCustCode()));
        } else if (StringUtil.isNotBlank((CharSequence)param.getCustCode())) {
            predicate.add(this.qCrmCustDO.custCode.like("%" + param.getCustCode() + "%"));
        }
        if (StringUtil.isNotBlank((CharSequence)param.getCustName())) {
            predicate.add(this.qCrmCustDO.custName.like("%" + param.getCustName() + "%"));
        }
        if (StringUtil.isNotBlank((CharSequence)param.getOuterCode())) {
            predicate.add(this.qCrmCustDO.outerCode.like("%" + param.getOuterCode() + "%"));
        }
        if (StringUtil.isNotBlank((CharSequence)param.getCustAbbr())) {
            predicate.add(this.qCrmCustDO.custAbbr.like("%" + param.getCustAbbr() + "%"));
        }
        if (StringUtil.isNotBlank((CharSequence)param.getCustCode2())) {
            predicate.add(this.qCrmCustDO.custCode2.like("%" + param.getCustCode2() + "%"));
        }
        if (StringUtil.isNotBlank((CharSequence)param.getCustType2())) {
            predicate.add(this.qCrmCustDO.custType2.eq((Object)param.getCustType2()));
        }
        if (StringUtil.isNotBlank((CharSequence)param.getCustType())) {
            predicate.add(this.qCrmCustDO.custType.eq((Object)param.getCustType()));
        }
        if (StringUtil.isNotBlank((CharSequence)param.getCustStatus())) {
            predicate.add(this.qCrmCustDO.custStatus.eq((Object)param.getCustStatus()));
        }
        if (StringUtil.isNotBlank((CharSequence)param.getRegion())) {
            predicate.add(this.qCrmCustDO.region.like("%" + param.getRegion() + "%"));
        }
        if (!ObjectUtils.isEmpty((Object)param.getAgentEmpId())) {
            predicate.add(this.qCrmCustDO.agentEmpId.eq((Object)param.getAgentEmpId()));
        }
        if (!ObjectUtils.isEmpty((Object)param.getCustGroup())) {
            predicate.add(this.qCrmCustDO.custGroup.eq((Object)param.getCustGroup()));
        }
        if (StringUtil.isNotBlank((CharSequence)param.getContactName())) {
            predicate.add(this.qCrmCustDO.contactName.like("%" + param.getContactName() + "%"));
        }
        if (StringUtil.isNotBlank((CharSequence)param.getContactPhone())) {
            predicate.add(this.qCrmCustDO.contactPhone.like("%" + param.getContactPhone() + "%"));
        }
        if (StringUtil.isNotBlank((CharSequence)param.getPid())) {
            predicate.add(this.qCrmCustDO.pid.like("%" + param.getPid() + "%"));
        }
        predicate.add(this.qCrmCustDO.deleteFlag.isNull().or((Predicate)this.qCrmCustDO.deleteFlag.eq((Object)0)));
        return ExpressionUtils.allOf(predicate);
    }

    public List<LmSaveCustRespVO> findInvCustCodes(List<String> custCodes) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(LmSaveCustRespVO.class, (Expression[])new Expression[]{this.qCrmCustDO.id, this.qCrmCustDO.custName, this.qCrmCustDO.custCode, this.qCrmCustDO.custCode2, this.qCrmCustDO.addrNo, this.qCrmCustDO.invAddress, this.qCrmCustDO.invBankAcc, this.qCrmCustDO.invBankBranch, this.qCrmCustDO.invTel, this.qCrmCustDO.invPicName, this.qCrmCustDO.invPicPhone, this.qCrmCustDO.invTitle, this.qCrmCustDO.pid, this.qCrmCustDO.custAbbr, this.qCrmCustDO.contactName, this.qCrmCustDO.contactPhone, this.qCrmCustDO.agentEmpId, this.qCrmCustDO.createTime, this.qCrmCustDO.region, this.qCrmCustDO.custType})).from((EntityPath)this.qCrmCustDO)).where((Predicate)this.qCrmCustDO.custCode.in(custCodes).and((Predicate)this.qCrmCustDO.deleteFlag.ne((Object)1)))).fetch();
    }

    public List<LmSaveCustRespVO> getCustInfoByRegion(List<String> region) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(LmSaveCustRespVO.class, (Expression[])new Expression[]{this.qCrmCustDO.id, this.qCrmCustDO.custName, this.qCrmCustDO.custCode, this.qCrmCustDO.custCode2, this.qCrmCustDO.addrNo, this.qCrmCustDO.invAddress, this.qCrmCustDO.invBankAcc, this.qCrmCustDO.invBankBranch, this.qCrmCustDO.invTel, this.qCrmCustDO.invPicName, this.qCrmCustDO.invPicPhone, this.qCrmCustDO.invTitle, this.qCrmCustDO.pid, this.qCrmCustDO.custAbbr, this.qCrmCustDO.contactName, this.qCrmCustDO.contactPhone, this.qCrmCustDO.agentEmpId, this.qCrmCustDO.createTime, this.qCrmCustDO.region})).from((EntityPath)this.qCrmCustDO)).where((Predicate)this.qCrmCustDO.region.in(region).and((Predicate)this.qCrmCustDO.deleteFlag.ne((Object)1)))).fetch();
    }

    public String getCustName(Long id) {
        return (String)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qCrmCustDO.custName).from((EntityPath)this.qCrmCustDO)).where((Predicate)this.qCrmCustDO.id.eq((Object)id))).limit(1L)).fetchOne();
    }

    public Long getAgentEmpId(String custCode) {
        return (Long)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qCrmCustDO.agentEmpId).from((EntityPath)this.qCrmCustDO)).where((Predicate)this.qCrmCustDO.custCode.eq((Object)custCode).and((Predicate)this.qCrmCustDO.deleteFlag.eq((Object)0)))).limit(1L)).fetchOne();
    }

    public String getCustRegion(String custCode) {
        return (String)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qCrmCustDO.region).from((EntityPath)this.qCrmCustDO)).where((Predicate)this.qCrmCustDO.custCode.eq((Object)custCode).and((Predicate)this.qCrmCustDO.deleteFlag.eq((Object)0)))).limit(1L)).fetchOne();
    }

    public String getCustStatusByCode(String custCode) {
        return (String)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qCrmCustDO.custStatus).from((EntityPath)this.qCrmCustDO)).where((Predicate)this.qCrmCustDO.custCode.eq((Object)custCode).and((Predicate)this.qCrmCustDO.deleteFlag.eq((Object)0)))).limit(1L)).fetchOne();
    }

    public String getCustName(String custCode) {
        return (String)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qCrmCustDO.custName).from((EntityPath)this.qCrmCustDO)).where((Predicate)this.qCrmCustDO.custCode.eq((Object)custCode).and((Predicate)this.qCrmCustDO.deleteFlag.eq((Object)0)))).limit(1L)).fetchOne();
    }

    public List<CustBaseInfoDTO> getCustBaseInfo(CustCode2BaseParam param) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(CustBaseInfoDTO.class, (Expression[])new Expression[]{this.qCrmCustDO.custCode, this.qCrmCustDO.id, this.qCrmCustDO.custName, this.qCrmCustDO.custCode2, this.qCrmCustDO.custType, this.qCrmCustDO.custType2, this.qCrmCustDO.custAbbr, this.qCrmCustDO.outerCode, this.qCrmCustDO.autoCreditFlag})).from((EntityPath)this.qCrmCustDO)).where(this.whereCustCode2OrCustCode(param))).fetch();
    }

    public Predicate whereCustCode2OrCustCode(CustCode2BaseParam param) {
        ArrayList<BooleanExpression> predicate = new ArrayList<BooleanExpression>();
        if (StringUtil.isNotBlank((CharSequence)param.getCustAbbr())) {
            predicate.add(this.qCrmCustDO.custAbbr.contains(param.getCustAbbr()));
        }
        if (StringUtil.isNotBlank((CharSequence)param.getCustName())) {
            predicate.add(this.qCrmCustDO.custName.contains(param.getCustName()));
        }
        if (!CollectionUtils.isEmpty((Collection)param.getCustCode())) {
            predicate.add(this.qCrmCustDO.custCode.in((Collection)param.getCustCode()));
        }
        if (!CollectionUtils.isEmpty((Collection)param.getCustCode2())) {
            predicate.add(this.qCrmCustDO.custCode2.in((Collection)param.getCustCode2()));
        }
        if (StringUtil.isNotBlank((CharSequence)param.getCustType())) {
            predicate.add(this.qCrmCustDO.custType.eq((Object)param.getCustType()));
        }
        if (StringUtil.isNotBlank((CharSequence)param.getCustType2())) {
            predicate.add(this.qCrmCustDO.custType2.eq((Object)param.getCustType2()));
        }
        predicate.add(this.qCrmCustDO.deleteFlag.isNull().or((Predicate)this.qCrmCustDO.deleteFlag.eq((Object)0)));
        return ExpressionUtils.allOf(predicate);
    }

    public List<CustCode2BaseDTO> getByCust2Base(CustCode2BaseParam param) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(CustCode2BaseDTO.class, (Expression[])new Expression[]{this.qCrmCustDO.custCode, this.qCrmCustDO.custCode2, this.qCrmCustDO.id, this.qCrmCustDO.custType, this.qCrmCustDO.custName, this.qCrmCustDO.custAbbr, this.qCrmCustDO.legalRepre, this.qCrmCustDO.provinceCode, this.qCrmCustDO.region})).from((EntityPath)this.qCrmCustDO)).where(this.whereCustCode2(param))).fetch();
    }

    public Predicate whereCustCode2(CustCode2BaseParam param) {
        ArrayList<BooleanExpression> predicate = new ArrayList<BooleanExpression>();
        if (!CollectionUtils.isEmpty((Collection)param.getCustCode())) {
            predicate.add(this.qCrmCustDO.custCode.in((Collection)param.getCustCode()));
        }
        if (!CollectionUtils.isEmpty((Collection)param.getCustCode2())) {
            predicate.add(this.qCrmCustDO.custCode2.in((Collection)param.getCustCode2()));
        }
        if (StringUtil.isNotBlank((CharSequence)param.getStatus())) {
            predicate.add(this.qCrmCustDO.custStatus.in((Object[])new String[]{param.getStatus()}));
        }
        if (StringUtil.isNotBlank((CharSequence)param.getProvinceCode())) {
            predicate.add(this.qCrmCustDO.provinceCode.eq((Object)param.getProvinceCode()));
        }
        if (StringUtil.isNotBlank((CharSequence)param.getRegion())) {
            predicate.add(this.qCrmCustDO.region.eq((Object)param.getRegion()));
        }
        predicate.add(this.qCrmCustDO.deleteFlag.isNull().or((Predicate)this.qCrmCustDO.deleteFlag.eq((Object)0)));
        return ExpressionUtils.allOf(predicate);
    }

    public CustPrentInfoDTO getPrentCust(String custCode) {
        return (CustPrentInfoDTO)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(CustPrentInfoDTO.class, (Expression[])new Expression[]{this.qCrmCustDO.custCode, this.qCrmCustDO.id, this.qCrmCustDO.custName, this.qCrmCustDO.region})).from((EntityPath)this.qCrmCustDO)).where((Predicate)this.qCrmCustDO.deleteFlag.eq((Object)0).and((Predicate)this.qCrmCustDO.pid.eq((Object)custCode)))).fetchOne();
    }

    public Long getAddrNo(Long id) {
        return (Long)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qCrmCustDO.addrNo).from((EntityPath)this.qCrmCustDO)).where((Predicate)this.qCrmCustDO.id.eq((Object)id))).limit(1L)).fetchOne();
    }

    public Long getAddrNo(String custCode) {
        return (Long)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qCrmCustDO.addrNo).from((EntityPath)this.qCrmCustDO)).where((Predicate)this.qCrmCustDO.custCode.eq((Object)custCode).and((Predicate)this.qCrmCustDO.deleteFlag.eq((Object)0)))).limit(1L)).fetchOne();
    }

    public CustDTO getCustSimpleInfo(Long id) {
        return (CustDTO)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(CustDTO.class, (Expression[])new Expression[]{this.qCrmCustDO.id, this.qCrmCustDO.ouId, this.qCrmCustDO.buId, this.qCrmCustDO.custCode, this.qCrmCustDO.custName, this.qCrmCustDO.custLevel})).from((EntityPath)this.qCrmCustDO)).where((Predicate)this.qCrmCustDO.id.eq((Object)id))).limit(1L)).fetchOne();
    }

    public List<CrmCustBaseRespVO> getCustByEmpId(Long agentEmpId) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(CrmCustBaseRespVO.class, (Expression[])new Expression[]{this.qCrmCustDO.id, this.qCrmCustDO.custCode, this.qCrmCustDO.custName, this.qCrmCustDO.country, this.qCrmCustDO.region, this.qCrmCustDO.custCode2, this.qCrmCustDO.agentEmpId, this.qCrmCustDO.contactName, this.qCrmCustDO.contactPhone, this.qCrmCustDO.addrNo})).from((EntityPath)this.qCrmCustDO)).where((Predicate)this.qCrmCustDO.agentEmpId.eq((Object)agentEmpId))).fetch();
    }

    public List<CrmCustBaseRespVO> getCustByEmpIds(List<Long> agentEmpIds) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(CrmCustBaseRespVO.class, (Expression[])new Expression[]{this.qCrmCustDO.id, this.qCrmCustDO.custCode, this.qCrmCustDO.custName, this.qCrmCustDO.country, this.qCrmCustDO.region, this.qCrmCustDO.custCode2, this.qCrmCustDO.agentEmpId, this.qCrmCustDO.contactName, this.qCrmCustDO.contactPhone, this.qCrmCustDO.addrNo, this.qCrmCustDO.custAbbr})).from((EntityPath)this.qCrmCustDO)).where((Predicate)this.qCrmCustDO.agentEmpId.in(agentEmpIds))).fetch();
    }

    public List<CrmCustSimpleDTO> query(String keyword) {
        keyword = "%" + (String)keyword + "%";
        BooleanExpression predicate = this.qCrmCustDO.custCode.like((String)keyword).or((Predicate)this.qCrmCustDO.custName.like((String)keyword));
        predicate = this.appendCommon((Predicate)predicate);
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{this.qCrmCustDO.id, this.qCrmCustDO.custCode, this.qCrmCustDO.custName, this.qCrmCustDO.custAbbr}).from((EntityPath)this.qCrmCustDO)).where((Predicate)predicate)).fetch().stream().map(tuple -> {
            CrmCustSimpleDTO dto = new CrmCustSimpleDTO();
            dto.setId((Long)tuple.get(this.qCrmCustDO.id));
            dto.setCustCode((String)tuple.get((Expression)this.qCrmCustDO.custCode));
            dto.setCustName((String)tuple.get((Expression)this.qCrmCustDO.custName));
            dto.setCustAbbr((String)tuple.get((Expression)this.qCrmCustDO.custAbbr));
            return dto;
        }).collect(Collectors.toList());
    }

    public CrmCustDO getByTaxRegNo(String taxRegNo) {
        return (CrmCustDO)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qCrmCustDO).from((EntityPath)this.qCrmCustDO)).where((Predicate)this.qCrmCustDO.taxRegNo.eq((Object)taxRegNo))).limit(1L)).fetchOne();
    }

    public CrmCustDO getCustInfoByCode(String custCode) {
        return (CrmCustDO)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qCrmCustDO).from((EntityPath)this.qCrmCustDO)).where((Predicate)this.qCrmCustDO.custCode.eq((Object)custCode).and((Predicate)this.qCrmCustDO.deleteFlag.eq((Object)0)))).limit(1L)).fetchOne();
    }

    private Predicate appendCommon(Predicate predicate) {
        return ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCrmCustDO.deleteFlag.eq((Object)0));
    }

    public Boolean exists(String custName, Long id) {
        BooleanExpression predicate = this.qCrmCustDO.deleteFlag.eq((Object)0).or((Predicate)this.qCrmCustDO.deleteFlag.isNull());
        predicate = StringUtils.isEmpty((Object)custName) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCrmCustDO.custName.eq((Object)custName));
        predicate = StringUtils.isEmpty((Object)id) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCrmCustDO.id.ne((Object)id));
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qCrmCustDO).from((EntityPath)this.qCrmCustDO)).where((Predicate)predicate)).fetchCount() > 0L;
    }

    public Boolean existsMobile(String mobile, Long id) {
        BooleanExpression predicate = this.qCrmCustDO.deleteFlag.eq((Object)0).or((Predicate)this.qCrmCustDO.deleteFlag.isNull());
        predicate = StringUtils.isEmpty((Object)mobile) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCrmCustDO.contactPhone.eq((Object)mobile));
        predicate = StringUtils.isEmpty((Object)id) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCrmCustDO.id.ne((Object)id));
        predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCrmCustDO.custType.in((Object[])new String[]{"ONE", "TWO"}));
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qCrmCustDO).from((EntityPath)this.qCrmCustDO)).where((Predicate)predicate)).fetchCount() > 0L;
    }

    public Boolean existsMobileAndBusinessType(String mobile, Long id, String businessType) {
        BooleanExpression predicate = this.qCrmCustDO.deleteFlag.eq((Object)0).or((Predicate)this.qCrmCustDO.deleteFlag.isNull());
        predicate = StringUtils.isEmpty((Object)mobile) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCrmCustDO.contactPhone.eq((Object)mobile));
        predicate = StringUtils.isEmpty((Object)id) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCrmCustDO.id.ne((Object)id));
        predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCrmCustDO.custType.in((Object[])new String[]{"ONE", "TWO"}));
        predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCrmCustDO.businessTypeCust.eq((Object)businessType));
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qCrmCustDO).from((EntityPath)this.qCrmCustDO)).where((Predicate)predicate)).fetchCount() > 0L;
    }

    public Boolean existsCustCode2(String custCode2, Long id) {
        BooleanExpression predicate = this.qCrmCustDO.deleteFlag.eq((Object)0).or((Predicate)this.qCrmCustDO.deleteFlag.isNull());
        predicate = StringUtils.isEmpty((Object)custCode2) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCrmCustDO.custCode2.eq((Object)custCode2));
        predicate = StringUtils.isEmpty((Object)id) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCrmCustDO.id.ne((Object)id));
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qCrmCustDO).from((EntityPath)this.qCrmCustDO)).where((Predicate)predicate)).fetchCount() > 0L;
    }

    public Boolean existsTaxRegNo(String taxRegNo, Long id, String businessTypeCust) {
        BooleanExpression predicate = this.qCrmCustDO.deleteFlag.eq((Object)0).or((Predicate)this.qCrmCustDO.deleteFlag.isNull());
        predicate = StringUtils.isEmpty((Object)taxRegNo) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCrmCustDO.taxRegNo.eq((Object)taxRegNo));
        predicate = StringUtils.isEmpty((Object)id) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCrmCustDO.id.ne((Object)id));
        predicate = StringUtils.isEmpty((Object)businessTypeCust) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCrmCustDO.businessTypeCust.eq((Object)businessTypeCust));
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qCrmCustDO).from((EntityPath)this.qCrmCustDO)).where((Predicate)predicate)).fetchCount() > 0L;
    }

    public CrmCustDO getDoByCustCode(String custCode) {
        BooleanExpression e = this.qCrmCustDO.deleteFlag.eq((Object)0).and((Predicate)this.qCrmCustDO.custCode.eq((Object)custCode));
        Optional optional = this.crmCustRepo.findOne((Predicate)e);
        if (optional.isPresent()) {
            return (CrmCustDO)optional.get();
        }
        return null;
    }

    public Boolean existsCodeAndOuId(String custCode, Long ouId) {
        BooleanExpression predicate = this.qCrmCustDO.deleteFlag.eq((Object)0).or((Predicate)this.qCrmCustDO.deleteFlag.isNull());
        predicate = StringUtils.isEmpty((Object)custCode) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCrmCustDO.custCode.eq((Object)custCode));
        predicate = StringUtils.isEmpty((Object)ouId) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCrmCustDO.ouId.eq((Object)ouId));
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qCrmCustDO).from((EntityPath)this.qCrmCustDO)).where((Predicate)predicate)).fetchCount() > 0L;
    }

    public Boolean existsCode(String custCode, Long id) {
        BooleanExpression predicate = this.qCrmCustDO.deleteFlag.eq((Object)0).or((Predicate)this.qCrmCustDO.deleteFlag.isNull());
        predicate = StringUtils.isEmpty((Object)custCode) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCrmCustDO.custCode.eq((Object)custCode));
        predicate = StringUtils.isEmpty((Object)id) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCrmCustDO.id.ne((Object)id));
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qCrmCustDO).from((EntityPath)this.qCrmCustDO)).where((Predicate)predicate)).fetchCount() > 0L;
    }

    public void updateAddrNo(Long id, Long addrNo) {
        this.jpaQueryFactory.update((EntityPath)this.qCrmCustDO).set(this.qCrmCustDO.addrNo, (Object)addrNo).where(new Predicate[]{this.qCrmCustDO.id.eq((Object)id)}).execute();
    }

    public List<CrmCustRespDTO> queryAllByAgentEmpId(Long agentEmpId) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{this.qCrmCustDO.taxRateNo, this.qCrmCustDO.taxRate, this.qCrmCustDO.region, this.qCrmCustDO.custCurr, this.qCrmCustDO.agentEmpId}).from((EntityPath)this.qCrmCustDO)).where((Predicate)this.qCrmCustDO.agentEmpId.eq((Object)agentEmpId).and((Predicate)this.qCrmCustDO.deleteFlag.ne((Object)1)))).fetch().parallelStream().map(tuple -> {
            CrmCustRespDTO crmCustRespDTO = new CrmCustRespDTO();
            crmCustRespDTO.setTaxRateNo((String)tuple.get((Expression)this.qCrmCustDO.taxRateNo));
            crmCustRespDTO.setTaxRate((BigDecimal)tuple.get(this.qCrmCustDO.taxRate));
            crmCustRespDTO.setRegion((String)tuple.get((Expression)this.qCrmCustDO.region));
            crmCustRespDTO.setCustCurr((String)tuple.get((Expression)this.qCrmCustDO.custCurr));
            crmCustRespDTO.setAgentEmpId((Long)tuple.get(this.qCrmCustDO.agentEmpId));
            return crmCustRespDTO;
        }).collect(Collectors.toList());
    }

    public BigDecimal getCreditLimitById(Long id) {
        return null;
    }

    public String getStatusById(Long id) {
        return (String)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qCrmCustDO.custStatus).from((EntityPath)this.qCrmCustDO)).where((Predicate)this.qCrmCustDO.id.eq((Object)id).and((Predicate)this.qCrmCustDO.deleteFlag.ne((Object)1)))).fetchOne();
    }

    public Long getaddrNoByCode(String custCode) {
        return (Long)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qCrmCustDO.addrNo).from((EntityPath)this.qCrmCustDO)).where((Predicate)this.qCrmCustDO.custCode.eq((Object)custCode).and((Predicate)this.qCrmCustDO.deleteFlag.ne((Object)1)))).fetchOne();
    }

    public String getCustNameByPidCode(String custCode) {
        return (String)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qCrmCustDO.custName).from((EntityPath)this.qCrmCustDO)).where((Predicate)this.qCrmCustDO.custCode.eq((Object)custCode).and((Predicate)this.qCrmCustDO.deleteFlag.ne((Object)1)))).fetchOne();
    }

    public List<CrmCustSimpleVO> getCustByName(String custName) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{this.qCrmCustDO.custCode, this.qCrmCustDO.id, this.qCrmCustDO.custName, this.qCrmCustDO.custAbbr}).from((EntityPath)this.qCrmCustDO)).where((Predicate)this.qCrmCustDO.custName.eq((Object)custName).and((Predicate)this.qCrmCustDO.deleteFlag.ne((Object)1)))).fetch().parallelStream().map(tuple -> {
            CrmCustSimpleVO crmCustSimpleVO = new CrmCustSimpleVO();
            crmCustSimpleVO.setId((Long)tuple.get(this.qCrmCustDO.id));
            crmCustSimpleVO.setCustName((String)tuple.get((Expression)this.qCrmCustDO.custName));
            crmCustSimpleVO.setCustCode((String)tuple.get((Expression)this.qCrmCustDO.custCode));
            crmCustSimpleVO.setCustAbbr((String)tuple.get((Expression)this.qCrmCustDO.custAbbr));
            return crmCustSimpleVO;
        }).collect(Collectors.toList());
    }

    public List<CrmCustSimpleVO> getCustByCodes(List<String> custCodes) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{this.qCrmCustDO.custCode, this.qCrmCustDO.id, this.qCrmCustDO.custName, this.qCrmCustDO.custAbbr}).from((EntityPath)this.qCrmCustDO)).where((Predicate)this.qCrmCustDO.custCode.in(custCodes).and((Predicate)this.qCrmCustDO.deleteFlag.ne((Object)1)))).fetch().parallelStream().map(tuple -> {
            CrmCustSimpleVO crmCustSimpleVO = new CrmCustSimpleVO();
            crmCustSimpleVO.setId((Long)tuple.get(this.qCrmCustDO.id));
            crmCustSimpleVO.setCustName((String)tuple.get((Expression)this.qCrmCustDO.custName));
            crmCustSimpleVO.setCustCode((String)tuple.get((Expression)this.qCrmCustDO.custCode));
            crmCustSimpleVO.setCustAbbr((String)tuple.get((Expression)this.qCrmCustDO.custAbbr));
            return crmCustSimpleVO;
        }).collect(Collectors.toList());
    }

    public List<CrmCustSimpleDTO> getCustByCode(String custCode) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{this.qCrmCustDO.custCode, this.qCrmCustDO.id, this.qCrmCustDO.custName, this.qCrmCustDO.custAbbr, this.qCrmCustDO.contactPhone, this.qCrmCustDO.contactName}).from((EntityPath)this.qCrmCustDO)).where((Predicate)this.qCrmCustDO.custCode.eq((Object)custCode).and((Predicate)this.qCrmCustDO.deleteFlag.ne((Object)1)))).fetch().parallelStream().map(tuple -> {
            CrmCustSimpleDTO dto = new CrmCustSimpleDTO();
            dto.setId((Long)tuple.get(this.qCrmCustDO.id));
            dto.setCustCode((String)tuple.get((Expression)this.qCrmCustDO.custCode));
            dto.setCustName((String)tuple.get((Expression)this.qCrmCustDO.custName));
            dto.setCustAbbr((String)tuple.get((Expression)this.qCrmCustDO.custAbbr));
            dto.setContactName((String)tuple.get((Expression)this.qCrmCustDO.contactName));
            dto.setContactPhone((String)tuple.get((Expression)this.qCrmCustDO.contactPhone));
            return dto;
        }).collect(Collectors.toList());
    }

    public List<CrmCustSimpleVO> findIdByNameAndTaxRegNo(String custName, String taxRegNo) {
        BooleanExpression predicate = this.qCrmCustDO.deleteFlag.eq((Object)0).or((Predicate)this.qCrmCustDO.deleteFlag.isNull());
        predicate = StringUtils.isEmpty((Object)custName) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCrmCustDO.custName.eq((Object)custName));
        predicate = StringUtils.isEmpty((Object)taxRegNo) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCrmCustDO.taxRegNo.eq((Object)taxRegNo));
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{this.qCrmCustDO.id, this.qCrmCustDO.custCode, this.qCrmCustDO.addrNo}).from((EntityPath)this.qCrmCustDO)).where((Predicate)predicate)).fetch().stream().map(tuple -> {
            CrmCustSimpleVO dto = new CrmCustSimpleVO();
            dto.setId((Long)tuple.get(this.qCrmCustDO.id));
            dto.setCustCode((String)tuple.get((Expression)this.qCrmCustDO.custCode));
            dto.setAddrNo((Long)tuple.get(this.qCrmCustDO.addrNo));
            return dto;
        }).collect(Collectors.toList());
    }

    public LmSaveCustRespVO getCustInfoByCustCode(String custCode) {
        return (LmSaveCustRespVO)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(LmSaveCustRespVO.class, (Expression[])new Expression[]{this.qCrmCustDO.id, this.qCrmCustDO.custName, this.qCrmCustDO.custCode, this.qCrmCustDO.custCode2, this.qCrmCustDO.addrNo, this.qCrmCustDO.invAddress, this.qCrmCustDO.invBankAcc, this.qCrmCustDO.invBankBranch, this.qCrmCustDO.invTel, this.qCrmCustDO.invBankName, this.qCrmCustDO.invPicName, this.qCrmCustDO.invPicPhone, this.qCrmCustDO.invTitle, this.qCrmCustDO.custCurr, this.qCrmCustDO.taxerNo, this.qCrmCustDO.pid, this.qCrmCustDO.invType, this.qCrmCustDO.custAbbr, this.qCrmCustDO.contactName, this.qCrmCustDO.contactPhone, this.qCrmCustDO.agentEmpId, this.qCrmCustDO.createTime, this.qCrmCustDO.region, this.qCrmCustDO.custType, this.qCrmCustDO.corOu, this.qCrmCustDO.storeOrderFlag, this.qCrmCustDO.legalRepre})).from((EntityPath)this.qCrmCustDO)).where((Predicate)this.qCrmCustDO.custCode.eq((Object)custCode).and((Predicate)this.qCrmCustDO.deleteFlag.ne((Object)1)))).fetchOne();
    }

    public List<LmSaveCustRespVO> getCustInfoByParam(CustAddrFindParam param) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(LmSaveCustRespVO.class, (Expression[])new Expression[]{this.qCrmCustDO.id, this.qCrmCustDO.custName, this.qCrmCustDO.custCode, this.qCrmCustDO.custCode2, this.qCrmCustDO.addrNo, this.qCrmCustDO.invAddress, this.qCrmCustDO.invBankAcc, this.qCrmCustDO.invBankBranch, this.qCrmCustDO.invTel, this.qCrmCustDO.invPicName, this.qCrmCustDO.invPicPhone, this.qCrmCustDO.invTitle, this.qCrmCustDO.pid, this.qCrmCustDO.custAbbr, this.qCrmCustDO.contactName, this.qCrmCustDO.contactPhone, this.qCrmCustDO.agentEmpId, this.qCrmCustDO.createTime, this.qCrmCustDO.region, this.qCrmCustDO.storeOrderFlag, this.qCrmCustDO.custType})).from((EntityPath)this.qCrmCustDO)).where(this.custInfoByParamWhere(param))).fetch();
    }

    private Predicate custInfoByParamWhere(CustAddrFindParam param) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        list.add(this.qCrmCustDO.deleteFlag.eq((Object)0));
        if (!CollectionUtils.isEmpty((Collection)param.getCustCodes())) {
            list.add(this.qCrmCustDO.custCode.in((Collection)param.getCustCodes()));
        }
        if (!StringUtil.isBlank((CharSequence)param.getCustCode2())) {
            list.add(this.qCrmCustDO.custCode2.contains(param.getCustCode2()));
        }
        if (!StringUtil.isBlank((CharSequence)param.getCustName())) {
            list.add(this.qCrmCustDO.custName.contains(param.getCustName()));
        }
        if (!StringUtil.isBlank((CharSequence)param.getCustCode())) {
            list.add(this.qCrmCustDO.custCode.contains(param.getCustCode()));
        }
        return ExpressionUtils.allOf(list);
    }

    public List<LmSaveCustRespVO> getCustInfoByPid(String custCode) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(LmSaveCustRespVO.class, (Expression[])new Expression[]{this.qCrmCustDO.id, this.qCrmCustDO.custName, this.qCrmCustDO.custCode, this.qCrmCustDO.custCode2, this.qCrmCustDO.addrNo, this.qCrmCustDO.invAddress, this.qCrmCustDO.invBankAcc, this.qCrmCustDO.invBankBranch, this.qCrmCustDO.invTel, this.qCrmCustDO.invPicName, this.qCrmCustDO.invPicPhone, this.qCrmCustDO.invTitle, this.qCrmCustDO.custCurr, this.qCrmCustDO.taxerNo, this.qCrmCustDO.pid, this.qCrmCustDO.custAbbr, this.qCrmCustDO.contactName, this.qCrmCustDO.contactPhone, this.qCrmCustDO.agentEmpId, this.qCrmCustDO.createTime, this.qCrmCustDO.region, this.qCrmCustDO.custType})).from((EntityPath)this.qCrmCustDO)).where((Predicate)this.qCrmCustDO.pid.eq((Object)custCode).and((Predicate)this.qCrmCustDO.deleteFlag.ne((Object)1)))).fetch();
    }

    public List<LmSaveCustRespVO> getCustInfoByCustCodes(CrmCustSimpleParam param) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(LmSaveCustRespVO.class, (Expression[])new Expression[]{this.qCrmCustDO.id, this.qCrmCustDO.custName, this.qCrmCustDO.custCode, this.qCrmCustDO.custCode2, this.qCrmCustDO.addrNo, this.qCrmCustDO.invAddress, this.qCrmCustDO.invBankAcc, this.qCrmCustDO.invBankBranch, this.qCrmCustDO.invBankName, this.qCrmCustDO.invTel, this.qCrmCustDO.invPicName, this.qCrmCustDO.invPicPhone, this.qCrmCustDO.invTitle, this.qCrmCustDO.custCurr, this.qCrmCustDO.taxerNo, this.qCrmCustDO.pid, this.qCrmCustDO.custAbbr, this.qCrmCustDO.contactName, this.qCrmCustDO.contactPhone, this.qCrmCustDO.agentEmpId, this.qCrmCustDO.storeOrderFlag, this.qCrmCustDO.createTime, this.qCrmCustDO.region, this.qCrmCustDO.custType, this.qCrmCustDO.invType})).from((EntityPath)this.qCrmCustDO)).where(this.simpleWhere(param))).fetch();
    }

    public Predicate simpleWhere(CrmCustSimpleParam param) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        list.add(this.qCrmCustDO.deleteFlag.eq((Object)0));
        if (StringUtil.isNotBlank((CharSequence)param.getCorOu())) {
            list.add(this.qCrmCustDO.corOu.eq((Object)param.getCorOu()));
        }
        if (StringUtil.isNotBlank((CharSequence)param.getCustCode())) {
            list.add(this.qCrmCustDO.custCode.eq((Object)param.getCustCode()));
        }
        return ExpressionUtils.allOf(list);
    }

    public List<LmSaveCustRespVO> findBaseCustInfo(CustCode2BaseParam param) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(LmSaveCustRespVO.class, (Expression[])new Expression[]{this.qCrmCustDO.id, this.qCrmCustDO.custName, this.qCrmCustDO.custCode, this.qCrmCustDO.custCode2, this.qCrmCustDO.addrNo, this.qCrmCustDO.invAddress, this.qCrmCustDO.invBankAcc, this.qCrmCustDO.invBankBranch, this.qCrmCustDO.invTel, this.qCrmCustDO.invPicName, this.qCrmCustDO.invPicPhone, this.qCrmCustDO.invTitle, this.qCrmCustDO.pid, this.qCrmCustDO.custAbbr, this.qCrmCustDO.contactName, this.qCrmCustDO.contactPhone, this.qCrmCustDO.agentEmpId, this.qCrmCustDO.createTime, this.qCrmCustDO.region, this.qCrmCustDO.taxerNo, this.qCrmCustDO.invType, this.qCrmCustDO.custType})).from((EntityPath)this.qCrmCustDO)).where(this.whereCustCode2(param))).fetch();
    }

    public List<LmSaveCustRespVO> getCustInfoByCustCodes(List<String> custCode) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(LmSaveCustRespVO.class, (Expression[])new Expression[]{this.qCrmCustDO.id, this.qCrmCustDO.custName, this.qCrmCustDO.custCode, this.qCrmCustDO.custCode2, this.qCrmCustDO.addrNo, this.qCrmCustDO.invAddress, this.qCrmCustDO.invBankAcc, this.qCrmCustDO.invBankName, this.qCrmCustDO.invBankBranch, this.qCrmCustDO.invTel, this.qCrmCustDO.invPicName, this.qCrmCustDO.invPicPhone, this.qCrmCustDO.invTitle, this.qCrmCustDO.custCurr, this.qCrmCustDO.taxerNo, this.qCrmCustDO.pid, this.qCrmCustDO.custAbbr, this.qCrmCustDO.contactName, this.qCrmCustDO.contactPhone, this.qCrmCustDO.agentEmpId, this.qCrmCustDO.createTime, this.qCrmCustDO.region, this.qCrmCustDO.custType, this.qCrmCustDO.invType, this.qCrmCustDO.legalRepre, this.qCrmCustDO.storeOrderFlag, this.qCrmCustDO.custStatus})).from((EntityPath)this.qCrmCustDO)).where((Predicate)this.qCrmCustDO.custCode.in(custCode).and((Predicate)this.qCrmCustDO.deleteFlag.ne((Object)1)))).fetch();
    }

    public List<LmSaveCustRespVO> getCustInfoByCustCode2s(List<String> custCode2s) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(LmSaveCustRespVO.class, (Expression[])new Expression[]{this.qCrmCustDO.id, this.qCrmCustDO.custName, this.qCrmCustDO.custCode, this.qCrmCustDO.custCode2, this.qCrmCustDO.addrNo, this.qCrmCustDO.invAddress, this.qCrmCustDO.invBankAcc, this.qCrmCustDO.invBankName, this.qCrmCustDO.invBankBranch, this.qCrmCustDO.invTel, this.qCrmCustDO.invPicName, this.qCrmCustDO.invPicPhone, this.qCrmCustDO.invTitle, this.qCrmCustDO.custCurr, this.qCrmCustDO.taxerNo, this.qCrmCustDO.pid, this.qCrmCustDO.custAbbr, this.qCrmCustDO.contactName, this.qCrmCustDO.contactPhone, this.qCrmCustDO.agentEmpId, this.qCrmCustDO.createTime, this.qCrmCustDO.region, this.qCrmCustDO.custType, this.qCrmCustDO.storeOrderFlag, this.qCrmCustDO.invType, this.qCrmCustDO.legalRepre, this.qCrmCustDO.custStatus})).from((EntityPath)this.qCrmCustDO)).where((Predicate)this.qCrmCustDO.custCode2.in(custCode2s).and((Predicate)this.qCrmCustDO.deleteFlag.ne((Object)1)))).fetch();
    }

    public CustCorOuResVO getCustCorOu(String custCode) {
        return (CustCorOuResVO)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(CustCorOuResVO.class, (Expression[])new Expression[]{this.qCrmCustDO.id, this.qCrmCustDO.custCode, this.qCrmCustDO.pid, this.qCrmCustDO.custGroup, this.qCrmCustDO.custName, this.qCrmCustDO.outerCode, this.qCrmCustDO.custCode2, this.qCrmCustDO.custAbbr, this.qCrmCustDO.custType2, this.qCrmCustDO.custType, this.qCrmCustDO.region, this.qCrmCustDO.agentEmpId, this.qCrmCustDO.custLevel, this.qCrmCustDO.certNo, this.qCrmCustDO.custCurr, this.qCrmCustDO.country, this.qCrmCustDO.taxpayerType, this.qCrmCustDO.contactName, this.qCrmCustDO.contactPhone, this.qCrmCustDO.custStatus, this.qCrmCustDO.isCreateOu, this.qCrmCustDO.corOu})).from((EntityPath)this.qCrmCustDO)).where((Predicate)this.qCrmCustDO.deleteFlag.eq((Object)0).and((Predicate)this.qCrmCustDO.custCode.eq((Object)custCode).and((Predicate)this.qCrmCustDO.isCreateOu.eq((Object)1))))).fetchOne();
    }
}

