/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.repo;

import com.elitesland.yst.production.sale.api.vo.param.component.SalesmanParamVO;
import com.elitesland.yst.production.sale.api.vo.resp.component.SalesmanPageRespVO;
import com.elitesland.yst.production.sale.entity.QSalesmanInfoDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class SalesmanComponentRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private static final QSalesmanInfoDO salesmanInfoDO = QSalesmanInfoDO.salesmanInfoDO;
    private final QBean<SalesmanPageRespVO> salesmanList;

    public long countSalesMan(SalesmanParamVO paramVO) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)salesmanInfoDO.count()).from((EntityPath)salesmanInfoDO);
        jpaQuery.where(this.whereSalesman(paramVO));
        return jpaQuery.fetchCount();
    }

    public List<SalesmanPageRespVO> querySalesMan(SalesmanParamVO paramVO) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select(this.salesmanList).from((EntityPath)salesmanInfoDO);
        paramVO.setPaging(jpaQuery);
        paramVO.fillOrders(jpaQuery, (EntityPathBase)salesmanInfoDO);
        jpaQuery.where(this.whereSalesman(paramVO));
        return jpaQuery.fetch();
    }

    private Predicate whereSalesman(SalesmanParamVO paramVO) {
        String likeStr;
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(SalesmanComponentRepoProc.salesmanInfoDO.enableStatus.eq((Object)1));
        if (StringUtils.isNotBlank((CharSequence)paramVO.getEmpCodeName())) {
            likeStr = "%" + paramVO.getEmpCodeName() + "%";
            predicates.add(SalesmanComponentRepoProc.salesmanInfoDO.salesmanNo.like(likeStr).or((Predicate)SalesmanComponentRepoProc.salesmanInfoDO.name.like(likeStr)));
        }
        if (StringUtils.isNotBlank((CharSequence)paramVO.getOuCodeName())) {
            likeStr = "%" + paramVO.getOuCodeName() + "%";
            predicates.add(SalesmanComponentRepoProc.salesmanInfoDO.ouCode.like(likeStr).or((Predicate)SalesmanComponentRepoProc.salesmanInfoDO.ouName.like(likeStr)));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public SalesmanComponentRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.salesmanList = Projections.bean(SalesmanPageRespVO.class, (Expression[])new Expression[]{SalesmanComponentRepoProc.salesmanInfoDO.id, SalesmanComponentRepoProc.salesmanInfoDO.salesmanNo.as("empCode"), SalesmanComponentRepoProc.salesmanInfoDO.name.as("empName"), SalesmanComponentRepoProc.salesmanInfoDO.salesmanType, SalesmanComponentRepoProc.salesmanInfoDO.ouCode, SalesmanComponentRepoProc.salesmanInfoDO.ouName});
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

