/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.rmi.ystsupport;

import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.yst.production.support.provider.org.dto.OrgStoreDetailRpcDTO;
import com.elitesland.yst.production.support.provider.org.service.OrgStoreRpcService;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class RmiOrgStoreRpcService {
    private static final Logger log = LoggerFactory.getLogger(RmiOrgStoreRpcService.class);
    @Autowired
    private OrgStoreRpcService orgStoreRpcService;

    public OrgStoreDetailRpcDTO findStoreById(Long id) {
        log.info("\u8c03\u7528support\u57df:\u6839\u636e\u95e8\u5e97ID\u67e5\u8be2\u95e8\u5e97\u4fe1\u606f,\u65f6\u95f4\uff1a{},\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)id);
        try {
            if (Objects.isNull(id)) {
                return null;
            }
            OrgStoreDetailRpcDTO orgStoreDetailRpcDTO = this.orgStoreRpcService.get(id);
            log.info("\u8c03\u7528support\u57df:\u6839\u636e\u95e8\u5e97ID\u67e5\u8be2\u95e8\u5e97\u4fe1\u606f,\u65f6\u95f4\uff1a{},\u51fa\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)orgStoreDetailRpcDTO);
            return orgStoreDetailRpcDTO;
        }
        catch (Exception e) {
            log.error("\u8c03\u7528support\u57df:\u6839\u636e\u95e8\u5e97ID\u67e5\u8be2\u95e8\u5e97\u4fe1\u606f,error\uff1a{}", (Object)e.getMessage());
            throw new BusinessException("\u8c03\u7528support\u57df:" + e.getMessage());
        }
    }

    public List<OrgStoreDetailRpcDTO> findStoreByStoreCodes(List<String> storeCodes) {
        log.info("\u8c03\u7528support\u57df:\u6839\u636e\u95e8\u5e97\u7f16\u7801\u6279\u91cf\u67e5\u8be2\u95e8\u5e97,\u65f6\u95f4\uff1a{},\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), storeCodes);
        if (CollectionUtils.isEmpty(storeCodes)) {
            return Collections.emptyList();
        }
        try {
            List orgStoreDetailRpcDTOList = this.orgStoreRpcService.queryByStoreCodes(storeCodes);
            log.info("\u8c03\u7528support\u57df:\u6839\u636e\u95e8\u5e97\u7f16\u7801\u6279\u91cf\u67e5\u8be2\u95e8\u5e97,\u65f6\u95f4\uff1a{},\u51fa\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)orgStoreDetailRpcDTOList);
            if (CollectionUtils.isEmpty((Collection)orgStoreDetailRpcDTOList)) {
                return Collections.EMPTY_LIST;
            }
            return orgStoreDetailRpcDTOList;
        }
        catch (Exception e) {
            log.error("\u8c03\u7528support\u57df:\u6839\u636e\u95e8\u5e97\u7f16\u7801\u6279\u91cf\u67e5\u8be2\u95e8\u5e97,error\uff1a{}", (Object)e.getMessage());
            throw new BusinessException("\u8c03\u7528support\u57df:" + e.getMessage());
        }
    }
}

