/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service;

import cn.hutool.core.collection.IterUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.security.util.DataAuthJpaUtil;
import com.elitesland.yst.production.sale.api.service.FirstSpecialItemService;
import com.elitesland.yst.production.sale.api.service.shop.BipItemAppService;
import com.elitesland.yst.production.sale.api.service.shop.BipOrderService;
import com.elitesland.yst.production.sale.api.vo.param.special.FirstIsAddShopParam;
import com.elitesland.yst.production.sale.api.vo.param.special.FirstSpecialItemAppParam;
import com.elitesland.yst.production.sale.api.vo.param.special.FirstSpecialItemAppVO;
import com.elitesland.yst.production.sale.api.vo.param.special.FirstSpecialItemQueryParam;
import com.elitesland.yst.production.sale.api.vo.param.special.FirstSpecialItemSaveParam;
import com.elitesland.yst.production.sale.api.vo.param.special.FirstSpecialStatusParam;
import com.elitesland.yst.production.sale.api.vo.resp.shop.FirstSpecialItemVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.FirstSpecialVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.common.model.CurrentUserDTO;
import com.elitesland.yst.production.sale.core.service.UserService;
import com.elitesland.yst.production.sale.entity.BipItemDO;
import com.elitesland.yst.production.sale.entity.FirstSpecialDO;
import com.elitesland.yst.production.sale.entity.FirstSpecialItemDO;
import com.elitesland.yst.production.sale.entity.QBusFirstMenuConfDDO;
import com.elitesland.yst.production.sale.entity.QFirstSpecialDO;
import com.elitesland.yst.production.sale.entity.QFirstSpecialItemDO;
import com.elitesland.yst.production.sale.entity.QZoneSettingDDO;
import com.elitesland.yst.production.sale.repo.BusFirstMenuConfDRepo;
import com.elitesland.yst.production.sale.repo.FirstSpecialItemRepo;
import com.elitesland.yst.production.sale.repo.FirstSpecialRepo;
import com.elitesland.yst.production.sale.repo.ZoneSettingDRepo;
import com.elitesland.yst.production.sale.repo.shop.BipCartRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipItemRepo;
import com.elitesland.yst.production.sale.repo.shop.BipOrderRepo;
import com.elitesland.yst.production.support.provider.org.dto.OrgUserEmpInfoRpcDTO;
import com.elitesland.yst.production.support.provider.org.service.OrgEmpRpcService;
import com.google.common.collect.Lists;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FirstSpecialItemServiceImpl
implements FirstSpecialItemService {
    private static final Logger log = LoggerFactory.getLogger(FirstSpecialItemServiceImpl.class);
    private final FirstSpecialItemRepo firstSpecialItemRepo;
    private final OrgEmpRpcService orgEmpRpcService;
    private final BipItemRepo bipItemRepo;
    private final BipItemAppService bipItemAppService;
    private final FirstSpecialRepo firstSpecialRepo;
    private final ZoneSettingDRepo zoneSettingDRepo;
    private final BusFirstMenuConfDRepo busFirstMenuConfDRepo;
    private final BipOrderService bipOrderService;
    private final BipCartRepoProc bipCartRepoProc;
    private final BipOrderRepo bipOrderRepo;

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Object> save(FirstSpecialItemSaveParam param) {
        OrgUserEmpInfoRpcDTO orgUserEmpInfoRpcDTO = this.getCurrentEmpInfo();
        if (null != param) {
            if (null == param.getId() || param.getId() < 0L) {
                FirstSpecialDO firstSpecialDO = new FirstSpecialDO();
                BeanUtils.copyProperties((Object)param, (Object)firstSpecialDO);
                firstSpecialDO.setOuId(orgUserEmpInfoRpcDTO.getOuId());
                firstSpecialDO.setOuCode(orgUserEmpInfoRpcDTO.getOuCode());
                firstSpecialDO.setOuName(orgUserEmpInfoRpcDTO.getOuName());
                firstSpecialDO = (FirstSpecialDO)this.firstSpecialRepo.save(firstSpecialDO);
                if (null != param.getList() && !param.getList().isEmpty()) {
                    List list = param.getList();
                    FirstSpecialDO finalFirstSpecialDO = firstSpecialDO;
                    list.stream().forEach(l -> {
                        FirstSpecialItemDO firstSpecialItemDO = new FirstSpecialItemDO();
                        BeanUtils.copyProperties((Object)l, (Object)firstSpecialItemDO);
                        firstSpecialItemDO.setSpecialId(finalFirstSpecialDO.getId());
                        firstSpecialItemDO.setOuId(orgUserEmpInfoRpcDTO.getOuId());
                        firstSpecialItemDO.setOuCode(orgUserEmpInfoRpcDTO.getOuCode());
                        firstSpecialItemDO.setOuName(orgUserEmpInfoRpcDTO.getOuName());
                        this.firstSpecialItemRepo.save(firstSpecialItemDO);
                    });
                }
            } else {
                Optional optional = this.firstSpecialRepo.findById(param.getId());
                if (optional.isPresent()) {
                    FirstSpecialDO firstSpecialDO = (FirstSpecialDO)optional.get();
                    BeanUtils.copyProperties((Object)param, (Object)firstSpecialDO);
                    this.firstSpecialRepo.save(firstSpecialDO);
                    List<FirstSpecialItemDO> lists = this.getItemListBySpecialId(param.getId());
                    if (!lists.isEmpty()) {
                        lists.stream().forEach(l -> {
                            l.setDeleteFlag(1);
                            this.firstSpecialItemRepo.save(l);
                        });
                    }
                    if (null != param.getList() && !param.getList().isEmpty()) {
                        List list = param.getList();
                        FirstSpecialDO finalFirstSpecialDO = firstSpecialDO;
                        list.stream().forEach(l -> {
                            FirstSpecialItemDO firstSpecialItemDO = new FirstSpecialItemDO();
                            BeanUtils.copyProperties((Object)l, (Object)firstSpecialItemDO);
                            firstSpecialItemDO.setSpecialId(finalFirstSpecialDO.getId());
                            firstSpecialItemDO.setOuId(orgUserEmpInfoRpcDTO.getOuId());
                            firstSpecialItemDO.setOuCode(orgUserEmpInfoRpcDTO.getOuCode());
                            firstSpecialItemDO.setOuName(orgUserEmpInfoRpcDTO.getOuName());
                            this.firstSpecialItemRepo.save(firstSpecialItemDO);
                        });
                    }
                }
            }
        }
        return ApiResult.ok();
    }

    public List<FirstSpecialItemDO> getItemListBySpecialId(Long specialId) {
        QFirstSpecialItemDO qFirstSpecialItemDO = QFirstSpecialItemDO.firstSpecialItemDO;
        BooleanExpression expression = qFirstSpecialItemDO.deleteFlag.eq((Object)0).and((Predicate)qFirstSpecialItemDO.specialId.eq((Object)specialId));
        Iterable iterables = this.firstSpecialItemRepo.findAll((Predicate)expression);
        if (!IterUtil.isEmpty((Iterable)iterables)) {
            return Lists.newArrayList((Iterable)iterables);
        }
        return null;
    }

    public void delByOuId(Long ouId) {
        QFirstSpecialItemDO qFirstSpecialItemDO = QFirstSpecialItemDO.firstSpecialItemDO;
        BooleanExpression expression = qFirstSpecialItemDO.deleteFlag.eq((Object)0).and((Predicate)qFirstSpecialItemDO.ouId.eq((Object)ouId));
        Iterable iterables = this.firstSpecialItemRepo.findAll((Predicate)expression);
        if (!IterUtil.isEmpty((Iterable)iterables)) {
            ArrayList list = new ArrayList();
            ArrayList resList = Lists.newArrayList((Iterable)iterables);
            resList.stream().forEach(r -> {
                r.setDeleteFlag(1);
                list.add(r);
            });
            this.firstSpecialItemRepo.saveAll(list);
        }
    }

    public Object del(List<Long> ids) {
        if (!ids.isEmpty()) {
            ids.stream().forEach(id -> {
                Optional optional = this.firstSpecialRepo.findById(id);
                if (optional.isPresent()) {
                    FirstSpecialDO firstSpecialItemDO = (FirstSpecialDO)optional.get();
                    firstSpecialItemDO.setDeleteFlag(1);
                    this.firstSpecialRepo.save(firstSpecialItemDO);
                }
            });
        }
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public Object closeOrActive(FirstSpecialStatusParam param) {
        if (!param.getIds().isEmpty() && StringUtils.isNotBlank((CharSequence)param.getStatus())) {
            QFirstSpecialDO qFirstSpecialDO = QFirstSpecialDO.firstSpecialDO;
            param.getIds().stream().forEach(id -> {
                Optional optional = this.firstSpecialRepo.findById(id);
                if (optional.isPresent()) {
                    FirstSpecialDO firstSpecialDO = (FirstSpecialDO)optional.get();
                    if (param.getStatus().equals(UdcEnum.FIRST_SPECIAL_ITEM_STATUS_ACTIVE.getValueCode())) {
                        BipItemDO bipItemDO;
                        Optional o = this.bipItemRepo.findById(firstSpecialDO.getItemId());
                        if (!o.isEmpty() && !(bipItemDO = (BipItemDO)o.get()).getOnShelf().booleanValue()) {
                            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u4e0a\u67b6\u5546\u54c1\u4e0d\u80fd\u6fc0\u6d3b");
                        }
                        BooleanExpression expression = qFirstSpecialDO.deleteFlag.eq((Object)0).and((Predicate)qFirstSpecialDO.ouId.eq((Object)firstSpecialDO.getOuId())).and((Predicate)qFirstSpecialDO.itemId.eq((Object)firstSpecialDO.getItemId())).and((Predicate)qFirstSpecialDO.status.eq((Object)UdcEnum.FIRST_SPECIAL_ITEM_STATUS_ACTIVE.getValueCode()));
                        Iterable iterables = this.firstSpecialRepo.findAll((Predicate)expression);
                        if (!IterUtil.isEmpty((Iterable)iterables)) {
                            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u76f8\u540c\u5546\u54c1\u53ea\u80fd\u6fc0\u6d3b\u4e00\u4e2a");
                        }
                    }
                    firstSpecialDO.setStatus(param.getStatus());
                    this.firstSpecialRepo.save(firstSpecialDO);
                }
            });
        }
        return null;
    }

    @SysCodeProc
    public PagingVO<FirstSpecialVO> searchAll(FirstSpecialItemQueryParam param) {
        QFirstSpecialDO qFirstSpecialDO = QFirstSpecialDO.firstSpecialDO;
        BooleanExpression expression = qFirstSpecialDO.deleteFlag.eq((Object)0);
        if (StringUtils.isNotBlank((CharSequence)param.getItemCode())) {
            expression = expression.and((Predicate)qFirstSpecialDO.itemCode.like("%" + param.getItemCode() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getItemName())) {
            expression = expression.and((Predicate)qFirstSpecialDO.itemName.like("%" + param.getItemName() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getStatus())) {
            expression = expression.and((Predicate)qFirstSpecialDO.status.eq((Object)param.getStatus()));
        }
        expression = expression.and(DataAuthJpaUtil.dataAuthJpaPredicate((PathMetadata)qFirstSpecialDO.getMetadata()));
        Page pageDo = this.firstSpecialRepo.findAll((Predicate)expression, (Pageable)param.getPageRequest());
        ArrayList list = new ArrayList();
        if (!pageDo.getContent().isEmpty()) {
            pageDo.getContent().stream().forEach(d -> {
                FirstSpecialVO firstSpecialVO = new FirstSpecialVO();
                BeanUtils.copyProperties((Object)d, (Object)firstSpecialVO);
                list.add(firstSpecialVO);
            });
        }
        return PagingVO.builder().total(pageDo.getTotalElements()).records(list).build();
    }

    @SysCodeProc
    public PagingVO<FirstSpecialItemAppVO> searchAppFirstSpecial(FirstSpecialItemAppParam param) {
        QFirstSpecialDO qFirstSpecialDO = QFirstSpecialDO.firstSpecialDO;
        BooleanExpression expression = qFirstSpecialDO.deleteFlag.eq((Object)0).and((Predicate)qFirstSpecialDO.status.eq((Object)UdcEnum.FIRST_SPECIAL_ITEM_STATUS_ACTIVE.getValueCode())).and((Predicate)qFirstSpecialDO.ouId.eq((Object)param.getOuId()));
        Page pageDo = this.firstSpecialRepo.findAll((Predicate)expression, (Pageable)param.getPageRequest());
        ArrayList list = new ArrayList();
        if (!pageDo.getContent().isEmpty()) {
            pageDo.getContent().stream().forEach(d -> {
                List<FirstSpecialItemDO> items;
                FirstSpecialItemAppVO firstSpecialItemAppVO = new FirstSpecialItemAppVO();
                BeanUtils.copyProperties((Object)d, (Object)firstSpecialItemAppVO);
                BipItemDO item = this.getByItemId(d.getItemId());
                if (null != item) {
                    firstSpecialItemAppVO.setRateEvalGood(item.getRateEvalGood());
                    firstSpecialItemAppVO.setNumSale(item.getNumSale());
                    firstSpecialItemAppVO.setMainPicUrl(item.getMainPicUrl());
                    firstSpecialItemAppVO.setMainPicFileCode(item.getMainPicFileCode());
                    firstSpecialItemAppVO.setTitle(item.getTitle());
                }
                if (null != (items = this.getItemListBySpecialId(d.getId())) && !items.isEmpty()) {
                    Optional preferentialPrice;
                    Optional basePrice;
                    ArrayList vos = new ArrayList();
                    ArrayList basePrices = new ArrayList();
                    ArrayList preferentialPrices = new ArrayList();
                    items.stream().forEach(i -> {
                        FirstSpecialItemVO firstSpecialItemVO = new FirstSpecialItemVO();
                        BeanUtils.copyProperties((Object)i, (Object)firstSpecialItemVO);
                        basePrices.add(i.getBasePrice());
                        preferentialPrices.add(i.getPreferentialPrice());
                    });
                    if (null != basePrices && !basePrices.isEmpty() && !(basePrice = basePrices.stream().min(BigDecimal::compareTo)).isEmpty()) {
                        firstSpecialItemAppVO.setBasePrice((BigDecimal)basePrice.get());
                    }
                    if (null != preferentialPrices && !preferentialPrices.isEmpty() && !(preferentialPrice = preferentialPrices.stream().min(BigDecimal::compareTo)).isEmpty()) {
                        firstSpecialItemAppVO.setPreferentialPrice((BigDecimal)preferentialPrice.get());
                    }
                }
                list.add(firstSpecialItemAppVO);
            });
            return PagingVO.builder().total(pageDo.getTotalElements()).records(list).build();
        }
        return new PagingVO();
    }

    @SysCodeProc
    public FirstSpecialItemSaveParam getItemList(Long specialId) {
        Optional optional = this.firstSpecialRepo.findById(specialId);
        FirstSpecialItemSaveParam vo = new FirstSpecialItemSaveParam();
        if (optional.isPresent()) {
            FirstSpecialDO firstSpecialDO = (FirstSpecialDO)optional.get();
            BeanUtils.copyProperties((Object)firstSpecialDO, (Object)vo);
            ArrayList vos = new ArrayList();
            List<FirstSpecialItemDO> items = this.getItemListBySpecialId(specialId);
            items.stream().forEach(i -> {
                FirstSpecialItemVO firstSpecialItemVO = new FirstSpecialItemVO();
                BeanUtils.copyProperties((Object)i, (Object)firstSpecialItemVO);
                vos.add(firstSpecialItemVO);
            });
            vo.setList(vos);
        }
        return vo;
    }

    public Boolean isAddShop(FirstIsAddShopParam param) {
        Boolean isPay = this.bipOrderService.isFirstOrder(param.getUserId(), "ps");
        if (!isPay.booleanValue()) {
            return true;
        }
        return false;
    }

    public BipItemDO getByItemId(Long itemId) {
        Optional optional = this.bipItemRepo.findById(itemId);
        if (optional.isPresent()) {
            return (BipItemDO)optional.get();
        }
        return null;
    }

    @SysCodeProc
    public List<FirstSpecialItemVO> searchList() {
        QFirstSpecialItemDO qFirstSpecialItemDO = QFirstSpecialItemDO.firstSpecialItemDO;
        BooleanExpression expression = qFirstSpecialItemDO.deleteFlag.eq((Object)0).and(DataAuthJpaUtil.dataAuthJpaPredicate((PathMetadata)qFirstSpecialItemDO.getMetadata()));
        Iterable iterables = this.firstSpecialItemRepo.findAll((Predicate)expression);
        if (!IterUtil.isEmpty((Iterable)iterables)) {
            ArrayList<FirstSpecialItemVO> list = new ArrayList<FirstSpecialItemVO>();
            iterables.forEach(d -> {
                FirstSpecialItemVO vo = new FirstSpecialItemVO();
                BeanUtils.copyProperties((Object)d, (Object)vo);
                list.add(vo);
            });
            return list;
        }
        return null;
    }

    private OrgUserEmpInfoRpcDTO getCurrentEmpInfo() {
        CurrentUserDTO currentUser = UserService.currentUser();
        if (currentUser == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f53\u524d\u7528\u6237\u5df2\u5931\u6548,\u8bf7\u91cd\u767b\u5f55\u91cd\u8bd5");
        }
        OrgUserEmpInfoRpcDTO userEmpInfo = this.orgEmpRpcService.findUserEmpInfo(currentUser.getUserId());
        if (userEmpInfo == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f");
        }
        return userEmpInfo;
    }

    public void updateItemState(List<Long> ids) {
        if (null != ids && !ids.isEmpty()) {
            this.excuteFirstSpecial(ids);
            this.excuteZoneSetting(ids);
            this.excuteFirstMenu(ids);
        }
    }

    public void excuteFirstMenu(List<Long> ids) {
        QBusFirstMenuConfDDO qBusFirstMenuConfDDO = QBusFirstMenuConfDDO.busFirstMenuConfDDO;
        BooleanExpression expression = qBusFirstMenuConfDDO.deleteFlag.eq((Object)0).and((Predicate)qBusFirstMenuConfDDO.itemId.in(ids));
        Iterable iterables = this.busFirstMenuConfDRepo.findAll((Predicate)expression);
        if (null != iterables && !IterUtil.isEmpty((Iterable)iterables)) {
            ArrayList list = Lists.newArrayList((Iterable)iterables);
            list.stream().forEach(l -> {
                l.setDeleteFlag(1);
                this.busFirstMenuConfDRepo.save(l);
            });
        }
    }

    public void excuteZoneSetting(List<Long> ids) {
        QZoneSettingDDO qZoneSettingDDO = QZoneSettingDDO.zoneSettingDDO;
        BooleanExpression expression = qZoneSettingDDO.deleteFlag.eq((Object)0).and((Predicate)qZoneSettingDDO.itemId.in(ids));
        Iterable iterables = this.zoneSettingDRepo.findAll((Predicate)expression);
        if (null != iterables && !IterUtil.isEmpty((Iterable)iterables)) {
            ArrayList list = Lists.newArrayList((Iterable)iterables);
            list.stream().forEach(l -> {
                l.setDeleteFlag(1);
                this.zoneSettingDRepo.save(l);
            });
        }
    }

    public void excuteFirstSpecial(List<Long> ids) {
        QFirstSpecialDO qFirstSpecialDO = QFirstSpecialDO.firstSpecialDO;
        BooleanExpression expression = qFirstSpecialDO.deleteFlag.eq((Object)0).and((Predicate)qFirstSpecialDO.status.eq((Object)UdcEnum.FIRST_SPECIAL_ITEM_STATUS_ACTIVE.getValueCode())).and((Predicate)qFirstSpecialDO.itemId.in(ids));
        Iterable iterables = this.firstSpecialRepo.findAll((Predicate)expression);
        if (null != iterables && !IterUtil.isEmpty((Iterable)iterables)) {
            ArrayList list = Lists.newArrayList((Iterable)iterables);
            list.stream().forEach(l -> {
                l.setStatus(UdcEnum.FIRST_SPECIAL_ITEM_STATUS_CLOSED.getValueCode());
                this.firstSpecialRepo.save(l);
            });
        }
    }

    public FirstSpecialItemServiceImpl(FirstSpecialItemRepo firstSpecialItemRepo, OrgEmpRpcService orgEmpRpcService, BipItemRepo bipItemRepo, BipItemAppService bipItemAppService, FirstSpecialRepo firstSpecialRepo, ZoneSettingDRepo zoneSettingDRepo, BusFirstMenuConfDRepo busFirstMenuConfDRepo, BipOrderService bipOrderService, BipCartRepoProc bipCartRepoProc, BipOrderRepo bipOrderRepo) {
        this.firstSpecialItemRepo = firstSpecialItemRepo;
        this.orgEmpRpcService = orgEmpRpcService;
        this.bipItemRepo = bipItemRepo;
        this.bipItemAppService = bipItemAppService;
        this.firstSpecialRepo = firstSpecialRepo;
        this.zoneSettingDRepo = zoneSettingDRepo;
        this.busFirstMenuConfDRepo = busFirstMenuConfDRepo;
        this.bipOrderService = bipOrderService;
        this.bipCartRepoProc = bipCartRepoProc;
        this.bipOrderRepo = bipOrderRepo;
    }
}

