/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service.shop;

import cn.hutool.core.collection.IterUtil;
import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.production.sale.api.service.PriSalePriceService;
import com.elitesland.yst.production.sale.api.service.shop.BipCartService;
import com.elitesland.yst.production.sale.api.service.shop.BipCompanyManageService;
import com.elitesland.yst.production.sale.api.service.shop.BipCouponCustService;
import com.elitesland.yst.production.sale.api.service.shop.BipCustUserBindService;
import com.elitesland.yst.production.sale.api.service.shop.BipItemMngService;
import com.elitesland.yst.production.sale.api.service.shop.BipOrderService;
import com.elitesland.yst.production.sale.api.service.shop.MktDiscountGiftService;
import com.elitesland.yst.production.sale.api.vo.param.logistics.LogisticsTemplateDFindParam;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipCartParmVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipCouponCustCurrentParam;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipCouponCustItemParam;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipFareAmtQueryParmVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.app.BipBuyNowSettleParmVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.app.BipCartSettleParmVO;
import com.elitesland.yst.production.sale.api.vo.resp.logistics.LogisticsTemplateDVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipAddressVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipCartItemRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipCartVo;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipCouponCustVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipItemDetailRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipItemPicRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipItemSkuAttrRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipItemSkuRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.MktDiscountGiftVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.MktDiscountOffsetVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.MktGiftRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.app.AttrAPPRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.app.AttrAppParamVO;
import com.elitesland.yst.production.sale.common.model.CurrentUserDTO;
import com.elitesland.yst.production.sale.convert.shop.BipCartCovert;
import com.elitesland.yst.production.sale.convert.shop.BipCartItemCovert;
import com.elitesland.yst.production.sale.convert.shop.BipItemConvert;
import com.elitesland.yst.production.sale.convert.shop.MktGiftCovert;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.core.service.UserService;
import com.elitesland.yst.production.sale.dto.PriSalePriceDTO;
import com.elitesland.yst.production.sale.dto.PriSalePriceSimpleDTO;
import com.elitesland.yst.production.sale.dto.query.PriSaleItemReqDTO;
import com.elitesland.yst.production.sale.dto.query.PriSalePriceReqDTO;
import com.elitesland.yst.production.sale.entity.BipCartDO;
import com.elitesland.yst.production.sale.entity.BipCouponDO;
import com.elitesland.yst.production.sale.entity.BipCustUserBindDO;
import com.elitesland.yst.production.sale.entity.BipItemDO;
import com.elitesland.yst.production.sale.entity.BipItemSkuDO;
import com.elitesland.yst.production.sale.entity.CrmCustDO;
import com.elitesland.yst.production.sale.entity.CrmCustOuDO;
import com.elitesland.yst.production.sale.entity.FirstSpecialItemDO;
import com.elitesland.yst.production.sale.entity.MktDiscountGiftDO;
import com.elitesland.yst.production.sale.entity.MktGiftDO;
import com.elitesland.yst.production.sale.entity.QBipCartDO;
import com.elitesland.yst.production.sale.entity.QBipItemDO;
import com.elitesland.yst.production.sale.entity.QBipItemSkuDO;
import com.elitesland.yst.production.sale.entity.QCrmCustOuDO;
import com.elitesland.yst.production.sale.entity.QFirstSpecialItemDO;
import com.elitesland.yst.production.sale.repo.BusFirstMenuConfRepo;
import com.elitesland.yst.production.sale.repo.CrmCustOuRepo;
import com.elitesland.yst.production.sale.repo.CrmCustRepo;
import com.elitesland.yst.production.sale.repo.FirstSpecialItemRepo;
import com.elitesland.yst.production.sale.repo.shop.BipCartRepo;
import com.elitesland.yst.production.sale.repo.shop.BipCartRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipCouponRepo;
import com.elitesland.yst.production.sale.repo.shop.BipCustUserBindRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipItemRepo;
import com.elitesland.yst.production.sale.repo.shop.BipItemRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipItemSkuRepo;
import com.elitesland.yst.production.sale.repo.shop.BipItemSkuRepoProc;
import com.elitesland.yst.production.sale.repo.shop.MktDiscountGiftRepo;
import com.elitesland.yst.production.sale.repo.shop.MktDiscountGiftRepoProc;
import com.elitesland.yst.production.sale.repo.shop.MktDiscountOffsetRepoProc;
import com.elitesland.yst.production.sale.repo.shop.MktGiftRepo;
import com.elitesland.yst.production.sale.repo.shop.MktGiftRepoProc;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiPriMainPriceService;
import com.elitesland.yst.production.sale.service.LogisticsTemplateDServiceImpl;
import com.elitesland.yst.production.sale.service.PriSalePriceRpcService;
import com.elitesland.yst.production.sale.service.shop.BipAddressServiceImpl;
import com.elitesland.yst.production.sale.service.shop.MktDiscountOffsetServiceImpl;
import com.google.common.collect.Lists;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BipCartServiceImpl
extends BaseServiceImpl
implements BipCartService {
    private static final Logger log = LoggerFactory.getLogger(BipCartServiceImpl.class);
    private final BipCartRepo bipCartRepo;
    private final RmiPriMainPriceService rmiPriMainPriceService;
    private final BipCartRepoProc bipCartRepoProc;
    private final BipCustUserBindRepoProc bipCustUserBindRepoProc;
    private final MktDiscountOffsetRepoProc mktDiscountOffsetRepoProc;
    private final MktDiscountGiftRepoProc mktDiscountGiftRepoProc;
    private final CrmCustRepo crmCustRepo;
    private final MktDiscountGiftRepo mktDiscountGiftRepo;
    private final MktGiftRepo mktGiftRepo;
    private final MktGiftRepoProc mktGiftRepoProc;
    private final BipCouponRepo bipCouponRepo;
    private final BusFirstMenuConfRepo busFirstMenuConfRepo;
    private final FirstSpecialItemRepo firstSpecialItemRepo;
    private final MktDiscountGiftService mktDiscountGiftService;
    private final PriSalePriceRpcService priSalePriceRpcService;
    private final CrmCustOuRepo crmCustOuRepo;
    @Autowired
    private BipCouponCustService bipCouponCustService;
    @Autowired
    private BipItemMngService bipItemService;
    @Autowired
    private MktDiscountOffsetServiceImpl mktDiscountOffsetService;
    @Autowired
    private BipItemSkuRepo bipItemSkuRepo;
    @Autowired
    private BipItemSkuRepoProc bipItemSkuRepoProc;
    @Autowired
    private BipItemRepo bipItemRepo;
    @Autowired
    private BipItemRepoProc bipItemRepoProc;
    @Autowired
    private BipAddressServiceImpl bipAddressService;
    @Autowired
    private LogisticsTemplateDServiceImpl logisticsTemplateDService;
    @Autowired
    private BipOrderService bipOrderService;
    @Autowired
    private BipCompanyManageService bipCompanyManageService;
    private final BipCustUserBindService custUserBindService;
    private final PriSalePriceService salePriceService;

    public void addItemToCart(BipCartParmVO bipCartParmVO) {
        log.info("\u8d2d\u7269\u8f66\u65b0\u589e\u53c2\u6570---" + JSON.toJSONString((Object)bipCartParmVO));
        Assert.notBlank((CharSequence)bipCartParmVO.getPriceType(), (String)"\u8bf7\u4f20\u5165\u4ef7\u683c\u7c7b\u578b\uff01", (Object[])new Object[0]);
        BipCustUserBindDO bipCustUserBindDO = null;
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        if (!Objects.nonNull(currentUserDTO.getUserId())) {
            throw new BusinessException("\u8bf7\u5148\u767b\u5f55!");
        }
        bipCustUserBindDO = this.bipCustUserBindRepoProc.getByUserId(currentUserDTO.getUserId());
        if (bipCustUserBindDO == null) {
            throw new BusinessException("\u8bf7\u7ed1\u5b9a\u516c\u53f8\u4fe1\u606f!");
        }
        if (this.bipItemSkuRepoProc.findFreezeStatus(bipCartParmVO.getSkuId()).booleanValue()) {
            throw new BusinessException("\u5546\u54c1" + bipCartParmVO.getSkuCode() + "\u5df2\u51bb\u7ed3");
        }
        BipCartDO bipCart = BipCartCovert.INSTANCE.BipCartParmVo2BipCart(bipCartParmVO);
        Long itemId = bipCart.getItemId();
        this.bipItemRepo.findById(itemId);
        bipCart.setUserId(currentUserDTO.getUserId());
        String skuCode = bipCart.getSkuCode();
        Long skuId = bipCart.getSkuId();
        Long num = bipCart.getItemNum();
        QBipCartDO qBipCartDO = QBipCartDO.bipCartDO;
        BooleanExpression e = qBipCartDO.deleteFlag.eq((Object)0).and((Predicate)qBipCartDO.userId.eq((Object)currentUserDTO.getUserId())).and((Predicate)qBipCartDO.itemId.eq((Object)itemId)).and((Predicate)qBipCartDO.skuId.eq((Object)skuId));
        Optional optional = this.bipCartRepo.findOne((Predicate)e);
        if (optional.isEmpty()) {
            bipCart.setStockEnough(this.checkCartStorm(skuId, num));
            this.bipCartRepo.save(bipCart);
        } else {
            BipCartDO bipCartDo = (BipCartDO)optional.get();
            Long exitNum = bipCartDo.getItemNum();
            long checkNum = exitNum + num;
            bipCart.setStockEnough(this.checkCartStorm(skuId, num));
            bipCartDo.setItemNum(checkNum);
            this.bipCartRepo.save(bipCartDo);
        }
    }

    public List<Long> getCrmCustOuIds(String custCode) {
        QCrmCustOuDO qCrmCustOuDO = QCrmCustOuDO.crmCustOuDO;
        BooleanExpression e = qCrmCustOuDO.custCode.eq((Object)custCode).and((Predicate)qCrmCustOuDO.deleteFlag.eq((Object)0));
        Iterable iterables = this.crmCustOuRepo.findAll((Predicate)e);
        if (!IterUtil.isEmpty((Iterable)iterables)) {
            ArrayList list = Lists.newArrayList((Iterable)iterables);
            List<Long> ouIdList = list.stream().filter(l -> null != l.getOuId()).map(CrmCustOuDO::getOuId).collect(Collectors.toList());
            return ouIdList;
        }
        return null;
    }

    public BipCartVo findBuyNowOrderPer(BipBuyNowSettleParmVO bipBuyNowSettleParmVO) {
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        Long addressId = bipBuyNowSettleParmVO.getAddressId();
        if (bipBuyNowSettleParmVO.getItemId() == null || bipBuyNowSettleParmVO.getSkuId() == null || bipBuyNowSettleParmVO.getItemNum() == null) {
            throw new BusinessException("\u7acb\u5373\u8d2d\u4e70\u53c2\u6570\u5f02\u5e38!");
        }
        if (this.bipItemSkuRepoProc.findFreezeStatus(bipBuyNowSettleParmVO.getSkuId()).booleanValue()) {
            throw new BusinessException("\u9500\u552e\u51bb\u7ed3\u72b6\u6001\u7684\u5546\u54c1\u4e0d\u80fd\u8d2d\u4e70");
        }
        BipCustUserBindDO bipCustUserBindDO = null;
        if (!Objects.nonNull(currentUserDTO.getUserId())) {
            throw new BusinessException("\u8bf7\u5148\u767b\u5f55!");
        }
        bipCustUserBindDO = this.bipCustUserBindRepoProc.getByUserId(currentUserDTO.getUserId());
        if (bipCustUserBindDO == null || null == bipCustUserBindDO.getCustId()) {
            throw new BusinessException("\u8bf7\u7ed1\u5b9a\u516c\u53f8\u4fe1\u606f!");
        }
        String custCode = bipCustUserBindDO.getCustCode();
        Long custId = bipCustUserBindDO.getCustId();
        CrmCustDO crmCustDO = (CrmCustDO)this.crmCustRepo.findById(custId).get();
        String custLevel = crmCustDO.getCustLevel();
        Long custOuId = crmCustDO.getOuId();
        Long ouId = bipBuyNowSettleParmVO.getOuId();
        ArrayList<Long> custOuIds = new ArrayList<Long>();
        List<Long> crmCustOuIds = this.getCrmCustOuIds(custCode);
        if (null != crmCustOuIds && !crmCustOuIds.isEmpty()) {
            custOuIds.addAll(crmCustOuIds);
        }
        custOuIds.add(custOuId);
        if (!custOuIds.contains(ouId)) {
            throw new BusinessException("\u53ea\u80fd\u8d2d\u4e70\u6240\u5c5e\u516c\u53f8\u5546\u54c1");
        }
        Long userId = currentUserDTO.getUserId();
        String userName = currentUserDTO.getUserName();
        BipCartItemRespVO bipCartItemRespVO = new BipCartItemRespVO();
        bipCartItemRespVO.setItemId(bipBuyNowSettleParmVO.getItemId());
        bipCartItemRespVO.setItemNum(bipBuyNowSettleParmVO.getItemNum());
        bipCartItemRespVO.setSkuId(bipBuyNowSettleParmVO.getSkuId());
        ArrayList<BipCartItemRespVO> itemVOList = new ArrayList<BipCartItemRespVO>();
        itemVOList.add(bipCartItemRespVO);
        ArrayList<Long> itemIds = new ArrayList<Long>();
        itemIds.add(bipBuyNowSettleParmVO.getItemId());
        this.checkItmeIdRelateOuId(itemIds, ouId);
        BipCartVo bipCartVo = new BipCartVo();
        bipCartVo.setCouponId(bipBuyNowSettleParmVO.getCouponId());
        if (null != bipBuyNowSettleParmVO.getFirstItemFlag() && bipBuyNowSettleParmVO.getFirstItemFlag().booleanValue()) {
            bipBuyNowSettleParmVO.setPreferentialPrice(this.getSpecialPrice(bipBuyNowSettleParmVO.getSkuId(), ouId));
        }
        this.buildOrderPerInfo(itemVOList, ouId, custLevel, userId, userName, bipCartVo, addressId, bipBuyNowSettleParmVO.getFirstItemFlag(), bipBuyNowSettleParmVO.getPreferentialPrice());
        this.buildMkDisscountOffsetInfo(itemVOList, ouId, custLevel);
        ArrayList<Long> skuIds = new ArrayList<Long>();
        skuIds.add(bipBuyNowSettleParmVO.getSkuId());
        log.info("\u67e5\u8be2\u8d60\u54c1\u4fe1\u606f-----------:" + JSON.toJSONString(itemVOList) + "ouId:" + ouId + "custLevel:" + custLevel + "skuIds:" + skuIds);
        this.getGiftList(itemVOList, ouId, custLevel, skuIds);
        log.info("\u7acb\u5373\u8d2d\u4e70\u7ed3\u7b97\u9875\u9762\u5546\u54c1\u4fe1\u606f" + JSON.toJSONString(itemVOList));
        BigDecimal discontFreeAmt = bipCartVo.getOrderDiscountFreeAmt();
        if (discontFreeAmt == null) {
            discontFreeAmt = BigDecimal.ZERO;
        }
        for (BipCartItemRespVO bipCartItemRespVO1 : itemVOList) {
            if (null == bipCartItemRespVO1 || null == bipCartItemRespVO1.getMktDiscountOffsetFreeAmt() || bipCartItemRespVO1.getMktDiscountOffsetFreeAmt().compareTo(BigDecimal.ZERO) == 0) continue;
            log.info(bipCartItemRespVO1.getItemName() + "--\u660e\u7ec6\u4fc3\u9500\u6298\u6263\u91d1\u989d--" + bipCartItemRespVO1.getMktDiscountOffsetFreeAmt());
            discontFreeAmt = discontFreeAmt.add(bipCartItemRespVO1.getMktDiscountOffsetFreeAmt());
        }
        log.info("\u4fc3\u9500\u6298\u6263\u91d1\u989d--" + discontFreeAmt);
        bipCartVo.setOrderDiscountFreeAmt(discontFreeAmt);
        bipCartVo.setItemList(itemVOList);
        if (!bipBuyNowSettleParmVO.getFirstItemFlag().booleanValue()) {
            this.buildItemCoupon(bipCartVo, userId, ouId);
        }
        for (BipCartItemRespVO respVO : bipCartVo.getItemList()) {
            Map<String, BigDecimal> prices = this.findSkuPriceReMap(respVO.getSkuCode(), userId, ouId);
            if (null != prices && null != prices.get("basePrice")) {
                respVO.setBasePrice(prices.get("basePrice"));
            }
            if (null == prices || null == prices.get("custPrice")) continue;
            respVO.setCustPrice(prices.get("custPrice"));
        }
        log.info("\u7acb\u5373\u8d2d\u4e70\u53c2\u6570\uff1a--------------------" + JSON.toJSONString((Object)bipCartVo));
        return bipCartVo;
    }

    private List<BigDecimal> findSkuPrice(String skuCode, Long userId) {
        return null;
    }

    private Map<String, BigDecimal> findSkuPriceReMap(String skuCode, Long userId, Long ouId) {
        return null;
    }

    public BigDecimal getSpecialPrice(Long skuId, Long ouId) {
        QFirstSpecialItemDO qFirstSpecialItemDO = QFirstSpecialItemDO.firstSpecialItemDO;
        BooleanExpression expression = qFirstSpecialItemDO.deleteFlag.eq((Object)0).and((Predicate)qFirstSpecialItemDO.skuId.eq((Object)skuId)).and((Predicate)qFirstSpecialItemDO.ouId.eq((Object)ouId));
        Optional optional = this.firstSpecialItemRepo.findOne((Predicate)expression);
        if (optional.isPresent()) {
            return ((FirstSpecialItemDO)optional.get()).getPreferentialPrice();
        }
        return null;
    }

    public void getGiftList(List<BipCartItemRespVO> itemVOList, Long ouId, String custLevel, List<Long> skuids) {
        log.info("\u4e70\u8d60\u67e5\u8be2\u5165\u53c2" + JSON.toJSONString(itemVOList));
        List giftList = this.mktDiscountGiftRepoProc.getGiftList(ouId, custLevel, LocalDateTime.now(), skuids).fetch();
        log.info("\u4e70\u8d60\u67e5\u8be2\u7ed3\u679c" + JSON.toJSONString((Object)giftList));
        itemVOList.forEach(item -> {
            ArrayList giftVOS = new ArrayList();
            giftList.forEach(gift -> {
                Long stockNum;
                if (item.getSkuId().equals(gift.getSkuId()) && (stockNum = Long.valueOf(gift.getStockNowNum() == null ? 0L : gift.getStockNowNum())) > 0L && (gift.getType().equals("0") && item.getItemNum() >= gift.getLimitNum() || gift.getType().equals("1") && item.getItemAmt().compareTo(gift.getLimitAmt()) >= 0)) {
                    giftVOS.add(gift);
                }
            });
            if (giftVOS.size() > 0) {
                item.setGiftList(giftVOS);
            }
        });
    }

    public void checkItmeIdRelateOuId(List<Long> itemIds, Long ouId) {
        List<Long> ouIds = this.bipItemRepoProc.findOuIdByItemIds(itemIds);
        if (ouIds == null || ouIds.isEmpty()) {
            throw new BusinessException("\u5546\u54c1\u672a\u7ed1\u5b9a\u516c\u53f8\u4fe1\u606f!");
        }
        if ((ouIds = ouIds.stream().distinct().collect(Collectors.toList())).size() > 1) {
            throw new BusinessException("\u5546\u54c1\u516c\u53f8\u4fe1\u606f\u4e0d\u4e00\u81f4!");
        }
    }

    public BipCartVo findMyCartEable(BipCartSettleParmVO bipCartSettleParmVO) {
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        List cartIds = bipCartSettleParmVO.getCartIds();
        Long addressId = bipCartSettleParmVO.getAddressId();
        if (cartIds == null || cartIds.isEmpty()) {
            throw new BusinessException("\u8bf7\u6c42\u53c2\u6570\u683c\u5f0f\u4e0d\u6b63\u786e!");
        }
        BipCustUserBindDO bipCustUserBindDO = null;
        if (!Objects.nonNull(currentUserDTO.getUserId())) {
            throw new BusinessException("\u8bf7\u5148\u767b\u5f55!");
        }
        bipCustUserBindDO = this.bipCustUserBindRepoProc.getByUserId(currentUserDTO.getUserId());
        if (bipCustUserBindDO == null) {
            throw new BusinessException("\u8bf7\u7ed1\u5b9a\u516c\u53f8\u4fe1\u606f!");
        }
        Long custId = bipCustUserBindDO.getCustId();
        CrmCustDO crmCustDO = (CrmCustDO)this.crmCustRepo.findById(custId).get();
        String custLevel = crmCustDO.getCustLevel();
        String custCode = bipCustUserBindDO.getCustCode();
        Long custOuId = crmCustDO.getOuId();
        Long ouId = bipCartSettleParmVO.getOuId();
        ArrayList<Long> custOuIds = new ArrayList<Long>();
        List<Long> crmCustOuIds = this.getCrmCustOuIds(custCode);
        if (null != crmCustOuIds && !crmCustOuIds.isEmpty()) {
            custOuIds.addAll(crmCustOuIds);
        }
        custOuIds.add(custOuId);
        if (!custOuIds.contains(ouId)) {
            throw new BusinessException("\u53ea\u80fd\u8d2d\u4e70\u6240\u5c5e\u516c\u53f8\u5546\u54c1");
        }
        Long userId = currentUserDTO.getUserId();
        String userName = currentUserDTO.getUserName();
        List bipCartDOList = this.bipCartRepo.findAllById(cartIds);
        for (BipCartDO cartDO : bipCartDOList) {
            if (!this.bipItemSkuRepoProc.findFreezeStatus(cartDO.getSkuId()).booleanValue()) continue;
            throw new BusinessException("\u5546\u54c1" + cartDO.getSkuCode() + "\u5df2\u51bb\u7ed3");
        }
        List<Long> itemIds = bipCartDOList.stream().map(BipCartDO::getItemId).distinct().collect(Collectors.toList());
        this.checkItmeIdRelateOuId(itemIds, ouId);
        List<BipCartItemRespVO> itemVOList = BipCartCovert.INSTANCE.dos2Resps(bipCartDOList);
        BipCartVo bipCartVo = new BipCartVo();
        bipCartVo.setCouponId(bipCartSettleParmVO.getCouponId());
        this.buildOrderPerInfo(itemVOList, ouId, custLevel, userId, userName, bipCartVo, addressId, false, null);
        this.buildMkDisscountOffsetInfo(itemVOList, ouId, custLevel);
        List<Long> skuIds = bipCartDOList.stream().map(bipCartDO -> bipCartDO.getSkuId()).distinct().collect(Collectors.toList());
        this.getGiftList(itemVOList, ouId, custLevel, skuIds);
        BigDecimal discontFreeAmt = bipCartVo.getOrderDiscountFreeAmt();
        if (discontFreeAmt == null) {
            discontFreeAmt = BigDecimal.ZERO;
        }
        for (BipCartItemRespVO bipCartItemRespVO : itemVOList) {
            if (bipCartItemRespVO.getMktDiscountOffsetFreeAmt() == null) continue;
            log.info("\u660e\u7ec6\u4fc3\u9500\u6298\u6263\u91d1\u989d--" + bipCartItemRespVO.getMktDiscountOffsetFreeAmt());
            discontFreeAmt = discontFreeAmt.add(bipCartItemRespVO.getMktDiscountOffsetFreeAmt());
        }
        log.info("\u4fc3\u9500\u6298\u6263\u91d1\u989d--" + discontFreeAmt);
        bipCartVo.setOrderDiscountFreeAmt(discontFreeAmt);
        log.info("\u8ba2\u5355\u6298\u6263\u4f18\u60e0\u91d1\u989d------" + discontFreeAmt);
        bipCartVo.setItemList(itemVOList);
        this.buildItemCoupon(bipCartVo, userId, ouId);
        if (StringUtils.isBlank((CharSequence)custLevel)) {
            return bipCartVo;
        }
        for (BipCartItemRespVO respVO : bipCartVo.getItemList()) {
            Map<String, BigDecimal> prices = this.findSkuPriceReMap(respVO.getSkuCode(), userId, ouId);
            if (null != prices && null != prices.get("basePrice")) {
                respVO.setBasePrice(prices.get("basePrice"));
            }
            if (null == prices || null == prices.get("custPrice")) continue;
            respVO.setCustPrice(prices.get("custPrice"));
        }
        return bipCartVo;
    }

    public void buildOrderPerInfo(List<BipCartItemRespVO> itemVOList, Long ouId, String custLevel, Long userId, String userName, BipCartVo bipCartVo, Long addressId, Boolean firstItemFlag, BigDecimal preferentialPrice) {
        for (BipCartItemRespVO bipCartItemRespVO : itemVOList) {
            this.buildItemInfo(bipCartItemRespVO, ouId);
            this.buildItemFareInfo(bipCartItemRespVO, addressId);
            bipCartItemRespVO.setUserId(userId);
            bipCartItemRespVO.setUserName(userName);
            Map<String, BigDecimal> prices = this.findSkuPriceReMap(bipCartItemRespVO.getSkuCode(), userId, ouId);
            if (null == prices || prices.get("basePrice") == null) {
                throw new BusinessException("\u5546\u54c1" + bipCartItemRespVO.getItemName() + "\u7f3a\u5c11\u57fa\u7840\u4ef7\u683c");
            }
            if (null != prices && null != prices.get("basePrice")) {
                bipCartItemRespVO.setCustPrice(prices.get("basePrice"));
            }
            if (null != prices && null != prices.get("custPrice")) {
                bipCartItemRespVO.setCustPrice(prices.get("custPrice"));
            }
            if (null != firstItemFlag && firstItemFlag.booleanValue()) {
                bipCartItemRespVO.setCustPrice(preferentialPrice);
                bipCartItemRespVO.setBasePrice(preferentialPrice);
            }
            BigDecimal amt = bipCartItemRespVO.getCustPrice() != null ? bipCartItemRespVO.getCustPrice() : bipCartItemRespVO.getBasePrice();
            bipCartItemRespVO.setItemAmt(amt.multiply(BigDecimal.valueOf(bipCartItemRespVO.getItemNum() == null ? 0L : bipCartItemRespVO.getItemNum())));
            if (bipCartItemRespVO.getMktDiscountOffsetAmt() == null || bipCartItemRespVO.getMktDiscountOffsetAmt().compareTo(BigDecimal.ZERO) <= 0) {
                bipCartItemRespVO.setMktDiscountOffsetFreeAmt(BigDecimal.ZERO);
                bipCartItemRespVO.setMktDiscountOffsetAmt(amt.subtract(BigDecimal.ZERO));
                bipCartItemRespVO.setItemAmt(amt.multiply(BigDecimal.valueOf(bipCartItemRespVO.getItemNum() == null ? 0L : bipCartItemRespVO.getItemNum())));
            }
            bipCartVo.setOrderDiscountFreeAmt(bipCartVo.getOrderDiscountFreeAmt().add(bipCartItemRespVO.getMktDiscountOffsetFreeAmt()));
            bipCartVo.setOrderTotalFareAmt(bipCartVo.getOrderTotalFareAmt().add(bipCartItemRespVO.getFareArm() == null ? BigDecimal.ZERO : bipCartItemRespVO.getFareArm()));
            bipCartVo.setOrderTotalItemAmt(bipCartVo.getOrderTotalItemAmt().add(bipCartItemRespVO.getItemAmt()));
        }
        bipCartVo.setOrderFinalAmt(bipCartVo.getOrderTotalItemAmt().add(bipCartVo.getOrderTotalFareAmt().subtract(bipCartVo.getOrderDiscountFreeAmt()).subtract(bipCartVo.getCouponAmt())));
    }

    public void buildItemInfo(BipCartItemRespVO bipCartItemRespVO, Long ouId) {
        Long itemId = bipCartItemRespVO.getItemId();
        Long skuId = bipCartItemRespVO.getSkuId();
        log.info("\u5546\u54c1\u4fe1\u606fitemId:---------" + itemId + "---skuId:---------:" + skuId);
        ApiResult result = this.bipItemService.get(itemId);
        if (!result.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5931\u8d25");
        }
        BipItemDetailRespVO bipItemDetailRespVO = (BipItemDetailRespVO)result.getData();
        bipCartItemRespVO.setRelateItemId(bipItemDetailRespVO.getItemId());
        bipCartItemRespVO.setItemCode(bipItemDetailRespVO.getItemCode());
        bipCartItemRespVO.setItemName(bipItemDetailRespVO.getItemName());
        bipCartItemRespVO.setUom(bipItemDetailRespVO.getUnit());
        BipItemSkuDO bipItemSkuDO = (BipItemSkuDO)this.bipItemSkuRepo.findById(skuId).get();
        bipCartItemRespVO.setMateriel(bipItemSkuDO.getMateriel());
        bipCartItemRespVO.setType(bipItemSkuDO.getType());
        bipCartItemRespVO.setItemSpec(bipItemSkuDO.getSpec());
        bipCartItemRespVO.setItemBrand(bipItemSkuDO.getBrand());
        bipCartItemRespVO.setItmeBrandCode(bipItemSkuDO.getBarcode());
        bipCartItemRespVO.setOuName(bipItemDetailRespVO.getOuName());
        CurrentUserDTO user = UserService.currentUser();
        if (null == user) {
            throw new BusinessException("\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
        }
        BipItemSkuRespVO bipItemSkuRespVO = BipItemConvert.INSTANCE.sku2DetailRespVO(bipItemSkuDO);
        Map<String, BigDecimal> prices = this.findSkuPriceReMap(bipItemSkuDO.getSkuCode(), user.getUserId(), ouId);
        if (null != prices.get("basePrice")) {
            bipCartItemRespVO.setBasePrice(prices.get("basePrice"));
        }
        if (null != prices.get("custPrice")) {
            bipCartItemRespVO.setCustPrice(prices.get("custPrice"));
        }
        bipItemSkuRespVO.setPrice(prices.get("basePrice"));
        bipItemSkuRespVO.setAttrList(this.convert2List(bipItemSkuDO.getAttr(), BipItemSkuAttrRespVO.class));
        List<BipItemSkuAttrRespVO> attrList = this.convert2List(bipItemSkuDO.getAttr(), BipItemSkuAttrRespVO.class);
        ArrayList<CallSite> list = new ArrayList<CallSite>();
        for (int i = 0; i < attrList.size(); ++i) {
            BipItemSkuAttrRespVO bipItemSkuAttrRespVO = (BipItemSkuAttrRespVO)JSON.parseObject((String)JSON.toJSONString((Object)attrList.get(i)), BipItemSkuAttrRespVO.class);
            if (bipItemSkuAttrRespVO == null) continue;
            list.add((CallSite)((Object)(bipItemSkuAttrRespVO.getName() + ":" + bipItemSkuAttrRespVO.getValue())));
        }
        String attstr = String.join((CharSequence)";", list);
        bipCartItemRespVO.setAttr(attstr);
        bipItemDetailRespVO.setState(bipCartItemRespVO.getState());
        bipCartItemRespVO.setRelateItemId(bipItemDetailRespVO.getItemId());
        BipCartItemCovert.INSTANCE.bipItemDetailRespVOToBipCartItemVo(bipItemDetailRespVO, bipCartItemRespVO);
        if (bipItemSkuRespVO != null) {
            bipCartItemRespVO.setSkuCode(bipItemSkuRespVO.getSkuCode());
        }
        bipCartItemRespVO.setItemSkuRespVO(bipItemSkuRespVO);
        if (bipItemDetailRespVO.getPicList() != null && !bipItemDetailRespVO.getPicList().isEmpty()) {
            BipItemPicRespVO bipItemPicRespVO = (BipItemPicRespVO)bipItemDetailRespVO.getPicList().get(0);
            bipCartItemRespVO.setMainPicFileCode(bipItemPicRespVO.getFileCode());
        }
    }

    public Boolean checkCartStorm(Long skuId, Long num) {
        BipItemSkuDO bipItemSkuDO = (BipItemSkuDO)this.bipItemSkuRepo.findById(skuId).get();
        if (bipItemSkuDO.getStock() != null && bipItemSkuDO.getStock() >= num.intValue()) {
            return true;
        }
        return false;
    }

    public BipItemSkuRespVO findItemSkuInfo(Long skuId, Long itemId, String skuCode) {
        BipItemDetailRespVO bipItemDetailRespVO = (BipItemDetailRespVO)this.bipItemService.get(itemId).getData();
        BipItemSkuDO bipItemSkuDO = null;
        bipItemSkuDO = Objects.isNull(skuId) ? this.bipItemSkuRepo.findByBipItemIdAndSkuCode(itemId, skuCode) : (BipItemSkuDO)this.bipItemSkuRepo.getOne(skuId);
        BipItemSkuRespVO bipItemSkuRespVO = BipItemConvert.INSTANCE.sku2DetailRespVO(bipItemSkuDO);
        return bipItemSkuRespVO;
    }

    public void buildMkDisscountOffsetInfo(List<BipCartItemRespVO> itemVOList, Long ouId, String custLevel) {
        List ids = itemVOList.stream().map(bipCartItemRespVO -> bipCartItemRespVO.getSkuId()).distinct().collect(Collectors.toList());
        List<String> skuCodes = itemVOList.stream().map(bipCartItemRespVO -> bipCartItemRespVO.getSkuCode()).distinct().collect(Collectors.toList());
        log.info("\u6ee1\u51cf\u6298\u6263\u8bf7\u6c42\u53c2\u6570\uff0couId--{},custLevel--{},ids--{},skuCodes--{}", new Object[]{ouId, custLevel, ids, skuCodes});
        List<MktDiscountOffsetVO> mktDiscountOffsetVOS = this.mktDiscountOffsetService.findMktDiscountOffsetByParamCode(ouId, custLevel, skuCodes);
        log.info("\u6ee1\u51cf\u6298\u6263\u8fd4\u56de\u4fe1\u606f---" + JSON.toJSONString(mktDiscountOffsetVOS));
        Map<String, List<MktDiscountOffsetVO>> map = mktDiscountOffsetVOS.stream().collect(Collectors.groupingBy(MktDiscountOffsetVO::getItemCode));
        for (BipCartItemRespVO bipCartItemRespVO2 : itemVOList) {
            Long itemId = bipCartItemRespVO2.getItemId();
            Long skuId = bipCartItemRespVO2.getSkuId();
            String skuCode = bipCartItemRespVO2.getSkuCode();
            if (map == null || map.isEmpty()) {
                bipCartItemRespVO2.setMktDiscountOffsetAmt(bipCartItemRespVO2.getItemAmt());
                bipCartItemRespVO2.setMktDiscountOffsetFreeAmt(BigDecimal.ZERO);
                continue;
            }
            List<MktDiscountOffsetVO> mktDiscountOffsetVOList = map.get(skuCode);
            if (mktDiscountOffsetVOList == null || mktDiscountOffsetVOList.isEmpty()) {
                bipCartItemRespVO2.setMktDiscountOffsetAmt(bipCartItemRespVO2.getItemAmt());
                bipCartItemRespVO2.setMktDiscountOffsetFreeAmt(BigDecimal.ZERO);
                continue;
            }
            List matchMktDiscountOffsetVOS = mktDiscountOffsetVOList.stream().filter(mktDiscountOffsetVO -> this.matchDiscount((MktDiscountOffsetVO)mktDiscountOffsetVO, bipCartItemRespVO2)).collect(Collectors.toList());
            log.info("\u6ee1\u51cf\u6298\u6263\u5339\u914d\u5230\u6298\u6263\u4fe1\u606f---" + JSON.toJSONString(matchMktDiscountOffsetVOS));
            matchMktDiscountOffsetVOS.stream().sorted(Comparator.comparing(MktDiscountOffsetVO::getFreeAmt));
            if (matchMktDiscountOffsetVOS == null || matchMktDiscountOffsetVOS.isEmpty()) {
                bipCartItemRespVO2.setMktDiscountOffsetAmt(bipCartItemRespVO2.getItemAmt());
                bipCartItemRespVO2.setMktDiscountOffsetFreeAmt(BigDecimal.ZERO);
                continue;
            }
            MktDiscountOffsetVO mktDiscountOffsetVO2 = new MktDiscountOffsetVO();
            if (((MktDiscountOffsetVO)matchMktDiscountOffsetVOS.get(0)).getType().equals("1")) {
                matchMktDiscountOffsetVOS = matchMktDiscountOffsetVOS.stream().sorted(Comparator.comparing(MktDiscountOffsetVO::getLimitAmt).reversed()).collect(Collectors.toList());
                for (MktDiscountOffsetVO mktDiscountOffset : matchMktDiscountOffsetVOS) {
                    if (bipCartItemRespVO2.getItemAmt().compareTo(mktDiscountOffset.getLimitAmt()) < 0) continue;
                    mktDiscountOffsetVO2 = mktDiscountOffset;
                    break;
                }
            }
            if (((MktDiscountOffsetVO)matchMktDiscountOffsetVOS.get(0)).getType().equals("0")) {
                matchMktDiscountOffsetVOS = matchMktDiscountOffsetVOS.stream().sorted(Comparator.comparing(MktDiscountOffsetVO::getLimitNum).reversed()).collect(Collectors.toList());
                for (MktDiscountOffsetVO mktDiscountOff : matchMktDiscountOffsetVOS) {
                    if (bipCartItemRespVO2.getItemNum() < mktDiscountOff.getLimitNum()) continue;
                    mktDiscountOffsetVO2 = mktDiscountOff;
                    break;
                }
            }
            if (null == mktDiscountOffsetVO2 || null == mktDiscountOffsetVO2.getItemId()) {
                bipCartItemRespVO2.setMktDiscountOffsetAmt(bipCartItemRespVO2.getItemAmt());
                bipCartItemRespVO2.setMktDiscountOffsetFreeAmt(BigDecimal.ZERO);
                continue;
            }
            bipCartItemRespVO2.setMktDiscountOffsetId(mktDiscountOffsetVO2.getMktDiscountOffsetId());
            bipCartItemRespVO2.setMktDiscountOffsetDId(mktDiscountOffsetVO2.getMktDiscountOffsetDId());
            BigDecimal freeAmt = mktDiscountOffsetVO2.getFreeAmt() == null ? BigDecimal.ZERO : mktDiscountOffsetVO2.getFreeAmt();
            bipCartItemRespVO2.setMktDiscountOffsetFreeAmt(freeAmt);
            bipCartItemRespVO2.setMktDiscountOffsetAmt(bipCartItemRespVO2.getItemAmt().subtract(freeAmt));
        }
    }

    public Boolean disRule(MktDiscountOffsetVO mktDiscountOffsetVO) {
        BigDecimal floorScale;
        BigDecimal floorPrice;
        BigDecimal disScale;
        BigDecimal freeAmt = mktDiscountOffsetVO.getFreeAmt();
        BigDecimal basePrice = mktDiscountOffsetVO.getBasePrice();
        if (mktDiscountOffsetVO.getType().equals("1")) {
            BigDecimal limitAmt = mktDiscountOffsetVO.getLimitAmt();
            disScale = freeAmt.divide(limitAmt, 4, RoundingMode.HALF_UP);
            floorPrice = this.getMinPrice(mktDiscountOffsetVO);
            if (floorPrice.compareTo(BigDecimal.ZERO) == 0) {
                return false;
            }
            floorScale = basePrice.subtract(floorPrice).divide(basePrice, 4, RoundingMode.HALF_UP);
            if (disScale.compareTo(floorScale) < 0) {
                return true;
            }
        }
        if (mktDiscountOffsetVO.getType().equals("0")) {
            BigDecimal amt = new BigDecimal(mktDiscountOffsetVO.getLimitNum()).multiply(basePrice);
            disScale = freeAmt.divide(amt, 4, RoundingMode.HALF_UP);
            floorPrice = this.getMinPrice(mktDiscountOffsetVO);
            if (floorPrice.compareTo(BigDecimal.ZERO) == 0) {
                return false;
            }
            floorScale = basePrice.subtract(floorPrice).divide(basePrice, 4, RoundingMode.HALF_UP);
            if (disScale.compareTo(floorScale) < 0) {
                return true;
            }
        }
        return false;
    }

    public BigDecimal getMinPrice(MktDiscountOffsetVO mktDiscountOffsetVO) {
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        BipCustUserBindDO bipCustUserBindDO = this.bipCustUserBindRepoProc.getByUserId(currentUserDTO.getUserId());
        if (bipCustUserBindDO == null || null == bipCustUserBindDO.getCustId()) {
            return BigDecimal.ZERO;
        }
        PriSalePriceReqDTO priSalePriceReqDTO = new PriSalePriceReqDTO();
        priSalePriceReqDTO.setOuId(mktDiscountOffsetVO.getOuId());
        priSalePriceReqDTO.setCustId(bipCustUserBindDO.getCustId());
        priSalePriceReqDTO.setCustCode(bipCustUserBindDO.getCustCode());
        ArrayList<PriSaleItemReqDTO> list = new ArrayList<PriSaleItemReqDTO>();
        PriSaleItemReqDTO priSaleItemReqDTO = new PriSaleItemReqDTO();
        priSaleItemReqDTO.setItemId(mktDiscountOffsetVO.getItemId());
        priSaleItemReqDTO.setUom(mktDiscountOffsetVO.getUom());
        list.add(priSaleItemReqDTO);
        priSalePriceReqDTO.setItems(list);
        ApiResult res = this.priSalePriceRpcService.findSalePriceDto(priSalePriceReqDTO);
        if (res.getCode() == 200 && null != res.getData() && null != ((PriSalePriceDTO)res.getData()).getPriceList() && !((PriSalePriceDTO)res.getData()).getPriceList().isEmpty()) {
            PriSalePriceSimpleDTO priSalePriceSimpleDTO = (PriSalePriceSimpleDTO)((PriSalePriceDTO)res.getData()).getPriceList().get(0);
            return priSalePriceSimpleDTO.getFloorPrice();
        }
        return BigDecimal.ZERO;
    }

    public Boolean matchDiscount(MktDiscountOffsetVO mktDiscountOffsetVO, BipCartItemRespVO bipCartItemRespVO) {
        if (mktDiscountOffsetVO.getLimitNum() != null && mktDiscountOffsetVO.getLimitNum() <= bipCartItemRespVO.getItemNum()) {
            return true;
        }
        if (mktDiscountOffsetVO.getLimitAmt() != null && mktDiscountOffsetVO.getLimitAmt().compareTo(bipCartItemRespVO.getItemAmt()) <= 0) {
            return true;
        }
        return false;
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateCart(BipCartParmVO bipCartParmVO) {
        log.info("\u8d2d\u7269\u8f66\u4fee\u6539\u53c2\u6570---" + JSON.toJSONString((Object)bipCartParmVO));
        BipCustUserBindDO bipCustUserBindDO = null;
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        if (!Objects.nonNull(currentUserDTO.getUserId())) {
            throw new BusinessException("\u8bf7\u5148\u767b\u5f55!");
        }
        bipCustUserBindDO = this.bipCustUserBindRepoProc.getByUserId(currentUserDTO.getUserId());
        if (bipCustUserBindDO == null) {
            throw new BusinessException("\u8bf7\u7ed1\u5b9a\u516c\u53f8\u4fe1\u606f!");
        }
        if (bipCartParmVO.getUserId() == null) {
            bipCartParmVO.setUserId(currentUserDTO.getUserId());
        }
        Long itemId = bipCartParmVO.getItemId();
        Long skuId = bipCartParmVO.getSkuId();
        if (itemId == null || skuId == null) {
            throw new BusinessException("\u5546\u54c1id\u548cskuID\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        BipCartDO bipCartDo = this.bipCartRepo.findAllByUserIdAndItemIdAndSkuId(currentUserDTO.getUserId(), itemId, skuId);
        Long exitNum = 0L;
        if (bipCartDo != null && !bipCartDo.getId().equals(bipCartParmVO.getId())) {
            ArrayList<Long> list = new ArrayList<Long>();
            list.add(bipCartDo.getId());
            if (bipCartParmVO.getItemNum() == null) {
                BipCartDO bipCartCurrentDo = (BipCartDO)this.bipCartRepo.findById(bipCartParmVO.getId()).get();
                exitNum = bipCartCurrentDo.getItemNum() == null ? 0L : bipCartCurrentDo.getItemNum();
                bipCartParmVO.setItemNum(exitNum);
            }
            exitNum = bipCartDo.getItemNum();
            bipCartParmVO.setItemNum(Long.valueOf(exitNum + bipCartParmVO.getItemNum()));
            this.bipCartRepoProc.deleteCartByIds(list);
        }
        BipCartDO bipCartDOLis = BipCartCovert.INSTANCE.BipCartParmVo2BipCart(bipCartParmVO);
        this.bipCartRepo.save(bipCartDOLis);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteCart(List<Long> idList) {
        this.bipCartRepoProc.deleteCartByIds(idList);
    }

    public List<AttrAPPRespVO> getAttrList(AttrAppParamVO attrAppParamVO) {
        if (null == attrAppParamVO.getItemId()) {
            throw new BusinessException("\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == attrAppParamVO.getAttrList() || attrAppParamVO.getAttrList().isEmpty()) {
            return null;
        }
        String attrFirst = JSON.toJSONString(attrAppParamVO.getAttrList().get(0));
        QBipItemSkuDO qBipItemSkuDO = QBipItemSkuDO.bipItemSkuDO;
        BooleanExpression e = qBipItemSkuDO.bipItemId.eq((Object)attrAppParamVO.getItemId()).and((Predicate)qBipItemSkuDO.deleteFlag.eq((Object)0)).and((Predicate)qBipItemSkuDO.attr.like("%" + attrFirst + "%"));
        Iterable iterables = this.bipItemSkuRepo.findAll((Predicate)e);
        if (!IterUtil.isEmpty((Iterable)iterables)) {
            List param = attrAppParamVO.getAttrList();
            ArrayList list = Lists.newArrayList((Iterable)iterables);
            ArrayList attrList = new ArrayList();
            list.stream().forEach(l -> {
                String attr = l.getAttr();
                for (int i = 0; i < param.size(); ++i) {
                    String paramStr = JSON.toJSONString(param.get(i));
                    if (!attr.contains(paramStr)) continue;
                    attrList.add(l);
                }
            });
            attrList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<BipItemSkuDO>(Comparator.comparing(BaseModel::getId))), ArrayList::new));
            ArrayList attrStrRes = new ArrayList();
            if (null != attrList && !attrList.isEmpty()) {
                attrList.stream().forEach(al -> {
                    String sixth;
                    String fifth;
                    String fourth;
                    String third;
                    String second;
                    String attr = al.getAttr();
                    List listVos = JSON.parseArray((String)attr, AttrAPPRespVO.class);
                    if (attrAppParamVO.getAttrList().size() == 1 && attr.contains(attrFirst) && attr.contains(attrFirst)) {
                        attrStrRes.addAll(listVos);
                    }
                    if (attrAppParamVO.getAttrList().size() == 2) {
                        second = JSON.toJSONString(attrAppParamVO.getAttrList().get(1));
                        if (attr.contains(attrFirst) && attr.contains(second)) {
                            attrStrRes.addAll(listVos);
                        }
                    }
                    if (attrAppParamVO.getAttrList().size() == 3) {
                        second = JSON.toJSONString(attrAppParamVO.getAttrList().get(1));
                        third = JSON.toJSONString(attrAppParamVO.getAttrList().get(2));
                        if (attr.contains(attrFirst) && attr.contains(second) && attr.contains(third)) {
                            attrStrRes.addAll(listVos);
                        }
                    }
                    if (attrAppParamVO.getAttrList().size() == 4) {
                        second = JSON.toJSONString(attrAppParamVO.getAttrList().get(1));
                        third = JSON.toJSONString(attrAppParamVO.getAttrList().get(2));
                        fourth = JSON.toJSONString(attrAppParamVO.getAttrList().get(3));
                        if (attr.contains(attrFirst) && attr.contains(second) && attr.contains(third) && attr.contains(fourth)) {
                            attrStrRes.addAll(listVos);
                        }
                    }
                    if (attrAppParamVO.getAttrList().size() == 5) {
                        second = JSON.toJSONString(attrAppParamVO.getAttrList().get(1));
                        third = JSON.toJSONString(attrAppParamVO.getAttrList().get(2));
                        fourth = JSON.toJSONString(attrAppParamVO.getAttrList().get(3));
                        fifth = JSON.toJSONString(attrAppParamVO.getAttrList().get(4));
                        if (attr.contains(attrFirst) && attr.contains(second) && attr.contains(third) && attr.contains(fourth) && attr.contains(fifth)) {
                            attrStrRes.addAll(listVos);
                        }
                    }
                    if (attrAppParamVO.getAttrList().size() == 6) {
                        second = JSON.toJSONString(attrAppParamVO.getAttrList().get(1));
                        third = JSON.toJSONString(attrAppParamVO.getAttrList().get(2));
                        fourth = JSON.toJSONString(attrAppParamVO.getAttrList().get(3));
                        fifth = JSON.toJSONString(attrAppParamVO.getAttrList().get(4));
                        sixth = JSON.toJSONString(attrAppParamVO.getAttrList().get(5));
                        if (attr.contains(attrFirst) && attr.contains(second) && attr.contains(third) && attr.contains(fourth) && attr.contains(fifth) && attr.contains(sixth)) {
                            attrStrRes.addAll(listVos);
                        }
                    }
                    if (attrAppParamVO.getAttrList().size() == 7) {
                        second = JSON.toJSONString(attrAppParamVO.getAttrList().get(1));
                        third = JSON.toJSONString(attrAppParamVO.getAttrList().get(2));
                        fourth = JSON.toJSONString(attrAppParamVO.getAttrList().get(3));
                        fifth = JSON.toJSONString(attrAppParamVO.getAttrList().get(4));
                        sixth = JSON.toJSONString(attrAppParamVO.getAttrList().get(5));
                        String seveth = JSON.toJSONString(attrAppParamVO.getAttrList().get(6));
                        if (attr.contains(attrFirst) && attr.contains(second) && attr.contains(third) && attr.contains(fourth) && attr.contains(fifth) && attr.contains(sixth) && attr.contains(seveth)) {
                            attrStrRes.addAll(listVos);
                        }
                    }
                });
            }
            if (null != attrStrRes && !attrStrRes.isEmpty()) {
                return attrStrRes.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<AttrAPPRespVO>(Comparator.comparing(AttrAPPRespVO::getValue))), ArrayList::new));
            }
        }
        return null;
    }

    public void buildItemDisscountGiftInfo(BipCartItemRespVO bipCartItemRespVO, Long ouId, String custLevel) {
        MktGiftRespVO mktGiftRespVO = null;
        MktDiscountGiftVO mktDiscountGiftVO = null;
        if (bipCartItemRespVO.getMktGiftId() == null) {
            JPAQuery<MktGiftRespVO> giftRespVOJPAQuery;
            List mktGiftRespVOS;
            BigDecimal priceGuide = bipCartItemRespVO.getItemSkuRespVO().getPriceGuide();
            Long num = bipCartItemRespVO.getItemNum();
            BigDecimal itemAmt = priceGuide.multiply(BigDecimal.valueOf(num));
            Long id = bipCartItemRespVO.getItemId();
            LocalDateTime now = LocalDateTime.now();
            ArrayList<Long> itemIds = new ArrayList<Long>();
            itemIds.add(bipCartItemRespVO.getSkuId());
            List mkList = this.mktDiscountGiftService.findMktDiscountGiftByParam(ouId, custLevel, itemIds);
            AtomicBoolean flag = new AtomicBoolean(false);
            ArrayList mktDiscountGiftVOList = new ArrayList();
            mkList.stream().forEach(mk -> {
                if (mk.getLimitNum() != null && mk.getLimitNum() <= bipCartItemRespVO.getItemNum()) {
                    mktDiscountGiftVOList.add(mk);
                    flag.set(true);
                }
                if (!flag.get() && mk.getLimitAmt() != null && bipCartItemRespVO.getItemAmt() != null && mk.getLimitAmt().compareTo(bipCartItemRespVO.getItemAmt()) >= 0) {
                    mktDiscountGiftVOList.add(mk);
                }
            });
            if (mktDiscountGiftVOList != null && !mktDiscountGiftVOList.isEmpty() && (mktGiftRespVOS = (giftRespVOJPAQuery = this.mktDiscountGiftRepoProc.selectGiftDetailsByMasCodeOrItemId((mktDiscountGiftVO = (MktDiscountGiftVO)mktDiscountGiftVOList.get(0)).getCode(), mktDiscountGiftVO.getItemId())).fetch()) != null && !mktGiftRespVOS.isEmpty()) {
                List sortMktGiftRespVOS = mktGiftRespVOS.stream().sorted(Comparator.comparing(MktGiftRespVO::getStockNum).reversed()).collect(Collectors.toList());
                mktGiftRespVO = (MktGiftRespVO)sortMktGiftRespVOS.get(0);
            }
        } else {
            MktGiftDO mktGiftDO = (MktGiftDO)this.mktGiftRepo.findById(bipCartItemRespVO.getMktGiftId()).get();
            mktGiftRespVO = MktGiftCovert.INSTANCE.doToResoVo(mktGiftDO);
            MktDiscountGiftDO mktDiscountGiftDO = (MktDiscountGiftDO)this.mktDiscountGiftRepo.getOne(bipCartItemRespVO.getMktDiscountGiftDId());
            mktDiscountGiftVO = new MktDiscountGiftVO();
            mktDiscountGiftVO.setValidEtime(mktDiscountGiftDO.getValidEtime());
            mktDiscountGiftVO.setValidStime(mktDiscountGiftDO.getValidStime());
        }
        if (this.checkDiscountGift(mktDiscountGiftVO).booleanValue() && this.checkGift(mktGiftRespVO).booleanValue()) {
            bipCartItemRespVO.setMktGiftId(mktGiftRespVO.getId());
            bipCartItemRespVO.setMktGiftItemName(mktDiscountGiftVO.getItemName());
            bipCartItemRespVO.setMktGiftRespVO(mktGiftRespVO);
        } else {
            bipCartItemRespVO.setMktGiftId(null);
            bipCartItemRespVO.setMktGiftRespVO(null);
            bipCartItemRespVO.setMktGiftItemName(null);
        }
    }

    public Boolean checkGift(MktGiftRespVO mktGiftRespVO) {
        LocalDateTime now = LocalDateTime.now();
        if (mktGiftRespVO != null && mktGiftRespVO.getValidStime().isBefore(now) && mktGiftRespVO.getValidEtime().isAfter(now)) {
            return true;
        }
        return false;
    }

    public Boolean checkDiscountGift(MktDiscountGiftVO mktDiscountGiftVO) {
        LocalDateTime now = LocalDateTime.now();
        if (mktDiscountGiftVO != null && mktDiscountGiftVO.getValidStime().isBefore(now) && mktDiscountGiftVO.getValidEtime().isAfter(now)) {
            return true;
        }
        return false;
    }

    public Boolean checkCoupon(BipCouponDO bipCouponDO) {
        LocalDateTime now = LocalDateTime.now();
        if (bipCouponDO != null && bipCouponDO.getValidStime().isBefore(now) && bipCouponDO.getValidEtime().isAfter(now)) {
            return true;
        }
        return false;
    }

    public void buildItemCoupon(BipCartVo bipCartVo, Long userId, Long ouId) {
        BipCouponDO bipCouponDO = null;
        List itemRespVOList = bipCartVo.getItemList();
        BipCouponCustCurrentParam bipCouponCustCurrentParam = new BipCouponCustCurrentParam();
        ArrayList<BipCouponCustItemParam> itemParams = new ArrayList<BipCouponCustItemParam>();
        for (BipCartItemRespVO bipCartItemRespVO : itemRespVOList) {
            BipCouponCustItemParam itemParam = new BipCouponCustItemParam();
            itemParam.setSkuId(bipCartItemRespVO.getSkuId());
            itemParam.setItemId(bipCartItemRespVO.getItemId());
            itemParam.setItemCode(bipCartItemRespVO.getItemCode());
            itemParam.setTotalAmount(bipCartItemRespVO.getItemAmt());
            itemParams.add(itemParam);
        }
        bipCouponCustCurrentParam.setList(itemParams);
        bipCouponCustCurrentParam.setOuId(ouId);
        bipCouponCustCurrentParam.setUserId(userId);
        log.info("\u4f18\u60e0\u5238\u67e5\u8be2\u53c2\u6570\uff1a--" + JSON.toJSONString((Object)bipCouponCustCurrentParam));
        List couponCustVOS = this.bipCouponCustService.currentUserCouponCust(bipCouponCustCurrentParam);
        if (null != couponCustVOS && !couponCustVOS.isEmpty()) {
            couponCustVOS.sort(Comparator.comparing(BipCouponCustVO::getFreeAmt).reversed());
            bipCartVo.setBipCouponCustVOS(couponCustVOS);
            if (Objects.isNull(bipCartVo.getCouponId())) {
                if (couponCustVOS != null && !couponCustVOS.isEmpty()) {
                    couponCustVOS.stream().sorted(Comparator.comparing(BipCouponCustVO::getFreeAmt));
                    BipCouponCustVO bipCouponCustVO = (BipCouponCustVO)couponCustVOS.get(0);
                    bipCouponDO = (BipCouponDO)this.bipCouponRepo.findById(bipCouponCustVO.getCouponId()).get();
                }
            } else {
                bipCouponDO = (BipCouponDO)this.bipCouponRepo.findById(bipCartVo.getCouponId()).get();
            }
            log.info("\u4f18\u60e0\u5238\u4fe1\u606f\uff1a--" + JSON.toJSONString(bipCouponDO));
            if (bipCouponDO != null) {
                bipCartVo.setCouponAmt(bipCouponDO.getFreeAmt());
                bipCartVo.setCouponId(bipCouponDO.getId());
                bipCartVo.setCouponName(bipCouponDO.getCouponName());
                bipCartVo.setCouponAmt(bipCouponDO.getFreeAmt());
            }
        }
    }

    public BipCartVo findMyCart(Long ouId) {
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        BipCustUserBindDO bipCustUserBindDO = null;
        if (currentUserDTO == null) {
            throw new BusinessException("\u8bf7\u5148\u767b\u5f55!");
        }
        Long userId = currentUserDTO.getUserId();
        if (!Objects.nonNull(currentUserDTO.getUserId())) {
            throw new BusinessException("\u8bf7\u5148\u767b\u5f55!");
        }
        bipCustUserBindDO = this.bipCustUserBindRepoProc.getByUserId(userId);
        if (bipCustUserBindDO == null) {
            throw new BusinessException("\u8bf7\u7ed1\u5b9a\u516c\u53f8\u4fe1\u606f!");
        }
        Long custId = bipCustUserBindDO.getCustId();
        if (custId == null) {
            throw new BusinessException("\u8bf7\u5148\u7ed1\u5b9a\u6240\u5c5e\u516c\u53f8!");
        }
        CrmCustDO crmCustDO = (CrmCustDO)this.crmCustRepo.findById(custId).get();
        String custLevel = crmCustDO.getCustLevel();
        String userName = currentUserDTO.getUserName();
        JPAQuery<BipCartItemRespVO> jpaQuery = this.bipCartRepoProc.findUserCartItemInfo(userId, null);
        ArrayList itemVOList = jpaQuery.fetch();
        if (itemVOList == null || itemVOList.isEmpty()) {
            return null;
        }
        ArrayList itemVOListCopy = new ArrayList();
        QBipItemDO qBipItemDO = QBipItemDO.bipItemDO;
        itemVOList.stream().forEach(item -> {
            Long itemId = item.getItemId();
            BooleanExpression expression = qBipItemDO.id.eq((Object)itemId).and((Predicate)qBipItemDO.ouId.eq((Object)ouId)).and((Predicate)qBipItemDO.deleteFlag.eq((Object)0));
            BipItemDO bipItemDO = (BipItemDO)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)qBipItemDO).from((EntityPath)qBipItemDO)).where((Predicate)expression)).limit(1L)).fetchOne();
            item.setState("OFF");
            if (bipItemDO != null) {
                if (bipItemDO.getOnShelf().booleanValue()) {
                    item.setState("SHELF");
                }
                itemVOListCopy.add(item);
            }
        });
        if (itemVOListCopy.isEmpty()) {
            return null;
        }
        itemVOList = itemVOListCopy;
        List<Long> itemIds = itemVOList.stream().map(BipCartItemRespVO::getItemId).distinct().collect(Collectors.toList());
        if (null == (itemIds = this.bipItemRepoProc.findIdByItemIds(itemIds)) && itemIds.isEmpty()) {
            return null;
        }
        this.checkItmeIdRelateOuId(itemIds, ouId);
        BipCartVo bipCartVo = new BipCartVo();
        for (BipCartItemRespVO bipCartItemRespVO : itemVOList) {
            BigDecimal amt;
            this.buildItemInfo(bipCartItemRespVO, ouId);
            this.buildItemDisscountGiftInfo(bipCartItemRespVO, ouId, custLevel);
            bipCartItemRespVO.setUserId(userId);
            bipCartItemRespVO.setUserName(userName);
            Map<String, BigDecimal> prices = this.findSkuPriceReMap(bipCartItemRespVO.getSkuCode(), userId, ouId);
            if (null == prices || null == prices.get("basePrice")) {
                throw new BusinessException("\u5546\u54c1" + bipCartItemRespVO.getItemName() + "\u7f3a\u5c11\u57fa\u7840\u4ef7\u683c");
            }
            if (null != prices && null != prices.get("basePrice")) {
                bipCartItemRespVO.setBasePrice(prices.get("basePrice"));
            }
            if (null != prices && null != prices.get("custPrice")) {
                bipCartItemRespVO.setCustPrice(prices.get("custPrice"));
            }
            BigDecimal bigDecimal = amt = bipCartItemRespVO.getCustPrice() == null ? bipCartItemRespVO.getBasePrice() : bipCartItemRespVO.getCustPrice();
            if (bipCartItemRespVO.getMktDiscountOffsetFreeAmt() == null || bipCartItemRespVO.getMktDiscountOffsetFreeAmt().compareTo(BigDecimal.ZERO) <= 0) {
                bipCartItemRespVO.setMktDiscountOffsetFreeAmt(BigDecimal.ZERO);
                bipCartItemRespVO.setMktDiscountOffsetAmt(amt.subtract(BigDecimal.ZERO));
                bipCartItemRespVO.setItemAmt(amt);
            }
            bipCartVo.setOrderTotalItemAmt(bipCartVo.getOrderTotalItemAmt().add(amt));
            bipCartVo.setOrderDiscountFreeAmt(bipCartVo.getOrderDiscountFreeAmt().add(bipCartItemRespVO.getMktDiscountOffsetFreeAmt()));
        }
        bipCartVo.setItemList(itemVOList);
        List ouName = itemVOList.stream().map(BipCartItemRespVO::getOuName).distinct().collect(Collectors.toList());
        bipCartVo.setOuName((String)ouName.get(0));
        return bipCartVo;
    }

    public HashMap<String, Object> findFeeFare(BipFareAmtQueryParmVO bipFareAmtQueryParmVO) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("isShowSubmit", false);
        ArrayList<Boolean> isSubmit = new ArrayList<Boolean>();
        log.info("\u8ba1\u7b97\u8fd0\u8d39\u8bf7\u6c42\u53c2\u6570:" + JSON.toJSONString((Object)bipFareAmtQueryParmVO));
        LogisticsTemplateDFindParam logisticsTemplateDFindParam = new LogisticsTemplateDFindParam();
        BipAddressVO bipAddressVO = null;
        Long addressId = bipFareAmtQueryParmVO.getAddressId();
        if (addressId == null) {
            map.put("totalFareAmt", BigDecimal.ZERO);
            return map;
        }
        bipAddressVO = this.bipAddressService.findById(addressId);
        if (bipAddressVO == null) {
            map.put("totalFareAmt", BigDecimal.ZERO);
            return map;
        }
        BigDecimal totalFareAmt = BigDecimal.ZERO;
        map.put("totalFareAmt", totalFareAmt);
        List list = bipFareAmtQueryParmVO.getFareAmtInfos();
        for (BipFareAmtQueryParmVO.FareAmtInfo bipCartItemRespVO : list) {
            String area = bipAddressVO.getArea();
            if (StringUtils.isBlank((CharSequence)area)) {
                area = this.getArea(bipAddressVO);
            }
            logisticsTemplateDFindParam.setTemplateId(bipCartItemRespVO.getTemplateId());
            logisticsTemplateDFindParam.setCityCode(bipAddressVO.getCity());
            logisticsTemplateDFindParam.setProvinceCode(bipAddressVO.getProvince());
            ArrayList<LogisticsTemplateDFindParam> params = new ArrayList<LogisticsTemplateDFindParam>();
            params.add(logisticsTemplateDFindParam);
            log.info("\u8bf7\u6c42\u8fd0\u8d39\u4fe1\u606f\u53c2\u6570:" + JSON.toJSONString((Object)logisticsTemplateDFindParam));
            if (bipCartItemRespVO.getFareFree() != null && !bipCartItemRespVO.getFareFree().booleanValue()) {
                List<LogisticsTemplateDVO> result = this.logisticsTemplateDService.getByArea(logisticsTemplateDFindParam);
                log.info("\u8bf7\u6c42\u8fd0\u8d39\u8fd4\u56de\u4fe1\u606f:" + JSON.toJSONString(result));
                if (result != null && !result.isEmpty()) {
                    map.put("isShowSubmit", true);
                    LogisticsTemplateDVO logisticsTemplateDVO = result.get(0);
                    BigDecimal incAmt = logisticsTemplateDVO.getAddFreight();
                    BigDecimal baseAmt = logisticsTemplateDVO.getDefFreight();
                    Integer baseNum = logisticsTemplateDVO.getPieceNumber();
                    Integer incNum = logisticsTemplateDVO.getContinuypieceNumber();
                    Long itemNum = bipCartItemRespVO.getItemNum();
                    Long num = itemNum - (long)baseNum.intValue();
                    BigDecimal inc = BigDecimal.valueOf(num).divide(BigDecimal.valueOf(incNum.intValue()), 0, RoundingMode.UP);
                    BigDecimal fareAmt = baseAmt.add(incAmt.multiply(inc));
                    if (fareAmt.compareTo(BigDecimal.ZERO) < 0) {
                        fareAmt = BigDecimal.ZERO;
                    }
                    totalFareAmt = totalFareAmt.add(fareAmt);
                } else {
                    isSubmit.add(false);
                }
            }
            if (!bipCartItemRespVO.getFareFree().booleanValue()) continue;
            map.put("isShowSubmit", true);
        }
        if (!isSubmit.isEmpty()) {
            map.put("isShowSubmit", false);
        }
        map.put("totalFareAmt", totalFareAmt);
        return map;
    }

    public void buildItemFareInfo(BipCartItemRespVO bipCartItemRespVO, Long addressId) {
        log.info("\u6784\u5efa\u8fd0\u8d39\u4fe1\u606f");
        LogisticsTemplateDFindParam logisticsTemplateDFindParam = new LogisticsTemplateDFindParam();
        BipAddressVO bipAddressVO = null;
        if (addressId == null) {
            List<BipAddressVO> bipAddressVOS = this.bipAddressService.findByAccountId();
            if (bipAddressVOS == null || bipAddressVOS.isEmpty()) {
                return;
            }
            bipAddressVO = bipAddressVOS.get(0);
        } else {
            bipAddressVO = this.bipAddressService.findById(addressId);
        }
        if (bipAddressVO == null) {
            throw new BusinessException("\u6536\u8d27\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        bipCartItemRespVO.setBipAddressVO(bipAddressVO);
        if (bipCartItemRespVO.getItemId() == null) {
            throw new BusinessException("\u5546\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        Long itemId = bipCartItemRespVO.getItemId();
        BipItemDO bipItemDO = (BipItemDO)this.bipItemRepo.findById(itemId).get();
        log.info("\u5546\u54c1\u4e3b\u4fe1\u606f" + JSON.toJSONString((Object)bipItemDO));
        Boolean fareFree = bipItemDO.getFareFree();
        Long templateId = bipItemDO.getFareTmplId();
        bipCartItemRespVO.setFareFree(fareFree);
        bipCartItemRespVO.setFareTmplId(templateId);
        bipCartItemRespVO.setFareTmplCode(bipItemDO.getFareTmplCode());
        bipCartItemRespVO.setFareTmplName(bipItemDO.getFareTmplName());
        String area = bipAddressVO.getArea();
        if (StringUtils.isBlank((CharSequence)area)) {
            area = this.getArea(bipAddressVO);
        }
        logisticsTemplateDFindParam.setProvinceCode(bipAddressVO.getProvince());
        logisticsTemplateDFindParam.setCityCode(bipAddressVO.getCity());
        logisticsTemplateDFindParam.setTemplateId(bipCartItemRespVO.getFareTmplId());
        ArrayList<LogisticsTemplateDFindParam> params = new ArrayList<LogisticsTemplateDFindParam>();
        params.add(logisticsTemplateDFindParam);
        log.info("\u8fd0\u8d39\u4fe1\u606f\u8bf7\u6c42\u53c2\u6570:" + JSON.toJSONString((Object)logisticsTemplateDFindParam));
        if (bipCartItemRespVO.getFareFree() != null && !bipCartItemRespVO.getFareFree().booleanValue()) {
            List<LogisticsTemplateDVO> result = this.logisticsTemplateDService.getByArea(logisticsTemplateDFindParam);
            log.info("\u8fd0\u8d39\u8fd4\u56de\u4fe1\u606f:" + JSON.toJSONString(result));
            if (result != null && !result.isEmpty()) {
                log.info("\u7269\u6d41\u8fd0\u8d39\u4fe1\u606f:" + JSON.toJSONString(result));
                LogisticsTemplateDVO logisticsTemplateDVO = result.get(0);
                BigDecimal incAmt = logisticsTemplateDVO.getAddFreight();
                BigDecimal baseAmt = logisticsTemplateDVO.getDefFreight();
                Integer baseNum = logisticsTemplateDVO.getPieceNumber();
                Integer incNum = logisticsTemplateDVO.getContinuypieceNumber();
                Long itemNum = bipCartItemRespVO.getItemNum();
                Long num = itemNum - (long)baseNum.intValue();
                BigDecimal inc = BigDecimal.valueOf(num).divide(BigDecimal.valueOf(incNum.intValue()), 0, RoundingMode.UP);
                BigDecimal fareAmt = baseAmt.add(incAmt.multiply(inc));
                bipCartItemRespVO.setFareArm(fareAmt);
            }
        }
    }

    public String getArea(BipAddressVO bipAddressVO) {
        if (bipAddressVO.getProvinceName() == null) {
            throw new BusinessException("\u5730\u5740\u7701\u4efd\u4e3a\u7a7a!");
        }
        if (bipAddressVO.getCityName() == null) {
            throw new BusinessException("\u5730\u5740\u57ce\u5e02\u4e3a\u7a7a!");
        }
        String area = bipAddressVO.getProvinceName() + bipAddressVO.getCityName();
        log.info("\u6536\u8d27\u5730\u5740\u533a\u57df--" + area);
        return area;
    }

    public BipCartServiceImpl(BipCartRepo bipCartRepo, RmiPriMainPriceService rmiPriMainPriceService, BipCartRepoProc bipCartRepoProc, BipCustUserBindRepoProc bipCustUserBindRepoProc, MktDiscountOffsetRepoProc mktDiscountOffsetRepoProc, MktDiscountGiftRepoProc mktDiscountGiftRepoProc, CrmCustRepo crmCustRepo, MktDiscountGiftRepo mktDiscountGiftRepo, MktGiftRepo mktGiftRepo, MktGiftRepoProc mktGiftRepoProc, BipCouponRepo bipCouponRepo, BusFirstMenuConfRepo busFirstMenuConfRepo, FirstSpecialItemRepo firstSpecialItemRepo, MktDiscountGiftService mktDiscountGiftService, PriSalePriceRpcService priSalePriceRpcService, CrmCustOuRepo crmCustOuRepo, BipCustUserBindService custUserBindService, PriSalePriceService salePriceService) {
        this.bipCartRepo = bipCartRepo;
        this.rmiPriMainPriceService = rmiPriMainPriceService;
        this.bipCartRepoProc = bipCartRepoProc;
        this.bipCustUserBindRepoProc = bipCustUserBindRepoProc;
        this.mktDiscountOffsetRepoProc = mktDiscountOffsetRepoProc;
        this.mktDiscountGiftRepoProc = mktDiscountGiftRepoProc;
        this.crmCustRepo = crmCustRepo;
        this.mktDiscountGiftRepo = mktDiscountGiftRepo;
        this.mktGiftRepo = mktGiftRepo;
        this.mktGiftRepoProc = mktGiftRepoProc;
        this.bipCouponRepo = bipCouponRepo;
        this.busFirstMenuConfRepo = busFirstMenuConfRepo;
        this.firstSpecialItemRepo = firstSpecialItemRepo;
        this.mktDiscountGiftService = mktDiscountGiftService;
        this.priSalePriceRpcService = priSalePriceRpcService;
        this.crmCustOuRepo = crmCustOuRepo;
        this.custUserBindService = custUserBindService;
        this.salePriceService = salePriceService;
    }
}

