/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service.shop;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Validator;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.security.util.DataAuthJpaUtil;
import com.elitesland.yst.production.sale.api.service.shop.BipCompanyManageService;
import com.elitesland.yst.production.sale.api.service.shop.BipFeedBackService;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipFeedBackParam;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipFeedBackQueryParamVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipFeedBackRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipFeedBackSaveVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.common.model.CurrentUserDTO;
import com.elitesland.yst.production.sale.convert.shop.BipFeedBackCovert;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.core.service.UserService;
import com.elitesland.yst.production.sale.entity.BipFeedBackDO;
import com.elitesland.yst.production.sale.entity.QBipFeedBackDO;
import com.elitesland.yst.production.sale.repo.shop.BipCustUserBindRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipFeedBackRepo;
import com.elitesland.yst.production.support.provider.org.service.OrgEmpRpcService;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class BipFeedBackServiceImpl
extends BaseServiceImpl
implements BipFeedBackService {
    private static final Logger log = LoggerFactory.getLogger(BipFeedBackServiceImpl.class);
    private final BipFeedBackRepo bipFeedBackRepo;
    private final OrgEmpRpcService orgEmpRpcService;
    private final BipCompanyManageService bipCompanyManageService;
    private static final QBipFeedBackDO qbipFeedBackDO = QBipFeedBackDO.bipFeedBackDO;
    @Autowired
    private BipCustUserBindRepoProc bipCustUserBindRepoProc;

    public Long addFeedBack(BipFeedBackParam param) {
        CurrentUserDTO currentUser = UserService.currentUser();
        if (currentUser == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f53\u524d\u7528\u6237\u5df2\u5931\u6548,\u8bf7\u91cd\u767b\u5f55\u91cd\u8bd5");
        }
        String mobile = currentUser.getDetail().getMobile();
        Assert.isFalse((!Validator.isNotEmpty((Object)mobile) ? 1 : 0) != 0, (String)"\u624b\u673a\u53f7\u4e3a\u7a7a\u8bf7\u5b8c\u5584\u4e2a\u4eba\u4fe1\u606f", (Object[])new Object[0]);
        Assert.isFalse((!Validator.isMobile((CharSequence)mobile) ? 1 : 0) != 0, (String)"\u624b\u673a\u53f7\u683c\u5f0f\u9519\u8bef", (Object[])new Object[0]);
        BipFeedBackCovert bipFeedBackCovert = BipFeedBackCovert.INSTANCE;
        BipFeedBackDO bipFeedBackDo = bipFeedBackCovert.paramToDO(param);
        bipFeedBackDo.setCustAccountId(currentUser.getUserId().toString());
        bipFeedBackDo.setCustAccountName(currentUser.getDetail().getUsername());
        bipFeedBackDo.setCreateTime(LocalDateTime.now());
        bipFeedBackDo.setTel(mobile);
        if (!CollectionUtils.isEmpty((Collection)param.getFileCodeList())) {
            String fileCodes = this.listToString(param.getFileCodeList());
            bipFeedBackDo.setFileCodes(fileCodes);
        }
        bipFeedBackDo.setReplay(UdcEnum.COM_YESNO_NO.getValueCode());
        return ((BipFeedBackDO)this.bipFeedBackRepo.save(bipFeedBackDo)).getId();
    }

    public List<BipFeedBackRespVO> getFeedBackAllById() {
        CurrentUserDTO currentUser = UserService.currentUser();
        if (currentUser == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u65e0\u6cd5\u5230\u83b7\u53d6\u5f53\u524d\u7528\u6237");
        }
        Long userId = currentUser.getUserId();
        return this.findFeedBackByUserId(userId.toString()).fetch();
    }

    @SysCodeProc
    public PagingVO<BipFeedBackRespVO> query(BipFeedBackQueryParamVO searchParam) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BipFeedBackRespVO.class, (Expression[])new Expression[]{BipFeedBackServiceImpl.qbipFeedBackDO.id, BipFeedBackServiceImpl.qbipFeedBackDO.custAccountId, BipFeedBackServiceImpl.qbipFeedBackDO.custAccountName, BipFeedBackServiceImpl.qbipFeedBackDO.tel, BipFeedBackServiceImpl.qbipFeedBackDO.replay, BipFeedBackServiceImpl.qbipFeedBackDO.replayAccountId, BipFeedBackServiceImpl.qbipFeedBackDO.replayAccountName, BipFeedBackServiceImpl.qbipFeedBackDO.replayContext, BipFeedBackServiceImpl.qbipFeedBackDO.replayTime, BipFeedBackServiceImpl.qbipFeedBackDO.context, BipFeedBackServiceImpl.qbipFeedBackDO.createTime})).from((EntityPath)qbipFeedBackDO)).where(this.buildPageSearchCondition(searchParam));
        long total = jpaQuery.fetchCount();
        if (total == 0L) {
            return PagingVO.builder().build();
        }
        PageRequest pageRequest = this.wrapperPageRequest(searchParam.getPageRequest(), null);
        this.appendPageAndSort(jpaQuery, pageRequest, qbipFeedBackDO);
        List pageResult = jpaQuery.fetch();
        return PagingVO.builder().total(total).records(pageResult).build();
    }

    @SysCodeProc
    public BipFeedBackRespVO findOneById(Long id) {
        BipFeedBackRespVO bipFeedBackRespVO = (BipFeedBackRespVO)((JPAQuery)((JPAQuery)this.findInfoJpaQuery().where((Predicate)BipFeedBackServiceImpl.qbipFeedBackDO.deleteFlag.eq((Object)0))).where((Predicate)BipFeedBackServiceImpl.qbipFeedBackDO.id.eq((Object)id))).fetchOne();
        Assert.isFalse((boolean)Validator.isNull((Object)bipFeedBackRespVO), (String)"[\u610f\u89c1\u53cd\u9988]\u6ca1\u6709\u67e5\u5230\u6570\u636e", (Object[])new Object[0]);
        String fileCodes = bipFeedBackRespVO.getFileCodes();
        if (!StringUtils.isEmpty((Object)fileCodes)) {
            List<String> fileCodeList = this.stringToList(fileCodes);
            bipFeedBackRespVO.setFileCodeList(fileCodeList);
        }
        return bipFeedBackRespVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public void reply(BipFeedBackSaveVO saveVO) {
        Assert.isFalse((boolean)Validator.isNull((Object)saveVO), (String)"[\u610f\u89c1\u53cd\u9988]\u64cd\u4f5c\u6570\u636e\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isFalse((boolean)Validator.isNull((Object)saveVO.getId()), (String)"[\u610f\u89c1\u53cd\u9988]\u6570\u636eID\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isFalse((boolean)StringUtils.isEmpty((Object)saveVO.getReplayContext()), (String)"\u53cd\u9988\u610f\u89c1\u4e3a\u7a7a", (Object[])new Object[0]);
        CurrentUserDTO currentUser = UserService.currentUser();
        if (currentUser == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f53\u524d\u7528\u6237\u5df2\u5931\u6548,\u8bf7\u91cd\u767b\u5f55\u91cd\u8bd5");
        }
        this.jpaQueryFactory.update((EntityPath)qbipFeedBackDO).set((Path)BipFeedBackServiceImpl.qbipFeedBackDO.replayContext, (Object)saveVO.getReplayContext()).set(BipFeedBackServiceImpl.qbipFeedBackDO.replayTime, (Object)saveVO.getReplayTime()).set((Path)BipFeedBackServiceImpl.qbipFeedBackDO.replay, (Object)UdcEnum.COM_YESNO_YES.getValueCode()).set((Path)BipFeedBackServiceImpl.qbipFeedBackDO.replayAccountId, (Object)String.valueOf(currentUser.getUserId())).set((Path)BipFeedBackServiceImpl.qbipFeedBackDO.replayAccountName, (Object)currentUser.getDetail().getUsername()).where(new Predicate[]{BipFeedBackServiceImpl.qbipFeedBackDO.id.eq((Object)saveVO.getId())}).execute();
    }

    private JPAQuery<BipFeedBackRespVO> findInfoJpaQuery() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BipFeedBackRespVO.class, (Expression[])new Expression[]{BipFeedBackServiceImpl.qbipFeedBackDO.id, BipFeedBackServiceImpl.qbipFeedBackDO.custAccountId, BipFeedBackServiceImpl.qbipFeedBackDO.custAccountName, BipFeedBackServiceImpl.qbipFeedBackDO.tel, BipFeedBackServiceImpl.qbipFeedBackDO.replay, BipFeedBackServiceImpl.qbipFeedBackDO.replayAccountId, BipFeedBackServiceImpl.qbipFeedBackDO.replayAccountName, BipFeedBackServiceImpl.qbipFeedBackDO.replayContext, BipFeedBackServiceImpl.qbipFeedBackDO.replayTime, BipFeedBackServiceImpl.qbipFeedBackDO.context, BipFeedBackServiceImpl.qbipFeedBackDO.createTime, BipFeedBackServiceImpl.qbipFeedBackDO.fileCodes})).from((EntityPath)qbipFeedBackDO);
    }

    private JPAQuery<BipFeedBackRespVO> findFeedBackByUserId(String id) {
        return (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BipFeedBackRespVO.class, (Expression[])new Expression[]{BipFeedBackServiceImpl.qbipFeedBackDO.id, BipFeedBackServiceImpl.qbipFeedBackDO.custAccountName, BipFeedBackServiceImpl.qbipFeedBackDO.replayContext, BipFeedBackServiceImpl.qbipFeedBackDO.replayAccountName, BipFeedBackServiceImpl.qbipFeedBackDO.context, BipFeedBackServiceImpl.qbipFeedBackDO.createTime})).from((EntityPath)qbipFeedBackDO)).where((Predicate)BipFeedBackServiceImpl.qbipFeedBackDO.custAccountId.eq((Object)id));
    }

    private Predicate buildPageSearchCondition(BipFeedBackQueryParamVO param) {
        BooleanExpression predicate = qbipFeedBackDO.isNotNull();
        if (Objects.nonNull(param)) {
            if (!StringUtils.isEmpty((Object)param.getCustAccountName())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)BipFeedBackServiceImpl.qbipFeedBackDO.custAccountName.like("%" + param.getCustAccountName() + "%"));
            }
            if (!StringUtils.isEmpty((Object)param.getTel())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)BipFeedBackServiceImpl.qbipFeedBackDO.tel.like("%" + param.getTel() + "%"));
            }
            if (Objects.nonNull(param.getCreateTime())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)BipFeedBackServiceImpl.qbipFeedBackDO.createTime.after((Comparable)LocalDateTime.of(param.getCreateTime().toLocalDate(), LocalTime.MIN)));
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)BipFeedBackServiceImpl.qbipFeedBackDO.createTime.before((Comparable)LocalDateTime.of(param.getCreateTime().toLocalDate(), LocalTime.MAX)));
            }
            if (!StringUtils.isEmpty((Object)param.getReplay())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)BipFeedBackServiceImpl.qbipFeedBackDO.replay.eq((Object)param.getReplay()));
            }
        }
        predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)DataAuthJpaUtil.dataAuthJpaPredicate((PathMetadata)qbipFeedBackDO.getMetadata()));
        log.info("\u5ba2\u6237\u53cd\u9988\u610f\u89c1\u67e5\u8be2\u6743\u9650" + (Predicate)predicate);
        return predicate;
    }

    private String listToString(List<String> fileCodeList) {
        StringBuilder fileCodeString = new StringBuilder();
        for (String s : fileCodeList) {
            fileCodeString.append(s).append("|");
        }
        return fileCodeString.toString();
    }

    private List<String> stringToList(String fileCodes) {
        String[] split = fileCodes.split("\\|");
        return Arrays.stream(split).collect(Collectors.toList());
    }

    public BipFeedBackServiceImpl(BipFeedBackRepo bipFeedBackRepo, OrgEmpRpcService orgEmpRpcService, BipCompanyManageService bipCompanyManageService) {
        this.bipFeedBackRepo = bipFeedBackRepo;
        this.orgEmpRpcService = orgEmpRpcService;
        this.bipCompanyManageService = bipCompanyManageService;
    }
}

