/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service.shop;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.IterUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Validator;
import cn.hutool.core.util.StrUtil;
import com.alibaba.cloud.commons.lang.StringUtils;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.service.shop.BipCompanyManageService;
import com.elitesland.yst.production.sale.api.service.shop.MktDiscountGiftService;
import com.elitesland.yst.production.sale.api.vo.param.shop.MktDiscountGiftDSaveVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.MktDiscountGiftQueryVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.MktDiscountGiftSaveVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.MktGiftSaveVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipCompanyManageRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.MktDiscountGiftRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.MktDiscountGiftVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.common.model.CurrentUserDTO;
import com.elitesland.yst.production.sale.convert.shop.MktDiscountGiftConvert;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.core.service.UserService;
import com.elitesland.yst.production.sale.entity.BipItemSkuDO;
import com.elitesland.yst.production.sale.entity.MktDiscountGiftDDO;
import com.elitesland.yst.production.sale.entity.MktDiscountGiftDO;
import com.elitesland.yst.production.sale.entity.MktGiftDO;
import com.elitesland.yst.production.sale.entity.QBipItemSkuDO;
import com.elitesland.yst.production.sale.entity.QMktDiscountGiftDO;
import com.elitesland.yst.production.sale.repo.shop.BipItemSkuRepo;
import com.elitesland.yst.production.sale.repo.shop.MktDiscountGiftDRepo;
import com.elitesland.yst.production.sale.repo.shop.MktDiscountGiftRepo;
import com.elitesland.yst.production.sale.repo.shop.MktDiscountGiftRepoProc;
import com.elitesland.yst.production.sale.repo.shop.MktDiscountOffsetRepoProc;
import com.elitesland.yst.production.sale.repo.shop.MktGiftRepo;
import com.elitesland.yst.production.sale.repo.shop.MktGiftRepoProc;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysNextNumberService;
import com.elitesland.yst.production.support.provider.org.dto.OrgUserEmpInfoRpcDTO;
import com.elitesland.yst.production.support.provider.org.service.OrgEmpRpcService;
import com.google.common.collect.Lists;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class MktDiscountGiftServiceImpl
extends BaseServiceImpl
implements MktDiscountGiftService {
    private static final Logger log = LoggerFactory.getLogger(MktDiscountGiftServiceImpl.class);
    private final OrgEmpRpcService orgEmpRpcService;
    private final RmiSysNextNumberService rmiSysNextNumberService;
    private final BipCompanyManageService bipCompanyManageService;
    private final MktDiscountGiftRepo mktDiscountGiftRepo;
    private final MktDiscountGiftDRepo mktDiscountGiftDRepo;
    private final MktGiftRepo mktGiftRepo;
    private final BipItemSkuRepo bipItemSkuRepo;
    private final MktGiftRepoProc mktGiftRepoProc;
    private final MktDiscountGiftRepoProc mktDiscountGiftRepoProc;
    private final MktDiscountOffsetRepoProc mktDiscountOffsetRepoProc;
    @Autowired
    private UdcProvider udcProvider;

    public PagingVO<MktDiscountGiftRespVO> search(MktDiscountGiftQueryVO queryParam) {
        List<String> first = this.mktDiscountGiftRepoProc.findDiscountCode(queryParam.getItemCode());
        queryParam.setCodeByItem(first != null && first.size() > 0 ? first.stream().filter(Objects::nonNull).distinct().collect(Collectors.toList()) : new ArrayList());
        List<String> second = this.mktGiftRepoProc.findDiscountCode(queryParam.getGiftCode());
        queryParam.setCodeByGift(second != null && second.size() > 0 ? second.stream().filter(Objects::nonNull).distinct().collect(Collectors.toList()) : new ArrayList());
        QMktDiscountGiftDO qmktDiscountGiftDO = QMktDiscountGiftDO.mktDiscountGiftDO;
        JPAQuery<MktDiscountGiftRespVO> jpaQuery = this.mktDiscountGiftRepoProc.select(queryParam);
        long total = jpaQuery.fetchCount();
        if (total == 0L) {
            return PagingVO.builder().build();
        }
        PageRequest pageRequest = this.wrapperPageRequest(queryParam.getPageRequest(), null);
        this.appendPageAndSort(jpaQuery, pageRequest, qmktDiscountGiftDO);
        List pageResult = jpaQuery.fetch();
        this.transUdc(pageResult);
        return PagingVO.builder().total(total).records(pageResult).build();
    }

    public Optional<MktDiscountGiftRespVO> findCodeOne(String code) {
        QMktDiscountGiftDO qmktDiscountGiftDO = QMktDiscountGiftDO.mktDiscountGiftDO;
        MktDiscountGiftRespVO mktDiscountGiftRespVO = (MktDiscountGiftRespVO)((JPAQuery)this.mktDiscountGiftRepoProc.select(null).where((Predicate)qmktDiscountGiftDO.code.eq((Object)code))).fetchOne();
        if (mktDiscountGiftRespVO == null) {
            return Optional.empty();
        }
        this.setDetails(mktDiscountGiftRespVO);
        this.transUdc(Collections.singletonList(mktDiscountGiftRespVO));
        return Optional.of(mktDiscountGiftRespVO);
    }

    public Optional<MktDiscountGiftRespVO> findIdOne(Long id) {
        QMktDiscountGiftDO qmktDiscountGiftDO = QMktDiscountGiftDO.mktDiscountGiftDO;
        MktDiscountGiftRespVO mktDiscountGiftRespVO = (MktDiscountGiftRespVO)((JPAQuery)this.mktDiscountGiftRepoProc.select(null).where((Predicate)qmktDiscountGiftDO.id.eq((Object)id))).fetchOne();
        if (mktDiscountGiftRespVO == null) {
            return Optional.empty();
        }
        this.setDetails(mktDiscountGiftRespVO);
        this.transUdc(Collections.singletonList(mktDiscountGiftRespVO));
        return Optional.of(mktDiscountGiftRespVO);
    }

    @Transactional(rollbackFor={Exception.class})
    public List<Long> createBatch(List<MktDiscountGiftSaveVO> list) {
        if (!CollectionUtil.isEmpty(list)) {
            OrgUserEmpInfoRpcDTO userEmpInfo = this.getCurrentEmpInfo();
            List manageByOuIds = this.bipCompanyManageService.findCompanyManageByOuIds(Arrays.asList(userEmpInfo.getOuId()));
            if (CollectionUtils.isEmpty((Collection)manageByOuIds)) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f53\u524d\u7528\u6237\u516c\u53f8\u4fe1\u606f\u4e3a\u7a7a");
            }
            this.paramCheck(list, true);
            List<Long> result = list.stream().map(i -> {
                MktDiscountGiftConvert mktDiscountGiftConvert = MktDiscountGiftConvert.INSTANCE;
                MktDiscountGiftDO mktDiscountGiftDO = mktDiscountGiftConvert.saveVoToDo((MktDiscountGiftSaveVO)i);
                mktDiscountGiftDO.setSecOuId(userEmpInfo.getOuId());
                mktDiscountGiftDO.setSecUserId(userEmpInfo.getUserId());
                mktDiscountGiftDO.setSecBuId(((BipCompanyManageRespVO)manageByOuIds.get(0)).getBuId());
                mktDiscountGiftDO.setId(null);
                String code = this.rmiSysNextNumberService.generateCode("yst-sale", "CX", new ArrayList<String>());
                mktDiscountGiftDO.setCode(code);
                mktDiscountGiftDO.setOuId(userEmpInfo.getOuId());
                mktDiscountGiftDO.setOuCode(userEmpInfo.getOuCode());
                mktDiscountGiftDO.setOuName(userEmpInfo.getOuName());
                mktDiscountGiftDO.setBuId(userEmpInfo.getBuId());
                mktDiscountGiftDO.setBuCode(userEmpInfo.getBuCode());
                mktDiscountGiftDO.setBuName(userEmpInfo.getBuName());
                mktDiscountGiftDO.setDeleteFlag(0);
                Long masId = ((MktDiscountGiftDO)this.mktDiscountGiftRepo.save(mktDiscountGiftDO)).getId();
                List mktDiscountGiftDDOS = i.getDetails().stream().map(d -> {
                    MktDiscountGiftDDO mktDiscountGiftDDO = mktDiscountGiftConvert.dsaveVoToDo((MktDiscountGiftDSaveVO)d);
                    mktDiscountGiftDO.setSecOuId(userEmpInfo.getOuId());
                    String skuCode = mktDiscountGiftDDO.getItemCode();
                    if (StringUtils.isNotBlank((CharSequence)skuCode)) {
                        QBipItemSkuDO qBipItemSkuDO = QBipItemSkuDO.bipItemSkuDO;
                        BooleanExpression exp = qBipItemSkuDO.skuCode.eq((Object)skuCode).and((Predicate)qBipItemSkuDO.deleteFlag.eq((Object)0));
                        Iterable iterables = this.bipItemSkuRepo.findAll((Predicate)exp);
                        if (!IterUtil.isEmpty((Iterable)iterables)) {
                            ArrayList listSkus = Lists.newArrayList((Iterable)iterables);
                            mktDiscountGiftDDO.setItemId(((BipItemSkuDO)listSkus.get(0)).getId());
                        }
                    }
                    mktDiscountGiftDDO.setSecOuId(userEmpInfo.getOuId());
                    mktDiscountGiftDDO.setSecUserId(userEmpInfo.getUserId());
                    mktDiscountGiftDDO.setSecBuId(((BipCompanyManageRespVO)manageByOuIds.get(0)).getBuId());
                    mktDiscountGiftDDO.setId(null);
                    mktDiscountGiftDDO.setMktDiscountGiftId(masId);
                    mktDiscountGiftDDO.setDiscountGiftCode(code);
                    mktDiscountGiftDDO.setDeleteFlag(0);
                    return mktDiscountGiftDDO;
                }).collect(Collectors.toList());
                this.mktDiscountGiftDRepo.saveAll(mktDiscountGiftDDOS);
                List mktGiftDOS = i.getGiftDetails().stream().map(d -> {
                    MktGiftDO mktGiftDO = mktDiscountGiftConvert.gsaveVoToDo((MktGiftSaveVO)d);
                    mktGiftDO.setStockNowNum(d.getStockNum());
                    mktGiftDO.setSecOuId(userEmpInfo.getOuId());
                    mktGiftDO.setSecUserId(userEmpInfo.getUserId());
                    mktGiftDO.setSecBuId(((BipCompanyManageRespVO)manageByOuIds.get(0)).getBuId());
                    mktGiftDO.setId(null);
                    mktGiftDO.setDiscountGiftCode(code);
                    mktGiftDO.setDeleteFlag(0);
                    return mktGiftDO;
                }).collect(Collectors.toList());
                this.mktGiftRepo.saveAll(mktGiftDOS);
                return mktDiscountGiftDO.getId();
            }).collect(Collectors.toList());
            return result;
        }
        return Collections.EMPTY_LIST;
    }

    @Transactional(rollbackFor={Exception.class})
    public void update(MktDiscountGiftSaveVO updateParam) {
        OrgUserEmpInfoRpcDTO userEmpInfo = this.getCurrentEmpInfo();
        List manageByOuIds = this.bipCompanyManageService.findCompanyManageByOuIds(Arrays.asList(userEmpInfo.getOuId()));
        if (CollectionUtils.isEmpty((Collection)manageByOuIds)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f53\u524d\u7528\u6237\u516c\u53f8\u4fe1\u606f\u4e3a\u7a7a");
        }
        this.paramCheck(Collections.singletonList(updateParam), false);
        MktDiscountGiftDO oldDO = (MktDiscountGiftDO)this.mktDiscountGiftRepo.findById(updateParam.getId()).get();
        Assert.isFalse((boolean)Validator.isNull((Object)oldDO), (String)"[\u6ee1\u51cf\u8d60\u4fc3\u9500]\u64cd\u4f5c\u6570\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        MktDiscountGiftConvert mktDiscountGiftConvert = MktDiscountGiftConvert.INSTANCE;
        MktDiscountGiftDO mktDiscountGiftDO = mktDiscountGiftConvert.saveVoToDo(updateParam);
        mktDiscountGiftDO.setSecOuId(userEmpInfo.getOuId());
        mktDiscountGiftDO.setSecUserId(userEmpInfo.getUserId());
        mktDiscountGiftDO.setSecBuId(((BipCompanyManageRespVO)manageByOuIds.get(0)).getBuId());
        mktDiscountGiftDO.setOuId(oldDO.getOuId());
        mktDiscountGiftDO.setOuCode(oldDO.getOuCode());
        mktDiscountGiftDO.setOuName(oldDO.getOuName());
        mktDiscountGiftDO.setBuId(oldDO.getBuId());
        mktDiscountGiftDO.setBuCode(oldDO.getBuCode());
        mktDiscountGiftDO.setBuName(oldDO.getBuName());
        if (mktDiscountGiftDO.getDeleteFlag() == null) {
            mktDiscountGiftDO.setDeleteFlag(0);
        }
        List details = updateParam.getDetails().stream().map(i -> {
            MktDiscountGiftDDO mktDiscountGiftDDO = mktDiscountGiftConvert.dsaveVoToDo((MktDiscountGiftDSaveVO)i);
            String skuCode = mktDiscountGiftDDO.getItemCode();
            if (StringUtils.isNotBlank((CharSequence)skuCode)) {
                QBipItemSkuDO qBipItemSkuDO = QBipItemSkuDO.bipItemSkuDO;
                BooleanExpression exp = qBipItemSkuDO.skuCode.eq((Object)skuCode).and((Predicate)qBipItemSkuDO.deleteFlag.eq((Object)0));
                Iterable iterables = this.bipItemSkuRepo.findAll((Predicate)exp);
                if (!IterUtil.isEmpty((Iterable)iterables)) {
                    ArrayList listSkus = Lists.newArrayList((Iterable)iterables);
                    mktDiscountGiftDDO.setItemId(((BipItemSkuDO)listSkus.get(0)).getId());
                }
            }
            mktDiscountGiftDDO.setSecOuId(userEmpInfo.getOuId());
            mktDiscountGiftDDO.setSecUserId(userEmpInfo.getUserId());
            mktDiscountGiftDDO.setSecBuId(((BipCompanyManageRespVO)manageByOuIds.get(0)).getBuId());
            mktDiscountGiftDDO.setMktDiscountGiftId(oldDO.getId());
            mktDiscountGiftDDO.setDiscountGiftCode(oldDO.getCode());
            if (mktDiscountGiftDDO.getDeleteFlag() == null) {
                mktDiscountGiftDDO.setDeleteFlag(0);
            }
            return mktDiscountGiftDDO;
        }).collect(Collectors.toList());
        List giftDetails = updateParam.getGiftDetails().stream().map(i -> {
            MktGiftDO mktGiftDO = mktDiscountGiftConvert.gsaveVoToDo((MktGiftSaveVO)i);
            mktGiftDO.setSecOuId(userEmpInfo.getOuId());
            mktGiftDO.setSecUserId(userEmpInfo.getUserId());
            mktGiftDO.setSecBuId(((BipCompanyManageRespVO)manageByOuIds.get(0)).getBuId());
            mktGiftDO.setDiscountGiftCode(oldDO.getCode());
            if (mktGiftDO.getDeleteFlag() == null) {
                mktGiftDO.setDeleteFlag(0);
            }
            return mktGiftDO;
        }).collect(Collectors.toList());
        this.mktDiscountGiftRepo.save(mktDiscountGiftDO);
        this.mktDiscountGiftDRepo.saveAll(details);
        this.mktGiftRepo.saveAll(giftDetails);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<Long> idList) {
        if (CollectionUtil.isEmpty(idList)) {
            return;
        }
        List<String> codeList = this.mktDiscountGiftRepoProc.getCodeById(idList);
        this.mktDiscountGiftRepoProc.deleteIdBatch(codeList);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteDBatch(List<Long> idList) {
        List allDetails = this.mktDiscountGiftDRepo.findAllById(idList);
        allDetails.forEach(i -> {
            this.mktDiscountGiftRepoProc.deleteDetailInfo(i.getId());
            this.mktDiscountGiftRepoProc.deleteGiftInfo(i.getDiscountGiftCode(), i.getItemId());
        });
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteGiftBatch(List<Long> idList) {
        this.mktDiscountGiftRepoProc.deleteGiftInfo(idList);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateDeleteFlag(Long id) {
        this.updateDeleteFlagBatch(Collections.singletonList(id));
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateDeleteFlagBatch(List<Long> ids) {
        Assert.isFalse((boolean)CollectionUtil.isEmpty(ids), (String)"[\u6ee1\u51cf\u8d60\u4fc3\u9500]\u64cd\u4f5c\u6570\u636e\u4e3a\u7a7a", (Object[])new Object[0]);
        List<String> codeList = this.mktDiscountGiftRepoProc.getCodeById(ids);
        this.mktDiscountGiftRepoProc.updateDeleteFlagBatch(codeList, 1);
    }

    @Transactional(rollbackFor={Exception.class})
    public void appr(List<Long> ids, String status) {
        Map statusUdcMap = this.udcProvider.getValueMapByUdcCode("yst-sale", "DISCOUNT_OFFSET_STATUS");
        Assert.isFalse((boolean)CollectionUtil.isEmpty(ids), (String)"[\u6ee1\u51cf\u8d60\u4fc3\u9500]\u64cd\u4f5c\u6570\u636e\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isTrue((boolean)this.checkUdcValueExit(statusUdcMap, status), (String)"\u4fc3\u9500\u72b6\u6001\u5f02\u5e38", (Object[])new Object[0]);
        if (status.equals("ENABLE")) {
            boolean flag = this.getOffsetSkuIds(ids);
            log.info("\u67e5\u8be2\u6ee1\u51cf\u6ee1\u8d60\u540c\u65f6\u5b58\u5728\uff1a---------" + flag);
            if (!flag) {
                throw new BusinessException("\u4e00\u4e2a\u5546\u54c1\u53ea\u80fd\u662f\u6ee1\u51cf\u6216\u4e70\u8d60");
            }
        }
        this.mktDiscountGiftRepoProc.updateStatusBatch(ids, status);
    }

    public boolean getOffsetSkuIds(List<Long> ids) {
        for (Long id : ids) {
            List<String> offsetSkuCodes;
            List<String> giftItemCodes = this.mktDiscountGiftRepoProc.getGiftSkuCode(id);
            Long ouId = this.mktDiscountGiftRepoProc.getOuIdById(id).get(0);
            List<Long> offSetIds = this.mktDiscountOffsetRepoProc.getOffsetId(ouId);
            if (null == offSetIds || offSetIds.isEmpty() || (offsetSkuCodes = this.mktDiscountOffsetRepoProc.getOffsetDetailSkuCode(offSetIds)).isEmpty() || offsetSkuCodes.isEmpty()) continue;
            offsetSkuCodes.retainAll(giftItemCodes);
            if (offsetSkuCodes.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public List<MktDiscountGiftVO> findMktDiscountGiftByParam(Long ouId, String customLevel, List<Long> itemIds) {
        Assert.isFalse((boolean)CollectionUtil.isEmpty(itemIds), (String)"\u5546\u54c1\u6570\u636e\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isFalse((boolean)Validator.isNull((Object)ouId), (String)"\u516c\u53f8\u6570\u636e\u4e3a\u7a7a", (Object[])new Object[0]);
        List mktDiscountGiftVOS = this.mktDiscountGiftRepoProc.findMktDisCountGift(ouId, customLevel, LocalDateTime.now(), itemIds).fetch();
        mktDiscountGiftVOS.forEach(i -> i.setGiftDetails(this.mktDiscountGiftRepoProc.selectGiftDetailsByMasCodeOrItemId(i.getCode(), i.getItemId()).fetch()));
        if (CollectionUtil.isNotEmpty((Collection)mktDiscountGiftVOS)) {
            Map custGroupUdcMap = this.udcProvider.getValueMapByUdcCode("yst-sale", "CUST_GROUP");
            Map statusUdcMap = this.udcProvider.getValueMapByUdcCode("yst-sale", "DISCOUNT_OFFSET_STATUS");
            Map typeUdcMap = this.udcProvider.getValueMapByUdcCode("yst-sale", "DISCOUNT_OFFSET_TYPE");
            Map uomUdcMap = this.udcProvider.getValueMapByUdcCode("yst-supp", "UOM");
            Map giftMaterielUdcMap = this.udcProvider.getValueMapByUdcCode("yst-supp", "ITEM_TYPE2");
            Map giftTypeUdcMap = this.udcProvider.getValueMapByUdcCode("yst-supp", "ITEM_TYPE");
            mktDiscountGiftVOS.forEach(i -> {
                if (StringUtils.isNotBlank((CharSequence)i.getCustomLevel()) && !MapUtils.isEmpty((Map)custGroupUdcMap)) {
                    i.setCustomLevelName((String)custGroupUdcMap.get(i.getCustomLevel()));
                }
                if (StringUtils.isNotBlank((CharSequence)i.getType()) && !MapUtils.isEmpty((Map)typeUdcMap)) {
                    i.setTypeName((String)typeUdcMap.get(i.getType()));
                }
                if (StringUtils.isNotBlank((CharSequence)i.getStatus()) && !MapUtils.isEmpty((Map)statusUdcMap)) {
                    i.setStatusName((String)statusUdcMap.get(i.getStatus()));
                }
                if (StringUtils.isNotBlank((CharSequence)i.getUom()) && !MapUtils.isEmpty((Map)uomUdcMap)) {
                    i.setUomName((String)uomUdcMap.get(i.getUom()));
                }
                if (!CollectionUtil.isEmpty((Collection)i.getGiftDetails())) {
                    i.getGiftDetails().forEach(d -> {
                        if (StringUtils.isNotBlank((CharSequence)d.getMateriel()) && !MapUtils.isEmpty((Map)giftMaterielUdcMap)) {
                            d.setMaterielName((String)giftMaterielUdcMap.get(d.getMateriel()));
                        }
                        if (StringUtils.isNotBlank((CharSequence)d.getType()) && !MapUtils.isEmpty((Map)giftTypeUdcMap)) {
                            d.setTypeName((String)giftTypeUdcMap.get(d.getType()));
                        }
                    });
                }
            });
        }
        return mktDiscountGiftVOS;
    }

    private void setDetails(MktDiscountGiftRespVO mktDiscountGiftRespVO) {
        if (mktDiscountGiftRespVO == null) {
            return;
        }
        List details = this.mktDiscountGiftRepoProc.selectDetailsByMasIdOrCode(mktDiscountGiftRespVO.getId(), null).fetch();
        List giftDetails = this.mktDiscountGiftRepoProc.selectGiftDetailsByMasCodeOrItemId(mktDiscountGiftRespVO.getCode(), null).fetch();
        mktDiscountGiftRespVO.setDetails(details);
        mktDiscountGiftRespVO.setGiftDetails(giftDetails);
    }

    private OrgUserEmpInfoRpcDTO getCurrentEmpInfo() {
        CurrentUserDTO currentUser = UserService.currentUser();
        if (currentUser == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f53\u524d\u7528\u6237\u5df2\u5931\u6548,\u8bf7\u91cd\u767b\u5f55\u91cd\u8bd5");
        }
        OrgUserEmpInfoRpcDTO userEmpInfo = this.orgEmpRpcService.findUserEmpInfo(currentUser.getUserId());
        if (userEmpInfo == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f");
        }
        return userEmpInfo;
    }

    private void paramCheck(List<MktDiscountGiftSaveVO> source, boolean isNew) {
        Map custGroupUdcMap = this.udcProvider.getValueMapByUdcCode("yst-sale", "CUST_GROUP");
        Map statusUdcMap = this.udcProvider.getValueMapByUdcCode("yst-sale", "DISCOUNT_OFFSET_STATUS");
        Map typeUdcMap = this.udcProvider.getValueMapByUdcCode("yst-sale", "DISCOUNT_OFFSET_TYPE");
        Map uomUdcMap = this.udcProvider.getValueMapByUdcCode("yst-supp", "UOM");
        source.forEach(i -> {
            List itemIds;
            Assert.isFalse((boolean)Validator.isNull((Object)i), (String)"[\u6ee1\u51cf\u8d60\u4fc3\u9500]\u64cd\u4f5c\u6570\u636e\u4e3a\u7a7a", (Object[])new Object[0]);
            if (!isNew) {
                Assert.isFalse((boolean)Validator.isNull((Object)i.getId()), (String)"\u66f4\u65b0\u4e3b\u952e\u7f3a\u5931", (Object[])new Object[0]);
                Assert.isFalse((boolean)Validator.isEmpty((Object)i.getCode()), (String)"\u4fc3\u9500\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
            }
            Assert.isFalse((boolean)Validator.isEmpty((Object)i.getName()), (String)"\u4fc3\u9500\u540d\u79f0\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.isFalse((boolean)Validator.isNull((Object)i.getValidStime()), (String)"\u4fc3\u9500\u751f\u6548\u65f6\u95f4\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.isFalse((boolean)Validator.isNull((Object)i.getValidEtime()), (String)"\u4fc3\u9500\u5931\u6548\u65f6\u95f4\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.isFalse((boolean)Validator.isEmpty((Object)i.getType()), (String)"\u4fc3\u9500\u6761\u4ef6\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.isFalse((boolean)CollectionUtil.isEmpty((Collection)i.getDetails()), (String)"\u4fc3\u9500\u660e\u7ec6\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.isFalse((boolean)CollectionUtil.isEmpty((Collection)i.getGiftDetails()), (String)"\u4fc3\u9500\u8d60\u54c1\u660e\u7ec6\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.isTrue((boolean)this.checkUdcValueExit(typeUdcMap, i.getType()), (String)"\u4fc3\u9500\u7c7b\u578b\u5f02\u5e38", (Object[])new Object[0]);
            Assert.isTrue((boolean)this.checkUdcValueExit(statusUdcMap, i.getStatus()), (String)"\u4fc3\u9500\u72b6\u6001\u5f02\u5e38", (Object[])new Object[0]);
            if (!StringUtils.isEmpty((CharSequence)i.getCustomLevel())) {
                Assert.isTrue((boolean)this.checkUdcValueExit(custGroupUdcMap, i.getCustomLevel()), (String)"\u5ba2\u6237\u7b49\u7ea7\u6570\u636e\u5f02\u5e38", (Object[])new Object[0]);
            }
            Assert.isFalse(((itemIds = i.getDetails().stream().map(MktDiscountGiftDSaveVO::getItemId).distinct().collect(Collectors.toList())).size() != i.getDetails().size() ? 1 : 0) != 0, (String)"\u660e\u7ec6\u4e2d\u5b58\u5728\u76f8\u540c\u7684\u5546\u54c1", (Object[])new Object[0]);
            i.getDetails().forEach(d -> {
                Assert.isTrue((boolean)this.checkUdcValueExit(uomUdcMap, d.getUom()), (String)"\u660e\u7ec6\u5546\u54c1\u5355\u4f4d\u5f02\u5e38", (Object[])new Object[0]);
                Assert.isFalse((boolean)i.getGiftDetails().stream().noneMatch(m -> d.getItemId().equals(m.getDiscountGiftItemId())), (String)"\u6ee1\u8d60\u8d60\u54c1\u4e3a\u7a7a", (Object[])new Object[0]);
                if (UdcEnum.MKT_DISCOUNT_OFFSET_TYPE_0.getValueCode().equals(i.getType())) {
                    Assert.isFalse((boolean)Validator.isNull((Object)d.getLimitNum()), (String)"\u3010\u4fc3\u9500\u6761\u4ef6\u3011\u4e3a\u3010\u6309\u6570\u91cf\u3011\uff0c\u6ee1\u8d60\u8fbe\u6807\u6570\u91cf\u4e3a\u7a7a", (Object[])new Object[0]);
                    d.setLimitAmt(null);
                } else if (UdcEnum.MKT_DISCOUNT_OFFSET_TYPE_1.getValueCode().equals(i.getType())) {
                    Assert.isFalse((boolean)Validator.isNull((Object)d.getLimitAmt()), (String)"\u3010\u4fc3\u9500\u6761\u4ef6\u3011\u4e3a\u3010\u6309\u91d1\u989d\u3011\uff0c\u6ee1\u8d60\u8fbe\u6807\u91d1\u989d\u4e3a\u7a7a", (Object[])new Object[0]);
                    d.setLimitNum(null);
                }
            });
        });
    }

    private void paramDbCheck(List<MktDiscountGiftSaveVO> source, boolean isNew, Long ouId) {
        source.forEach(i -> {
            if (i.getValidEtime().isAfter(LocalDateTime.now())) {
                List<Long> itemIds = i.getDetails().stream().map(MktDiscountGiftDSaveVO::getItemId).distinct().collect(Collectors.toList());
                List<Tuple> itemCodes = this.mktDiscountGiftRepoProc.checkItemExitsInValidDate(isNew ? null : i.getId(), ouId, i.getCustomLevel(), i.getValidStime(), i.getValidEtime(), itemIds);
                Assert.isFalse((itemCodes.size() > 0 ? 1 : 0) != 0, (String)"\u6570\u636e\u5e93\u5df2\u5b58\u5728\u7b26\u5408\u751f\u6548\u89c4\u5219\u7684[\u4e70\u8d60\u6d3b\u52a8]\u5546\u54c1\u660e\u7ec6\uff1a{}", (Object[])new Object[]{String.join((CharSequence)",", itemCodes.stream().map(t -> StrUtil.format((CharSequence)"[\u4fc3\u9500\u7f16\u7801\u4e3a\uff1a{}\uff0c\u5546\u54c1\u7f16\u53f7\u4e3a:{}]", (Object[])new Object[]{t.get(0, String.class), t.get(1, String.class)})).collect(Collectors.toList()))});
                itemCodes = this.mktDiscountOffsetRepoProc.checkItemExitsInValidDate(isNew ? null : i.getId(), ouId, i.getCustomLevel(), i.getValidStime(), i.getValidEtime(), itemIds);
                Assert.isFalse((itemCodes.size() > 0 ? 1 : 0) != 0, (String)"\u6570\u636e\u5e93\u5df2\u5b58\u5728\u7b26\u5408\u751f\u6548\u89c4\u5219\u7684[\u6ee1\u51cf\u6d3b\u52a8]\u5546\u54c1\u660e\u7ec6\uff1a{}", (Object[])new Object[]{String.join((CharSequence)",", itemCodes.stream().map(t -> StrUtil.format((CharSequence)"[\u4fc3\u9500\u7f16\u7801\u4e3a\uff1a{}\uff0c\u5546\u54c1\u7f16\u53f7\u4e3a:{}]", (Object[])new Object[]{t.get(0, String.class), t.get(1, String.class)})).collect(Collectors.toList()))});
            }
        });
    }

    private void transUdc(List<MktDiscountGiftRespVO> source) {
        Map custGroupUdcMap = this.udcProvider.getValueMapByUdcCode("yst-sale", "CUST_GROUP");
        Map statusUdcMap = this.udcProvider.getValueMapByUdcCode("yst-sale", "DISCOUNT_OFFSET_STATUS");
        Map typeUdcMap = this.udcProvider.getValueMapByUdcCode("yst-sale", "DISCOUNT_OFFSET_TYPE");
        Map uomUdcMap = this.udcProvider.getValueMapByUdcCode("yst-supp", "UOM");
        Map giftMaterielUdcMap = this.udcProvider.getValueMapByUdcCode("yst-sale", "ITEM_TYPE2");
        Map giftTypeUdcMap = this.udcProvider.getValueMapByUdcCode("yst-sale", "ITEM_TYPE");
        source.forEach(i -> {
            if (StringUtils.isNotBlank((CharSequence)i.getCustomLevel()) && !MapUtils.isEmpty((Map)custGroupUdcMap)) {
                i.setCustomLevelName((String)custGroupUdcMap.get(i.getCustomLevel()));
            }
            if (StringUtils.isNotBlank((CharSequence)i.getType()) && !MapUtils.isEmpty((Map)typeUdcMap)) {
                i.setTypeName((String)typeUdcMap.get(i.getType()));
            }
            if (StringUtils.isNotBlank((CharSequence)i.getStatus()) && !MapUtils.isEmpty((Map)statusUdcMap)) {
                i.setStatusName((String)statusUdcMap.get(i.getStatus()));
            }
            if (!CollectionUtil.isEmpty((Collection)i.getDetails())) {
                i.getDetails().forEach(d -> {
                    if (StringUtils.isNotBlank((CharSequence)d.getUom()) && !MapUtils.isEmpty((Map)uomUdcMap)) {
                        d.setUomName((String)uomUdcMap.get(d.getUom()));
                    }
                });
            }
            if (!CollectionUtil.isEmpty((Collection)i.getGiftDetails())) {
                i.getGiftDetails().forEach(d -> {
                    if (StringUtils.isNotBlank((CharSequence)d.getMateriel()) && !MapUtils.isEmpty((Map)giftMaterielUdcMap)) {
                        d.setMaterielName((String)giftMaterielUdcMap.get(d.getMateriel()));
                    }
                    if (StringUtils.isNotBlank((CharSequence)d.getType()) && !MapUtils.isEmpty((Map)giftTypeUdcMap)) {
                        d.setTypeName((String)giftTypeUdcMap.get(d.getType()));
                    }
                });
            }
        });
    }

    public MktDiscountGiftServiceImpl(OrgEmpRpcService orgEmpRpcService, RmiSysNextNumberService rmiSysNextNumberService, BipCompanyManageService bipCompanyManageService, MktDiscountGiftRepo mktDiscountGiftRepo, MktDiscountGiftDRepo mktDiscountGiftDRepo, MktGiftRepo mktGiftRepo, BipItemSkuRepo bipItemSkuRepo, MktGiftRepoProc mktGiftRepoProc, MktDiscountGiftRepoProc mktDiscountGiftRepoProc, MktDiscountOffsetRepoProc mktDiscountOffsetRepoProc) {
        this.orgEmpRpcService = orgEmpRpcService;
        this.rmiSysNextNumberService = rmiSysNextNumberService;
        this.bipCompanyManageService = bipCompanyManageService;
        this.mktDiscountGiftRepo = mktDiscountGiftRepo;
        this.mktDiscountGiftDRepo = mktDiscountGiftDRepo;
        this.mktGiftRepo = mktGiftRepo;
        this.bipItemSkuRepo = bipItemSkuRepo;
        this.mktGiftRepoProc = mktGiftRepoProc;
        this.mktDiscountGiftRepoProc = mktDiscountGiftRepoProc;
        this.mktDiscountOffsetRepoProc = mktDiscountOffsetRepoProc;
    }
}

