/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.workflow.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSONObject;
import com.el.coordinator.core.common.exception.BusinessException;
import com.elitescloud.cloudt.system.param.SysUserIdFlowRoleRpcParam;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.yst.production.sale.api.service.shop.BipOrderBackService;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipOrderBackSaveVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.convert.shop.BipOrderBackConvert;
import com.elitesland.yst.production.sale.entity.BipOrderBackDO;
import com.elitesland.yst.production.sale.entity.QBipOrderBackDO;
import com.elitesland.yst.production.sale.repo.shop.BipOrderBackRepo;
import com.elitesland.yst.production.sale.repo.shop.BipOrderBackRepoProc;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysUserFlowRoleRpcService;
import com.elitesland.yst.production.sale.workflow.service.BipOrderBackProcessService;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class BipOrderBackProcessServiceImpl
implements BipOrderBackProcessService {
    private static final Logger log = LoggerFactory.getLogger(BipOrderBackProcessServiceImpl.class);
    private final JPAQueryFactory jpaQueryFactory;
    private final BipOrderBackRepo bipOrderBackRepo;
    private final BipOrderBackService bipOrderBackService;
    private final BipOrderBackRepoProc bipOrderBackRepoProc;
    private final RmiSysUserFlowRoleRpcService rmiSysUserFlowRoleRpcService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void processStatusChange(long id, ProcInstStatus procInstStatus) {
        BipOrderBackSaveVO orderBackSaveVO;
        BipOrderBackConvert backConvert;
        Optional bipOrderBackDO = this.bipOrderBackRepo.findById(id);
        if (!bipOrderBackDO.isPresent()) {
            throw new BusinessException("\u5355\u636e(id:" + id + ")\u4e0d\u5b58\u5728,\u65e0\u6cd5\u5ba1\u6279");
        }
        QBipOrderBackDO qBipOrderBackDO = QBipOrderBackDO.bipOrderBackDO;
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)qBipOrderBackDO).set(qBipOrderBackDO.procInstStatus, (Object)procInstStatus).where(new Predicate[]{qBipOrderBackDO.id.eq((Object)id)});
        switch (procInstStatus) {
            case NOTSUBMIT: {
                jpaUpdateClause.set((Path)qBipOrderBackDO.status, (Object)UdcEnum.SAL_RSO_STATUS_DR.getValueCode());
                break;
            }
            case INTERRUPT: {
                jpaUpdateClause.set((Path)qBipOrderBackDO.status, (Object)UdcEnum.SAL_RSO_STATUS_REJECTED.getValueCode());
                break;
            }
            case REJECTED: {
                jpaUpdateClause.set((Path)qBipOrderBackDO.status, (Object)UdcEnum.SAL_RSO_STATUS_REJECTED.getValueCode());
                break;
            }
            case INVALID: {
                jpaUpdateClause.set((Path)qBipOrderBackDO.status, (Object)UdcEnum.SAL_RSO_STATUS_CL.getValueCode());
                break;
            }
            case APPROVING: {
                jpaUpdateClause.set((Path)qBipOrderBackDO.status, (Object)UdcEnum.SAL_RSO_STATUS_APPING.getValueCode());
                break;
            }
            case APPROVED: {
                if (ObjectUtils.isEmpty((Object)((BipOrderBackDO)bipOrderBackDO.get()).getBackType())) break;
                if (UdcEnum.SO_BACK_TYPE_10.getValueCode().equals(((BipOrderBackDO)bipOrderBackDO.get()).getBackType())) {
                    jpaUpdateClause.set((Path)qBipOrderBackDO.status, (Object)UdcEnum.SAL_RSO_STATUS_WH.getValueCode()).set(qBipOrderBackDO.approvedTime, (Object)LocalDateTime.now());
                    break;
                }
                if (!UdcEnum.SO_BACK_TYPE_20.getValueCode().equals(((BipOrderBackDO)bipOrderBackDO.get()).getBackType())) break;
                jpaUpdateClause.set((Path)qBipOrderBackDO.status, (Object)UdcEnum.SAL_RSO_STATUS_WK.getValueCode()).set(qBipOrderBackDO.approvedTime, (Object)LocalDateTime.now());
            }
        }
        jpaUpdateClause.execute();
        Optional bipOrderBackDO1 = this.bipOrderBackRepo.findById(id);
        if (procInstStatus.equals((Object)ProcInstStatus.APPROVED)) {
            backConvert = BipOrderBackConvert.INSTANCE;
            orderBackSaveVO = backConvert.doToSave((BipOrderBackDO)bipOrderBackDO1.get());
            if (UdcEnum.SO_BACK_TYPE_10.getValueCode().equals(((BipOrderBackDO)bipOrderBackDO.get()).getBackType())) {
                orderBackSaveVO.setStatus(UdcEnum.SAL_RSO_STATUS_WH.getValueCode());
            } else if (UdcEnum.SO_BACK_TYPE_20.getValueCode().equals(((BipOrderBackDO)bipOrderBackDO.get()).getBackType())) {
                orderBackSaveVO.setStatus(UdcEnum.SAL_RSO_STATUS_WK.getValueCode());
            }
            this.bipOrderBackService.updateCheckStatus(orderBackSaveVO);
        }
        if (procInstStatus.equals((Object)ProcInstStatus.REJECTED) || procInstStatus.equals((Object)ProcInstStatus.INTERRUPT)) {
            backConvert = BipOrderBackConvert.INSTANCE;
            orderBackSaveVO = backConvert.doToSave((BipOrderBackDO)bipOrderBackDO1.get());
            orderBackSaveVO.setStatus(UdcEnum.SAL_RSO_STATUS_REJECTED.getValueCode());
            this.bipOrderBackService.updateCheckStatus(orderBackSaveVO);
        }
    }

    @Override
    public List<String> taskAssignee(Long businessKey, String customParams) {
        log.info("\u901a\u8fc7ouId,\u81ea\u5b9a\u4e49\u53c2\u6570\u83b7\u53d6\u7528\u6237\u5217\u8868\uff0c\u65f6\u95f4:{},\u5165\u53c2:{}", (Object)LocalDateTime.now(), (Object)businessKey);
        log.info("(B\u7aef\u9000\u8d27\u5de5\u4f5c\u6d41)\u5165\u53c2", (Object)JSONObject.toJSONString((Object)customParams));
        Long ouId = this.bipOrderBackRepoProc.getOuIdById((long)businessKey);
        log.info("(B\u7aef\u9000\u8d27\u5de5\u4f5c\u6d41)\u5165\u53c22", (Object)JSONObject.toJSONString((Object)ouId));
        try {
            SysUserIdFlowRoleRpcParam sysUserIdFlowRoleRpcParam = new SysUserIdFlowRoleRpcParam();
            sysUserIdFlowRoleRpcParam.setOuIds(Collections.singletonList(ouId));
            List<String> flowRoleCodes = Arrays.asList(customParams.split(","));
            sysUserIdFlowRoleRpcParam.setFlowRoleCodes(flowRoleCodes);
            log.info("\u516c\u53f8\u89d2\u8272\u67e5\u8be2\u4fe1\u606f(B\u7aef\u9000\u8d27){}", (Object)JSONObject.toJSONString((Object)sysUserIdFlowRoleRpcParam));
            List userIdsByFlowRoles = this.rmiSysUserFlowRoleRpcService.findUserIdsByFlowRoles(sysUserIdFlowRoleRpcParam).stream().filter(Objects::nonNull).collect(Collectors.toList());
            log.info("\u516c\u53f8\u89d2\u8272\u67e5\u8be2\u4fe1\u606f\u8fd4\u56de\u7ed3\u679c(B\u7aef\u9000\u8d27){}", (Object)JSONObject.toJSONString(userIdsByFlowRoles));
            List userIds = userIdsByFlowRoles.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(userIds)) {
                return CollUtil.newArrayList(userIds);
            }
        }
        catch (Exception e) {
            log.error("findUserIdsByFlowRoles error:", (Throwable)e);
            throw new BusinessException("\u8c03\u7528\u652f\u6491\u57df\u67e5\u8be2\u5ba1\u6279\u89d2\u8272\u5bf9\u5e94\u5ba1\u6279\u4eba\u5f02\u5e38" + e, (Throwable)e);
        }
        return null;
    }

    public BipOrderBackProcessServiceImpl(JPAQueryFactory jpaQueryFactory, BipOrderBackRepo bipOrderBackRepo, BipOrderBackService bipOrderBackService, BipOrderBackRepoProc bipOrderBackRepoProc, RmiSysUserFlowRoleRpcService rmiSysUserFlowRoleRpcService) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.bipOrderBackRepo = bipOrderBackRepo;
        this.bipOrderBackService = bipOrderBackService;
        this.bipOrderBackRepoProc = bipOrderBackRepoProc;
        this.rmiSysUserFlowRoleRpcService = rmiSysUserFlowRoleRpcService;
    }
}

