package com.elitesland.yst.production.sale.config;

import com.elitescloud.cloudt.authorization.api.client.config.AuthorizationProperties;
import com.elitescloud.cloudt.authorization.sdk.config.AuthorizationSdkProperties;
import com.elitesland.yst.production.sale.config.cas.UserSourceService;
import com.elitesland.yst.production.sale.config.cas.support.CustomUserDetailManager;
import com.elitesland.yst.production.sale.config.cas.support.UserSyncProvider;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 认证相关配置.
 *
 * @author Kaiser（wang shao）
 * @date 2022/12/29
 */
@Configuration(proxyBeanMethods = false)
@ConditionalOnProperty(prefix = AuthorizationSdkProperties.CONFIG_PREFIX + ".cas-client", name = "enabled", havingValue = "true")
@Log4j2
public class AuthConfig implements InitializingBean {
    private final AuthorizationSdkProperties sdkProperties;
    private final AuthorizationProperties authorizationProperties;

    private UserSourceService userSourceService;

    public AuthConfig(AuthorizationSdkProperties sdkProperties,
                      AuthorizationProperties authorizationProperties) {
        this.sdkProperties = sdkProperties;
        this.authorizationProperties = authorizationProperties;
    }

    @Bean
    public UserSyncProvider userSyncProvider() {
        return new UserSyncProvider(userSourceService);
    }

//    @Bean
    public CustomUserDetailManager customUserDetailManager() {
        return new CustomUserDetailManager(authorizationProperties, userSourceService);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        if (userSourceService == null) {
            log.error("统一身份认证异常，缺少服务{}实现类", UserSourceService.class.getName());
        }
    }

    @Autowired(required = false)
    public void setUserSourceService(UserSourceService userSourceService) {
        this.userSourceService = userSourceService;
    }
}
