package com.elitesland.yst.production.sale.controller.crm.app;

import com.elitesland.yst.production.sale.api.service.shop.BipCrmCustService;
import com.elitesland.yst.production.sale.api.service.shop.BipCustUserBindService;
import com.elitesland.yst.production.sale.api.vo.param.com.SmsVerifyCodeParamVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipCrmCustInfoVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipCrmCustSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipCustUserBindSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipCustUserRegisterSaveVO;
import com.elitesland.yst.production.sale.controller.BaseController;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021/08/30
 */
@Api(tags = "客户信息管理（app）")
@ApiSupport(author = "Kaiser（wang shao）")
@RestController
@RequestMapping(value = "/bip/app/cust", produces = MediaType.APPLICATION_JSON_VALUE)
@RequiredArgsConstructor
public class CrmCustAppController extends BaseController {

    private final BipCustUserBindService bipCustUserBindService;

    private final BipCrmCustService bipCrmCustService;

    @ApiOperation(value = "用户注册")
    @ApiOperationSupport(order = 1)
    @PostMapping(value = "/register/mobile")
    public ApiResult<Long> registerByMobile(@RequestBody @Valid BipCustUserRegisterSaveVO saveVO) {
        return bipCustUserBindService.saveRegister(saveVO);
    }

    @ApiOperation(value = "发送手机验证码（绑定企业时）")
    @ApiOperationSupport(order = 2)
    @PostMapping(value = "/bindUser/sendVerifyCode")
    public ApiResult<Boolean> sendSmsVerifyCode(@RequestBody @Valid SmsVerifyCodeParamVO paramVO) {
        return bipCustUserBindService.sendSmsVerifyCodeForBind(paramVO);
    }

    @ApiOperation(value = "用户绑定公司")
    @ApiOperationSupport(order = 3)
    @PostMapping(value = "/bindUser")
    public ApiResult<Long> saveBind(@RequestBody @Valid BipCustUserBindSaveVO saveVO) {
        return bipCustUserBindService.saveBind(saveVO);
    }

    @ApiOperation(value = "账户信息")
    @ApiOperationSupport(order = 4)
    @PostMapping(value = "/info")
    public ApiResult<BipCrmCustInfoVO> searchInfoCurrent() {
        return bipCrmCustService.searchInfoCurrent();
    }

    @ApiOperation(value = "更新账户信息")
    @ApiOperationSupport(order = 5)
    @PutMapping(value = "/update")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "param", value = "更新参数", required = true, dataType = "BipCrmCustSaveVO")
    })
    public ApiResult<Object> updateCurrent(@RequestBody BipCrmCustSaveVO param) {
        bipCrmCustService.updateCurrent(param);
        return ApiResult.ok();
    }

    @GetMapping("/checkCustUserBindInfo")
    @ApiOperation("校验当前登陆用户绑定状态。返回值：( 200:用户状态正常。 201:请绑定公司信息。  202:您的账号已冻结，请联系业务员。 203:请等待审核完成后下单或联系业务员。  204:请重新绑定公司信息。) ")
    @ApiOperationSupport(order = 6)
    public ApiResult<Object> checkCustUserBindInfo() {
        return ApiResult.ok(bipCustUserBindService.checkCustUserBindInfo());
    }

}
