package com.elitesland.yst.production.sale.controller.logistics;

import com.elitesland.yst.production.sale.api.service.LogisticsTemplateDService;
import com.elitesland.yst.production.sale.api.vo.param.logistics.LogisticsTemplateDFindParam;
import com.elitesland.yst.production.sale.api.vo.param.logistics.LogisticsTemplateDetailParam;
import com.elitesland.yst.production.sale.api.vo.param.logistics.LogisticsTemplateDetailSaveParam;
import com.elitesland.yst.production.sale.api.vo.resp.logistics.LogisticsTemplateDVO;
import com.elitesland.yst.production.sale.controller.BaseController;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;


/**
 * 运费模板
 */
@RestController
@RequestMapping(value = "/logisticsdetail/conf", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(tags = "运费模板明细")
@RequiredArgsConstructor
public class LogisticsTemplateDetailController extends BaseController {

    private final LogisticsTemplateDService logisticsTemplateDService;

    @PostMapping(value = "/pageList")
    @ApiOperation(value = "运费模板列表分页")
    @ApiOperationSupport(order = 1)
    public ApiResult<PagingVO<LogisticsTemplateDVO>> findPagingDetailResult(@RequestBody LogisticsTemplateDetailParam param){
        PagingVO<LogisticsTemplateDVO> list = logisticsTemplateDService.findPagingDetailResult(param);
        return ApiResult.ok(list);
    }


    @PostMapping(value = "/saveDetail")
    @ApiOperation(value = "新增/修改明细")
    @ApiOperationSupport(order = 1)
    public ApiResult<Object> saveDetail(@RequestBody List<LogisticsTemplateDetailSaveParam> params){
        return logisticsTemplateDService.saveDetail(params);
    }


    @PostMapping(value = "/delDetail")
    @ApiOperation(value = "删除明细")
    @ApiOperationSupport(order = 1)
    public ApiResult<Object> delDetail(@RequestBody List<Long> ids){
        return logisticsTemplateDService.delDetail(ids);
    }


    @PostMapping(value = "/getByArea")
    @ApiOperation(value = "通过区域查询明细")
    @ApiOperationSupport(order = 1)
    public List<LogisticsTemplateDVO> getByArea(@RequestBody LogisticsTemplateDFindParam param){
        return logisticsTemplateDService.getByArea(param);
    }

}
