package com.elitesland.yst.production.sale.controller.shop;

import com.elitesland.yst.production.sale.api.service.shop.BipOrderDService;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipOrderDParmVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipOrderDRespVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipOrderDSaveVO;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/08/20/10:15
 * @Description:
 */
@RestController
@RequestMapping(value = "/bip/orderD")
@Api(value = "订单详情",tags = "订单详情")
@Slf4j
public class BipOrderDController {

    @Autowired
    private BipOrderDService bipOrderDService;

    @PostMapping("/page/search")
    @ApiOperation("分页查询")
    @ApiOperationSupport(order = 1)
    public ApiResult<PagingVO<BipOrderDRespVO>> findPageOrderD(BipOrderDParmVO bipOrderDParmVO){
        return ApiResult.ok(bipOrderDService.findPageOrderD(bipOrderDParmVO)) ;

    }

    @PostMapping("/find")
    @ApiOperation("订单查询")
    @ApiOperationSupport(order = 2)
    public ApiResult<List<BipOrderDRespVO>> findOrderD(@RequestBody BipOrderDParmVO bipOrderParmDVO){
        List<BipOrderDRespVO> list=bipOrderDService.findOrderD(bipOrderParmDVO);
        return ApiResult.ok(list);
    }


    @PostMapping("/find/id")
    @ApiOperation("订单查询---通过id")
    @ApiOperationSupport(order = 3)
    public ApiResult<List<BipOrderDRespVO>> findOrderById(List<Long> ids){
        List<BipOrderDRespVO> list=bipOrderDService.findOrderById(ids);
        return ApiResult.ok(list);
    }



    @PostMapping("/update")
    @ApiOperation("订单明细更新")
    @ApiOperationSupport(order = 4)
    public ApiResult updateOrder(@RequestBody  List<BipOrderDSaveVO> bipOrderDos){
        bipOrderDService.updateOrder(bipOrderDos);
        return ApiResult.ok();
    }


    @PostMapping("/delete/ids")
    @ApiOperation("订单明细删除---通过id")
    @ApiOperationSupport(order = 5)
    public ApiResult deleteOrderByIds(@RequestBody List<Long> ids){
        bipOrderDService.deleteOrderDByIds(ids);
        return ApiResult.ok();
    }

    @PostMapping("/delete/id")
    @ApiOperation("订单明细删除")
    @ApiOperationSupport(order = 6)
    public ApiResult deleteOrder(@RequestBody Long id){

        bipOrderDService.deleteOrderDById(id);
        return ApiResult.ok();
    }

}
