package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/08/04/14:32
 * @Description:购物车
 */

@Entity
@Table(name = "bip_cart")
@org.hibernate.annotations.Table(appliesTo = "bip_cart", comment = "购物车")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")

public class BipCartDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = -538725400407981401L;

    @Column(name = "sku_id", columnDefinition = "bigInt(20)   comment 'skuId'")
    private Long skuId;

    @Column(name = "item_id", columnDefinition = "bigInt(20)   comment '商品id'")
    private Long itemId;

    @Column(name = "item_code", columnDefinition = "varchar(20)   comment '商品编码'")
    private String itemCode;

    @Column(name = "sku_code", columnDefinition = "varchar(20)   comment '商品SKU编码'")
    private String skuCode;

    @Column(name = "user_id", columnDefinition = "bigInt(20)   comment '账号id'")
    private Long userId;

    @Column(name = "item_num", columnDefinition = "bigInt(20)   comment '数量'")
    private Long itemNum;

    @Column(name = "put_amt", columnDefinition = "decimal(20,2)   comment '加入时价格'")
    private BigDecimal putAmt;

    @Column(name = "is_enabled", columnDefinition = "varchar(20)   comment '是否选中'")
    private String isEabled;

    @Column(name = "stock_enough", columnDefinition = "tinyint(1) default 0  comment '添加到购物车时，库存是否充足,true:足够，false：不足'")
    private Boolean stockEnough;

    @Column(name = "first_item_flag", columnDefinition = "tinyint(1) default 0  comment '是否首单商品 true是  false不是'")
    private Boolean firstItemFlag;

    @Column(name = "price_type", columnDefinition = "varchar(40) comment '价格类型 [UDC]PRI:SALE_PRICE_TYPE'")
    private String priceType;

}
