package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * b2b小程序首页菜单详情
 */
@Entity
@Table(name = "bus_first_menu_conf_d")
@org.hibernate.annotations.Table(appliesTo = "bus_first_menu_conf_d", comment = "b2b小程序首页菜单详情")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class BusFirstMenuConfDDO extends BaseModel implements Serializable {

    @ApiModelProperty("菜单ID")
    @Column(name = "menu_id", columnDefinition = "bigint(18)  comment '菜单ID'")
    private Long menuId;

    @ApiModelProperty("所属公司")
    @Column(name = "ou_id", columnDefinition = "bigint(18)  comment '所属公司'")
    private Long ouId;

    @ApiModelProperty("所属公司名称")
    @Column(name = "ou_name", columnDefinition = "varchar(256)  comment '所属公司名称'")
    private String ouName;

    @ApiModelProperty("商品id")
    @Column(name = "item_id", columnDefinition = "bigint(18)  comment '商品ID'")
    private Long itemId;

    @ApiModelProperty("商品名称")
    @Column(name = "item_name", columnDefinition = "varchar(256)  comment '商品名称'")
    private String itemName;


    @ApiModelProperty("商品编码")
    @Column(name = "item_code", columnDefinition = "varchar(64)  comment '商品编码'")
    private String itemCode;


    @ApiModelProperty("商品规格")
    @Column(name = "item_attr", columnDefinition = "varchar(64)  comment '商品规格'")
    private String itemAttr;


    @ApiModelProperty("商品条码")
    @Column(name = "barcode", columnDefinition = "varchar(64)  comment '商品条码'")
    private String barcode;


    @ApiModelProperty("品牌")
    @Column(name = "item_brand", columnDefinition = "varchar(64)  comment '品牌'")
    private String itemBrand;

    @ApiModelProperty("排序")
    @Column(name = "sort", columnDefinition = "int(10) comment '排序'")
    private Integer sort;

    @ApiModelProperty("商品状态")
    @Column(name = "state", columnDefinition = "varchar(64) comment '商品状态'")
    private String state;

    @ApiModelProperty("商品分类")
    @Column(name = "category_name", columnDefinition = "varchar(64) default '' comment '商品分类'")
    private String categoryName;

}
