package com.elitesland.yst.production.sale.repo;

import com.elitesland.yst.production.sale.api.vo.param.logistics.LogisticsTemplateParam;
import com.elitesland.yst.production.sale.api.vo.resp.logistics.LogisticsTemplateVO;
import com.elitesland.yst.production.sale.api.vo.resp.menu.BusFirstMenuConfVO;
import com.elitesland.yst.production.sale.entity.QLogisticsTemplateDO;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.security.util.DataAuthJpaUtil;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import jodd.util.StringUtil;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.List;

@Component
@RequiredArgsConstructor
public class LogisticsTemplateRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private final QLogisticsTemplateDO qLogisticsTemplateDO = QLogisticsTemplateDO.logisticsTemplateDO;

    public PagingVO<LogisticsTemplateVO> findPagingResult(LogisticsTemplateParam param){
        JPAQuery<LogisticsTemplateVO> query = selectFromWhere(LogisticsTemplateVO.class,param);
        param.setPaging(query);
        param.fillOrders(query,qLogisticsTemplateDO);
        return PagingVO.<LogisticsTemplateVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }

    private <T> JPAQuery<T> selectFromWhere(Class<T> cls, LogisticsTemplateParam param){
        return jpaQueryFactory.select(Projections.bean(cls,
                qLogisticsTemplateDO.id,
                qLogisticsTemplateDO.logisticsCode,
                qLogisticsTemplateDO.logisticsName,
                qLogisticsTemplateDO.provinceName,
                qLogisticsTemplateDO.provinceCode,
                qLogisticsTemplateDO.cityName,
                qLogisticsTemplateDO.cityCode,
                qLogisticsTemplateDO.countyName,
                qLogisticsTemplateDO.countyCode,
                qLogisticsTemplateDO.status,
                qLogisticsTemplateDO.logisticDesc,
                qLogisticsTemplateDO.modifyTime,
                qLogisticsTemplateDO.createTime,
                qLogisticsTemplateDO.createUserId,
                qLogisticsTemplateDO.ouId,
                qLogisticsTemplateDO.ouName,
                qLogisticsTemplateDO.creator,
                qLogisticsTemplateDO.remark)).from(qLogisticsTemplateDO).where(where(param));
    }

    public Predicate where(LogisticsTemplateParam param){
        List<Predicate> predicate = new ArrayList<>();
        if(null != param.getOuId()){
            predicate.add(qLogisticsTemplateDO.ouId.eq(param.getOuId()));
        }else {
            predicate.add(DataAuthJpaUtil.dataAuthJpaPredicate(qLogisticsTemplateDO.getMetadata()));
        }
        if(StringUtil.isNotBlank(param.getLogisticsCode())){
            predicate.add(qLogisticsTemplateDO.logisticsCode.like("%" + param.getLogisticsCode() + "%"));
        }
        if(StringUtil.isNotBlank(param.getLogisticsName())){
            predicate.add(qLogisticsTemplateDO.logisticsName.like("%" + param.getLogisticsName() + "%"));
        }
        if(StringUtil.isNotBlank(param.getCityCode())){
            predicate.add(qLogisticsTemplateDO.cityCode.eq(param.getCityCode()));
        }
        if(StringUtil.isNotBlank(param.getStatus())){
            predicate.add(qLogisticsTemplateDO.status.eq(param.getStatus()));
        }
        predicate.add(qLogisticsTemplateDO.deleteFlag.isNull().or(qLogisticsTemplateDO.deleteFlag.eq(0)));
        return ExpressionUtils.allOf(predicate);
    }

}
