package com.elitesland.yst.production.sale.repo;

import com.elitesland.yst.production.sale.entity.SaleStatisticsDealerDtlDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;
import java.util.List;


/**
 * @author : WWW
 * @date : 2023-6-1
 * @desc : 销售业绩统计-经销商-明细Repo
 */

@Repository
public interface SaleStatisticsDealerDtlRepo extends JpaRepository<SaleStatisticsDealerDtlDO, Long>, QuerydslPredicateExecutor<SaleStatisticsDealerDtlDO> {

    /**
     * 根据主表ID删除明细
     *
     * @param masId 主表ID
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    void deleteByMasId(Long masId);

    /**
     * 根据主表ID批量删除明细
     *
     * @param masIds 主表ID
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    void deleteByMasIdIn(List<Long> masIds);

    @Transactional
    @Modifying
    @Query(value = "delete from sale_statistics_dealer_dtl where mas_id in ( select id from sale_statistics_dealer where doc_time between ?1 and ?2)", nativeQuery = true)
    void deleteByDocTime(LocalDateTime startTime, LocalDateTime endTime);
}

