package com.elitesland.yst.production.sale.repo.shop;

import com.elitesland.yst.production.sale.entity.BipFavoritesDo;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/08/08/9:02
 * @Description:
 */
public interface BipFavoritesRepo  extends JpaRepository<BipFavoritesDo, Long>, QuerydslPredicateExecutor<BipFavoritesDo> {

    @Transactional//事务的注解
    @Modifying//增删改必须有这个注解
    @Query(value = "delete from bip_favorites where cust_account_id = ?1 and item_id in ?2", nativeQuery = true)
    void deleteBipFavorites(Long accountId, List<Long> itemIds);
}
