package com.elitesland.yst.production.sale.repo.shop;

import com.elitesland.yst.production.sale.entity.BipOrderDDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/08/08/9:02
 * @Description:
 */
public interface BipOrderDRepo  extends JpaRepository<BipOrderDDO, Long>, QuerydslPredicateExecutor<BipOrderDDO>, JpaSpecificationExecutor<BipOrderDDO> {

    @Transactional//事务的注解
    @Modifying//增删改必须有这个注解
    @Query(value = "update bip_order_d set delete_flag = 1 where id in ?1", nativeQuery = true)
    public void deleteOrderDByIds(List<Long> ids);


    @Transactional//事务的注解
    @Modifying//增删改必须有这个注解
    @Query(value = "update bip_order_d set delete_flag = 1 where order_id in ?1", nativeQuery = true)
    public void deleteOrderDByOrderIds(List<Long> ids);


    @Transactional//事务的注解
    @Modifying//增删改必须有这个注解
    @Query(value = "update bip_order_d set delete_flag = 1 where id = ?1", nativeQuery = true)
    public void deleteOrderDByOrderId(Long id);


    @Transactional//事务的注解
    @Modifying//增删改必须有这个注解
    @Query(value = "update bip_order_d set status = ?1 where order__id in ?2 and status=?2", nativeQuery = true)
    void updateOrderDByOrderIds(List<Long> ids,String status);


    List<BipOrderDDO> findByOrderId(Long id);


    List<BipOrderDDO> findByOrderDocNo(String docNo);

    List<BipOrderDDO> findByIdIn(List<Long> ids);

}
