package com.elitesland.yst.production.sale.rmi.ystsystem;

import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.system.dto.SysEmployeeBasicDTO;
import com.elitescloud.cloudt.system.dto.req.EmployeePageQueryDTO;
import com.elitescloud.cloudt.system.dto.req.EmployeeQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.EmployeePageRespDTO;
import com.elitescloud.cloudt.system.dto.resp.EmployeeUnderlingDTO;
import com.elitescloud.cloudt.system.provider.org.EmployeeRpcService;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/04/17
 * @Version 1.0
 * @Content:
 */
@Component
@Slf4j
public class RmiEmployeeRpcService {
    @Autowired
    private EmployeeRpcService employeeRpcService;


    /**
     * 根据员工ID获取员工信息
     *
     * @param id 员工ID
     * @return 员工信息
     */
    public SysEmployeeBasicDTO findEmployeeById(Long id) {
        log.info("调用system域:根据员工ID获取员工信息,时间：{},入参：{}", LocalDateTime.now(), id);
        try {
            if (Objects.isNull(id)) {
                return null;
            }
            ApiResult<SysEmployeeBasicDTO> apiResult = employeeRpcService.getById(id);
            log.info("调用system域:根据员工ID获取员工信息,时间：{},出参：{}", LocalDateTime.now(), apiResult);
            if (apiResult.isSuccess()) {
                return apiResult.getData();
            } else {
                throw new BusinessException(ApiCode.FAIL, apiResult.getMsg());
            }
        } catch (Exception e) {
            log.error("调用system域:根据员工ID获取员工信息,error：{}", e.getMessage());
            throw new BusinessException("调用system域:" + e.getMessage());
        }
    }

    /**
     * 根据员工ID批量获取员工信息
     *
     * @param ids 员工ID
     * @return 员工信息列表
     */
    public List<SysEmployeeBasicDTO> findEmployeeByIds(Set<Long> ids) {
        log.info("调用system域:根据员工ID批量获取员工信息,时间：{},入参：{}", LocalDateTime.now(), ids);
        try {
            if (CollectionUtils.isEmpty(ids)) {
                return Collections.emptyList();
            }
            EmployeeQueryDTO queryDTO = new EmployeeQueryDTO();
            queryDTO.setIds(ids);
            ApiResult<List<SysEmployeeBasicDTO>> apiResult = employeeRpcService.queryList(queryDTO);
            log.info("调用system域:根据员工ID批量获取员工信息,时间：{},出参：{}", LocalDateTime.now(), apiResult);
            if (apiResult.isSuccess()) {
                return apiResult.getData();
            } else {
                throw new BusinessException(ApiCode.FAIL, apiResult.getMsg());
            }
        } catch (Exception e) {
            log.error("调用system域:根据员工ID批量获取员工信息,error：{}", e.getMessage());
            throw new BusinessException("调用system域:" + e.getMessage());
        }
    }

    /**
     * 根据员工编码获取员工信息
     *
     * @param code 员工编码
     * @return 员工信息
     */
    public SysEmployeeBasicDTO findEmployeeByCode(String code) {
        log.info("调用system域:根据员工编码获取员工信息,时间：{},入参：{}", LocalDateTime.now(), code);
        try {
            if (StringUtils.isBlank(code)) {
                return null;
            }
            ApiResult<SysEmployeeBasicDTO> apiResult = employeeRpcService.getByCode(code);
            log.info("调用system域:根据员工编码获取员工信息,时间：{},出参：{}", LocalDateTime.now(), apiResult);
            if (apiResult.isSuccess()) {
                return apiResult.getData();
            } else {
                throw new BusinessException(ApiCode.FAIL, apiResult.getMsg());
            }
        } catch (Exception e) {
            log.error("调用system域:根据员工编码获取员工信息,error：{}", e.getMessage());
            throw new BusinessException("调用system域:" + e.getMessage());
        }
    }

    /**
     * 根据员工编码批量获取员工信息
     *
     * @param codes 员工编码
     * @return 员工信息列表
     */
    public List<SysEmployeeBasicDTO> findEmployeeByCodes(Set<String> codes) {
        log.info("调用system域:根据员工编码批量获取员工信息,时间：{},入参：{}", LocalDateTime.now(), codes);
        try {
            if (CollectionUtils.isEmpty(codes)) {
                return Collections.emptyList();
            }
            EmployeeQueryDTO queryDTO = new EmployeeQueryDTO();
            queryDTO.setCodes(codes);
            ApiResult<List<SysEmployeeBasicDTO>> apiResult = employeeRpcService.queryList(queryDTO);
            log.info("调用system域:根据员工编码批量获取员工信息,时间：{},出参：{}", LocalDateTime.now(), apiResult);
            if (apiResult.isSuccess()) {
                return apiResult.getData();
            } else {
                throw new BusinessException(ApiCode.FAIL, apiResult.getMsg());
            }
        } catch (Exception e) {
            log.error("调用system域:根据员工编码批量获取员工信息,error：{}", e.getMessage());
            throw new BusinessException("调用system域:" + e.getMessage());
        }
    }

    /**
     * 根据用户ID获取所属员工
     *
     * @param userId 用户ID
     * @return 员工信息
     */
    public SysEmployeeBasicDTO findEmployeeByUserId(Long userId) {
        log.info("调用system域:根据用户ID获取所属员工,时间：{},入参：{}", LocalDateTime.now(), userId);
        try {
            if (Objects.isNull(userId)) {
                return null;
            }
            ApiResult<SysEmployeeBasicDTO> apiResult = employeeRpcService.getByUserId(userId);
            log.info("调用system域:根据用户ID获取所属员工,时间：{},出参：{}", LocalDateTime.now(), apiResult);
            if (apiResult.isSuccess()) {
                return apiResult.getData();
            } else {
                throw new BusinessException(ApiCode.FAIL, apiResult.getMsg());
            }
        } catch (Exception e) {
            log.error("调用system域:根据用户ID获取所属员工,error：{}", e.getMessage());
            throw new BusinessException("调用system域:" + e.getMessage());
        }
    }

    /**
     * 获取下属员工
     *
     * @param code    员工编号
     * @param cascade 是否级联获取所有下属员工
     * @return 员工列表
     */
    public List<EmployeeUnderlingDTO> getUnderlingByCode(String code, Boolean cascade, Boolean enable) {
        log.info("调用system域:根据员工编号获取下属员工,时间：{},员工编号：{},是否级联获取所有下属员工：{}", LocalDateTime.now(), code, cascade);
        try {
            ApiResult<List<EmployeeUnderlingDTO>> apiResult = employeeRpcService.getUnderlingByCode(code, cascade, enable);
            log.info("调用system域:根据员工编号获取下属员工,时间：{},出参：{}", LocalDateTime.now(), apiResult);
            if (apiResult.isSuccess()) {
                return apiResult.getData();
            } else {
                throw new BusinessException(ApiCode.FAIL, apiResult.getMsg());
            }
        } catch (Exception e) {
            log.error("调用system域:根据员工编号获取下属员工,error：{}", e.getMessage());
            throw new BusinessException("调用system域:" + e.getMessage());
        }
    }

    /**
     * 查询员工列表
     *
     * @param queryDTO 查询参数
     * @return 员工列表
     */
    public List<SysEmployeeBasicDTO> queryList(EmployeeQueryDTO queryDTO) {
        log.info("调用system域:查询员工列表,时间：{},入参：{}", LocalDateTime.now(), queryDTO);
        try {
            ApiResult<List<SysEmployeeBasicDTO>> apiResult = employeeRpcService.queryList(queryDTO);
            log.info("调用system域:查询员工列表,时间：{},出参：{}", LocalDateTime.now(), apiResult);
            if (apiResult.isSuccess()) {
                return apiResult.getData();
            } else {
                throw new BusinessException(ApiCode.FAIL, apiResult.getMsg());
            }
        } catch (Exception e) {
            log.error("调用system域:查询员工列表,error：{}", e.getMessage());
            throw new BusinessException("调用system域:" + e.getMessage());
        }
    }


    /**
     * 根据账号获取员工信息
     *
     * @param username 登录账号
     * @return 员工信息
     */
    public SysEmployeeBasicDTO findEmployeeByUsername(String username) {
        log.info("调用system域:根据账号获取员工信息,时间：{},入参：{}", LocalDateTime.now(), username);
        try {
            if (StringUtils.isBlank(username)) {
                return null;
            }
            ApiResult<SysEmployeeBasicDTO> apiResult = employeeRpcService.getByUsername(username);
            log.info("调用system域:根据账号获取员工信息,时间：{},出参：{}", LocalDateTime.now(), apiResult);
            if (apiResult.isSuccess()) {
                return apiResult.getData();
            } else {
                throw new BusinessException(ApiCode.FAIL, apiResult.getMsg());
            }
        } catch (Exception e) {
            log.error("调用system域:根据账号获取员工信息,error：{}", e.getMessage());
            throw new BusinessException("调用system域:" + e.getMessage());
        }
    }

    /**
     * 根据员工全名获取员工信息
     *
     * @param fullName 员工全名
     * @return 员工信息
     */
    public List<EmployeePageRespDTO> findEmployeeByFullName(String fullName) {
        log.info("调用system域:根据员工全名获取员工信息,时间：{},入参：{}", LocalDateTime.now(), fullName);
        try {
            if (StringUtils.isBlank(fullName)) {
                return Collections.emptyList();
            }
            EmployeePageQueryDTO employeePageQueryDTO = new EmployeePageQueryDTO();
            employeePageQueryDTO.setType(UdcEnum.CUST_TYPE_SALESMAN.getValueCode());
            employeePageQueryDTO.setSize(1000);
            employeePageQueryDTO.setKeyword(fullName);

            ApiResult<PagingVO<EmployeePageRespDTO>> apiResult = employeeRpcService.queryByPage(employeePageQueryDTO);
            log.info("调用system域:根据员工全名获取员工信息,时间：{},出参：{}", LocalDateTime.now(), apiResult);
            if (apiResult.isSuccess()) {
                PagingVO<EmployeePageRespDTO> pagingVO = apiResult.getData();
                return pagingVO.getRecords();
            } else {
                throw new BusinessException(ApiCode.FAIL, apiResult.getMsg());
            }
        } catch (Exception e) {
            log.error("调用system域:根据员工全名获取员工信息,error：{}", e.getMessage());
            throw new BusinessException("调用system域:" + e.getMessage());
        }
    }

}
