package com.elitesland.yst.production.sale.service;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.SysOrgBasicDTO;
import com.elitescloud.cloudt.system.param.SysOrgQueryDTO;
import com.elitesland.yst.production.sale.api.service.CustBelongOuService;
import com.elitesland.yst.production.sale.api.vo.param.crm.CrmCustQueryLmParam;
import com.elitesland.yst.production.sale.api.vo.param.crm.CustSwitchStatusParamVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CustBelongOuVO;
import com.elitesland.yst.production.sale.convert.CustBelongOuConvert;
import com.elitesland.yst.production.sale.entity.CustAccountDO;

import com.elitesland.yst.production.sale.entity.CustBelongOuDO;

import com.elitesland.yst.production.sale.entity.QCustBelongOuDO;
import com.elitesland.yst.production.sale.repo.CustAccountRepoProc;
import com.elitesland.yst.production.sale.repo.CustBelongOuRepo;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgBuService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgOuService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysOrgService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysUserRpcService;
import com.elitesland.yst.production.support.provider.org.dto.OrgOuRpcDTO;
import com.google.common.collect.Lists;
import com.querydsl.core.types.dsl.BooleanExpression;
import lombok.extern.log4j.Log4j2;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

@Service
@Log4j2
public class CustBelongOuServiceImpl implements CustBelongOuService {

    @Autowired
    private CustBelongOuRepo custBelongOuRepo;

    @Autowired
    private RmiSysUserRpcService rmiSysUserRpcService;

    @Autowired
    private  RmiOrgOuService rmiOrgOuService;

    @Autowired
    private RmiSysOrgService rmiSysOrgService;

    @Override
    public List<CustBelongOuVO> getByCustCode(String custCode) {
        List<CustBelongOuVO> res = new ArrayList<>();
        QCustBelongOuDO qCustBelongOuDO = QCustBelongOuDO.custBelongOuDO;
        BooleanExpression e = qCustBelongOuDO.custCode.eq(custCode).and(qCustBelongOuDO.deleteFlag.eq(0));
        Iterable<CustBelongOuDO> iterables = custBelongOuRepo.findAll(e);
        Map<String, String> channelTypeUdc = rmiSysUserRpcService.sysUdcGetCodeMap("yst-supp", "CHANNEL_TYPE");
        Map<String, String> paymentTermUdc = rmiSysUserRpcService.sysUdcGetCodeMap("yst-sale", "PAYMENT_TERM");
        Map<String, String> ouTypeInnerUdc = rmiSysUserRpcService.sysUdcGetCodeMap("yst-supp", "OU_TYPE_INNER");
        if(!IterableUtils.isEmpty(iterables)){
            List<CustBelongOuDO> list = Lists.newArrayList(iterables);
            List<Long> ouIds = list.stream().map(CustBelongOuDO :: getOuId).collect(Collectors.toList());
            List<Long> buIds = list.stream().map(CustBelongOuDO :: getBuId).collect(Collectors.toList());
            ouIds.removeAll(Collections.singletonList(null));
            buIds.removeAll(Collections.singletonList(null));
            Map<Long,OrgOuRpcDTO> ouMap = new HashMap<>();
            Map<Long,SysOrgBasicDTO> buMap = new HashMap<>();
            if(!CollectionUtils.isEmpty(ouIds)){
                List<OrgOuRpcDTO> ouInfos = rmiOrgOuService.findOuDtoList(ouIds, null);
                ouMap = ouInfos.stream().collect(Collectors.toMap(OrgOuRpcDTO :: getId,t -> t,(t1 , t2) -> t1));
            }
            if(!CollectionUtils.isEmpty(buIds)){
                SysOrgQueryDTO sysOrgQueryDTO = new SysOrgQueryDTO();
                HashSet<Long> hashSet = new HashSet<>(buIds);
                sysOrgQueryDTO.setIds(hashSet);
                List<SysOrgBasicDTO> buInfos =  rmiSysOrgService.findOrgByParam(sysOrgQueryDTO);
//                List<OrgBuRpcDTO> buInfos = rmiOrgBuService.findBuDtoList(buIds, null);
                buMap = buInfos.stream().collect(Collectors.toMap(SysOrgBasicDTO :: getId,t -> t ,(t1,t2) -> t2 ));
            }
            Map<Long, OrgOuRpcDTO> finalOuMap = ouMap;
            Map<Long, SysOrgBasicDTO> finalBuMap = buMap;
            list.forEach(l ->{
                CustBelongOuVO v = CustBelongOuConvert.INSTANCE.doToVo(l);
                if(StringUtils.isNotBlank(v.getStatus()) && "0".equals(v.getStatus())){
                    v.setStatusName("启用");
                }else {
                    v.setStatusName("禁用");
                }
                if(!MapUtils.isEmpty(finalOuMap) && null != v.getOuId() && !ObjectUtils.isEmpty(finalOuMap.get(v.getOuId()))){
                    OrgOuRpcDTO orgOuRpcDTO = finalOuMap.get(v.getOuId());
                    v.setOuName(orgOuRpcDTO.getOuName());
                    v.setOuType(orgOuRpcDTO.getOuType());
                    v.setOuCode(orgOuRpcDTO.getOuCode());
                    if(!MapUtils.isEmpty(ouTypeInnerUdc) && !StringUtils.isEmpty(orgOuRpcDTO.getOuType())){
                        v.setOuTypeName(ouTypeInnerUdc.get(orgOuRpcDTO.getOuType()));
                    }
                }
                if(!MapUtils.isEmpty(finalBuMap) && null != l.getBuId() && !ObjectUtils.isEmpty(finalBuMap.get(v.getBuId()))){
                    v.setBuName(finalBuMap.get(v.getBuId()).getName());
                    v.setBuCode(finalBuMap.get(v.getBuId()).getCode());
                }
                if(!MapUtils.isEmpty(channelTypeUdc) && StringUtils.isNotBlank(l.getChannelType())){
                    v.setChannelTypeName(channelTypeUdc.get(v.getChannelType()));
                }
                if(!MapUtils.isEmpty(paymentTermUdc) && StringUtils.isNotBlank(v.getPaymentTerm())){
                    v.setPaymentTermName(paymentTermUdc.get(v.getPaymentTerm()));
                }
                res.add(v);
            });
        }
        if(CollectionUtils.isNotEmpty(res)){

        }
        return res;
    }
}