package com.elitesland.yst.production.sale.service;

import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.ReUtil;
import com.elitescloud.boot.auth.cas.model.AuthUserDTO;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.common.param.SysSendVerifyCodeVO;
import com.elitescloud.boot.core.base.SeqNumProvider;
import com.elitescloud.boot.core.support.verifycode.common.VerifyCodeManager;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.boot.provider.TenantDataIsolateProvider;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.provider.SysUserRpcService;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.yst.production.sale.Application;
import com.elitesland.yst.production.sale.api.service.CustAccountService;
import com.elitesland.yst.production.sale.api.service.DeCustAccountService;
import com.elitesland.yst.production.sale.api.service.common.DeAccountRoleService;
import com.elitesland.yst.production.sale.api.vo.param.com.DeAccountRoleParam;
import com.elitesland.yst.production.sale.api.vo.param.crm.CrmCustAccountParam;
import com.elitesland.yst.production.sale.api.vo.param.crm.CustAccountQueryParam;
import com.elitesland.yst.production.sale.api.vo.param.crm.CustUpdateVO;
import com.elitesland.yst.production.sale.api.vo.resp.com.DeAccountRoleVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CustAccountVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.RemarkCustPwdVO;
import com.elitesland.yst.production.sale.api.vo.save.CustAccountUpdateVO;
import com.elitesland.yst.production.sale.common.constant.ConstantsSale;
import com.elitesland.yst.production.sale.config.cas.CasUserClientHelper;
import com.elitesland.yst.production.sale.convert.CustAccountConvert;
import com.elitesland.yst.production.sale.entity.CustAccountDO;
import com.elitesland.yst.production.sale.repo.CustAccountRepo;
import com.elitesland.yst.production.sale.repo.CustAccountRepoProc;
import com.elitesland.yst.production.sale.repo.common.DeAccountRoleRepoProc;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysRoleService;
import jodd.util.StringUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.text.MessageFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2023/2/20 11:47
 */
@Service("lmCustAccountService")
@RequiredArgsConstructor
@Slf4j
public class DeCustAccountServiceImpl implements DeCustAccountService {

    private final CustAccountRepo custAccountRepo;

    private final CasUserClientHelper casUserClientHelper;

    private final CustAccountRepoProc custAccountRepoProc;

    private final DeAccountRoleService lmAcountRoleService;

    private final DeAccountRoleRepoProc deAccountRoleRepoProc;

    private final RmiSysRoleService rmiSysRoleService;

    private final CustAccountService custAccountService;

    private final RedisUtils redisClient;

    private final TenantDataIsolateProvider tenantDataIsolateProvider;

    private final TenantClientProvider tenantClientProvider;

    private final VerifyCodeManager verifyCodeManager;

    private final SeqNumProvider sysNumberRuleService;

    private final static String BUSINESS_TYPE_RETRIEVE_PWD = "yst_sale_retrieve_pwd";

    private final JdbcTemplate jdbcTemplate;

    @Autowired
    private SysUserRpcService sysUserRpcService;

    public static final String REG_MOBILE = "^(12[1-3]\\d{8})|[1][3-9]\\d{9}$|^([5|6|7|9])\\d{7}$|^[0][9]\\d{8}$|^[6]\\d{7}$";


    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long createUser(CrmCustAccountParam param) {
        // 拿到数据补充数据
        CustAccountDO custAccountDO = this.excuteAccountInfo(param);
        CustAccountVO custAccountVO = new CustAccountVO();
        if (Boolean.FALSE.equals(param.getCreateFlag())) {
//            List<CustAccountVO> byCustCodes = custAccountService.getByCustCodes(Collections.singletonList(param.getCustCode()));
            List<CustAccountVO> custAccounts = new ArrayList<>();
            List<String> dealerTypes = new ArrayList<>();
            if(StringUtil.isNotBlank(param.getSource())){
                if("CUST".equals(param.getSource())){
                    dealerTypes.add("ONE");
                    dealerTypes.add("TWO");
                    //老账号查询
//                    custAccounts = custAccountService.getByUserNameAndSource(Collections.singletonList(param.getOldUserName()),dealerTypes,param.getBusinessTypeCust());
                    custAccounts = custAccountService.getByCustCodesAndUserName(param.getCustCode(),param.getOldUserName(),dealerTypes);
                }
            }else {
                dealerTypes.add("STORE");
                custAccounts = custAccountService.getByUserNameAndSource(Collections.singletonList(param.getUserName()),dealerTypes,param.getBusinessTypeCust());
            }
            if (CollectionUtils.isEmpty(custAccounts)) {
                throw new BusinessException("未找到该账户信息");
            }
            custAccountVO = custAccounts.get(0);
            custAccountDO.setUserName(custAccountVO.getUserName());
            custAccountDO.setMobile(param.getMobile());
            custAccountDO.setId(custAccountVO.getId());
            custAccountDO.setUserId(custAccountVO.getUserId());
            custAccountDO.setIsModifyPwd(custAccountVO.getIsModifyPwd());
            custAccountDO.setBusinessTypeCust(param.getBusinessTypeCust());
//            if(StringUtil.isNotBlank(custAccountVO.getPwd())){
//                custAccountDO.setPwd(custAccountVO.getPwd());
//            }
            custAccountDO.setPwd(null);
            this.checkHandleSonAccount(custAccountVO,custAccountDO);

        }else {
            //查询手机号是否存在 如果存在而且修改过密码
            CustAccountVO accountMobile = custAccountRepoProc.getAccountByMobile(custAccountDO.getMobile());
            if(!ObjectUtils.isEmpty(accountMobile)){
                custAccountDO.setIsModifyPwd(accountMobile.getIsModifyPwd());
                custAccountDO.setPwd(null);
            }
            custAccountDO = custAccountRepo.save(custAccountDO);
        }
        Map<String, AuthUserDTO> userDTOMap = this.checkAndPackUserInfo(param.getCustCode(), custAccountDO,custAccountVO,param.getBusinessTypeCust());

        // 推数据生成账户
        Long userId = casUserClientHelper.onUpsert(userDTOMap.get(custAccountDO.getCustCode()));
        // 注册完的数据处理
        //查询账号是否存在
        CustAccountVO account = custAccountRepoProc.getAccountByMobile(param.getMobile());
        if(!ObjectUtils.isEmpty(account)){
            custAccountDO.setIsModifyPwd(account.getIsModifyPwd());
        }
        custAccountRepo.save(custAccountDO);
        return userId;
    }

    private void checkHandleSonAccount(CustAccountVO custAccountVO,CustAccountDO custAccountDO){
        if (!ObjectUtils.isEmpty(custAccountVO.getDealerType()) && !ObjectUtils.isEmpty(custAccountVO.getBusinessType())){
            if ((!custAccountVO.getBusinessType().equals(custAccountDO.getBusinessType()))
                    || (!custAccountVO.getBusinessType().equals(custAccountDO.getBusinessType()))) {
                // 查找子账户并清空子账户角色数据
                this.sonAccountRoleHandle(custAccountVO.getCustCode());
            }
        }
    }

    private void sonAccountRoleHandle(String custCode) {
        // 查找子账户并清空子账户角色数据
        CustAccountQueryParam param1 = new CustAccountQueryParam();
        param1.setCustCode(custCode);
        List<CustAccountVO> tradeConfigPage = custAccountRepoProc.getAccountPage(param1);
        if (ObjectUtils.isEmpty(tradeConfigPage)) {
            return;
        }
        tradeConfigPage.forEach(k -> {
            k.setRoleName(null);
            k.setRoleId(null);
            k.setRoleCode(null);
        });
        List<CustAccountDO> accountDOS = tradeConfigPage.stream().map(CustAccountConvert.INSTANCE::voToDO)
                .collect(Collectors.toList());
        custAccountRepo.saveAll(accountDOS);
    }

    private CustAccountDO excuteAccountInfo(CrmCustAccountParam param) {

        CustAccountDO custAccountDO = new CustAccountDO();
        custAccountDO.setCustCode(param.getCustCode());
        if(StringUtil.isNotBlank(param.getUserName())){
            custAccountDO.setUserName(param.getUserName());
        }else {
            custAccountDO.setUserName(param.getMobile());
        }
        if (!ObjectUtils.isEmpty(param.getUserName())) {
            custAccountDO.setUserName(param.getUserName());
        }
        custAccountDO.setMobile(param.getMobile());
        custAccountDO.setPwd(ConstantsSale.ACCOUNT_PASSWORD);
        custAccountDO.setIsOpenAccount(Boolean.FALSE);
        custAccountDO.setDealerType(param.getDealerType());
        custAccountDO.setSubAcFlag(param.getSubAcFlag());
        custAccountDO.setEnable(param.getEnable());
        custAccountDO.setBusinessType(param.getBusinessType());
        custAccountDO.setNickName(param.getCustName());
        custAccountDO.setBusinessTypeCust(param.getBusinessTypeCust());
        // 补充角色
        if (!ObjectUtils.isEmpty(param.getBusinessType())) {
            DeAccountRoleParam param1 = new DeAccountRoleParam();
            param1.setDealerType(param.getDealerType());
            param1.setBusinessType(param.getBusinessType());
            List<DeAccountRoleVO> serviceRole = deAccountRoleRepoProc.getRole(param1);
            if (!ObjectUtils.isEmpty(serviceRole)) {
                custAccountDO.setRoleCode(serviceRole.get(0).getRoleCode());
                // 修改权限信息
                custAccountDO.setRoleId(serviceRole.get(0).getRoleId());
            }
        }
        return custAccountDO;
    }

    @Override
    public PagingVO<CustAccountVO> searchCustAccount(CustAccountQueryParam param) {
        SysUserDTO sysUser = this.getCurrentUser();
//        CustAccountVO currentAccount = custAccountRepoProc.getAccountByUserName(sysUser.getUsername());
        CustAccountVO currentAccount = custAccountRepoProc.getAccountByUserId(sysUser.getId());
        param.setCustCode(currentAccount.getCustCode());
        long count = custAccountRepoProc.getAccountPageCount(param);
        if (count > 0) {
            List<CustAccountVO> tradeConfigPage = custAccountRepoProc.getAccountPage(param);
            tradeConfigPage.forEach(t ->{
                t.setCreateAccountTime(t.getCreateTime());
            });
            // 公司翻译
            this.translate(tradeConfigPage);
            return new PagingVO<>(count, tradeConfigPage);
        }        //获取当前用户
        return new PagingVO<>();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long createSonUser(CustUpdateVO param) {
        //校验手机号是否存在
        Boolean exists = custAccountRepoProc.exists1(param.getMobile(), "","CUST",param.getBusinessTypeCust());
        if (exists) {
            throw new com.elitescloud.boot.exception.BusinessException("业务类型:" + param.getBusinessTypeCust() +"对应的账号已经存在！");
        }
        CustAccountConvert custAccountConvert = CustAccountConvert.INSTANCE;
        SysUserDTO currentUser = this.getCurrentUser();
        CustAccountDO byUserName = custAccountRepoProc.getByUserId(currentUser.getId());
        CustAccountVO custAccountVO = new CustAccountVO();

        if ("STORE".equals(byUserName.getDealerType())){
            String docNo = sysNumberRuleService.generateCode(Application.NAME,"STORE_EMP",
                    Collections.singletonList(byUserName.getCustCode()));
            custAccountVO.setUserName(docNo);
        }else{
            this.checkUserMobile(param.getMobile(), param.getId(),"CUST");
//            custAccountVO.setUserName("auto_20230621171846901_678878");
//            custAccountVO.setUserId(702958425990044548L);
            log.info("认证服务通过手机号查询用户信息参数：{}",param.getMobile());
            var result = casUserClientHelper.getAuthByMobile(param.getMobile());
            log.info("认证服务通过手机号查询用户信息返回：{}",result);
            if(result.getSuccess() && !ObjectUtils.isEmpty(result.getData())){
                var authUserDTO = result.getData();
                custAccountVO.setUserName(authUserDTO.getUsername());
                custAccountVO.setUserId(authUserDTO.getId());
            }else {
                custAccountVO.setUserName(param.getMobile() + "_" + RandomUtil.randomString(6));
            }
        }
        // 修改账户表信息
        custAccountVO.setCustCode(byUserName.getCustCode());
        custAccountVO.setMobile(param.getMobile());
        custAccountVO.setNickName(param.getNickName());
        custAccountVO.setDealerType(byUserName.getDealerType());
        custAccountVO.setEnable(Boolean.TRUE);
        custAccountVO.setSubAcFlag(Boolean.TRUE);
        custAccountVO.setRoleId(param.getRoleId());
        custAccountVO.setRoleCode(param.getRoleCode());
        custAccountVO.setPwd(ConstantsSale.ACCOUNT_PASSWORD);
        custAccountVO.setBusinessTypeCust(param.getBusinessTypeCust());
        // 反写数据
        CustAccountDO custAccountDO = custAccountConvert.voToDO(custAccountVO);
        CustAccountDO save = custAccountRepo.save(custAccountDO);
        // 修改user表信息
        AuthUserDTO authUserDTO = new AuthUserDTO();
        //门店账号全部不要传手机号 因为门店是用账号登录的
        if(!"STORE".equals(byUserName.getDealerType())){
            authUserDTO.setMobile(custAccountVO.getMobile());
        }
        authUserDTO.setId(custAccountVO.getUserId());
        authUserDTO.setUsername(custAccountVO.getUserName());
        authUserDTO.setPassword(ConstantsSale.ACCOUNT_PASSWORD);
        authUserDTO.setIdentityType(param.getBusinessTypeCust());
        casUserClientHelper.onUpsert(authUserDTO);
        return save.getId();
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long updateSonAccount(CustUpdateVO param) {
        Boolean exists = custAccountRepoProc.existsCustAccount(param.getMobile(),param.getId(),"CUST");
        if (exists) {
            throw new com.elitescloud.boot.exception.BusinessException("此账号已经存在！");
        }
        CustAccountConvert custAccountConvert = CustAccountConvert.INSTANCE;
        Optional<CustAccountDO> accountRepoById = custAccountRepo.findById(param.getId());
        AuthUserDTO authUserDTO = new AuthUserDTO();
        if (accountRepoById.isEmpty()) {
            throw new BusinessException("未找到当前用户");
        }
        CustAccountDO byUserName = accountRepoById.get();
        CustAccountVO custAccountVO = custAccountConvert.doToVO(accountRepoById.get());
        if ("STORE".equals(custAccountVO.getDealerType())){
            authUserDTO.setUsername(byUserName.getUserName());
        }else{
            this.checkUserName(param.getUserName(),param.getMobile(), param.getId(),"CUST",param.getBusinessTypeCust());
            custAccountVO.setUserName(param.getUserName());
//            ApiResult<SysUserDTO> apiResult = sysUserRpcService.getUserById(custAccountVO.getUserId().toString());
//            log.info("修改子账号用户信息查询入参：{}，返回：{}",custAccountVO.getMobile(),apiResult);
//            if(!apiResult.isSuccess() || ObjectUtils.isEmpty(apiResult.getData())){
//                throw  new BusinessException("用户信息不存在");
//            }
//            SysUserDTO sysUserDTO =  apiResult.getData();
//            authUserDTO.setUsername(sysUserDTO.getUsername());
            authUserDTO.setMobile(param.getMobile());
        }
        // 修改账户表信息
        custAccountVO.setNickName(param.getNickName());
        custAccountVO.setMobile(param.getMobile());
        custAccountVO.setRoleCode(param.getRoleCode());
        custAccountVO.setRoleId(param.getRoleId());
        custAccountVO.setDealerType(byUserName.getDealerType());
        custAccountVO.setBusinessTypeCust(param.getBusinessTypeCust());
        CustAccountDO custAccountDO = custAccountConvert.voToDO(custAccountVO);
        custAccountRepo.save(custAccountDO);
        // 修改user表信息
        authUserDTO.setId(custAccountVO.getUserId());
        //通过手机号查询账号  custAccountVO.getMobile()
        authUserDTO.setFirstName(custAccountVO.getNickName());
        authUserDTO.setUsername(custAccountVO.getUserName());
        authUserDTO.setUserType(param.getDealerType());
        authUserDTO.setIdentityType(custAccountVO.getBusinessTypeCust());
        casUserClientHelper.onUpsert(authUserDTO);
        // 修改权限信息
        return custAccountDO.getId();
    }

    private void getRoleInfo(CustAccountVO custAccountVO) {
        if (!ObjectUtils.isEmpty(custAccountVO.getBusinessType())) {
            DeAccountRoleParam param1 = new DeAccountRoleParam();
            param1.setDealerType(custAccountVO.getDealerType());
            param1.setBusinessType(custAccountVO.getBusinessType());
            List<DeAccountRoleVO> serviceRole = lmAcountRoleService.getRole(param1);
            if (!ObjectUtils.isEmpty(serviceRole)) {
                custAccountVO.setRoleCode(serviceRole.get(0).getRoleCode());
                // 修改权限信息
                custAccountVO.setRoleId(serviceRole.get(0).getRoleId());
            } else {
                throw new BusinessException("未找到权限角色信息!!!");
            }
        }
    }

    @Override
    public CustAccountVO getCustAccountByUserId(Long userId) {
        CustAccountDO allByUserId = custAccountRepo.findAllByUserId(userId);
        CustAccountConvert custAccountConvert = CustAccountConvert.INSTANCE;
        return custAccountConvert.doToVO(allByUserId);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long onEnable(Long userId, Boolean enable) {

        // 通过userId 查询
        CustAccountConvert custAccountConvert = CustAccountConvert.INSTANCE;
        CustAccountVO custAccountVO = this.getCustAccountByUserId(userId);
        custAccountVO.setEnable(enable);
        // 数据处理
        casUserClientHelper.onEnabled(userId, enable);
        CustAccountDO custAccountDO = custAccountConvert.voToDO(custAccountVO);
        CustAccountDO save = custAccountRepo.save(custAccountDO);
        return save.getId();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long remakePwd(CustAccountUpdateVO custAccountUpdate) {
        List<CustAccountDO> tenantInfos = this.getTenantInfo2(custAccountUpdate.getUserName());
        custAccountUpdate.setMobile(tenantInfos.get(0).getMobile());
        // 校验验证码
        this.checkPwd(custAccountUpdate);
        tenantDataIsolateProvider.byTenantDirectly(() -> {
            List<Long> userIds = new ArrayList<>();
            tenantInfos.forEach(a ->{
                Long userId = null;
                try {
                    userId = casUserClientHelper.onUpdatePassword(a.getUserId(), custAccountUpdate.getNewPwd());
                } catch (Exception e) {
                    log.error("修改密码 error:", e);
                    throw new BusinessException("调用修改密码服务异常" + e, e);
                }
                custAccountUpdate.setNewPwd(custAccountUpdate.getNewPwd());
                custAccountService.updateAccountPwd(a.getUserId(), custAccountUpdate);
            });

            return userIds;
        }, tenantClientProvider.getTenant(tenantInfos.get(0).getTenantId()));
        return null;
    }

    private CustAccountDO getTenantInfo(String username,String identityType) {
        List<CustAccountDO> custAccountDOS = new ArrayList<>();
        boolean correctMobile = ReUtil.isMatch(REG_MOBILE, username);
        //手机号  经销商
        if (correctMobile == true){
            custAccountDOS = jdbcTemplate.query("select * from cust_account where delete_flag = 0 and business_type_cust = " + identityType  +" dealer_type <> 'STORE' and mobile = " + username ,
                    new BeanPropertyRowMapper<>(CustAccountDO.class));
        }else {
            //门店
            custAccountDOS = jdbcTemplate.query("select * from cust_account where delete_flag = 0 and dealer_type = 'STORE' and user_name = " + username ,
                    new BeanPropertyRowMapper<>(CustAccountDO.class));
        }

        if (ObjectUtils.isEmpty(custAccountDOS)) {
            throw new BusinessException(username+"账户不存在请检查!!!");
        }
        return custAccountDOS.get(0);
    }

    private List<CustAccountDO> getTenantInfo2(String username) {
        List<CustAccountDO> custAccountDOS = new ArrayList<>();
        boolean correctMobile = ReUtil.isMatch(REG_MOBILE, username);
        //手机号  经销商
        if (correctMobile == true){
            custAccountDOS = jdbcTemplate.query("select * from cust_account where delete_flag = 0 and  dealer_type <> 'STORE' and mobile = " + username ,
                    new BeanPropertyRowMapper<>(CustAccountDO.class));
        }else {
            //门店
            custAccountDOS = jdbcTemplate.query("select * from cust_account where delete_flag = 0 and dealer_type = 'STORE' and user_name = " + username ,
                    new BeanPropertyRowMapper<>(CustAccountDO.class));
        }

        if (ObjectUtils.isEmpty(custAccountDOS)) {
            throw new BusinessException(username+"账户不存在请检查!!!");
        }
        return custAccountDOS;
    }

    private void checkPwd(CustAccountUpdateVO custAccountUpdate) {

//        Boolean checkBoolean = checkMobileSmsKaptcha(
//                craterKey(BUSINESS_TYPE_RETRIEVE_PWD, custAccountUpdate.getMobile())
//                , custAccountUpdate.getKaptcha());
//        if (!checkBoolean) {
//            throw new BusinessException("验证码错误或者已过期");
//        }
        String verify = verifyCodeManager.verify(BUSINESS_TYPE_RETRIEVE_PWD, custAccountUpdate.getMobile(), custAccountUpdate.getKaptcha());
        if (!ObjectUtils.isEmpty(verify)){
            throw new BusinessException(verify);
        }

        if (ObjectUtils.isEmpty(custAccountUpdate)) {
            throw new BusinessException("密码信息为空");
        }
        if (!custAccountUpdate.getNewPwd().equals(custAccountUpdate.getConfirmPwd())) {
            throw new BusinessException("密码不一致！");
        }
//        if(!custAccountUpdate.getNewPwd().matches(PWD_MATCHES)){
//            throw new BusinessException("密码必须包含数字字母不能少于6位");
//        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Object delSonAccount(List<Long> accountIds) {
        List<CustAccountDO> allById = custAccountRepo.findAllById(accountIds);
        allById.forEach(k -> {
            casUserClientHelper.onDelete(k.getUserId());
        });
        return custAccountRepoProc.delSonAccount(accountIds);
    }

    /**
     * 发送验证码信息
     *
     * @param username
     * @return
     */
    @Override
    public ApiResult<String> sendSms(String username) {
        // 查找该手机号下的账户
        CustAccountDO accountDO = this.getTenantInfo(username,"");
        String mobile = accountDO.getMobile();
        if (ObjectUtils.isEmpty(mobile)){
            throw new BusinessException(username+"的账户未维护手机号,请先维护手机号");
        }
        SysSendVerifyCodeVO sysSendVerifyCodeVO = new SysSendVerifyCodeVO();
        sysSendVerifyCodeVO.setAccount(mobile);
        sysSendVerifyCodeVO.setAccountType("mobile");
        sysSendVerifyCodeVO.setPeriod(600L);
        verifyCodeManager.send(BUSINESS_TYPE_RETRIEVE_PWD,sysSendVerifyCodeVO);
//        return ApiResult.ok(this.encipherPhone(mobile));
        return ApiResult.ok(mobile);
    }


    @Override
    public ApiResult<List<RemarkCustPwdVO>> sendSms2(String phone) {
        // 查找该手机号下的账户
        List<CustAccountDO> accountDO = this.getTenantInfo2(phone);
        String mobile = accountDO.get(0).getMobile();
        if (ObjectUtils.isEmpty(mobile)){
            throw new BusinessException(phone+"的账户未维护手机号,请先维护手机号");
        }
        SysSendVerifyCodeVO sysSendVerifyCodeVO = new SysSendVerifyCodeVO();
        sysSendVerifyCodeVO.setAccount(mobile);
        sysSendVerifyCodeVO.setAccountType("mobile");
        sysSendVerifyCodeVO.setPeriod(600L);
        verifyCodeManager.send(BUSINESS_TYPE_RETRIEVE_PWD,sysSendVerifyCodeVO);
//        return ApiResult.ok(this.encipherPhone(mobile));
        List<RemarkCustPwdVO> list = new ArrayList<>();
        accountDO.forEach(a ->{
            RemarkCustPwdVO remarkCustPwdVO = new RemarkCustPwdVO();
            remarkCustPwdVO.setUserId(a.getUserId());
            remarkCustPwdVO.setMobile(mobile);
            remarkCustPwdVO.setUserName(a.getUserName());
            list.add(remarkCustPwdVO);
        });
        return ApiResult.ok(list);
    }

    private String encipherPhone(String phone){
        String k = "****";
        StringBuilder sb = new StringBuilder(phone);
        sb.replace(3,sb.length() - 4,k);
        return sb.toString();
    }

    /**
     * 校验短信验证码.
     *
     * @param key     mobile
     * @param kaptcha kaptcha
     * @return 校验结果
     */
    public Boolean checkMobileSmsKaptcha(String key, String kaptcha) {
        Object s = this.redisClient.get(key);
        return s != null && s.toString().equals(kaptcha);
    }

    /**
     * 创建短信存储的key
     *
     * @param type
     * @param mobile
     * @return
     */
    public static String craterKey(String type, String mobile) {
        return type + ":" + mobile;
    }

    private String formatContent(String str, String kaptcha) {
        return MessageFormat.format(str, kaptcha);
    }

    /**
     * 生成短信验证码并存储.
     *
     * @return kaptcha
     */
    public String getKaptcha(int length) {
        StringBuilder str = new StringBuilder();
        Random random = new Random();
        for (int i = 0; i < length; i++) {
            // 生成一个[0,10)
            int randomInt = random.nextInt(10);
            str.append(randomInt);
        }
        return str.toString();
    }


    private void translate(List<CustAccountVO> custAccountVOS) {

        // 数据补充
        List<Long> rolesIds = custAccountVOS.stream().map(CustAccountVO::getRoleId)
                .distinct().collect(Collectors.toList());
        DeAccountRoleParam param = new DeAccountRoleParam();
        param.setRoleIds(rolesIds);
        List<DeAccountRoleVO> repoProcRole = deAccountRoleRepoProc.getRole(param);
        custAccountVOS.forEach(k -> {
            repoProcRole.stream().filter(n -> n.getRoleId().equals(k.getRoleId()))
                    .findFirst()
                    .ifPresent(ro -> {
                        k.setRoleName(ro.getRoleName());
                    });
        });
    }

    private SysUserDTO getCurrentUser() {
        //获取当前用户
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        if (Objects.isNull(userDetails) || Objects.isNull(userDetails.getUser())) {
            throw new BusinessException("获取当前用户信息失败");
        }
        SysUserDTO sysUser = userDetails.getUser();
        //SysUserDTO sysUser = rmiSysUserService.currentUser();
        if (ObjectUtils.isEmpty(sysUser)) {
            throw new BusinessException("用户信息获取失败");
        }
        return sysUser;
    }

    private Map<String, AuthUserDTO> checkAndPackUserInfo(String custCode, CustAccountDO accountDO,CustAccountVO custAccountVO,String businessTypeCust) {

        Map<String, AuthUserDTO> res = new HashMap<>();
        this.checkUserName(accountDO.getUserName(),accountDO.getMobile() ,accountDO.getId(),accountDO.getDealerType(),businessTypeCust);
        AuthUserDTO authUser = this.excuteUserInfo(accountDO,custAccountVO,businessTypeCust);
        res.put(custCode, authUser);
        return res;
    }

    /**
     * @param userName
     * @param id
     * @param source 客户：CUST  门店：STORE
     */
    public void checkUserName(String userName,String mobile, Long id,String source,String businessTypeCust) {
        //账号重复校验
        if(StringUtil.isBlank(source)){
            throw new BusinessException("来源为空");
        }
        Boolean exists = Boolean.FALSE;
        if(!source.equals("STORE")){
            exists = custAccountRepoProc.existsMobile2(mobile, id,source,businessTypeCust);
        }else {
            exists = custAccountRepoProc.exists(userName, id,source);
        }

        if (exists) {
            throw new BusinessException("此账号已经存在！");
        }
    }


    public void checkUserMobile(String mobile, Long id,String source) {
        //账号重复校验
        if(StringUtil.isBlank(source)){
            throw new BusinessException("来源为空");
        }
        Boolean exists = custAccountRepoProc.existsMobile(mobile, id,source);
        if (exists) {
            throw new BusinessException("此账号已经存在！");
        }
    }

    public AuthUserDTO excuteUserInfo(CustAccountDO custAccountDO,CustAccountVO custAccountVO,String businessTypeCust) {
        AuthUserDTO authUser = new AuthUserDTO();
        if(ObjectUtils.isEmpty(custAccountVO.getUserName())){
            authUser.setUsername(custAccountDO.getUserName());
        }else {
            authUser.setUsername(custAccountVO.getUserName());
        }
        authUser.setIdentityType(businessTypeCust);
        authUser.setPassword(custAccountDO.getPwd());
        if(!custAccountDO.getDealerType().equals("STORE")){
            authUser.setMobile(custAccountDO.getMobile());
        }
        //todo 需要添下业务类型

        authUser.setIdentityType(businessTypeCust);
        authUser.setId(custAccountDO.getUserId());
        authUser.setFirstName(custAccountDO.getUserName());
        authUser.setEnabled(true);
        authUser.setUserType(custAccountDO.getDealerType());
        return authUser;
    }

    @Override
    public Boolean isModifyPwd(String userName) {
        CustAccountDO custAccount = custAccountRepoProc.getByMobileDo(userName);
        return custAccount.getIsModifyPwd();
    }

    @Override
    public Boolean isModifyPwdByUserId(Long userId) {
        CustAccountVO custAccount = custAccountRepoProc.getAccountByUserId(userId);
        return custAccount.getIsModifyPwd();
    }

    @Override
    public ApiResult<String> modifyPwdStatus(Long userId) {
        jdbcTemplate.update("update cust_account set is_modify_pwd = 1 where user_id = " + userId);
        return ApiResult.ok(userId.toString());
    }
}
