package com.elitesland.yst.production.sale.service;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.security.util.DataAuthJpaUtil;
import com.elitescloud.cloudt.system.dto.resp.SysCurrencyRespDTO;
import com.elitescloud.cloudt.system.provider.extend.SysCurrencyRpcService;
import com.elitesland.yst.production.sale.Application;
import com.elitesland.yst.production.sale.api.service.ComSaleFileInfoService;
import com.elitesland.yst.production.sale.api.service.CrmCustService;
import com.elitesland.yst.production.sale.api.service.PriSalePriceService;
import com.elitesland.yst.production.sale.api.service.SalContractService;
import com.elitesland.yst.production.sale.api.vo.param.crm.CrmCustQueryParamVO;
import com.elitesland.yst.production.sale.api.vo.param.pri.PriSalePriceTypeQueryParam;
import com.elitesland.yst.production.sale.api.vo.param.pro.*;
import com.elitesland.yst.production.sale.api.vo.resp.com.ComSaleFileComVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CrmCustPageRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CrmCustSimpleVO;
import com.elitesland.yst.production.sale.api.vo.resp.pri.PriSalePriceTypeRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.pro.*;
import com.elitesland.yst.production.sale.api.vo.save.SalContractImportSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.SalContractItemImportSaveVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.convert.SalContractConvert;
import com.elitesland.yst.production.sale.convert.SalContractDConvert;
import com.elitesland.yst.production.sale.convert.SalContractRecvConvert;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.entity.*;
import com.elitesland.yst.production.sale.repo.*;

import com.elitesland.yst.production.sale.rmi.ystsupport.*;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiCommonService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysNextNumberService;

import com.elitesland.yst.production.support.provider.item.dto.ItmItemBusinessRpcPagingDTO;
import com.elitesland.yst.production.support.provider.item.param.ItmItemBusinessRpcPagingParam;
import com.elitesland.yst.production.support.provider.org.dto.OrgBuRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgEmpRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgOuRpcDTO;
import com.elitesland.yst.production.support.provider.org.param.OrgEmpRpcDtoParam;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQuery;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

/**
 * 项目合同相关业务
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/6/8 9:10 上午
 */
@Service("salContractService")
@RequiredArgsConstructor
@Slf4j
public class SalContractServiceImpl extends BaseServiceImpl implements SalContractService {

    private final QSalContractDO qSalContractDO = QSalContractDO.salContractDO;
    private final SalContractRepo salContractRepo;
    private final SalContractDRepo salContractDRepo;
    private final SalContractRecvRepo salContractRecvRepo;
    private final ComSaleFileInfoService comSaleFileInfoService;
    private final CrmCustService crmCustService;
    private final RmiSysNextNumberService nextNumberService;
    private final SysCurrencyRpcService sysCurrencyRpcService;
    public static final String ATTACH_BUSINESS_TYPE = "SAL_CONTRACT";  // 附件业务类型

    private final PriSalePriceService priSalePriceService;
    private final RmiOrgEmpService rmiOrgEmpService;
    private final RmiOrgOuService rmiOrgOuService;
    private final RmiOrgBuService rmiOrgBuService;
    private final SalProjRepoProc salProjRepoProc;

    private final CrmCustRepoProc crmCustRepoProc;
    private final SalProjRepo salProjRepo;
    private final SalReceiptdRepo salReceiptdRepo;
    private final SalInvApplydRepo salInvApplydRepo;
    private final SalContractRepoProc salContractRepoProc;

    private final RmiCityCodeService rmiCityCodeService;

    private final RmiItemService rmiItemService;

    private static final String CONTRACT_S_DRAFT = UdcEnum.SAL_CONTRACT_STATUS_DRAFT.getValueCode();
    private static final String CONTRACT_S_APPROVING = UdcEnum.SAL_CONTRACT_STATUS_APPROVING.getValueCode();
    private static final String CONTRACT_S_APPROVED = UdcEnum.SAL_CONTRACT_STATUS_APPROVED.getValueCode();
    private static final String CONTRACT_S_REJECTED = UdcEnum.SAL_CONTRACT_STATUS_REJECTED.getValueCode();
    private static final String CONTRACT_S_CLOSED = UdcEnum.SAL_CONTRACT_STATUS_CLOSED.getValueCode();


    @Override
    @SysCodeProc
    public PagingVO<SalContractPageRespVO> query(SalContractPagingParam pageParam) {
        // 如果客户类别不为空，则需要反查客户
        if (StrUtil.isNotBlank(pageParam.getCustType())) {
            var custQueryParam = new CrmCustQueryParamVO();
            custQueryParam.setCustType(pageParam.getCustType());
            List<CrmCustPageRespVO> crmCustResult = crmCustService.searchList(custQueryParam);
            List<Long> custIds = crmCustResult.stream().map(CrmCustPageRespVO::getId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            pageParam.setCustIds(custIds);
        }
        var predicate = buildPageSearchCondition(pageParam);
        var jpaQuery = jpaQueryFactory.selectFrom(qSalContractDO).where(predicate);
        long total = jpaQuery.fetchCount();
        if (total == 0) {
            return PagingVO.<SalContractPageRespVO>builder().build();
        }
        // 添加分页和排序
        var pageRequest = wrapperPageRequest(pageParam.getPageRequest(), null);
        appendPageAndSort(jpaQuery, pageRequest, qSalContractDO);
        // 查询结果
        List<SalContractDO> queryResult = jpaQuery.fetch();
        List<SalContractPageRespVO> pageResult = queryResult.stream().map(SalContractConvert.INSTANCE::doToPageRespVo).collect(Collectors.toList());
        this.translationPageSalContract(pageResult);
        return PagingVO.<SalContractPageRespVO>builder().total(total).records(pageResult).build();
    }

    /**
     * 拼接分页查询条件
     */
    private Predicate buildPageSearchCondition(SalContractPagingParam pageParam) {
        Predicate predicate = qSalContractDO.isNotNull();
        if (Objects.nonNull(pageParam)) {
            if (StrUtil.isNotBlank(pageParam.getContractNo())) {
                predicate = ExpressionUtils.and(predicate, qSalContractDO.contractNo.like("%" + pageParam.getContractNo().trim() + "%"));
            }
            if (StrUtil.isNotBlank(pageParam.getContractName())) {
                predicate = ExpressionUtils.and(predicate, qSalContractDO.contractName.like("%" + pageParam.getContractName().trim() + "%"));
            }
            if (StrUtil.isNotBlank(pageParam.getContractType())) {
                predicate = ExpressionUtils.and(predicate, qSalContractDO.contractType.eq(pageParam.getContractType()));
            }
            if (Objects.nonNull(pageParam.getSignDate())) {
                predicate = ExpressionUtils.and(predicate, qSalContractDO.signDate.eq(pageParam.getSignDate()));
            }
            if (StrUtil.isNotBlank(pageParam.getProjName())) {
                predicate = ExpressionUtils.and(predicate, qSalContractDO.projName.like("%" + pageParam.getProjName().trim() + "%"));
            }
            if (StrUtil.isNotBlank(pageParam.getContractStatus())) {
                predicate = ExpressionUtils.and(predicate, qSalContractDO.contractStatus.eq(pageParam.getContractStatus()));
            }
            if (Objects.nonNull(pageParam.getCustId())) {
                predicate = ExpressionUtils.and(predicate, qSalContractDO.custId.eq(pageParam.getCustId()));
            }
            if (CollUtil.isNotEmpty(pageParam.getCustIds())) {
                predicate = ExpressionUtils.and(predicate, qSalContractDO.custId.in(pageParam.getCustIds()));
            }
            if (StrUtil.isNotBlank(pageParam.getCustCode())) {
                predicate = ExpressionUtils.and(predicate, qSalContractDO.custCode.like("%" + pageParam.getCustCode().trim() + "%"));
            }
            if (StrUtil.isNotBlank(pageParam.getCustName())) {
                predicate = ExpressionUtils.and(predicate, qSalContractDO.custName.like("%" + pageParam.getCustName().trim() + "%"));
            }
            if (StrUtil.isNotBlank(pageParam.getSignOu())) {
                predicate = ExpressionUtils.and(predicate, qSalContractDO.bSignOu.eq(pageParam.getSignOu()));
            }
            if (StrUtil.isNotBlank(pageParam.getSalesMan())) {
                predicate = ExpressionUtils.and(predicate, qSalContractDO.bSalesman.eq(pageParam.getSalesMan()));
            }
            if (StrUtil.isNotBlank(pageParam.getRegion())) {
                predicate = ExpressionUtils.and(predicate, qSalContractDO.bRegion.eq(pageParam.getRegion()));
            }
            if (StrUtil.isNotBlank(pageParam.getFindCloseOrderFlag()) && pageParam.getFindCloseOrderFlag().equals("false")) {
                predicate = ExpressionUtils.and(predicate, qSalContractDO.contractStatus.eq(UdcEnum.SAL_CONTRACT_STATUS_APPROVED.getValueCode()));
            }
        }
//        // 添加权限信息
        predicate = ExpressionUtils.and(predicate, DataAuthJpaUtil.dataAuthJpaPredicate(qSalContractDO.getMetadata()));
        return predicate;
    }

    private void translationPageSalContract(List<SalContractPageRespVO> pageResult) {

        // 填充币种名称
        Set<String> currCodes = pageResult.stream().map(SalContractPageRespVO::getCurrCode).filter(StrUtil::isNotBlank).distinct().collect(Collectors.toSet());
        ApiResult<List<SysCurrencyRespDTO>> sysCurrencyRespDTOListApiResult = sysCurrencyRpcService.listByCodes(currCodes);
        Assert.notNull(sysCurrencyRespDTOListApiResult, "根据编码查询币种失败");
        Assert.isTrue(sysCurrencyRespDTOListApiResult.isSuccess(), "根据编码查询币种失败");

        List<SysCurrencyRespDTO> currRpcResult = sysCurrencyRpcService.listByCodes(currCodes).getData();

        List<String> salesmans = pageResult.stream().map(SalContractPageRespVO::getBSalesman).distinct().filter(Objects::nonNull).collect(Collectors.toList());
        List<Long> salesmansL = salesmans.stream().map(Long::parseLong).collect(Collectors.toList());
        List<String> signDepts = pageResult.stream().map(SalContractPageRespVO::getBSignDept).distinct().filter(Objects::nonNull).collect(Collectors.toList());
        List<Long> signDeptsL = signDepts.stream().map(Long::parseLong).collect(Collectors.toList());
        List<String> signOus = pageResult.stream().map(SalContractPageRespVO::getBSignOu).distinct().filter(Objects::nonNull).collect(Collectors.toList());
        List<Long> signOusL = signOus.stream().map(Long::parseLong).collect(Collectors.toList());
        // 销售员名称
        OrgEmpRpcDtoParam orgEmpRpcDtoParam = new OrgEmpRpcDtoParam();
        List<OrgEmpRpcDTO> empListByParam = new ArrayList<>();
        if (!CollectionUtils.isEmpty(salesmansL)) {
            orgEmpRpcDtoParam.setEmpIds(salesmansL);
            empListByParam = rmiOrgEmpService.findEmpListByParam(orgEmpRpcDtoParam);
        }
        // 签约公司
        List<OrgOuRpcDTO> ouDtoList = new ArrayList<>();
        if (!CollectionUtils.isEmpty(signOusL)) {
            ouDtoList = rmiOrgOuService.findOuDtoList(signOusL, null);
        }
        // 签约部门
        List<OrgBuRpcDTO> buDtoList = new ArrayList<>();
        if (!CollectionUtils.isEmpty(signDeptsL)) {
            buDtoList = rmiOrgBuService.findBuDtoList(signDeptsL, null);
        }
        List<OrgEmpRpcDTO> finalEmpListByParam = empListByParam;
        List<OrgOuRpcDTO> finalOuDtoList = ouDtoList;
        List<OrgBuRpcDTO> finalBuDtoList = buDtoList;
        pageResult.forEach(r -> {
            currRpcResult.stream().filter(curr -> StrUtil.isNotBlank(r.getCurrCode()) && curr.getCurrCode().equals(r.getCurrCode()))
                    .findFirst().ifPresent(c -> r.setCurrName(c.getCurrName()));
            finalEmpListByParam.stream().filter(emp -> emp.getId().equals(Long.parseLong(r.getBSalesman() == null ? "0" : r.getBSalesman())))
                    .findFirst().ifPresent(e -> r.setBSalesmanName(e.getEmpName()));
            finalOuDtoList.stream().filter(ou -> ou.getId().equals(Long.parseLong(r.getBSignOu() == null ? "0" : r.getBSignOu())))
                    .findFirst().ifPresent(o -> r.setBSignOuName(o.getOuName()));
            finalBuDtoList.stream().filter(bu -> bu.getId().equals(Long.parseLong(r.getBSignDept() == null ? "0" : r.getBSignDept())))
                    .findFirst().ifPresent(b -> r.setBSignDeptName(b.getBuName()));
        });
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public JSONObject saveOrSubmit(SalContractSaveParam param, String operate) {
        log.info("合同保存或提交：{}", JSON.toJSONString(param));
        if (Objects.isNull(param.getId())) {
            String contractNo = nextNumberService.generateCode(Application.NAME,"SAL_CONTR_NO", null);
            param.setContractNo(contractNo);
        }
//        checkContractNo(param.getId(), contractNo);
        // 去查项目所属的公司、客户
        if (!StringUtils.isEmpty(param.getProjName())) {
            Boolean exists = salProjRepoProc.exists(param.getProjName(), param.getCustCode());
            Boolean exists1 = salProjRepoProc.exists1(param.getProjName(), param.getBSignOu());
            if (!exists) {
                throw new BusinessException("该客户不属于该项目,请检查");
            }
            if (!exists1) {
                throw new BusinessException("该签约公司不属于该项目,请检查");
            }
        }
        SalContractDO salContractDO = null;
        if (Objects.nonNull(param.getId())) {
            Optional<SalContractDO> contractOptional = salContractRepo.findById(param.getId());
            if (contractOptional.isPresent()) {
                salContractDO = contractOptional.get();
                // 若是提交，需要判断一下当前状态是否为草稿状态
                if (CONTRACT_S_APPROVING.equals(operate) && !CONTRACT_S_DRAFT.equals(salContractDO.getContractStatus()) && !CONTRACT_S_REJECTED.equals(salContractDO.getContractStatus())) {
                    throw new BusinessException("当前销售合同非待提交或已拒绝状态不能执行该操作");
                }
                param.setContractNo(salContractDO.getContractNo());
            } else {
                throw new BusinessException("当前销售合同不存在");
            }
        }
        salContractDO = SalContractConvert.INSTANCE.paramToDo(param);
        salContractDO.setDeleteFlag(0);
        // 若没有填写版本，给个默认版本1
        salContractDO.setContractVersion(Objects.isNull(param.getContractVersion()) ? 1 : param.getContractVersion());
        salContractDO.setContractStatus(operate);
        // 权限字段添加
        salContractDO.setSecBuId(Long.parseLong(param.getBSignDept()));
        salContractDO.setSecOuId(Long.parseLong(param.getBSignOu()));
        if (!ObjectUtils.isEmpty(param.getBSalesman())){
            salContractDO.setSecUserId(Long.parseLong(param.getBSalesman()));
        }
        salContractRepo.save(salContractDO);

        Long masId = salContractDO.getId();
        String contractNo = salContractDO.getContractNo();
        // 物理删除所有商品明细以及合同收款计划
        salContractDRepo.deleteAllByMasId(masId);
//        salContractRecvRepo.deleteAllByMasId(masId);
        salContractRecvRepo.deleteAllByContractNo(contractNo);
        // 重新保存合同明细
        List<SalContractDSaveParam> itemDetails = param.getItemDetails();

        List<SalContractDDO> itemDetailDOList = itemDetails.stream().map(SalContractDConvert.INSTANCE::paramToDo).collect(Collectors.toList());
        // 查询BsignOuCode
        List<Long> ouIds = new ArrayList<>();
        ouIds.add(Long.parseLong(param.getBSignOu()));
        List<OrgOuRpcDTO> ouDtoList = rmiOrgOuService.findOuDtoList(ouIds, null);
        itemDetailDOList.forEach(i -> {
            i.setMasId(masId);
            // 校验商品是否在经营目录中
            if (param.getCatalogueFlag() == 1) {
                ItmItemBusinessRpcPagingParam pagingParam = new ItmItemBusinessRpcPagingParam();
                List<String> itemCodes = new ArrayList<>();
                itemCodes.add(i.getItemCode());
                List<String> ouCodes = new ArrayList<>();
                if (!CollectionUtils.isEmpty(ouDtoList)){
                    String ouCode = ouDtoList.stream().filter(ou -> ou.getId().equals(Long.parseLong(param.getBSignOu())))
                            .findFirst().orElseThrow(new BusinessException("该签约公司不存在")).getOuCode();
                    ouCodes.add(ouCode);
                }
                pagingParam.setItemCodes(itemCodes);
                pagingParam.setBuCodes(ouCodes);
                PagingVO<ItmItemBusinessRpcPagingDTO> itemBusinessRpcDtoByParam = rmiItemService.findItemBusinessRpcDtoByParam(pagingParam);
                if (ObjectUtils.isEmpty(itemBusinessRpcDtoByParam.getRecords())) {
                    throw new BusinessException("商品编码为" + i.getItemCode() + "的商品在经营目录上没有维护,请检查");
                }
            }
        });
        salContractDRepo.saveAll(itemDetailDOList);
        // 重新保存收款计划
        List<SalContractRecvSaveParam> contractRecvs = param.getContractRecvs();
        if (!CollectionUtils.isEmpty(contractRecvs)){
            List<SalContractRecvDO> contractRecvDOList = contractRecvs.stream().map(SalContractRecvConvert.INSTANCE::paramToDo).collect(Collectors.toList());
            contractRecvDOList.forEach(c -> {
                        c.setMasId(masId);
                        c.setSecBuId(Long.parseLong(param.getBSignDept()));
                        c.setSecOuId(Long.parseLong(param.getBSignOu()));
                        c.setSecUserId(Long.parseLong(param.getBSalesman()));
                        c.setCurrCode(param.getCurrCode());
                        c.setContractNo(param.getContractNo());
                    }
            );
            salContractRecvRepo.saveAll(contractRecvDOList);
        }
        // 处理附件
        List<ComSaleFileComVO> attachFiles = param.getAttachFiles();
//        if(!CollectionUtils.isEmpty(attachFiles)){
        comSaleFileInfoService.comSaleFileHardSave(ATTACH_BUSINESS_TYPE, masId, attachFiles);
//        }
        var result = new JSONObject();
        result.put("id", masId);
        result.put("contractNo",contractNo);
        return result;
    }
}