package com.elitesland.yst.production.sale.service;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.el.coordinator.core.common.utils.BeanCopyUtil;
import com.elitesland.yst.production.order.param.SalSoDUpdateDTO;
import com.elitesland.yst.production.order.param.SalSoDetailQueryDTO;
import com.elitesland.yst.production.order.param.SalSoDetailRespDTO;
import com.elitesland.yst.production.order.param.SalSoReceiptSaveDTO;
import com.elitesland.yst.production.sale.api.vo.resp.sal.SalInvApplydRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.sal.SalReceiptdRespVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.dto.query.SalInvApplyCheckDTO;
import com.elitesland.yst.production.sale.dto.query.SalReceiptCheckDTO;
import com.elitesland.yst.production.sale.entity.*;
import com.elitesland.yst.production.sale.repo.*;
import com.elitesland.yst.production.sale.repo.shop.BipOrderRepo;
import com.elitesland.yst.production.sale.rmi.ystorder.RmiOrderSalSoDService;
//import com.elitesland.yst.production.sale.rmi.ystorder.RmiOrderSalSoService;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.boot.exception.BusinessException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @auther JinXK
 * @date 2021/8/26 11:09
 */
@Slf4j
@RestController
@RequestMapping(SalReceiptRpcService.URI)
public class SalReceiptRpcServiceImpl extends BaseServiceImpl implements SalReceiptRpcService{

    @Autowired
    private SalReceiptRepo salReceiptRepo;
    @Autowired
    private SalReceiptdRepoProc salReceiptdRepoProc;
    @Autowired
    private RmiOrderSalSoDService rmiOrderSalSoDService;
//    @Autowired
//    private RmiOrderSalSoService rmiOrderSalSoService;
    @Autowired
    private SalSoaRepo salSoaRepo;
    @Autowired
    private SalInvApplyRepo salInvApplyRepo;
    @Autowired
    private SalInvApplydRepoProc salInvApplydRepoProc;
    @Autowired
    private SalInvSerialRepo salInvSerialRepo;
    @Autowired
    private BipOrderRepo bipOrderRepo;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<Object> updateReceiptStatus(SalReceiptCheckDTO param) {
        Optional<SalReceiptDO> optional = salReceiptRepo.findById(param.getId());
        if(optional.isEmpty()){
            throw new BusinessException("单据不存在");
        }
        SalReceiptDO salReceiptDO = optional.get();
        if(!salReceiptDO.getDocStatus().equals(UdcEnum.SAL_RECEIPT_STATUS_APPROVING.getValueCode())){
            throw new BusinessException("单据状态必须为待审批的才能审批");
        }
        SalReceiptDO relaSal = new SalReceiptDO();
        if(!StringUtils.isEmpty(salReceiptDO.getRelateDocId())) {
            Optional<SalReceiptDO> relaOp = salReceiptRepo.findById(salReceiptDO.getRelateDocId());
            if(!relaOp.isEmpty()){
                relaSal = relaOp.get();
            }
        }
        List<SalSoaDO> soaList = new ArrayList<>();
        if(salReceiptDO.getSoaOrSo()!=null && "SOA".equals(salReceiptDO.getSoaOrSo())){
            //为对账单的收款单时 需改对应对账单的收款状态
            List<SalReceiptdRespVO> invDs = salReceiptdRepoProc.findBymasId(salReceiptDO.getId()).fetch();
            List<Long> soaId = invDs.stream().map(SalReceiptdRespVO::getSoaId).distinct().collect(Collectors.toList());
            soaList = salSoaRepo.findByIdIn(soaId);
            if(!salReceiptDO.getReceiptType().equals("RED")){
                soaList.forEach(soa -> {
                    if(!soa.getSoaReceiptStatus().equals(UdcEnum.SAL_SOA_RECEIPT_STATUS_20.getValueCode())) {
                        throw new BusinessException("对账单"+soa.getDocNo()+"的对账单收款状态不为收款中");
                    }
                });
            }
        }
        if("approve".equals(param.getType())){
            //审批通过
            salReceiptDO.setDocStatus(UdcEnum.SAL_RECEIPT_STATUS_APPROVED.getValueCode());
            if(relaSal != null && "DEPOSIT".equals(relaSal.getReceiptType())) {
                //原单为押金单时，审批通过
                if(salReceiptDO.getReceiptType().equals("20")){
                    //退押金类型
                    BigDecimal amt = salReceiptDO.getAmt()==null?BigDecimal.ZERO:salReceiptDO.getAmt().abs();
                    relaSal.setReturningAmt((relaSal.getReturningAmt()==null?BigDecimal.ZERO:relaSal.getReturningAmt()).subtract(amt));
                    relaSal.setReturnAmt((relaSal.getReturnAmt()==null?BigDecimal.ZERO:relaSal.getReturnAmt()).add(amt));
                }else {
                    //押金转货款类型 转货款中金额给已转货款金额
                    BigDecimal amt = salReceiptDO.getAmt()==null?BigDecimal.ZERO:salReceiptDO.getAmt().abs();
                    relaSal.setTransferAmt(relaSal.getTransferAmt().add(amt));
                    relaSal.setTransferingAmt(relaSal.getTransferingAmt().subtract(amt));
                }
                salReceiptRepo.save(relaSal);
            }
            if(salReceiptDO.getSoaOrSo()!=null && "SOA".equals(salReceiptDO.getSoaOrSo())){
                if(salReceiptDO.getReceiptType()!=null && salReceiptDO.getReceiptType().equals("RED")){
                    soaList.forEach(soa -> {
                        soa.setSoaReceiptStatus(UdcEnum.SAL_SOA_RECEIPT_STATUS_10.getValueCode());
                    });
                }else {
                    soaList.forEach(soa -> {
                        soa.setSoaReceiptStatus(UdcEnum.SAL_SOA_RECEIPT_STATUS_30.getValueCode());
                    });
                }
                salSoaRepo.saveAll(soaList);
            }
        }else if("reject".equals(param.getType())){
            //审批拒绝
            salReceiptDO.setDocStatus(UdcEnum.SAL_RECEIPT_STATUS_REJECTED.getValueCode());
            if(relaSal != null && "DEPOSIT".equals(relaSal.getReceiptType())) {
                //原单为押金单时，审批拒绝
                if(salReceiptDO.getReceiptType().equals("20")){
                    //退押金类型
                    BigDecimal amt = salReceiptDO.getAmt()==null?BigDecimal.ZERO:salReceiptDO.getAmt().abs();
                    relaSal.setReturningAmt((relaSal.getReturningAmt()==null?BigDecimal.ZERO:relaSal.getReturningAmt()).subtract(amt));
                    relaSal.setOpenAmt((relaSal.getOpenAmt()==null?BigDecimal.ZERO:relaSal.getOpenAmt()).add(amt));
                }else {
                    //押金转货款类型 转货款中金额给押金余额
                    BigDecimal amt = salReceiptDO.getAmt()==null?BigDecimal.ZERO:salReceiptDO.getAmt().abs();
                    relaSal.setOpenAmt(relaSal.getOpenAmt().add(amt));
                    relaSal.setTransferingAmt(relaSal.getTransferingAmt().subtract(amt));
                }
                salReceiptRepo.save(relaSal);
            }
            if("RED".equals(salReceiptDO.getReceiptType())) {
                //红冲单被拒绝时去掉原单的红冲标记
                SalReceiptDO salRDO = salReceiptRepo.findById(salReceiptDO.getRelateDocId()).get();
                salRDO.setOffFlag(null);
                salReceiptRepo.save(salRDO);
            }
            if(salReceiptDO.getSoaOrSo()!=null && "SOA".equals(salReceiptDO.getSoaOrSo())){
                soaList.forEach(soa -> {
                    soa.setSoaReceiptStatus(UdcEnum.SAL_SOA_RECEIPT_STATUS_10.getValueCode());
                    soa.setReceiptId(null);
                    soa.setReceiptNo(null);
                });
                salSoaRepo.saveAll(soaList);
            }
        }else {
            throw new BusinessException("审批状态错误");
        }
        salReceiptDO.setApprTime(LocalDateTime.now());
        if(param.getApprComment()!=null){
            salReceiptDO.setApprComment(param.getApprComment());
        }
        if(param.getApprUserId()!=null){
            salReceiptDO.setApprUserId(param.getApprUserId());
        }
        if(param.getApprUserName()!=null){
            salReceiptDO.setApprUserName(param.getApprUserName());
        }
        salReceiptRepo.save(salReceiptDO);
        if("reject".equals(param.getType())){
            if(salReceiptDO.getDocType()!=null && salReceiptDO.getDocType().equals("RD")){
                if(!(salReceiptDO.getReceiptType()!=null && salReceiptDO.getReceiptType().equals("30"))){
                    List<SalReceiptdRespVO> ddos = salReceiptdRepoProc.findBymasId(salReceiptDO.getId()).fetch();
                    if(ddos.size()>0){
                        Map<Long, BigDecimal> IdAndAmt = new HashMap<>();
                        ddos.forEach(ddo -> {
                            if(ddo.getSoDId()!=null && ddo.getReceiptAmt()!=null){
                                IdAndAmt.put(ddo.getSoDId(),ddo.getReceiptAmt().abs());
                            }
                        });
                        if(IdAndAmt.size()>0){
                        //    rmiOrderSalSoDService.rejectRefund(IdAndAmt);
                        }
                    }
                }
            }else {
                //审批结束,为拒绝时反写销售单-收款中->待收款
                List<SalReceiptdRespVO> details = salReceiptdRepoProc.findBymasId(salReceiptDO.getId()).fetch();
                List<Long> sodid = details.stream().map(SalReceiptdRespVO::getSoDId).collect(Collectors.toList());
                List<SalSoDetailRespDTO> sodList = getSodListBySodId(sodid);
                List<SalSoDUpdateDTO> sodUpList = new ArrayList<>();
                sodList.forEach(sod -> {
                    SalSoDUpdateDTO salSoDUpdateDTO = new SalSoDUpdateDTO();
                    salSoDUpdateDTO.setSodId(sod.getSoDId());
                    salSoDUpdateDTO.setPayingAmt(sod.getPayingAmt()==null?BigDecimal.ZERO:sod.getPayingAmt());
                    salSoDUpdateDTO.setOpenAmt(sod.getOpenAmt()==null?BigDecimal.ZERO:sod.getOpenAmt());
                    salSoDUpdateDTO.setPayedAmt(sod.getPayedAmt()==null?BigDecimal.ZERO:sod.getPayedAmt());
                    details.forEach(d -> {
                        if(sod.getSoDId().equals(d.getSoDId())) {
                            salSoDUpdateDTO.setPayingAmt(salSoDUpdateDTO.getPayingAmt().subtract(d.getReceiptAmt()));
                            salSoDUpdateDTO.setOpenAmt(salSoDUpdateDTO.getOpenAmt().add(d.getReceiptAmt()));
                        }
                    });
                    salSoDUpdateDTO.setApAmt((sod.getConfirmQty().multiply(sod.getPrice()))
                            .subtract(salSoDUpdateDTO.getPayedAmt()).subtract(salSoDUpdateDTO.getPayingAmt()));
                    sodUpList.add(salSoDUpdateDTO);
                });
                if(sodUpList.size()>0){
                    rmiOrderSalSoDService.querySalSoDetail(sodUpList);
                }
            }
        }else {
            if(salReceiptDO.getDocType()!=null && salReceiptDO.getDocType().equals("RD")){
                if(salReceiptDO.getReceiptType()!=null && salReceiptDO.getReceiptType().equals("30")){
                    //预收退款单提交成功,反写销售单
                    List<SalReceiptdRespVO> detailList = salReceiptdRepoProc.findBymasId(salReceiptDO.getId()).fetch();
                    List<Long> sodIdList = detailList.stream().filter(s->s.getSoDId()!=null).map(SalReceiptdRespVO::getSoDId).collect(Collectors.toList());
                    List<SalSoDetailRespDTO> sodList = new ArrayList<>();
                    if(sodIdList.size()>0) {
                        sodList = getSodListBySodId(sodIdList);
                    }
                    List<SalSoDUpdateDTO> sodUpList = new ArrayList<>();
                    sodList.forEach(sod -> {
                        SalSoDUpdateDTO salSoDUpdateDTO = new SalSoDUpdateDTO();
                        salSoDUpdateDTO.setSodId(sod.getSoDId());
                        salSoDUpdateDTO.setPayingAmt(sod.getPayingAmt()==null?BigDecimal.ZERO:sod.getPayingAmt());
                        salSoDUpdateDTO.setOpenAmt(sod.getOpenAmt()==null?BigDecimal.ZERO:sod.getOpenAmt());
                        salSoDUpdateDTO.setPayedAmt(sod.getPayedAmt()==null?BigDecimal.ZERO:sod.getPayedAmt());
                        detailList.forEach(d -> {
                            if(sod.getSoDId().equals(d.getSoDId())) {
                                salSoDUpdateDTO.setPayedAmt(salSoDUpdateDTO.getPayedAmt().add(d.getReceiptAmt()));
                                salSoDUpdateDTO.setOpenAmt(salSoDUpdateDTO.getOpenAmt().subtract(d.getReceiptAmt()));
                            }
                        });
                        salSoDUpdateDTO.setApAmt((sod.getConfirmQty().multiply(sod.getPrice()))
                                .subtract(salSoDUpdateDTO.getPayedAmt()).subtract(salSoDUpdateDTO.getPayingAmt()));
                        sodUpList.add(salSoDUpdateDTO);
                    });
                    if(sodUpList.size()>0){
                        rmiOrderSalSoDService.querySalSoDetail(sodUpList);
                    }
                }else {
                    //其他退款单反写退货单
                    List<SalReceiptdRespVO> ddos = salReceiptdRepoProc.findBymasId(salReceiptDO.getId()).fetch();
                    if(ddos.size()>0){
                        Map<Long, BigDecimal> IdAndAmt = new HashMap<>();
                        ddos.forEach(ddo -> {
                            if(ddo.getSoDId()!=null && ddo.getReceiptAmt()!=null){
                                IdAndAmt.put(ddo.getSoDId(),ddo.getReceiptAmt().abs());
                            }
                        });
                        if(IdAndAmt.size()>0){
           //                 rmiOrderSalSoDService.approveRefund(IdAndAmt);
                        }
                    }
                }
            }else {
                //审批结束,为通过时反写销售单-收款中->已收款
                List<SalReceiptdRespVO> details = salReceiptdRepoProc.findBymasId(salReceiptDO.getId()).fetch();
                List<Long> sodid = details.stream().map(SalReceiptdRespVO::getSoDId).collect(Collectors.toList());
                List<SalSoDetailRespDTO> sodList = getSodListBySodId(sodid);
                List<SalSoDUpdateDTO> sodUpList = new ArrayList<>();
                sodList.forEach(sod -> {
                    SalSoDUpdateDTO salSoDUpdateDTO = new SalSoDUpdateDTO();
                    salSoDUpdateDTO.setSodId(sod.getSoDId());
                    salSoDUpdateDTO.setPayingAmt(sod.getPayingAmt()==null?BigDecimal.ZERO:sod.getPayingAmt());
                    salSoDUpdateDTO.setPayedAmt(sod.getPayedAmt()==null?BigDecimal.ZERO:sod.getPayedAmt());
                    details.forEach(d -> {
                        if(sod.getSoDId().equals(d.getSoDId())) {
                            salSoDUpdateDTO.setPayingAmt(salSoDUpdateDTO.getPayingAmt().subtract(d.getReceiptAmt()));
                            salSoDUpdateDTO.setPayedAmt(salSoDUpdateDTO.getPayedAmt().add(d.getReceiptAmt()));
                        }
                    });
                    sodUpList.add(salSoDUpdateDTO);
                });
                if(sodUpList.size()>0){
                    rmiOrderSalSoDService.querySalSoDetail(sodUpList);
                }
                //调用OMS核销红冲接口 更改订单中心支付状态
                List<SalSoReceiptSaveDTO> soList = new ArrayList<>();
                details.forEach(d -> {
                    SalSoReceiptSaveDTO saveDTO = new SalSoReceiptSaveDTO();
                    saveDTO.setSoId(d.getSoId());
                    saveDTO.setSoNo(d.getSoNo());
                    saveDTO.setSoDId(d.getSoDId());
                    saveDTO.setSoLineNo(d.getSoLineNo().toString());
                    saveDTO.setReceiptType(salReceiptDO.getReceiptType());
                    saveDTO.setReceiptMethod(salReceiptDO.getPayMethod());
                    saveDTO.setReceiptAmt(d.getReceiptAmt());
                    saveDTO.setReceiptTax(d.getReceiptTax());
                    saveDTO.setApplyTime(salReceiptDO.getApplyDate());
                    saveDTO.setApprTime(salReceiptDO.getApprTime());
                    saveDTO.setRelateDocType(salReceiptDO.getDocType());
                    saveDTO.setRelateDocId(salReceiptDO.getId());
                    saveDTO.setRelateDocNo(salReceiptDO.getDocNo());
                    saveDTO.setRelateDocDid(d.getId());
                    if(salReceiptDO.getReceiptType().equals("OFF_PRE")){
                        saveDTO.setType("OFF_PRE");
                    }
                    soList.add(saveDTO);
                });
                if(soList.size()>0){
         //           rmiOrderSalSoDService.updateWhenVerifyOrReverse(soList);
                }
                //B端商城线下收款类型需要另外反写B端商城订单类型
                if(salReceiptDO.getReceiptType()!=null && salReceiptDO.getReceiptType().equals("OFF_PRE")){
                    List<String> soNoList = details.stream().filter(a->a.getSoNo()!=null)
                            .map(SalReceiptdRespVO::getSoNo).collect(Collectors.toList());
                    List<BipOrderDO> orderList = bipOrderRepo.findAllByDocNoIn(soNoList);
                    if(orderList.size()>0){
                        //更新商城订单状态为 待收货
                        orderList.forEach(a -> a.setStatus("shipping"));
                        bipOrderRepo.saveAll(orderList);
                    }
                }
            }
        }
        return ApiResult.ok();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<Object> updateInvApplyStatus(SalInvApplyCheckDTO param) {
        log.info("开票申请审批回传方法入参"+ JSONUtil.toJsonStr(param));
        Optional<SalInvApplyDO> optional = salInvApplyRepo.findById(param.getId());
        if(optional.isEmpty()){
            throw new BusinessException("单据不存在");
        }
        SalInvApplyDO salInvApplyDO = optional.get();
        if(!salInvApplyDO.getDocStatus().equals(UdcEnum.SAL_BILL_STATUS_APPROVING.getValueCode())){
            throw new BusinessException("单据状态必须为待审批的才能审批");
        }
        List<SalSoaDO> soaList = new ArrayList<>();
        if(salInvApplyDO.getSoaOrSo()!=null && "SOA".equals(salInvApplyDO.getSoaOrSo())){
            //为对账单的开票申请单时 需改对应对账单的开票状态
            List<SalInvApplydRespVO> invDs = salInvApplydRepoProc.findBymasId(salInvApplyDO.getId()).fetch();
            List<Long> soaId = invDs.stream().map(SalInvApplydRespVO::getSoaId).distinct().collect(Collectors.toList());
            soaList = salSoaRepo.findByIdIn(soaId);
            soaList.forEach(soa -> {
                if(soa.getInvApplyingAmt().compareTo(salInvApplyDO.getInvAmt())<0 && salInvApplyDO.getOpenType().equals("1")) {
                    throw new BusinessException("对账单"+soa.getDocNo()+"的开票中金额不足");
                }
            });
        }
        if("approve".equals(param.getType())){
            if(salInvApplyDO.getOpenType().equals("1") && (param.getInvSerialList()==null || param.getInvSerialList().size()==0)){
                throw new BusinessException("开票通过流程必须返回流水号等信息");
            }
            //审批通过
            salInvApplyDO.setDocStatus(UdcEnum.SAL_BILL_STATUS_INVOICED.getValueCode());
            salInvApplyDO.setInvDate(LocalDateTime.now());
            if(salInvApplyDO.getSoaOrSo()!=null && "SOA".equals(salInvApplyDO.getSoaOrSo())){
                soaList.forEach(soa -> {
                    if("1".equals(salInvApplyDO.getOpenType())){
                        soa.setInvApplyingAmt(soa.getInvApplyingAmt().subtract(salInvApplyDO.getInvAmt()));
                        soa.setInvApplyedAmt((soa.getInvApplyedAmt()==null?BigDecimal.ZERO:soa.getInvApplyedAmt()).add(salInvApplyDO.getInvAmt()));
                    }else {
                        soa.setInvApplyAmt(soa.getInvApplyAmt().subtract(salInvApplyDO.getInvAmt()));
                        soa.setInvApplyedAmt((soa.getInvApplyedAmt()==null?BigDecimal.ZERO:soa.getInvApplyedAmt()).add(salInvApplyDO.getInvAmt()));
                    }
                });
                salSoaRepo.saveAll(soaList);
            }
        }else if("reject".equals(param.getType())){
            //审批拒绝
            salInvApplyDO.setDocStatus(UdcEnum.SAL_BILL_STATUS_REJECTED.getValueCode());
            if("1".equals(salInvApplyDO.getOpenType()) && salInvApplyDO.getSoaOrSo()!=null && "SOA".equals(salInvApplyDO.getSoaOrSo())){
                soaList.forEach(soa -> {
                    soa.setInvApplyingAmt(soa.getInvApplyingAmt().subtract(salInvApplyDO.getInvAmt()));
                    soa.setInvApplyAmt(soa.getInvApplyAmt().add(salInvApplyDO.getInvAmt()));
                    soa.setInvApplyId(null);
                    soa.setInvApplyNo(null);
                });
                salSoaRepo.saveAll(soaList);
            }
        }else {
            throw new BusinessException("审批状态错误");
        }
        salInvApplyDO.setApprTime(LocalDateTime.now());
        if(param.getApprComment()!=null){
            salInvApplyDO.setApprComment(param.getApprComment());
        }
        if(param.getApprUserId()!=null){
            salInvApplyDO.setApprUserId(param.getApprUserId());
        }
        if(param.getApprUserName()!=null){
            salInvApplyDO.setApprUserName(param.getApprUserName());
        }
        salInvApplyRepo.save(salInvApplyDO);
        if(param.getInvSerialList()!=null && param.getInvSerialList().size()>0){
            List<SalInvSerialDO> list = new ArrayList<>();
            param.getInvSerialList().forEach(l -> {
                SalInvSerialDO invSerialDO = new SalInvSerialDO();
                BeanCopyUtil.beanCopy(l, invSerialDO);
                invSerialDO.setMasId(salInvApplyDO.getId());
                list.add(invSerialDO);
            });
            salInvSerialRepo.saveAll(list);
        }
        List<SalInvApplydRespVO> details = salInvApplydRepoProc.findBymasId(salInvApplyDO.getId()).fetch();
        if("reject".equals(param.getType()) && salInvApplyDO.getOpenType().equals("1")){
            //审批结束,为拒绝时反写销售单
            List<Long> sodid = details.stream().map(SalInvApplydRespVO::getSoDId).collect(Collectors.toList());
            List<SalSoDetailRespDTO> sodList = getSodListBySodId(sodid);
            List<SalSoDUpdateDTO> sodUpList = new ArrayList<>();
            log.info("开票拒绝反写入参:sodList-"+ JSON.toJSONString(sodList)+";details-"+JSON.toJSONString(details));
            sodList.forEach(sod -> {
                SalSoDUpdateDTO salSoDUpdateDTO = new SalSoDUpdateDTO();
                salSoDUpdateDTO.setSodId(sod.getSoDId());
                salSoDUpdateDTO.setInvingAmt(sod.getInvingAmt());
                salSoDUpdateDTO.setInvingQty(sod.getInvingQty());
                salSoDUpdateDTO.setNoinvAmt(sod.getNoinvAmt());
                salSoDUpdateDTO.setNoinvQty(sod.getNoinvQty());
                details.forEach(d -> {
                    if(sod.getSoDId().equals(d.getSoDId())) {
                        salSoDUpdateDTO.setInvingAmt(salSoDUpdateDTO.getInvingAmt().subtract(d.getApplyAmt()));
                        salSoDUpdateDTO.setInvingQty(salSoDUpdateDTO.getInvingQty().subtract(d.getApplyQty()));
                        salSoDUpdateDTO.setNoinvAmt(salSoDUpdateDTO.getNoinvAmt().add(d.getApplyAmt()));
                        salSoDUpdateDTO.setNoinvQty(salSoDUpdateDTO.getNoinvQty().add(d.getApplyQty()));
                    }
                });
                sodUpList.add(salSoDUpdateDTO);
            });
            if(sodUpList.size()>0){
                rmiOrderSalSoDService.querySalSoDetail(sodUpList);
            }
        }else if("approve".equals(param.getType())){
            //提交成功,反写销售单
            if(salInvApplyDO.getOpenType().equals("2")){
                List<Long> sodIdList = details.stream().map(SalInvApplydRespVO::getSoDId).collect(Collectors.toList());
                List<SalSoDetailRespDTO> sodList = getSodListBySodId(sodIdList);
                List<SalSoDUpdateDTO> sodUpList = new ArrayList<>();
                log.info("红票通过反写入参:sodList-"+ JSON.toJSONString(sodList)+";details-"+JSON.toJSONString(details));
                sodList.forEach(sod -> {
                    SalSoDUpdateDTO salSoDUpdateDTO = new SalSoDUpdateDTO();
                    salSoDUpdateDTO.setSodId(sod.getSoDId());
                    salSoDUpdateDTO.setInvedAmt(sod.getInvedAmt());
                    salSoDUpdateDTO.setInvedQty(sod.getInvedQty());
                    salSoDUpdateDTO.setNoinvAmt(sod.getNoinvAmt());
                    salSoDUpdateDTO.setNoinvQty(sod.getNoinvQty());
                    salSoDUpdateDTO.setInvDate(salInvApplyDO.getInvDate());
                    details.forEach(d -> {
                        if(sod.getSoDId().equals(d.getSoDId())) {
                            salSoDUpdateDTO.setInvedAmt(salSoDUpdateDTO.getInvedAmt().add(d.getApplyAmt()));
                            salSoDUpdateDTO.setInvedQty(salSoDUpdateDTO.getInvedQty().add(d.getApplyQty()));
                            salSoDUpdateDTO.setNoinvAmt(salSoDUpdateDTO.getNoinvAmt().subtract(d.getApplyAmt()));
                            salSoDUpdateDTO.setNoinvQty(salSoDUpdateDTO.getNoinvQty().subtract(d.getApplyQty()));
                        }
                    });
                    sodUpList.add(salSoDUpdateDTO);
                });
                if(sodUpList.size()>0){
                    rmiOrderSalSoDService.querySalSoDetail(sodUpList);
                }
            }else {
                List<Long> sodIdList = details.stream().map(SalInvApplydRespVO::getSoDId).collect(Collectors.toList());
                List<SalSoDetailRespDTO> sodList = getSodListBySodId(sodIdList);
                List<SalSoDUpdateDTO> sodUpList = new ArrayList<>();
                log.info("蓝票通过反写入参:sodList-"+ JSON.toJSONString(sodList)+";details-"+JSON.toJSONString(details));
                sodList.forEach(sod -> {
                    SalSoDUpdateDTO salSoDUpdateDTO = new SalSoDUpdateDTO();
                    salSoDUpdateDTO.setSodId(sod.getSoDId());
                    salSoDUpdateDTO.setInvingAmt(sod.getInvingAmt());
                    salSoDUpdateDTO.setInvingQty(sod.getInvingQty());
                    salSoDUpdateDTO.setInvedAmt(sod.getInvedAmt());
                    salSoDUpdateDTO.setInvedQty(sod.getInvedQty());
                    salSoDUpdateDTO.setInvDate(salInvApplyDO.getInvDate());
                    details.forEach(d -> {
                        if(sod.getSoDId().equals(d.getSoDId())) {
                            salSoDUpdateDTO.setInvedAmt(salSoDUpdateDTO.getInvedAmt().add(d.getApplyAmt()));
                            salSoDUpdateDTO.setInvedQty(salSoDUpdateDTO.getInvedQty().add(d.getApplyQty()));
                            salSoDUpdateDTO.setInvingAmt(salSoDUpdateDTO.getInvingAmt().subtract(d.getApplyAmt()));
                            salSoDUpdateDTO.setInvingQty(salSoDUpdateDTO.getInvingQty().subtract(d.getApplyQty()));
                        }
                    });
                    sodUpList.add(salSoDUpdateDTO);
                });
                if(sodUpList.size()>0){
                    rmiOrderSalSoDService.querySalSoDetail(sodUpList);
                }
            }
        }
        return ApiResult.ok();
    }

    /**
     * 根据明细id获取销售单明细
     */
    private List<SalSoDetailRespDTO> getSodListBySodId(List<Long> sodIds){
        List<SalSoDetailRespDTO> sodList = new ArrayList<>();
//        if(sodIds.size()>0){
//            SalSoDetailQueryDTO salSoDetailQueryDTO = new SalSoDetailQueryDTO();
//            salSoDetailQueryDTO.setSoDIdList(sodIds);
//            salSoDetailQueryDTO.setSize(10000);
//            ApiResult<PagingVO<SalSoDetailRespDTO>> apiResult = rmiOrderSalSoService.querySalSoDetail(salSoDetailQueryDTO);
//            if(apiResult.getCode()!=200){
//                throw new BusinessException(apiResult.getMsg());
//            }
//            sodList = apiResult.getData().getRecords();
//        }
        return sodList;
    }
}
