package com.elitesland.yst.production.sale.service.shop;

import com.elitesland.yst.production.sale.api.service.shop.BipAddressService;
import com.elitesland.yst.production.sale.api.service.shop.BipCustUserBindService;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipAddressCreateParam;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipAddressUpdateParam;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipAddressVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.common.model.CurrentUserDTO;
import com.elitesland.yst.production.sale.convert.shop.BipAddressConvert;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.core.service.UserService;
import com.elitesland.yst.production.sale.repo.CrmCustRepoProc;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgAddrService;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.yst.production.support.provider.org.dto.*;
import com.elitesland.yst.production.support.provider.org.param.*;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author makejava
 * @since 2021-09-01 14:38:17
 */
@Service
@RequiredArgsConstructor
public class BipAddressServiceImpl extends BaseServiceImpl implements BipAddressService {

    /**
     * 已删除状态
     */
    private static final int DELETE_FLAG_1 = 1;
    /**
     * 未删除状态
     */
    private static final int DELETE_FLAG_0 = 0;
    /**
     * 默认状态
     */
    private static final int IS_DEFAULT = 1;
    /**
     * 非默认状态
     */
    private static final int NOT_DEFAULT = 0;

    private final CrmCustRepoProc crmCustRepoPro;

    private final RmiOrgAddrService rmiOrgAddrService;

    private final BipCustUserBindService bipCustUserBindService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long createAddress(BipAddressCreateParam param) {
        //转换
        BipAddressConvert convert = BipAddressConvert.INSTANCE;
        BipAddressUpdateParam bipAddressUpdateParam = convert.creatParamToUpdate(param);
        bipAddressUpdateParam.setAddressType(UdcEnum.ORG_ADDRESS_TYPE_RECEIVE.getValueCode());
        Long id = updateAddress(bipAddressUpdateParam);

        ApiResult<OrgAddrDetailsRpcDTO> addrByAddrNo = rmiOrgAddrService.findAddrByAddrNo(id);

        OrgAddrAddressRpcDTO newAddr = null;

        List<OrgAddrAddressRpcDTO> addressVos = addrByAddrNo.getData().getOrgAddrAddressVos();
        Optional<OrgAddrAddressRpcDTO> first = addressVos.stream()
                .filter(addr -> param.getMobile().equals(addr.getMobile()) &&
                                param.getProvince().equals(addr.getProvince()) &&
                                param.getCity().equals(addr.getCity()) &&
                                param.getCounty().equals(addr.getCounty()) &&
                                param.getDetailAddr().equals(addr.getDetailAddr()))
                .findFirst();

        if (first.isPresent()) {
            newAddr = first.get();
        } else {
            throw new BusinessException("未找到新增地址");
        }

        return newAddr.getId();
    }

    public List<OrgAddrAddressRpcSaveParam> convertAddrAddressVos(List<OrgAddrAddressRpcDTO> params){
        BipAddressConvert convert = BipAddressConvert.INSTANCE;
        if (CollectionUtils.isEmpty(params)) {
            return null;
        }

        List<OrgAddrAddressRpcSaveParam> saveParams = new LinkedList<>();
        for (OrgAddrAddressRpcDTO param : params) {
            OrgAddrAddressRpcSaveParam orgAddrAddressRpcSaveParam = convert.orgAddrAddressRpcDTOToOrgAddrAddressRpcSaveParam(param);
            saveParams.add(orgAddrAddressRpcSaveParam);
        }
        return saveParams;

    }
    public List<OrgAddrBankAccRpcSaveParam> convertAddrBankAccVos(List<OrgAddrBankAccRpcDTO> params){
        BipAddressConvert convert = BipAddressConvert.INSTANCE;
        if (CollectionUtils.isEmpty(params)) {
            return null;
        }

        List<OrgAddrBankAccRpcSaveParam> saveParams = new LinkedList<>();
        for (OrgAddrBankAccRpcDTO param : params) {
            OrgAddrBankAccRpcSaveParam orgAddrBankAccRpcSaveParam = convert.OrgAddrBankAccRpcDTOToOrgAddrAddressRpcSaveParam(param);
            saveParams.add(orgAddrBankAccRpcSaveParam);
        }
        return saveParams;
    }
    public List<OrgAddrQualifyRpcSaveParam> convertAddrQualifyVos(List<OrgAddrQualifyRpcDTO> params){
        BipAddressConvert convert = BipAddressConvert.INSTANCE;
        if (CollectionUtils.isEmpty(params)) {
            return null;
        }

        List<OrgAddrQualifyRpcSaveParam> saveParams = new LinkedList<>();
        for (OrgAddrQualifyRpcDTO param : params) {
            OrgAddrQualifyRpcSaveParam orgAddrQualifyRpcSaveParam = convert.OrgAddrQualifyRpcDTOToOrgOrgAddrQualifyRpcSaveParam(param);
            saveParams.add(orgAddrQualifyRpcSaveParam);
        }
        return saveParams;
    }



    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long deleteAddressById(Long id) {
        OrgAddrDetailsRpcDTO orgAddrDetailsRpcDTO = findaddr();
        List<OrgAddrAddressRpcDTO> orgAddrAddressVos = orgAddrDetailsRpcDTO.getOrgAddrAddressVos();
        List<OrgAddrAddressRpcDTO> collect = orgAddrAddressVos.stream().filter(org -> !id.equals(org.getId())).collect(Collectors.toList());
        orgAddrDetailsRpcDTO.setOrgAddrAddressVos(collect);
        BipAddressConvert convert = BipAddressConvert.INSTANCE;
        OrgAddrRpcSaveParam orgAddrRpcSaveParam = convert.rpcDTOToRpcParam(orgAddrDetailsRpcDTO);

        List<OrgAddrAddressRpcDTO> orgAddrAddressNewVos = orgAddrDetailsRpcDTO.getOrgAddrAddressVos();
        List<OrgAddrAddressRpcSaveParam> orgAddrAddressRpcSaveParams = convertAddrAddressVos(orgAddrAddressNewVos);
        orgAddrRpcSaveParam.setOrgAddrAddressSaveParams(orgAddrAddressRpcSaveParams);

        List<OrgAddrBankAccRpcDTO> orgAddrBankAccVos = orgAddrDetailsRpcDTO.getOrgAddrBankAccVos();
        List<OrgAddrBankAccRpcSaveParam> orgAddrBankAccRpcSaveParams = convertAddrBankAccVos(orgAddrBankAccVos);
        orgAddrRpcSaveParam.setOrgAddrBankAccSaveParams(orgAddrBankAccRpcSaveParams);

        List<OrgAddrQualifyRpcDTO> orgAddrQualifyVos = orgAddrDetailsRpcDTO.getOrgAddrQualifyVos();
        List<OrgAddrQualifyRpcSaveParam> orgAddrQualifyRpcSaveParams = convertAddrQualifyVos(orgAddrQualifyVos);
        orgAddrRpcSaveParam.setOrgAddrQualifySaveParams(orgAddrQualifyRpcSaveParams);

        rmiOrgAddrService.orgAddrSaveOrUpdate(orgAddrRpcSaveParam);
        return id;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long updateAddress(BipAddressUpdateParam param) {

        BipAddressConvert convert = BipAddressConvert.INSTANCE;
        OrgAddrDetailsRpcDTO orgAddrDetailsRpcDTO = findaddr();
        if(orgAddrDetailsRpcDTO==null){
            throw new BusinessException("地址薄DTO为空请检查!!");
        }
        List<OrgAddrAddressRpcDTO> orgAddrAddressVos = orgAddrDetailsRpcDTO.getOrgAddrAddressVos();
        OrgAddrAddressRpcDTO orgAddrAddressRpcDTO = convert.updateParamToRpcDTO(param);
        ArrayList<OrgAddrAddressRpcDTO> orgAddrAddressRpcDTOS = new ArrayList<>();
        //判断默认
        if (orgAddrAddressRpcDTO.getDefaultFlag()){
            for (OrgAddrAddressRpcDTO orgAddrAddressVo : orgAddrAddressVos) {
                if (orgAddrAddressVo.getDefaultFlag()) {
                    orgAddrAddressVo.setDefaultFlag(false);
                    orgAddrAddressRpcDTOS.add(orgAddrAddressVo);
                    continue;
                }
                orgAddrAddressRpcDTOS.add(orgAddrAddressVo);
            }
        }

        // 没有地址时，设置新增的为默认
        if (CollectionUtils.isEmpty(orgAddrAddressVos)){
            orgAddrAddressRpcDTO.setDefaultFlag(true);
        }

        //先删除
        if (param.getId()!=null) {
            orgAddrAddressVos = orgAddrAddressVos.stream().filter(org -> !param.getId().equals(org.getId())).collect(Collectors.toList());
        }
        orgAddrAddressRpcDTO.setAddressType(UdcEnum.ORG_ADDRESS_TYPE_RECEIVE.getValueCode());
        orgAddrAddressVos.add(orgAddrAddressRpcDTO);

        OrgAddrRpcSaveParam orgAddrRpcSaveParam = convert.rpcDTOToRpcParam(orgAddrDetailsRpcDTO);

        List<OrgAddrAddressRpcSaveParam> orgAddrAddressRpcSaveParams = convertAddrAddressVos(orgAddrAddressVos);
        orgAddrRpcSaveParam.setOrgAddrAddressSaveParams(orgAddrAddressRpcSaveParams);

        List<OrgAddrBankAccRpcDTO> orgAddrBankAccVos = orgAddrDetailsRpcDTO.getOrgAddrBankAccVos();
        List<OrgAddrBankAccRpcSaveParam> orgAddrBankAccRpcSaveParams = convertAddrBankAccVos(orgAddrBankAccVos);
        orgAddrRpcSaveParam.setOrgAddrBankAccSaveParams(orgAddrBankAccRpcSaveParams);

        List<OrgAddrQualifyRpcDTO> orgAddrQualifyVos = orgAddrDetailsRpcDTO.getOrgAddrQualifyVos();
        List<OrgAddrQualifyRpcSaveParam> orgAddrQualifyRpcSaveParams = convertAddrQualifyVos(orgAddrQualifyVos);
        orgAddrRpcSaveParam.setOrgAddrQualifySaveParams(orgAddrQualifyRpcSaveParams);
        ApiResult<Long> apiResult = rmiOrgAddrService.orgAddrSaveOrUpdate(orgAddrRpcSaveParam);
        if (apiResult==null) {
            throw new BusinessException("更新或保存后未返回!!");
        }
        return apiResult.getData();
    }

    @Override
    public BipAddressVO findById(Long id) {
        BipAddressConvert convert = BipAddressConvert.INSTANCE;
//        OrgAddrDetailsRpcDTO orgAddrDetailsRpcDTO = findaddr();
//        List<OrgAddrAddressRpcDTO> orgAddrAddressVos = orgAddrDetailsRpcDTO.getOrgAddrAddressVos();
//        Optional<OrgAddrAddressRpcDTO> first = orgAddrAddressVos.stream().filter(org -> id.equals(org.getId())).findFirst();
//        if (first.isPresent()) {
//            OrgAddrAddressRpcDTO orgAddrAddressRpcDTO = first.get();
//            return convert.rpcDTOToVO(orgAddrAddressRpcDTO);
//        }else {
//            throw new BusinessException("该用户该id没有地址信息");
//        }
        OrgAddressRpcDtoParam orgAddressRpcDtoParam = new OrgAddressRpcDtoParam();
        orgAddressRpcDtoParam.setIds(Arrays.asList(id));
        List<OrgAddressRpcDTO> addrAddressListByParam = rmiOrgAddrService.findAddrAddressListByParam(orgAddressRpcDtoParam);
        if (CollectionUtils.isEmpty(addrAddressListByParam)) {
            return null;
        }
        return convert.addressRpcDTOToVO(addrAddressListByParam.get(0));
    }

    @Override
    public List<BipAddressVO> findByAccountId() {
        BipAddressConvert convert = BipAddressConvert.INSTANCE;
        OrgAddrDetailsRpcDTO orgAddrDetailsRpcDTO = findaddr();
        if (orgAddrDetailsRpcDTO!=null) {
            List<OrgAddrAddressRpcDTO> orgAddrAddressVos = orgAddrDetailsRpcDTO.getOrgAddrAddressVos();
            if (!CollectionUtils.isEmpty(orgAddrAddressVos)) {
                List<OrgAddrAddressRpcDTO> collect = orgAddrAddressVos.stream().filter(org -> UdcEnum.ORG_ADDRESS_TYPE_RECEIVE.getValueCode().equals(org.getAddressType())).collect(Collectors.toList());
                ArrayList<BipAddressVO> bipAddressVOS = new ArrayList<>();
                for (int i = 0; i < collect.size(); i++) {
                    if (collect.get(i).getDefaultFlag()) {
                        //获得默认地址
                        OrgAddrAddressRpcDTO defaultBipAddress = collect.get(i);
                        //移除原位置默认地址
                        collect.remove(i);
                        //将默认地址放入集合头部
                        collect.add(0,defaultBipAddress);
                    }

                }
                for (OrgAddrAddressRpcDTO orgAddrAddressRpcDTO : collect) {
                    BipAddressVO bipAddressVO = convert.rpcDTOToVO(orgAddrAddressRpcDTO);
                    bipAddressVOS.add(bipAddressVO);
                }
                return bipAddressVOS;
            }
        }

        return null;

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long updateDefaultById(Long id) {
        BipAddressConvert convert = BipAddressConvert.INSTANCE;

        OrgAddrDetailsRpcDTO orgAddrDetailsRpcDTO = findaddr();
        List<OrgAddrAddressRpcDTO> orgAddrAddressVos = orgAddrDetailsRpcDTO.getOrgAddrAddressVos();
        List<OrgAddrAddressRpcDTO> collect = orgAddrAddressVos.stream().filter(org -> id.equals(org.getId())).collect(Collectors.toList());
        OrgAddrAddressRpcDTO orgAddrAddressRpcDTO = collect.get(0);
        BipAddressUpdateParam bipAddressUpdateParam = convert.rpcDTOToUpdateParam(orgAddrAddressRpcDTO);
        bipAddressUpdateParam.setDefaultFlag(true);
        return updateAddress(bipAddressUpdateParam);

    }


    /**
     * 检查当前用户并返回用户信息
     *
     * @return CurrentUserDTO--当前用户信息
     */

    private static CurrentUserDTO checkUser() {
        CurrentUserDTO currentUser = UserService.currentUser();
        if (currentUser == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "无法到获取当前用户");
        }
        return currentUser;
    }

    @Transactional(rollbackFor = Exception.class)
   public OrgAddrDetailsRpcDTO findaddr(){
        //检查并返回当前用户
        CurrentUserDTO currentUser = checkUser();
        Long custAccountId = currentUser.getUserId();
        Long custId = bipCustUserBindService.getCustIdByUserId(custAccountId).getData();
        if(custId==null){
            throw new BusinessException("游客登录 请先绑定客户身份");
        }
        //获取地址号码
        Long addrNo = crmCustRepoPro.getAddrNo(custId);
        //如果为空说明支撑域没有数据  那么就新增一条
        if (addrNo==null) {
            OrgAddrRpcSaveParam orgAddrRpcSaveParam = new OrgAddrRpcSaveParam();
            orgAddrRpcSaveParam.setAddrType(UdcEnum.ORG_ADDR_TYPE_CUST.getValueCode());
            orgAddrRpcSaveParam.setAddrName(currentUser.getDetail().getUsername());
            //新增
            ApiResult<Long> addrNoNew = rmiOrgAddrService.orgAddrSaveOrUpdate(orgAddrRpcSaveParam);
            //将地址号维护到客户列表
            Boolean aBoolean = crmCustRepoPro.existsCode(null, custAccountId);
            if(!aBoolean){
                crmCustRepoPro.updateAddrNo(custAccountId,addrNoNew.getData());
            }
        }
        //获取 OrgAddrDetailsRpcDTO
        ApiResult<OrgAddrDetailsRpcDTO> apiResult = rmiOrgAddrService.findAddrByAddrNo(addrNo);
        if(apiResult.getData()==null){
            throw new BusinessException("地址薄DTO为空请检查!!");
        }
        return apiResult.getData();
    }

}


