package com.elitesland.yst.production.sale.service.shop;

import com.elitesland.yst.production.sale.api.service.shop.BipOrderBackDService;
import com.elitesland.yst.production.sale.api.service.shop.BipOrderBackService;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipOrderBackDParmVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipOrderBackParmVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipOrderBackDRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipOrderBackRespVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipOrderBackDSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipOrderBackSaveVO;
import com.elitesland.yst.production.sale.convert.shop.BipOrderBackConvert;
import com.elitesland.yst.production.sale.convert.shop.BipOrderBackDConvert;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.entity.BipOrderBackDDO;
import com.elitesland.yst.production.sale.entity.BipOrderBackDO;
import com.elitesland.yst.production.sale.entity.BipOrderDDO;
import com.elitesland.yst.production.sale.entity.QBipOrderBackDDO;
import com.elitesland.yst.production.sale.repo.shop.BipOrderBackDRepo;
import com.elitesland.yst.production.sale.repo.shop.BipOrderBackRepo;
import com.elitesland.yst.production.sale.repo.shop.BipOrderDRepo;
import com.elitesland.yst.production.sale.util.BeanUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.exception.BusinessException;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/08/21/17:22
 * @Description:
 */
@Service
public class BipOrderBackDServiceImpl extends BaseServiceImpl implements BipOrderBackDService {

    @Autowired
    private BipOrderBackDRepo bipOrderBackDRepo;

    @Autowired
    private BipOrderDRepo bipOrderDRepo;

    @Autowired
    private BipOrderBackRepo bipOrderBackRepo;

    @Autowired
    private BipOrderBackService bipOrderBackService;


    @Autowired
    protected JPAQueryFactory jpaQueryFactory;

    private final QBipOrderBackDDO qBipOrderBackDDO=QBipOrderBackDDO.bipOrderBackDDO;



    public void saveBipOrderDBackD(List<BipOrderBackDSaveVO> bipOrderBackSaveDVOList){

        BipOrderBackSaveVO bipOrderBackSaveVO=BipOrderBackConvert.INSTANCE.DSaveTosave(bipOrderBackSaveDVOList.get(0));

        //@todo 不考虑赠品问题
        bipOrderBackSaveDVOList.stream().forEach(bipOrderBackDParmVO -> {
//         补充当前登录人以及登录人客户关联公司信息
//            bipOrderBackDParmVO.getd
        });


    }

    /**
        * @Description: 分页查询
        * @Param: [bipOrderBackDParmVO]
        * @return: com.elitescloud.cloudt.common.base.PagingVO
        * @Author: wangyinghao
        * @Date: 2021/8/22
        */
    @Override
    public PagingVO findBipOrderBackPage(BipOrderBackDParmVO bipOrderBackDParmVO){
        Page<BipOrderBackDDO> page= bipOrderBackDRepo.findAll(where(bipOrderBackDParmVO),bipOrderBackDParmVO.getPageRequest());
        List<BipOrderBackDRespVO> resList=page.getContent().stream().map(BipOrderBackDConvert.INSTANCE::doToresp).collect(Collectors.toList());
        return PagingVO.<BipOrderBackDRespVO>builder()
                .total(page.getTotalElements())
                .records(resList)
                .build();
    }


    /**
     * @Description: 查询--不分页
     * @Param: [bipOrderBackDParmVO]
     * @return: com.elitescloud.cloudt.common.base.PagingVO
     * @Author: wangyinghao
     * @Date: 2021/8/22
     */
    @Override
    public  List<BipOrderBackDRespVO> findBipOrderBackD(BipOrderBackDParmVO bipOrderBackDParmVO){
        List<BipOrderBackDDO> list= jpaQueryFactory.select(qBipOrderBackDDO)
                .from(qBipOrderBackDDO)
                .where(where(bipOrderBackDParmVO))
                .fetch();
        List<BipOrderBackDRespVO> resList=list.stream().map(BipOrderBackDConvert.INSTANCE::doToresp).collect(Collectors.toList());
        return resList;
    }


    /**
        * @Description: 更新退货单明细
        * @Param: [bipOrderBackDSaveVOS]
        * @return: void
        * @Author: wangyinghao
        * @Date: 2021/8/22
        */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateBipOrderBackD(BipOrderBackDSaveVO bipOrderBackDSaveVO){

        if(bipOrderBackDSaveVO.getId()==null){
            throw new BusinessException("明细ID不能为空!");
        }
        BipOrderBackDDO bipOrderBackDDO=bipOrderBackDRepo.findById(bipOrderBackDSaveVO.getId()).get();

        BipOrderBackDConvert.INSTANCE.copySaveToDo(bipOrderBackDSaveVO,bipOrderBackDDO);

//        BeanUtil.beanCopy(bipOrderBackDSaveVO,bipOrderBackDDO);
        bipOrderBackDRepo.save(bipOrderBackDDO);

    }

    /***
     * @Description: 分页查询
     * @Param: [bipOrderBackParmVO]
     * @return: com.elitescloud.cloudt.common.base.PagingVO
     * @Author: wangyinghao
     * @Date: 2021/8/22
     */
    public PagingVO findBipOrderDBackPage(BipOrderBackDParmVO bipOrderBackParmVO){
        Page<BipOrderBackDDO> page= bipOrderBackDRepo.findAll(where(bipOrderBackParmVO),bipOrderBackParmVO.getPageRequest());
        List<BipOrderBackDRespVO> resList=page.getContent().stream().map(BipOrderBackDConvert.INSTANCE::doToresp).collect(Collectors.toList());
        return PagingVO.<BipOrderBackDRespVO>builder()
                .total(page.getTotalElements())
                .records(resList)
                .build();
    }

    /***
        * @Description: 验证明细状态是否一致
        * @Param: [list]
        * @return: java.lang.String
        * @Author: wangyinghao
        * @Date: 2021/8/22
        */
    public String validStatusCompatibility(List<BipOrderBackDDO> list){
        String status="";
        if(list==null||list.isEmpty()){
            return "no";
        }
        boolean compatibility=true;
       for(int i=0;i<list.size();i++){
           if(StringUtils.isBlank(list.get(i).getStatus())){
               throw new BusinessException("退货单状态不能为空!");
           }
           if(i==0){
               status=list.get(i).getStatus();
           }else{
               compatibility=status.equals(list.get(i).getStatus());
               if(!compatibility){
                   break;
               }
           }
       }
       if(compatibility){
           return status;
       }
       return "no";
    }


    /**
        * @Description: 删除退货单--通过id
        * @Param: [ids]
        * @return: void
        * @Author: wangyinghao
        * @Date: 2021/8/22
        */
    @Override
    public void deleteBipOrderBackDById(List<Long> ids){
        bipOrderBackDRepo.deleteOrderBackDByIds(ids);
    }



    public Predicate where(BipOrderBackDParmVO bipOrderBackDParmVO) {

        Predicate predicate=qBipOrderBackDDO.isNotNull();
        if(Objects.nonNull(bipOrderBackDParmVO)){
            if(StringUtils.isNotBlank(bipOrderBackDParmVO.getOrderBackDocNo())){
                predicate= ExpressionUtils.and(predicate,qBipOrderBackDDO.orderBackDocNo.like("%" + bipOrderBackDParmVO.getOrderBackDocNo() + "%"));

            }

            if(Objects.nonNull(bipOrderBackDParmVO.getOrderBackId())){
                predicate= ExpressionUtils.and(predicate,qBipOrderBackDDO.orderBackId.like("%" + bipOrderBackDParmVO.getOrderBackId() + "%"));

            }

        }
        return predicate;
    }


    /**
     * 根据orderID 返回退货单子单详情
     * @param orderIds
     */
    public void  findDetailInfoByorderDId(List<Long> orderIds){
        List<BipOrderDDO> bipOrderDDOS=bipOrderDRepo.findAllById(orderIds);
        for(BipOrderDDO bipOrderDDO:bipOrderDDOS){
            bipOrderDDO.getItmeBrandCode();
            bipOrderDDO.getItemBrand();
            bipOrderDDO.getPayAmt();
            bipOrderDDO.getItemSpec();
        }
    }
}
