package com.elitesland.yst.production.sale.service.shop;

import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.core.security.util.DataAuthJpaUtil;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitesland.yst.production.order.param.SalDoReturnTOBSaveDTO;
import com.elitesland.yst.production.sale.api.service.shop.BipCompanyManageService;
import com.elitesland.yst.production.sale.api.service.shop.BipOrderBackDService;
import com.elitesland.yst.production.sale.api.service.shop.BipOrderBackService;
import com.elitesland.yst.production.sale.api.service.shop.BipOrderBackToOmsServicei;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipOrderBackDParmVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipOrderBackParmVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.app.BipOrderBackUserParmVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipCompanyManageRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipItemSkuAttrRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipOrderBackDRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipOrderBackRespVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipOrderBackDSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipOrderBackLogistSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipOrderBackSaveVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.common.model.CurrentUserDTO;
import com.elitesland.yst.production.sale.convert.shop.BipOrderBackConvert;
import com.elitesland.yst.production.sale.convert.shop.BipOrderBackDConvert;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.core.service.UserService;
import com.elitesland.yst.production.sale.dto.save.BipOrderBackRpcDto;
import com.elitesland.yst.production.sale.entity.*;
import com.elitesland.yst.production.sale.ext.cpcn.resp.CPCN5021Resp;
import com.elitesland.yst.production.sale.repo.shop.*;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgOuService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysNextNumberService;
import com.elitesland.yst.production.sale.workflow.ProcDefKey;
import com.elitesland.yst.production.support.provider.org.dto.OrgOuRpcDTO;
import com.elitesland.yst.production.support.provider.org.param.OrgOuRpcDtoParam;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/08/21/17:22
 * @Description:
 */
@Service
@Slf4j
@RequiredArgsConstructor
public class BipOrderBackServiceImpl extends BaseServiceImpl implements BipOrderBackService {

    @Autowired
    private BipOrderBackRepo bipOrderBackRepo;

    @Autowired
    private BipOrderBackRepoProc bipOrderBackRepoProc;

    @Autowired
    private BipOrderBackDRepo bipOrderBackDRepo;

    @Autowired
    private BipCustUserBindRepoProc bipCustUserBindRepoProc;
    @Autowired
    private BipOrderDRepoProc bipOrderDRepoProc;

    @Autowired
    private BipOrderDRepo bipOrderDRepo;
    @Autowired
    private BipOrderRepo bipOrderRepo;

    @Autowired
    private BipOrderBackDService bipOrderBackDService;

    @Autowired
    private BipItemSkuRepo bipItemSkuRepo;

    @Autowired
    private BipItemRepo bipItemRepo;

    @Autowired
    private RmiOrgOuService rmiOrgOuService;

    @Autowired
    private UdcProvider udcProvider;

    @Autowired
    private BipCompanyManageService bipCompanyManageService;

    @Autowired
    private BipOrderBackToOmsServiceimpl bipOrderBackToOmsServiceimpl;

    @Autowired
    private BipAddressServiceImpl bipAddressService;

    @Autowired
    private BipOrderBackServiceImpl bipOrderBackService;

    @Autowired
    private BipSendOrderErrLogRepo bipSendOrderErrLogRepo;

    @Autowired
    private BipOrderBackToOmsServicei bipOrderBackToOmsServicei;

//    @DubboReference(check = false, timeout = 60000)
//    private SalSoReturnRpcService salSoReturnRpcService;
//
//    @DubboReference(check = false, timeout = 60000)
//    private SalDoRpcService salDoRpcService;
//
//
//    @DubboReference
//    private SalDoReturnRpcService salDoReturnRpcService;

    private final RmiSysNextNumberService rmiSysNextNumberService;

//    private final WorkflowService workflowService;

//    @Value("${cpcn.sale.reurnNoticUrl}")
    private String returnNoticUrl;

    private final TransactionTemplate transactionTemplate;

    private final QBipOrderBackDO qBipOrderBackDO = QBipOrderBackDO.bipOrderBackDO;

    private final QBipOrderBackDDO qBipOrderBackDDO = QBipOrderBackDDO.bipOrderBackDDO;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void createOrderBack(BipOrderBackSaveVO bipOrderBackSaveVO) {

        if (bipOrderBackSaveVO.getOrderId() == null) {
            throw new BusinessException("订单ID不能为空!");
        }
        if (bipOrderBackSaveVO.getOrderDocNo() == null) {
            throw new BusinessException("订单编号不能为空!");
        }

        List<BipOrderBackDSaveVO> bipOrderBackDSaveVOS = bipOrderBackSaveVO.getBipOrderBackDSaveVOS();

        List<Long> orderDids = bipOrderBackDSaveVOS.stream().map(BipOrderBackDSaveVO::getOrderDId).distinct().collect(Collectors.toList());


        //非一件代发的要生成的退货单明细
        List<BipOrderBackSaveVO> bipOrderBackSaveVOS = new ArrayList<>();

        Map<String, List<BipItemSkuDO>> shipOneGroupMap = spliteOrderBackD(orderDids);

        List<BipItemSkuDO> shipOneNoList = shipOneGroupMap.get(Boolean.FALSE.toString());
//        List<Long> skuIds=shipOneNoList.stream().map(bipItemSkuDO -> {
//            return bipItemSkuDO.getId();
//        }).distinct().collect(Collectors.toList());
//        List<Long> orderdIds=findOrderBackDBySkuId(skuIds,bipOrderBackSaveVO.getOrderId());
//
//        BipOrderBackSaveVO shipNoBipOrderBackSaveVO=new BipOrderBackSaveVO();
//
//        shipNoBipOrderBackSaveVO.setOrderId(bipOrderBackSaveVO.getOrderId());
//        shipNoBipOrderBackSaveVO.setOrderDocNo(bipOrderBackSaveVO.getOrderDocNo());
//
//        List<BipOrderBackDSaveVO> shipNobipOrderBackDSaveVOS=bipOrderBackDSaveVOS.stream().filter(bipOrderBackDSaveVO -> {
//             return orderdIds.contains(bipOrderBackDSaveVO.getOrderDId());
//        }).collect(Collectors.toList());
//        shipNoBipOrderBackSaveVO.setBipOrderBackDSaveVOS(shipNobipOrderBackDSaveVOS);
        log.info("shipOneNoList---------:"+JSON.toJSONString(shipOneNoList));
        log.info("bipOrderBackSaveVO----------:"+JSON.toJSONString(bipOrderBackSaveVO));
        if(null != shipOneNoList && !shipOneNoList.isEmpty()){
            BipOrderBackSaveVO shipOneNoBipOrderBackSaveVO1 = createSpliteOrderBack(shipOneNoList, bipOrderBackSaveVO);
            bipOrderBackSaveVOS.add(shipOneNoBipOrderBackSaveVO1);
            log.info("非一件代发退货单信息:--" + JSON.toJSONString(shipOneNoBipOrderBackSaveVO1));
        }

        List<BipItemSkuDO> shipOneList = shipOneGroupMap.get(Boolean.TRUE.toString());
        if (shipOneList != null && !shipOneList.isEmpty()) {
            Map<String, List<BipItemSkuDO>> shipOneGroupMpa = shipOneList.stream().collect(Collectors.groupingBy(BipItemSkuDO::getSupplier));

            for (String supplier : shipOneGroupMpa.keySet()) {
                List<BipItemSkuDO> bipItemSkuDOS = shipOneGroupMpa.get(supplier);
                BipOrderBackSaveVO shipOneBipOrderBackSaveVO = createSpliteOrderBack(bipItemSkuDOS, bipOrderBackSaveVO);

                log.info("一件代发退货单信息:--" + JSON.toJSONString(shipOneBipOrderBackSaveVO));
                bipOrderBackSaveVOS.add(shipOneBipOrderBackSaveVO);
            }
        }


        List<Long> orderBackIds = new ArrayList<>();
        for (BipOrderBackSaveVO backSaveVO : bipOrderBackSaveVOS) {
            saveBipOrderBack(backSaveVO, orderBackIds);
        }

        //同步订单中心
        bipOrderBackToOmsServiceimpl.sendToOms(orderBackIds);
    }

    public ApiResult subBipOrderBack(BipOrderBackSaveVO bipOrderBackSaveVO) {
        if (bipOrderBackSaveVO.getOrderId() == null) {
            throw new BusinessException("订单ID不能为空!");
        }
        if (bipOrderBackSaveVO.getOrderDocNo() == null) {
            throw new BusinessException("订单编号不能为空!");
        }
        //查询订单中心订单状态是否已发货
        List<String> docNoList = new ArrayList<>();
        docNoList.add(bipOrderBackSaveVO.getOrderDocNo());
//        ApiResult<List<SalSoStatusRespDTO>> orderStatusList = salDoRpcService.querySalSoStatus(docNoList);
//        List<SalSoStatusRespDTO> soStatus = orderStatusList.getData();
//        if(null == soStatus || StringUtils.isBlank(soStatus.get(0).getDocStatus())){
//            throw new BusinessException("发货信息为空!");
//        }
//        SalSoStatusRespDTO statusRespDTO = soStatus.get(0);
//        if(statusRespDTO.getDocStatus().equals("PARTSHIP") || statusRespDTO.getDocStatus().equals("SHIP") || statusRespDTO.getDocStatus().equals("SIGN")){
//            throw new BusinessException("订单已发货,不能进行退款操作!");
//        }
        //更新订单状态
        Optional<BipOrderDO> optionalBipOrderDO = bipOrderRepo.findById(bipOrderBackSaveVO.getOrderId());
        if(null == optionalBipOrderDO || optionalBipOrderDO.isEmpty()){
            throw new BusinessException("订单信息为空!");
        }
        BipOrderDO orderDo = optionalBipOrderDO.get();
        orderDo.setStatus("cancelled");
        bipOrderRepo.save(orderDo);

        List<BipOrderBackDSaveVO> bipOrderBackDSaveVOS = bipOrderBackSaveVO.getBipOrderBackDSaveVOS();
        List<Long> orderDids = bipOrderBackDSaveVOS.stream().map(BipOrderBackDSaveVO::getOrderDId).distinct().collect(Collectors.toList());
        //非一件代发的要生成的退货单明细
        List<BipOrderBackSaveVO> bipOrderBackSaveVOS = new ArrayList<>();
        Map<String, List<BipItemSkuDO>> shipOneGroupMap = spliteOrderBackD(orderDids);
        List<BipItemSkuDO> shipOneNoList = shipOneGroupMap.get(Boolean.FALSE.toString());
        log.info("shipOneNoList---------:"+JSON.toJSONString(shipOneNoList));
        log.info("bipOrderBackSaveVO----------:"+JSON.toJSONString(bipOrderBackSaveVO));
        if(null != shipOneNoList && !shipOneNoList.isEmpty()){
            BipOrderBackSaveVO shipOneNoBipOrderBackSaveVO1 = createSpliteOrderBack(shipOneNoList, bipOrderBackSaveVO);
            bipOrderBackSaveVOS.add(shipOneNoBipOrderBackSaveVO1);
            log.info("非一件代发退货单信息:--" + JSON.toJSONString(shipOneNoBipOrderBackSaveVO1));
        }
        List<BipItemSkuDO> shipOneList = shipOneGroupMap.get(Boolean.TRUE.toString());
        if (shipOneList != null && !shipOneList.isEmpty()) {
            Map<String, List<BipItemSkuDO>> shipOneGroupMpa = shipOneList.stream().collect(Collectors.groupingBy(bipItemSkuDO -> {
                return bipItemSkuDO.getSupplier();
            }));
            for (String supplier : shipOneGroupMpa.keySet()) {
                List<BipItemSkuDO> bipItemSkuDOS = shipOneGroupMpa.get(supplier);
                BipOrderBackSaveVO shipOneBipOrderBackSaveVO = createSpliteOrderBack(bipItemSkuDOS, bipOrderBackSaveVO);
                log.info("一件代发退货单信息:--" + JSON.toJSONString(shipOneBipOrderBackSaveVO));
                bipOrderBackSaveVOS.add(shipOneBipOrderBackSaveVO);
            }
        }
        List<Long> orderBackIds = new ArrayList<>();
        BipOrderBackDO bipOrderBackDO = new BipOrderBackDO();
        log.info("bipOrderBackSaveVOS:----------"+JSON.toJSONString(bipOrderBackSaveVOS));
        for (BipOrderBackSaveVO backSaveVO : bipOrderBackSaveVOS) {
            bipOrderBackDO = saveSubBipOrderBack(backSaveVO, orderBackIds);
        }

        if(null == bipOrderBackDO || null == bipOrderBackDO.getId()){
            throw new BusinessException("退款单信息为空");
        }

        //同步订单中心
        bipOrderBackToOmsServiceimpl.sendToOms(orderBackIds);
        //退款操作
        BipOrderBackRpcDto bipOrderBackRpcDto = new BipOrderBackRpcDto();
        bipOrderBackRpcDto.setDocNo(bipOrderBackDO.getOrderBackDocNo());
        bipOrderBackRpcDto.setStatus(UdcEnum.SAL_RSO_STATUS_DONE.getValueCode());
        return updateOrderBackStatus(bipOrderBackRpcDto);

    }

    public ApiResult updateOrderBackStatus(BipOrderBackRpcDto bipOrderBackRpcDto){
        List<BipOrderBackDO>  bipOrderBackDOS=new ArrayList<>();
        if(bipOrderBackRpcDto.getDocNo()==null){
            throw new BusinessException("主表ID不能为空!");
        }
        if(StringUtils.isBlank(bipOrderBackRpcDto.getStatus())){
            throw new BusinessException("状态不能为空!---");
        }
        List<String> docNos = new ArrayList<>();
        log.info("查询退货单信息:----");
        BipOrderBackDO bipOrderBackDO=bipOrderBackRepoProc.findOrderBackByDocNo(bipOrderBackRpcDto.getDocNo());
        log.info("退货单的信息"+JSON.toJSONString(bipOrderBackDO));
        bipOrderBackDO.setStatus(bipOrderBackRpcDto.getStatus());
        log.info("设置退货单状态:----");
        if(bipOrderBackDO.getOrderId()==null){
            throw new BusinessException("退货单未关联订单");
        }
        log.info("查询订单信息:----");
        BipOrderDO bipOrderDo=bipOrderRepo.findById(bipOrderBackDO.getOrderId()).get();
        log.info("订单信息:----"+JSON.toJSONString(bipOrderDo));
        //订单中心传过来的WP(退款中)的话这边直接支付
        log.info("退款中状态:----");
//        if(UdcEnum.SO_BACK_TYPE_10.getValueCode().equals(bipOrderBackDO.getBackType())
//                || UdcEnum.SO_BACK_TYPE_20.getValueCode().equals(bipOrderBackDO.getBackType())
//                || UdcEnum.SO_BACK_TYPE_30.getValueCode().equals(bipOrderBackDO.getBackType())){
//            log.info("销售订单退货类型为10或者20");
//            if("online".equals(bipOrderDo.getPayMethodName())){
//                log.info("是在线订单");
//                CPCN5021Resp resp=bipOrderBackService.cpcn5011Request(bipOrderBackDO.getId());
//                log.info("调用中金退款返回信息--"+ JSON.toJSONString(resp));
//                if(resp==null){
//                    throw new BusinessException("调用中金退款失败");
//                }else {
//                    docNos.add(bipOrderBackRpcDto.getDocNo());
//                    //退货单流水号
//                    bipOrderBackDO.setTxsn(resp.getTxSN());
//                    //修改状态已退款
//                    bipOrderBackDO.setStatus(UdcEnum.SAL_RSO_STATUS_DONE.getValueCode());
//                }
//            }
//        }
        docNos.add(bipOrderBackRpcDto.getDocNo());
        //修改状态已退款
        bipOrderBackDO.setStatus(UdcEnum.SAL_RSO_STATUS_DONE.getValueCode());
        bipOrderBackDOS.add(bipOrderBackDO);
        log.info("退货单数据:---"+JSON.toJSONString(bipOrderBackDOS));
        bipOrderBackRepo.saveAll(bipOrderBackDOS);


        //生成退款单
        if(null != docNos && !docNos.isEmpty()){
            //退款成功的单号要同步到订单中心
            log.info("同意退款传给订单中心的参数:"+ docNos );
//            try {
//                ApiResult<Object> res = salSoReturnRpcService.allowReturnMoney(docNos);
//                log.info("退货单同意退款返回:"+JSON.toJSONString(res));
//                if(res.getCode() != 200){
//                    QBipSendOrderErrLogDO qBipSendOrderErrLogDO = QBipSendOrderErrLogDO.bipSendOrderErrLogDO;
//                    BooleanExpression ex = qBipSendOrderErrLogDO.deleteFlag.eq(0).and(qBipSendOrderErrLogDO.type.eq(UdcEnum.SAL_SEND_PARAM_ERR_BACK_ORDER.getValueCode())).and(qBipSendOrderErrLogDO.param.eq(JSONUtil.toJsonStr(docNos)));
//                    Iterable<BipSendOrderErrLogDO> iterable = bipSendOrderErrLogRepo.findAll(ex);
//                    if(IterUtil.isEmpty(iterable)){
//                        BipSendOrderErrLogDO bipSendOrderErrLogDO = new BipSendOrderErrLogDO();
//                        bipSendOrderErrLogDO.setParam(JSONUtil.toJsonStr(docNos));
//                        bipSendOrderErrLogDO.setCount(0);
//                        bipSendOrderErrLogDO.setType(UdcEnum.SAL_SEND_PARAM_ERR_BACK_ORDER.getValueCode());
//                        bipSendOrderErrLogRepo.save(bipSendOrderErrLogDO);
//                    }
//                }
//            }catch (Exception e){
//                //调用订单  如果失败就保存参数 定时进行调用
//                //判断存不存在
//                QBipSendOrderErrLogDO qBipSendOrderErrLogDO = QBipSendOrderErrLogDO.bipSendOrderErrLogDO;
//                BooleanExpression ex = qBipSendOrderErrLogDO.deleteFlag.eq(0).and(qBipSendOrderErrLogDO.type.eq(UdcEnum.SAL_SEND_PARAM_ERR_BACK_ORDER.getValueCode())).and(qBipSendOrderErrLogDO.param.eq(JSONUtil.toJsonStr(docNos)));
//                Iterable<BipSendOrderErrLogDO> iterable = bipSendOrderErrLogRepo.findAll(ex);
//                if(IterUtil.isEmpty(iterable)){
//                    BipSendOrderErrLogDO bipSendOrderErrLogDO = new BipSendOrderErrLogDO();
//                    bipSendOrderErrLogDO.setParam(JSONUtil.toJsonStr(docNos));
//                    bipSendOrderErrLogDO.setCount(0);
//                    bipSendOrderErrLogDO.setType(UdcEnum.SAL_SEND_PARAM_ERR_BACK_ORDER.getValueCode());
//                    bipSendOrderErrLogRepo.save(bipSendOrderErrLogDO);
//                }
//                log.info("退货单同意退款调用异常:"+e.getMessage());
//                throw e;
//            }
            docNos.stream().forEach(docNo ->{
                log.info("生成退款单单号:-------"+docNo);
                bipOrderBackToOmsServicei.createSalReceiptService(docNo);
            });
        }

        return ApiResult.ok();
    }




    /**
     * 拆单后生成退货单
     *
     * @param bipItemSkuDOS
     * @param bipOrderBackSaveVO
     * @return
     */
    public BipOrderBackSaveVO createSpliteOrderBack(List<BipItemSkuDO> bipItemSkuDOS, BipOrderBackSaveVO bipOrderBackSaveVO) {
        if(!bipItemSkuDOS.isEmpty()){
            List<Long> skuIds = bipItemSkuDOS.stream().map(bipItemSkuDO -> {
                return bipItemSkuDO.getId();
            }).distinct().collect(Collectors.toList());
            List<Long> orderdIds = findOrderBackDBySkuId(skuIds, bipOrderBackSaveVO.getOrderId());

            BipOrderBackSaveVO shipNoBipOrderBackSaveVO = new BipOrderBackSaveVO();

            BipOrderBackConvert.INSTANCE.copySaveVO(bipOrderBackSaveVO, shipNoBipOrderBackSaveVO);
            shipNoBipOrderBackSaveVO.setOrderId(bipOrderBackSaveVO.getOrderId());
            shipNoBipOrderBackSaveVO.setOrderDocNo(bipOrderBackSaveVO.getOrderDocNo());

            List<BipOrderBackDSaveVO> bipOrderBackDSaveVOS = bipOrderBackSaveVO.getBipOrderBackDSaveVOS();
            List<BipOrderBackDSaveVO> shipNobipOrderBackDSaveVOS = bipOrderBackDSaveVOS.stream().filter(bipOrderBackDSaveVO -> {


                return orderdIds.contains(bipOrderBackDSaveVO.getOrderDId());
            }).collect(Collectors.toList());
            shipNoBipOrderBackSaveVO.setBipOrderBackDSaveVOS(shipNobipOrderBackDSaveVOS);
            return shipNoBipOrderBackSaveVO;
        }
        return null;
    }

    /**
     * @Description: 保存退货单
     * @Param: [bipOrderBackDParmVOList]
     * @return: void
     * @Author: wangyinghao
     * @Date: 2021/8/22
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveBipOrderBack(BipOrderBackSaveVO bipOrderBackSaveVO, List<Long> orderBackIds) {
        CurrentUserDTO currentUserDTO = UserService.currentUser();

        log.info("退货单参数: " + JSON.toJSONString(bipOrderBackSaveVO));
        //获取当前登录人信息和客户信息
        BipCustUserBindDO bipCustUserBindDO = null;

        if (Objects.nonNull(currentUserDTO.getUserId())) {
            bipCustUserBindDO = bipCustUserBindRepoProc.getByUserId(currentUserDTO.getUserId());
        } else {
            throw new BusinessException("请先登录!");
        }

        BipOrderBackDO bipOrderBackDO = BipOrderBackConvert.INSTANCE.saveToDo(bipOrderBackSaveVO);


        fillOrderCustInfo(bipCustUserBindDO, bipOrderBackDO);

        List<BipOrderBackDSaveVO> bipOrderBackDSaveVOS = bipOrderBackSaveVO.getBipOrderBackDSaveVOS();

        String docNo = rmiSysNextNumberService.generateCode("yst-sale","ORDER_BACK_DOC_NO", new ArrayList<>());

        bipOrderBackDO.setOrderBackDocNo(docNo);
        bipOrderBackDO.setBackTime(LocalDateTime.now());
        bipOrderBackDO = bipOrderBackRepo.save(bipOrderBackDO);

        List<BipOrderBackDDO> bipOrderBackDDOList = BipOrderBackDConvert.INSTANCE.savesToDos(bipOrderBackDSaveVOS);

        List<BipOrderBackDDO> bipOrderBackDDOSaveList = new ArrayList<>();


        BigDecimal backAmtTotal = new BigDecimal(0);

        int lineNo = 1;
        for (BipOrderBackDDO bipOrderBackDDO : bipOrderBackDDOList) {

            bipOrderBackDDO.setLineNo(lineNo);
            lineNo++;
            bipOrderBackDDO.setCustAccountId(bipCustUserBindDO.getUserId());
            bipOrderBackDDO.setCustAccountName(bipCustUserBindDO.getUsername());

            if (bipOrderBackDDO.getOrderDId() == null) {
                throw new BusinessException("订单ID不能为空!");
            }
            buildItemfoByOrderId(bipOrderBackDDO.getOrderDId(), bipOrderBackDDO);
            bipOrderBackDDO.setOrderBackId(bipOrderBackDO.getId());
            bipOrderBackDDO.setOrderBackDocNo(bipOrderBackDO.getOrderBackDocNo());
            bipOrderBackDDO.setPayAmt(bipOrderBackDDO.getPayAmt());
            bipOrderBackDDO.setApplyBackAmt(bipOrderBackDDO.getPayAmt().multiply(new BigDecimal(bipOrderBackDDO.getBackNum())));
            if (bipOrderBackDDO.getApplyBackAmt() != null) {
                BigDecimal backAmt = bipOrderBackDDO.getApplyBackAmt();
                bipOrderBackDDO.setApproveBackAmt(backAmt);
                backAmtTotal = backAmtTotal.add(backAmt);
            }
//            else{
//                if(bipOrderBackDDO.getBackNum()==null||bipOrderBackDDO.getBackNum()<=0){
//                    throw new BusinessException("退货数量数据异常!");
//                }
//                BigDecimal backNum=bipOrderBackDDO.getBackNum()==null?BigDecimal.ZERO:BigDecimal.valueOf(bipOrderBackDDO.getBackNum());
//                BigDecimal payAmt=BigDecimal.ZERO;
//                if(bipOrderBackDDO.getPayAmt()!=null){
//                    payAmt=bipOrderBackDDO.getPayAmt();
//                }
//                BigDecimal backAmt=payAmt.multiply(backNum);
//                bipOrderBackDDO.setApproveBackAmt(backAmt);
//                bipOrderBackDDO.setApplyBackAmt(backAmt);
//                backAmtTotal=backAmtTotal.add(backAmt);
//            }


            bipOrderBackDDOSaveList.add(bipOrderBackDDO);
//            bipOrderBackDRepo.save(bipOrderBackDDO);

//           List<Long> giftOrderIds=bipOrderDRepoProc.findGiftOrderId(bipOrderBackDDO.getOrderDId());
//           if(giftOrderIds!=null&&giftOrderIds.size()>0){
//               for(Long orderID:giftOrderIds){
//                   BipOrderBackDDO bipOrderBackDDOGift=new BipOrderBackDDO();
//                   buildItemfoByOrderId(orderID,bipOrderBackDDOGift);
//
//                   bipOrderBackDDOGift.setPid(bipOrderBackDDO.getId());
//                   bipOrderBackDDOGift.setOrderBackId(bipOrderBackDO.getId());
//                   bipOrderBackDDOGift.setOrderBackDocNo(bipOrderBackDO.getOrderBackDocNo());
//
//                   bipOrderBackDDOSaveList.add(bipOrderBackDDOGift);
////                   bipOrderBackDRepo.save(bipOrderBackDDOGift);
//               }
//           }
        }
        ;

        bipOrderBackDRepo.saveAll(bipOrderBackDDOSaveList);

        bipOrderBackDO.setApplyBackAmt(backAmtTotal);
        bipOrderBackDO.setApproveBackAmt(backAmtTotal);

        bipOrderBackDO.setStatus(UdcEnum.SAL_RSO_STATUS_APPING.getValueCode());
        bipOrderBackRepo.save(bipOrderBackDO);
        orderBackIds.add(bipOrderBackDO.getId());
//        bipOrderBackToOmsServiceimpl.sendToOms(bipOrderBackDO.getId());

    }


    /**
     * @Description: 保存退货单
     * @Param: [bipOrderBackDParmVOList]
     * @return: void
     * @Author: wangyinghao
     * @Date: 2021/8/22
     */
    @Transactional(rollbackFor = Exception.class)
    public BipOrderBackDO saveSubBipOrderBack(BipOrderBackSaveVO bipOrderBackSaveVO, List<Long> orderBackIds) {
        CurrentUserDTO currentUserDTO = UserService.currentUser();

        log.info("退货单参数: " + JSON.toJSONString(bipOrderBackSaveVO));
        //获取当前登录人信息和客户信息
        BipCustUserBindDO bipCustUserBindDO = null;

        if (Objects.nonNull(currentUserDTO.getUserId())) {
            bipCustUserBindDO = bipCustUserBindRepoProc.getByUserId(currentUserDTO.getUserId());
        } else {
            throw new BusinessException("请先登录!");
        }

        BipOrderBackDO bipOrderBackDO = BipOrderBackConvert.INSTANCE.saveToDo(bipOrderBackSaveVO);


        fillOrderCustInfo(bipCustUserBindDO, bipOrderBackDO);

        List<BipOrderBackDSaveVO> bipOrderBackDSaveVOS = bipOrderBackSaveVO.getBipOrderBackDSaveVOS();

        String docNo = rmiSysNextNumberService.generateCode("yst-sale","ORDER_BACK_DOC_NO", new ArrayList<>());

        bipOrderBackDO.setOrderBackDocNo(docNo);
        bipOrderBackDO.setBackTime(LocalDateTime.now());
        bipOrderBackDO = bipOrderBackRepo.save(bipOrderBackDO);

        List<BipOrderBackDDO> bipOrderBackDDOList = BipOrderBackDConvert.INSTANCE.savesToDos(bipOrderBackDSaveVOS);

        List<BipOrderBackDDO> bipOrderBackDDOSaveList = new ArrayList<>();


        BigDecimal backAmtTotal = new BigDecimal(0);

        int lineNo = 1;
        for (BipOrderBackDDO bipOrderBackDDO : bipOrderBackDDOList) {

            bipOrderBackDDO.setLineNo(lineNo);
            lineNo++;
            bipOrderBackDDO.setCustAccountId(bipCustUserBindDO.getUserId());
            bipOrderBackDDO.setCustAccountName(bipCustUserBindDO.getUsername());

            if (bipOrderBackDDO.getOrderDId() == null) {
                throw new BusinessException("订单ID不能为空!");
            }
            buildSubItemfoByOrderId(bipOrderBackDDO.getOrderDId(), bipOrderBackDDO);
            bipOrderBackDDO.setOrderBackId(bipOrderBackDO.getId());
            bipOrderBackDDO.setOrderBackDocNo(bipOrderBackDO.getOrderBackDocNo());
            bipOrderBackDDO.setPayAmt(bipOrderBackDDO.getPayAmt());
           // bipOrderBackDDO.setApplyBackAmt(bipOrderBackDDO.getPayAmt().multiply(new BigDecimal(bipOrderBackDDO.getBackNum())));
            if (bipOrderBackDDO.getApplyBackAmt() != null) {
                BigDecimal backAmt = bipOrderBackDDO.getApplyBackAmt();
                bipOrderBackDDO.setApproveBackAmt(backAmt);
                backAmtTotal = backAmtTotal.add(backAmt);
            }
            bipOrderBackDDOSaveList.add(bipOrderBackDDO);
        }
        ;

        bipOrderBackDRepo.saveAll(bipOrderBackDDOSaveList);
        bipOrderBackDO.setApplyBackAmt(backAmtTotal);
        bipOrderBackDO.setApproveBackAmt(backAmtTotal);
        bipOrderBackDO.setStatus(UdcEnum.SAL_RSO_STATUS_DONE.getValueCode());
        log.info("退款单保存参数：----------------"+JSON.toJSONString(bipOrderBackDO));
        bipOrderBackDO = bipOrderBackRepo.save(bipOrderBackDO);
        log.info("退款单保存参数成功"+JSON.toJSONString(bipOrderBackDO));
        orderBackIds.add(bipOrderBackDO.getId());
//        bipOrderBackToOmsServiceimpl.sendToOms(bipOrderBackDO.getId());
        return bipOrderBackDO;
    }


    /**
     * 根据订单明细id集合查询商品信息，在根据商品是够一件代发分组，然后再根据不同供应商分组
     */

    public Map<String, List<BipItemSkuDO>> spliteOrderBackD(List<Long> orderDIds) {
        List<Long> skuIdByIds = bipOrderDRepoProc.findOrderDSkuIdByIds(orderDIds);

        List<BipItemSkuDO> bipItemSkuDOList = bipItemSkuRepo.findAllById(skuIdByIds);

        Map<String, List<BipItemSkuDO>> bipItemSkuDOListGroupMap = bipItemSkuDOList.stream().collect(Collectors.groupingBy(bipItemSkuDO -> {
            return bipItemSkuDO.getShipOne().toString();
        }));
        log.info("bipItemSkuDOListGroupMap-------:" + JSON.toJSONString(bipItemSkuDOListGroupMap));
        log.info("是否一件代发分组KEY:" + JSON.toJSONString(bipItemSkuDOListGroupMap.keySet().toString()));
        return bipItemSkuDOListGroupMap;
    }


    /**
     * 一件代发分组
     *
     * @param shipOnelist
     * @return
     */
    public Map<String, List<BipItemSkuDO>> spliteShipOneOrderBackD(List<BipItemSkuDO> shipOnelist) {
        //一件代发的 list再根据供应商去分组

        Map<String, List<BipItemSkuDO>> shipGroupMap = shipOnelist.stream().collect(Collectors.groupingBy(bipItemSkuDO -> {
            return bipItemSkuDO.getSupplier();
        }));

        return shipGroupMap;
    }

    /**
     * 查询明细id
     *
     * @param skuIds
     * @param orderId
     */
    public List<Long> findOrderBackDBySkuId(List<Long> skuIds, Long orderId) {
        List<Long> orderDIds = bipOrderDRepoProc.findOrderDIdBySkuId(skuIds, orderId);
        if (orderDIds == null || orderDIds.isEmpty()) {
            throw new BusinessException("数据异常,根据订单id和skuId查询明细数据错误");
        }
        return orderDIds;
    }

    /**
     * 构建退货单商品信息
     *
     * @param orderId
     * @param bipOrderBackDDO
     */
    public void buildItemfoByOrderId(Long orderId, BipOrderBackDDO bipOrderBackDDO) {
        BipOrderDDO bipOrderDDo = bipOrderDRepo.findById(orderId).get();

        bipOrderBackDDO.setItemId(bipOrderDDo.getItemId());
        bipOrderBackDDO.setSkuId(bipOrderDDo.getSkuId());
        bipOrderBackDDO.setRelateItemId(bipOrderDDo.getRelateItemId());
        bipOrderBackDDO.setItemCode(bipOrderDDo.getItemCode());
        bipOrderBackDDO.setItemName(bipOrderDDo.getItemName());
        bipOrderBackDDO.setItemTitle(bipOrderDDo.getItemTitle());
        bipOrderBackDDO.setItmeBrandID(bipOrderDDo.getItmeBrandID());
        bipOrderBackDDO.setItemBrand(bipOrderDDo.getItemBrand());
        bipOrderBackDDO.setItemSpec(bipOrderDDo.getItemSpec());
        bipOrderBackDDO.setUom(bipOrderDDo.getUom());
        bipOrderBackDDO.setItemPicFileCode(bipOrderDDo.getItemPicFileCode());
        bipOrderBackDDO.setOrderDocNo(bipOrderDDo.getOrderDocNo());
        bipOrderBackDDO.setOrderId(bipOrderDDo.getOrderId());
        bipOrderBackDDO.setItemType(bipOrderDDo.getItemType());

        bipOrderBackDDO.setPayAmt(bipOrderDDo.getBuyAmt());

        Long allowBackNum = bipOrderDDo.getAllowBackNum();
        if (allowBackNum == null) {
            allowBackNum = bipOrderDDo.getBuyQty();
        }
        bipOrderDDo.setAllowBackNum(allowBackNum - bipOrderBackDDO.getBackNum());
        bipOrderDRepo.save(bipOrderDDo);
        //  bipOrderDRepoProc.updateOrderDAllowBackNum(orderId,-bipOrderBackDDO.getBackNum());

//        bipOrderDRepo.save(bipOrderDDo);
        log.info("订单转退货单赠品信息" + JSON.toJSONString(bipOrderBackDDO));

    }


    public void buildSubItemfoByOrderId(Long orderId, BipOrderBackDDO bipOrderBackDDO) {
        BipOrderDDO bipOrderDDo = bipOrderDRepo.findById(orderId).get();

        bipOrderBackDDO.setItemId(bipOrderDDo.getItemId());
        bipOrderBackDDO.setSkuId(bipOrderDDo.getSkuId());
        bipOrderBackDDO.setRelateItemId(bipOrderDDo.getRelateItemId());
        bipOrderBackDDO.setItemCode(bipOrderDDo.getItemCode());
        bipOrderBackDDO.setItemName(bipOrderDDo.getItemName());
        bipOrderBackDDO.setItemTitle(bipOrderDDo.getItemTitle());
        bipOrderBackDDO.setItmeBrandID(bipOrderDDo.getItmeBrandID());
        bipOrderBackDDO.setItemBrand(bipOrderDDo.getItemBrand());
        bipOrderBackDDO.setItemSpec(bipOrderDDo.getItemSpec());
        bipOrderBackDDO.setUom(bipOrderDDo.getUom());
        bipOrderBackDDO.setItemPicFileCode(bipOrderDDo.getItemPicFileCode());
        bipOrderBackDDO.setOrderDocNo(bipOrderDDo.getOrderDocNo());
        bipOrderBackDDO.setOrderId(bipOrderDDo.getOrderId());
        bipOrderBackDDO.setItemType(bipOrderDDo.getItemType());
        bipOrderBackDDO.setApplyBackAmt(bipOrderDDo.getPayAmt());
        bipOrderBackDDO.setApproveBackAmt(bipOrderDDo.getPayAmt());

        bipOrderBackDDO.setPayAmt(bipOrderDDo.getBuyAmt());

        Long allowBackNum = bipOrderDDo.getAllowBackNum();
        if (allowBackNum == null) {
            allowBackNum = bipOrderDDo.getBuyQty();
        }
        bipOrderDDo.setAllowBackNum(allowBackNum - bipOrderBackDDO.getBackNum());
        bipOrderDRepo.save(bipOrderDDo);
        //  bipOrderDRepoProc.updateOrderDAllowBackNum(orderId,-bipOrderBackDDO.getBackNum());

//        bipOrderDRepo.save(bipOrderDDo);
        log.info("订单转退货单赠品信息" + JSON.toJSONString(bipOrderBackDDO));

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void reBack(Long id) {
        BipOrderBackDO bipOrderBackDO = bipOrderBackRepo.findById(id).get();
        BipOrderBackDO reBipOrderBackDo = null;
        reBipOrderBackDo = BipOrderBackConvert.INSTANCE.copy(bipOrderBackDO);
        reBipOrderBackDo.setStatus(UdcEnum.SAL_RSO_STATUS_APPING.getValueCode());
        reBipOrderBackDo.setId(null);
        String docNo = rmiSysNextNumberService.generateCode("yst-sale","ORDER_BACK_DOC_NO", new ArrayList<>());
        reBipOrderBackDo.setOrderBackDocNo(docNo);
        reBipOrderBackDo = bipOrderBackRepo.save(reBipOrderBackDo);

        List<BipOrderBackDDO> bipOrderBackDDOList = bipOrderBackDRepo.findByOrderBackId(id);
        List<BipOrderBackDDO> reBipOrderBackDDOList = new ArrayList<>();

        for (BipOrderBackDDO bipOrderBackDDO : bipOrderBackDDOList) {
            Long num = bipOrderBackDDO.getBackNum();

            BipOrderBackDDO reBipOrderBackDDo = BipOrderBackDConvert.INSTANCE.copy(bipOrderBackDDO);

            reBipOrderBackDDo.setId(null);
            reBipOrderBackDDo.setOrderBackId(reBipOrderBackDo.getId());
            reBipOrderBackDDo.setOrderBackDocNo(docNo);

            reBipOrderBackDDo.setCreateTime(LocalDateTime.now());
            reBipOrderBackDDo.setCreateUserId(null);

            reBipOrderBackDDo.setUpdater(null);
            reBipOrderBackDDo.setModifyTime(LocalDateTime.now());
            reBipOrderBackDDo.setModifyUserId(null);

            Long orderDId = bipOrderBackDDO.getOrderDId();

            if (orderDId == null) {
                throw new BusinessException("数据错误,退货单未关联订单!");
            }
            bipOrderDRepoProc.updateOrderDAllowBackNum(orderDId, -num);


            reBipOrderBackDDOList.add(reBipOrderBackDDo);

        }

        bipOrderBackDRepo.saveAll(reBipOrderBackDDOList);
    }


    /**
     * @param bipCustUserBindDO
     * @param orderBackDO
     */
    private void fillOrderCustInfo(BipCustUserBindDO bipCustUserBindDO, BipOrderBackDO orderBackDO) {

        Long custId = bipCustUserBindDO.getCustId();
        orderBackDO.setOuId(bipCustUserBindDO.getOuId());

        Long ouId = bipCustUserBindDO.getOuId();
        List<Long> ouList = new ArrayList<>();
        ouList.add(ouId);
        OrgOuRpcDtoParam orgOuRpcDtoParam = new OrgOuRpcDtoParam();
        orgOuRpcDtoParam.setOuIds(ouList);
        log.info("调用公司接口参数---" + JSON.toJSONString(orgOuRpcDtoParam));

        List<OrgOuRpcDTO> orgOuRpcDTOS = rmiOrgOuService.findOuDtoListByParam(orgOuRpcDtoParam);

        if (orgOuRpcDTOS != null && !orgOuRpcDTOS.isEmpty()) {
            OrgOuRpcDTO orgOuRpcDTO = orgOuRpcDTOS.get(0);
            orderBackDO.setOuName(orgOuRpcDTO.getOuName());
            orderBackDO.setOuCode(orgOuRpcDTO.getOuCode());

        }

        List<BipCompanyManageRespVO> bipCompanyManageRespVOS = bipCompanyManageService.findCompanyManageByOuIds(ouList);

        if (bipCompanyManageRespVOS != null && !bipCompanyManageRespVOS.isEmpty()) {
            BipCompanyManageRespVO bipCompanyManageRespVO = bipCompanyManageRespVOS.get(0);
            orderBackDO.setBuId(bipCompanyManageRespVO.getBuId());
            orderBackDO.setBuCode(bipCompanyManageRespVO.getBuCode());
            orderBackDO.setBuName(bipCompanyManageRespVO.getBuName());
        }

        orderBackDO.setCustAccountId(bipCustUserBindDO.getUserId());
        orderBackDO.setCustAccountName(bipCustUserBindDO.getUsername());

        orderBackDO.setCustId(custId);
        orderBackDO.setCustCode(bipCustUserBindDO.getCustCode());
//        order.setCustCode2(bipCustUserBindDO.getCustCode2());
        orderBackDO.setCustName(bipCustUserBindDO.getCustName());
        orderBackDO.setAgentEmpId(bipCustUserBindDO.getAgentEmpId());
//        order.setAgentName(bipCustUserBindDO.getAgentEmpName());

    }


    /***
     * @Description: 分页查询
     * @Param: [bipOrderBackParmVO]
     * @return: com.elitescloud.cloudt.common.base.PagingVO
     * @Author: wangyinghao
     * @Date: 2021/8/22
     */
    @Override
    public PagingVO<BipOrderBackRespVO> findBipOrderBackPage(BipOrderBackParmVO bipOrderBackParmVO) {
        Page<BipOrderBackDO> page = bipOrderBackRepo.findAll(where(bipOrderBackParmVO), bipOrderBackParmVO.getPageRequest());
        List<BipOrderBackRespVO> resList = page.getContent().stream().map(BipOrderBackConvert.INSTANCE::doToresp).collect(Collectors.toList());

        for (BipOrderBackRespVO bipOrderBackRespVO : resList) {
            findStatusName(bipOrderBackRespVO);
            findBackTypeName(bipOrderBackRespVO);
            findBackResonName(bipOrderBackRespVO);
        }

        return PagingVO.<BipOrderBackRespVO>builder()
                .total(page.getTotalElements())
                .records(resList)
                .build();
    }

    @Override
    public void updateSync(BipOrderBackSaveVO bipOrderBackSaveVO) {

        if (bipOrderBackSaveVO.getId() == null) {
            throw new BusinessException("ID不能为空!");
        }
        BipOrderBackDO bipOrderBackDO = bipOrderBackRepo.findById(bipOrderBackSaveVO.getId()).get();
        BipOrderBackConvert.INSTANCE.copySaveToDo(bipOrderBackSaveVO, bipOrderBackDO);

        bipOrderBackRepo.save(bipOrderBackDO);

        // 修改明细
        List<BipOrderBackDDO> bipOrderBackDDOS = new ArrayList<>();
        for (BipOrderBackDSaveVO dSaveVO : bipOrderBackSaveVO.getBipOrderBackDSaveVOS()) {

            Optional<BipOrderBackDDO> byId = bipOrderBackDRepo.findById(dSaveVO.getId());

            if (byId.isPresent()){
                BipOrderBackDDO backDDO = byId.get();
                backDDO.setApproveBackAmt(dSaveVO.getApproveBackAmt());
                backDDO.setIsWorkOrder(dSaveVO.getIsWorkOrder());
                bipOrderBackDDOS.add(backDDO);
            }
        }

        bipOrderBackDRepo.saveAll(bipOrderBackDDOS);

        bipOrderBackToOmsServiceimpl.updateBackOrder(bipOrderBackDDOS, bipOrderBackSaveVO.getStatus());

    }

    @Override
    public void cancelSync(Long id) {

        BipOrderBackDO bipOrderBackDO = bipOrderBackRepo.findById(id).orElseThrow(()-> new BusinessException("退款单【"+id+"】不存在！"));
        bipOrderBackDO.setStatus("CL");

        bipOrderBackRepo.save(bipOrderBackDO);

        List<BipOrderBackDDO> bipOrderBackDDOS = bipOrderBackDRepo.findByOrderBackId(id);

        Assert.notNull(bipOrderBackDDOS,"退款单【"+id+"】明细为空！");

        // sync oms
        bipOrderBackToOmsServiceimpl.updateBackOrder(bipOrderBackDDOS, "CL");

    }


    /**
     * 删除退货单--通过id
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBipOrderBackByIds(List<Long> ids) {

        bipOrderBackRepo.deleteOrderBackByIds(ids);

        bipOrderBackDRepo.deleteOrderBackDByOrderbackIds(ids);
    }


    public Predicate where(BipOrderBackParmVO bipOrderBackParmVO) {
        Predicate predicate = qBipOrderBackDO.isNotNull();
        if (Objects.nonNull(bipOrderBackParmVO)) {
            if (StringUtils.isNotBlank(bipOrderBackParmVO.getOrderBackDocNo())) {
                predicate = ExpressionUtils.and(predicate, qBipOrderBackDO.orderBackDocNo.like("%" + bipOrderBackParmVO.getOrderBackDocNo() + "%"));
            }

            if (StringUtils.isNotBlank(bipOrderBackParmVO.getOrderDocNo())) {
                predicate = ExpressionUtils.and(predicate, qBipOrderBackDO.orderDocNo.like("%" + bipOrderBackParmVO.getOrderDocNo() + "%"));
            }

            if (StringUtils.isNotBlank(bipOrderBackParmVO.getLogistDocNo())) {
                predicate = ExpressionUtils.and(predicate, qBipOrderBackDO.logistDocNo.like("%" + bipOrderBackParmVO.getLogistDocNo() + "%"));
            }

            if (Objects.nonNull(bipOrderBackParmVO.getOuId())) {
                predicate = ExpressionUtils.and(predicate, qBipOrderBackDO.ouId.eq(bipOrderBackParmVO.getOuId()));
            }

            if (StringUtils.isNotBlank(bipOrderBackParmVO.getStatus())) {
                predicate = ExpressionUtils.and(predicate, qBipOrderBackDO.status.eq(bipOrderBackParmVO.getStatus()));
            }

            if (StringUtils.isNotBlank(bipOrderBackParmVO.getShipperName())) {
                predicate = ExpressionUtils.and(predicate, qBipOrderBackDO.shipperName.like("%" + bipOrderBackParmVO.getShipperName() + "%"));
            }

            if (StringUtils.isNotBlank(bipOrderBackParmVO.getShipperTel())) {
                predicate = ExpressionUtils.and(predicate, qBipOrderBackDO.shipperTel.like("%" + bipOrderBackParmVO.getShipperTel() + "%"));
            }

            if (StringUtils.isNotBlank(bipOrderBackParmVO.getCustAccountName())) {
                predicate = ExpressionUtils.and(predicate, qBipOrderBackDO.custAccountName.like("%" + bipOrderBackParmVO.getCustAccountName() + "%"));
            }

            if (StringUtils.isNotBlank(bipOrderBackParmVO.getBuName())) {
                predicate = ExpressionUtils.and(predicate, qBipOrderBackDO.buName.like("%" + bipOrderBackParmVO.getBuName() + "%"));
            }

            if (StringUtils.isNotBlank(bipOrderBackParmVO.getBackReason())) {
                predicate = ExpressionUtils.and(predicate, qBipOrderBackDO.backReason.eq(bipOrderBackParmVO.getBackReason()));
            }

            if (StringUtils.isNotBlank(bipOrderBackParmVO.getBackType())) {
                predicate = ExpressionUtils.and(predicate, qBipOrderBackDO.backType.eq(bipOrderBackParmVO.getBackType()));
            }

            if (StringUtils.isNotBlank(bipOrderBackParmVO.getReceiverName())) {
                predicate = ExpressionUtils.and(predicate, qBipOrderBackDO.receiverName.like("%" + bipOrderBackParmVO.getReceiverName() + "%"));
            }

            if (StringUtils.isNotBlank(bipOrderBackParmVO.getReceiverTel())) {
                predicate = ExpressionUtils.and(predicate, qBipOrderBackDO.receiverTel.like("%" + bipOrderBackParmVO.getReceiverTel() + "%"));
            }

            if (Objects.nonNull(bipOrderBackParmVO.getCreateTime())) {
                predicate = ExpressionUtils.and(predicate, qBipOrderBackDO.createTime.eq(bipOrderBackParmVO.getCreateTime()));
            }

            if (Objects.nonNull(bipOrderBackParmVO.getSignTime())) {
                predicate = ExpressionUtils.and(predicate, qBipOrderBackDO.signTime.eq(bipOrderBackParmVO.getSignTime()));
            }

            predicate = ExpressionUtils.and(predicate, DataAuthJpaUtil.dataAuthJpaPredicate(qBipOrderBackDO.getMetadata()));
        }
        return predicate;
    }

    /**
     * 退货单详情查询
     *
     * @param orderBackId 查询 orderBack 聚合信息包含明细信息
     * @return
     */
    @Override
    public BipOrderBackRespVO findPolymerizeOrderBack(Long orderBackId) {
        BipOrderBackDO bipOrderBackDO = bipOrderBackRepo.findById(orderBackId).get();
        BipOrderBackRespVO bipOrderBackRespVO = BipOrderBackConvert.INSTANCE.doToresp(bipOrderBackDO);
        BipOrderBackDParmVO bipOrderBackDParmVO = new BipOrderBackDParmVO();
        bipOrderBackDParmVO.setOrderBackId(orderBackId);
        List<BipOrderBackDRespVO> list = bipOrderBackDService.findBipOrderBackD(bipOrderBackDParmVO);
        if (null != list && !list.isEmpty()) {
            list.stream().forEach(l -> {
                Long skuId = l.getSkuId();
                BipItemSkuDO skuDO = bipItemSkuRepo.findById(skuId).get();
                l.setItemCode(skuDO.getSkuCode());
                l.setItemName(skuDO.getItemName());
            });
        }
//        list.stream().forEach(l ->{
//            BigDecimal backPrice = (l.getApplyBackAmt()).divide(new BigDecimal(l.getBackNum()),2, RoundingMode.UP);
//            l.setBuyAmt(backPrice);
//        });
        bipOrderBackRespVO.setBipOrderBackDRespVOList(list);

        findStatusName(bipOrderBackRespVO);
        findBackTypeName(bipOrderBackRespVO);
        findBackResonName(bipOrderBackRespVO);
        if (StringUtils.isNotBlank(bipOrderBackDO.getFileCodes())) {
            bipOrderBackRespVO.setFileCodes(bipOrderBackDO.getFileCodes().split(","));
        }

        return bipOrderBackRespVO;
    }


    /**
     * 查询用户退货单列表
     *
     * @param bipOrderBackUserParmVO
     */
    @Override
    public PagingVO<BipOrderBackRespVO> findUserOrderBack(BipOrderBackUserParmVO bipOrderBackUserParmVO) {

        CurrentUserDTO currentUser = UserService.currentUser();
        Long userId = currentUser.getUserId();

        if (currentUser == null || userId == null) {
            throw new BusinessException("请先登录!");
        }
        Predicate predicate = qBipOrderBackDO.isNotNull();
        predicate = ExpressionUtils.and(predicate, qBipOrderBackDO.custAccountId.eq(userId));

        Page<BipOrderBackDO> page = bipOrderBackRepo.findAll(predicate, bipOrderBackUserParmVO.getPageRequest());

        List<BipOrderBackRespVO> bipOrderBackRespVOList = page.getContent().stream().map(BipOrderBackConvert.INSTANCE::doToresp).collect(Collectors.toList());


        bipOrderBackRespVOList.stream().forEach(bipOrderBackRespVO -> {
            findStatusName(bipOrderBackRespVO);
            findBackTypeName(bipOrderBackRespVO);
            findBackResonName(bipOrderBackRespVO);

            List<BipOrderBackDDO> bipOrderBackDDOList = bipOrderBackDRepo.findByOrderBackId(bipOrderBackRespVO.getId());
            List<BipOrderBackDRespVO> bipOrderBackDRespVOS = BipOrderBackDConvert.INSTANCE.dosToresps(bipOrderBackDDOList);

            log.info("订单明细集合——" + JSON.toJSONString(bipOrderBackDDOList));

            List<Long> skuIds = bipOrderBackDDOList.stream()
                    .filter(bipOrderDRespVO -> bipOrderDRespVO.getSkuId() != null)
                    .map(bipOrderDRespVO -> bipOrderDRespVO.getSkuId())
                    .distinct()
                    .collect(Collectors.toList());
            List<BipItemSkuDO> bipItemSkuDOS = bipItemSkuRepo.findAllById(skuIds);

            log.info("订单明细sku集合——" + JSON.toJSONString(bipItemSkuDOS));
            Map<Long, List<BipItemSkuDO>> skuMap = bipItemSkuDOS.stream().collect(Collectors.groupingBy(BipItemSkuDO::getId));

            bipOrderBackDRespVOS.stream().forEach(bipOrderBackDRespVO -> {
                // BigDecimal backPrice = (bipOrderBackDRespVO.getApplyBackAmt()).divide(new BigDecimal(bipOrderBackDRespVO.getBackNum()),2, RoundingMode.UP);
                BipOrderDDO bipOrderDDO = bipOrderDRepo.findById(bipOrderBackDRespVO.getOrderDId()).get();
                bipOrderBackDRespVO.setBuyAmt(bipOrderDDO.getBuyAmt());
                if (bipOrderBackDRespVO.getSkuId() != null) {
                    List<BipItemSkuDO> skus = skuMap.get(bipOrderBackDRespVO.getSkuId());
                    if (skus != null & skus.size() > 0) {
                        BipItemSkuDO skuDO = skus.get(0);

                        List<BipItemSkuAttrRespVO> attrList = convert2List(skuDO.getAttr(), BipItemSkuAttrRespVO.class);
                        //属性转换字符串
                        List<String> list = new ArrayList<>();
                        for (int i = 0; i < attrList.size(); i++) {
                            BipItemSkuAttrRespVO bipItemSkuAttrRespVO = JSON.parseObject(JSON.toJSONString(attrList.get(0)), BipItemSkuAttrRespVO.class);
                            if (bipItemSkuAttrRespVO != null) {
                                list.add(bipItemSkuAttrRespVO.getName() + ":" + bipItemSkuAttrRespVO.getValue());
                            }

                        }

                        String attstr = String.join(";", list);
                        bipOrderBackDRespVO.setItemAttr(attstr);

                    }

                }
                if (bipOrderBackDRespVO.getItemId() != null) {
                    Optional<BipItemDO> optionalBipItemDO = bipItemRepo.findById(bipOrderBackDRespVO.getItemId());
                    if (null != optionalBipItemDO && !optionalBipItemDO.isEmpty()) {
                        BipItemDO bipItemDO = optionalBipItemDO.get();
                        bipOrderBackDRespVO.setItemPicFileCode(bipItemDO.getMainPicFileCode());
                        bipOrderBackDRespVO.setItemTitle(bipItemDO.getTitle());
                    }
                }
            });
            bipOrderBackRespVO.setBipOrderBackDRespVOList(bipOrderBackDRespVOS);

        });

        return PagingVO.<BipOrderBackRespVO>builder()
                .total(page.getTotalElements())
                .records(bipOrderBackRespVOList)
                .build();
    }


    /**
     * 通过查询退货单详情通过ID
     *
     * @param id
     */
    @Override
    @SysCodeProc
    public BipOrderBackRespVO findOrderBackDetailById(Long id) {

        BipOrderBackDO bipOrderBackDO = bipOrderBackRepo.findById(id).get();
        BipOrderBackRespVO bipOrderBackRespVO = BipOrderBackConvert.INSTANCE.doToresp(bipOrderBackDO);
        bipOrderBackDO.setLogisCompany(bipOrderBackDO.getLogisCompany());
        List<BipOrderBackDDO> bipOrderBackDDOList = bipOrderBackDRepo.findByOrderBackId(id);
        List<BipOrderBackDRespVO> bipOrderBackDRespVOS = BipOrderBackDConvert.INSTANCE.dosToresps(bipOrderBackDDOList);
        log.info("订单明细集合——" + JSON.toJSONString(bipOrderBackDDOList));

        List<Long> skuIds = bipOrderBackDDOList.stream()
                .filter(bipOrderDRespVO -> bipOrderDRespVO.getSkuId() != null)
                .map(bipOrderDRespVO -> bipOrderDRespVO.getSkuId())
                .distinct()
                .collect(Collectors.toList());
        List<BipItemSkuDO> bipItemSkuDOS = bipItemSkuRepo.findAllById(skuIds);

        log.info("订单明细sku集合——" + JSON.toJSONString(bipItemSkuDOS));
        Map<Long, List<BipItemSkuDO>> skuMap = bipItemSkuDOS.stream().collect(Collectors.groupingBy(BipItemSkuDO::getId));

        bipOrderBackDRespVOS.stream().forEach(bipOrderBackDRespVO -> {


            if (bipOrderBackDRespVO.getSkuId() != null) {
                List<BipItemSkuDO> skus = skuMap.get(bipOrderBackDRespVO.getSkuId());
                if (skus != null & skus.size() > 0) {
                    BipItemSkuDO skuDO = skus.get(0);

                    List<BipItemSkuAttrRespVO> attrList = convert2List(skuDO.getAttr(), BipItemSkuAttrRespVO.class);
                    //属性转换字符串
                    List<String> list = new ArrayList<>();
                    for (int i = 0; i < attrList.size(); i++) {
                        BipItemSkuAttrRespVO bipItemSkuAttrRespVO = JSON.parseObject(JSON.toJSONString(attrList.get(0)), BipItemSkuAttrRespVO.class);
                        if (bipItemSkuAttrRespVO != null) {
                            list.add(bipItemSkuAttrRespVO.getName() + ":" + bipItemSkuAttrRespVO.getValue());
                        }

                    }

                    String attstr = String.join(";", list);
                    bipOrderBackDRespVO.setItemAttr(attstr);

                }

            }
            if (bipOrderBackDRespVO.getItemId() != null) {
                BipItemDO bipItemDO = bipItemRepo.findById(bipOrderBackDRespVO.getItemId()).get();
                bipOrderBackDRespVO.setItemPicFileCode(bipItemDO.getMainPicFileCode());
            }
        });

        findStatusName(bipOrderBackRespVO);
        findBackResonName(bipOrderBackRespVO);
        bipOrderBackRespVO.setBipOrderBackDRespVOList(bipOrderBackDRespVOS);

        return bipOrderBackRespVO;
    }


    /**
     * 更新退货单物流信息
     *
     * @param bipOrderBackLogistSaveVO
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateOrderBackLogistInfo(BipOrderBackLogistSaveVO bipOrderBackLogistSaveVO) {
        if (bipOrderBackLogistSaveVO.getId() == null) {
            throw new BusinessException("ID不能为空");
        }

        BipOrderBackDO bipOrderBackDO = bipOrderBackRepo.findById(bipOrderBackLogistSaveVO.getId()).get();

        BipOrderBackConvert.INSTANCE.logisSaveVOToDo(bipOrderBackLogistSaveVO, bipOrderBackDO);

        bipOrderBackDO.setStatus(UdcEnum.SAL_RSO_STATUS_RTING.getValueCode());
        bipOrderBackDO.setLogisCompany(bipOrderBackLogistSaveVO.getLogisCompany());
        bipOrderBackRepo.save(bipOrderBackDO);

        //同步订单中心物流 单号
        SalDoReturnTOBSaveDTO salDoReturnTOBSaveDTO = new SalDoReturnTOBSaveDTO();
        salDoReturnTOBSaveDTO.setDocNo(bipOrderBackDO.getOrderBackDocNo());
        salDoReturnTOBSaveDTO.setShiptranNo(bipOrderBackLogistSaveVO.getLogistDocNo());
        salDoReturnTOBSaveDTO.setRecvContactName(bipOrderBackLogistSaveVO.getReceiverName());
        salDoReturnTOBSaveDTO.setRecvContactTel(bipOrderBackLogistSaveVO.getReceiverTel());
        salDoReturnTOBSaveDTO.setFlag("3");

        //查询订单信息
        QBipOrderDO qBipOrderDO = QBipOrderDO.bipOrderDO;
        BooleanExpression expression = qBipOrderDO.docNo.eq(bipOrderBackDO.getOrderDocNo()).and(qBipOrderDO.deleteFlag.eq(0));
        Optional<BipOrderDO> optional = bipOrderRepo.findOne(expression);
        if (optional.isPresent()) {
            BipOrderDO order = optional.get();
//            BipAddressVO bipAddressVO = bipAddressService.findById(optional.get().getAdressId());
//            if(null == bipAddressVO){
//                throw new BusinessException("同步订单中心物流信息为空");
//            }
//            salDoReturnTOBSaveDTO.setRecvProvince(bipAddressVO.getProvince());
//            salDoReturnTOBSaveDTO.setRecvCity(bipAddressVO.getCity());
//            salDoReturnTOBSaveDTO.setRecvCounty(bipAddressVO.getCounty());
//            salDoReturnTOBSaveDTO.setRecvDetailaddr(bipAddressVO.getDetailAddr());
            salDoReturnTOBSaveDTO.setRecvProvince(order.getProvince());
            salDoReturnTOBSaveDTO.setRecvCity(order.getCity());
            salDoReturnTOBSaveDTO.setRecvCounty(order.getCounty());
            salDoReturnTOBSaveDTO.setRecvDetailaddr(order.getDetailAddr());
            salDoReturnTOBSaveDTO.setLogisCarrierNo(bipOrderBackLogistSaveVO.getLogisCompany());
        } else {
          //  log.info("同步订单中心物流信息地址信息为空");
            log.info("同步订单中心物订单信息为空");
        }
        try {
            log.info("----------同步订单中心物流信息------------" + JSON.toJSONString(salDoReturnTOBSaveDTO));
          //  ApiResult<String> res = salDoReturnRpcService.updateTOBLogisInfo(salDoReturnTOBSaveDTO);
            log.info("同步订单中心物流信息完成");
        } catch (Exception e) {
            log.error("同步订单中心物流信息" + e.getMessage());
            throw e;
        }
    }


    /**
     * 更新退货单审核状态
     *
     * @param bipOrderBackSaveVO
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateCheckStatus(BipOrderBackSaveVO bipOrderBackSaveVO) {
        log.info("更新退货单审核状态:---------" + JSON.toJSONString(bipOrderBackSaveVO));
        if (bipOrderBackSaveVO.getId() == null) {
            throw new BusinessException("ID不能为空!");
        }
        if (bipOrderBackSaveVO.getStatus() == null) {
            throw new BusinessException("状态不能为空!");
        }

        BipOrderBackDO orderBackDO = bipOrderBackRepo.findById(bipOrderBackSaveVO.getId())
                .orElseThrow(() -> new BusinessException("不存在该记录：" + bipOrderBackSaveVO.getId()));


//        if (!UdcEnum.SAL_RSO_STATUS_APPING.getValueCode().equals(orderBackDO.getStatus())) {
//            throw new BusinessException("只有审批中的记录才能执行此操作！");
//        }

        //更新订单明细可退货数量
        if (!bipOrderBackSaveVO.getStatus().equals("WH") && !bipOrderBackSaveVO.getStatus().equals("WK")) {
            updateOrderDAllowBackNum(orderBackDO.getId());
        }
        List<BipOrderBackDDO> bipOrderBackDDOList = bipOrderBackDRepo.findByOrderBackId(bipOrderBackSaveVO.getId());

        if (bipOrderBackDDOList == null || bipOrderBackDDOList.isEmpty()) {
            throw new BusinessException("退货单明细为空!");
        }
        BigDecimal approveAmt = bipOrderBackDDOList.stream().map(bipOrderBackDDO -> {
//            if(bipOrderBackDDO.getApproveBackAmt()==null){
//                return bipOrderBackDDO.getApplyBackAmt();
//            }else{
//                return bipOrderBackDDO.getApproveBackAmt();
//            }
            if (null != bipOrderBackDDO.getApproveBackAmt()) {
                return bipOrderBackDDO.getApproveBackAmt();
            } else {
                return BigDecimal.ZERO;
            }


        }).reduce(BigDecimal::add).get();

//        List<BigDecimal> bigDecimals = bipOrderBackDDOList.stream().filter(b ->  null != b.getApproveBackAmt()).map(BipOrderBackDDO :: getApproveBackAmt).collect(Collectors.toList());
//        if(null != bigDecimals && !bigDecimals.isEmpty()){
//            orderBackDO.setApproveBackAmt(bigDecimals.stream().reduce(BigDecimal.ZERO,BigDecimal::add));
//        }else {
//            orderBackDO.setApproveBackAmt(BigDecimal.ZERO);
//        }


        orderBackDO.setStatus(bipOrderBackSaveVO.getStatus());
        orderBackDO.setApproveBackAmt(approveAmt);

        if (UdcEnum.SAL_RSO_STATUS_RJ.getValueCode().equals(orderBackDO.getStatus())) {
            updateOrderDAllowBackNum(bipOrderBackSaveVO.getId());
        }

        CurrentUserDTO user = UserService.currentUser();
        if (user != null) {
            orderBackDO.setApproveUserId(user.getUserId());
            orderBackDO.setApproveUserName(user.getDetail().getFirstName());
        }
        //更新允许退款金额

        orderBackDO.setApproveTime(LocalDateTime.now());

        bipOrderBackToOmsServiceimpl.updateBackOrder(bipOrderBackDDOList, bipOrderBackSaveVO.getStatus());

        bipOrderBackRepo.save(orderBackDO);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void submit(BipOrderBackSaveVO bipOrderBackSaveVO) {

        CurrentUserDTO currentUser = UserService.currentUser();
        if (currentUser == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "无法到获取当前用户");
        }

        // 设置隔离级别
        transactionTemplate.setPropagationBehavior(TransactionDefinition.PROPAGATION_REQUIRES_NEW);
        // ----------- 不同价格类型，进行校验特定的参数，校验通过返回已存在的申请单 -----------
        // 开启事务
        BipOrderBackDO bipOrderBackDO1 = transactionTemplate.execute(transactionStatus ->{
            try {
                List<BipOrderBackDDO> bipOrderBackDDOS = new ArrayList<>();
                for (BipOrderBackDSaveVO dSaveVO : bipOrderBackSaveVO.getBipOrderBackDSaveVOS()) {

                    Optional<BipOrderBackDDO> byId = bipOrderBackDRepo.findById(dSaveVO.getId());

                    if (byId.isPresent()){
                        BipOrderBackDDO backDDO = byId.get();
                        backDDO.setApproveBackAmt(dSaveVO.getApproveBackAmt());
                        backDDO.setIsWorkOrder(dSaveVO.getIsWorkOrder());
                        bipOrderBackDDOS.add(backDDO);
                    }
                }

                bipOrderBackDRepo.saveAll(bipOrderBackDDOS);
                bipOrderBackToOmsServiceimpl.updateBackOrder(bipOrderBackDDOS, bipOrderBackSaveVO.getStatus());
                return bipOrderBackRepo.findById(bipOrderBackSaveVO.getId()).get();
            } catch (Exception e){
                // 回滚
                transactionStatus.setRollbackOnly();
                throw e;
            }
        });

        /************************************************************************
         *                              工作流开始                                *
         ************************************************************************/

        if (
                org.springframework.util.StringUtils.isEmpty(bipOrderBackSaveVO.getProcInstId())  // 1.只有未起过工作流的单子才能启动工作流                                                  //2,旧单子，未起过工作流
        ) {
            /**
             * 为什么要加上面3个判断，是因为流程已经启动了,就没必要再启动流程(场景:在'审批中'的过程中，做保存操作)
             * 工作流规则:
             *  1,一个业务单据在一个流程没结束前是不能再起的同一个工作流
             *  2,一个业务单据可以同时有2个"不同类型"的流程再跑
             */
            //启动流程
            String procInstName = "B端商城退货";//流程实例名称
            ProcDefKey procDefKey = ProcDefKey.TOB_SALE_RETURN;//流程

//            ProcessInfo processInfo = workflowService.startProcess(procDefKey.name(), procInstName + "-" + bipOrderBackSaveVO.getOrderBackDocNo(), bipOrderBackSaveVO.getId() + "", null);
//            if (ObjectUtils.isEmpty(processInfo)) {
//                throw new BusinessException("工作流启动服务失败,请检查");
//            }
//            //修改业务审批数据
//            QBipOrderBackDO bipOrderBackDO = QBipOrderBackDO.bipOrderBackDO;
//            JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(bipOrderBackDO)
//                    .set(bipOrderBackDO.procInstId, processInfo.getProcInstId())//流程实例id
////                        .set(qPriSalePriceAlterDO.procInstStatus, ProcInstStatus.APPROVING)//审批状态
//                    .set(bipOrderBackDO.submitTime, LocalDateTime.now())//提交实际那
////                        .set(qPriSalePriceAlterDO.docStatus, UdcEnum.PRI_APPLY_STATUS_APPING.getValueCode())//单据状态
//                    .where(bipOrderBackDO.id.eq(bipOrderBackSaveVO.getId()));
//            if (!Objects.equals(processInfo.getProcInstStatus(), ProcInstStatus.APPROVED)) {
//                jpaUpdateClause.set(bipOrderBackDO.procInstStatus, ProcInstStatus.APPROVING);
//                jpaUpdateClause.set(bipOrderBackDO.status, UdcEnum.SAL_RSO_STATUS_APPING.getValueCode());
//            }
//            jpaUpdateClause.execute();

        } else {
            throw new BusinessException("只有未起过工作流的单子才能开始审批,请检查");
        }

        /************************************************************************
         *                              工作流结束                                *
         ************************************************************************/
    }


    /**
     * 退货单撤销申请
     *
     * @param id
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void cancle(Long id) {
        updateOrderDAllowBackNum(id);
        bipOrderBackRepoProc.updateStatus(id, "CL");
    }


    /**
     * 更新订单退货数量
     *
     * @param id
     */
    @Transactional(rollbackFor = Exception.class)
    public void updateOrderDAllowBackNum(Long id) {
        BipOrderBackDO bipOrderBackDO = bipOrderBackRepo.findById(id).get();
        Long orderId = bipOrderBackDO.getOrderId();
        List<BipOrderBackDDO> bipOrderBackDDOList = bipOrderBackDRepo.findByOrderBackId(id);
        for (BipOrderBackDDO bipOrderBackDDO : bipOrderBackDDOList) {
            Long orderDId = bipOrderBackDDO.getOrderDId();
            Long backNum = bipOrderBackDDO.getBackNum();
            Optional<BipOrderDDO> optional = bipOrderDRepo.findById(orderDId);
            if (optional.isPresent()) {
                BipOrderDDO orderDDO = optional.get();
                orderDDO.setAllowBackNum(orderDDO.getAllowBackNum() + backNum);
                bipOrderDRepo.save(orderDDO);
            }
            //     bipOrderDRepoProc.updateOrderDAllowBackNum(orderId,backNum);
        }
    }


    /**
     * 获取状态中文名
     *
     * @param bipOrderBackRespVO
     */
    public void findStatusName(BipOrderBackRespVO bipOrderBackRespVO) {
        Map<String, String> statusMap = udcProvider.getValueMapByUdcCode("yst-sale", "RSO_STATUS");

        if (statusMap != null) {
            String statusName = statusMap.get(bipOrderBackRespVO.getStatus());
            bipOrderBackRespVO.setStatusName(statusName);
        }

    }


    /**
     * 获取状态英文
     *
     * @param bipOrderBackRespVO
     */
    public void findBackTypeName(BipOrderBackRespVO bipOrderBackRespVO) {
        Map<String, String> backTypeMap = udcProvider.getValueMapByUdcCode("yst-sale", "SO_BACK_TYPE");
        if (backTypeMap != null) {
            String statusName = backTypeMap.get(bipOrderBackRespVO.getBackType());
            bipOrderBackRespVO.setBackTypeName(statusName);
        }


    }

    /**
     * 获取状态英文
     *
     * @param bipOrderBackRespVO
     */
    public void findBackResonName(BipOrderBackRespVO bipOrderBackRespVO) {
        Map<String, String> backReasonMap = udcProvider.getValueMapByUdcCode("yst-sale", "SO_RETURN_REASON");
        if (backReasonMap != null) {
            String reasonName = backReasonMap.get(bipOrderBackRespVO.getBackReason());
            bipOrderBackRespVO.setBackReasonName(reasonName);
        }

    }


    /**
     * 5021-发送退款请求
     */
    public CPCN5021Resp cpcn5011Request(Long backOrderId) {
//        BipOrderBackDO bipOrderBackDO = bipOrderBackRepo.findById(backOrderId).get();
//        Long orderId = bipOrderBackDO.getOrderId();
//        BipOrderDO bipOrderDO = bipOrderRepo.findById(orderId).get();
//        if (orderId == null || bipOrderDO == null) {
//            throw new BusinessException("退货单未关联订单ID异常!");
//        }
//        //退款生成流水号给中金
//        String txSN = CPCNUtils.getTxSN();
//        //支付流水号
//        String txsn = bipOrderDO.getTxsn();
//        if (StringUtils.isBlank(txsn)) {
//            throw new BusinessException("订单交易流水号为空!");
//        }
//        LocalDateTime payTime = bipOrderDO.getPayTime();
//        if (payTime == null) {
//            throw new BusinessException("订单支付时间为空!");
//        }
//        String sourceTxTime = DateTimeUtil.FORMATTER_DATE.format(payTime).replace("-", "");
//        BigDecimal amt = bipOrderBackDO.getApproveBackAmt();
//        if (amt == null || amt.compareTo(BigDecimal.ZERO) <= 0) {
//            throw new BusinessException("退款金额必须大于0!");
//
//        }
//
//        amt = amt.multiply(BigDecimal.valueOf(100));
//        //转换的 5021 响应信息
//        CPCN5021Req req = new CPCN5021Req();
//        req.setPaymentTxSN(bipOrderDO.getTxsn());
//        req.setTxSN(txSN);
//
//      //  req.setAmount(String.valueOf(1));
//        req.setAmount(String.valueOf(bipOrderBackDO.getApproveBackAmt().movePointRight(2).intValue()));
//        req.setRefundWay("20");
//        req.setSourceTxTime(sourceTxTime);
//        req.setRemark("B端商城线上支付退款");
//
//        log.info("回调地址信息---" + returnNoticUrl);
//        req.setNoticeURL(returnNoticUrl);
//        log.info("中金请求信息---" + JSON.toJSONString(req));
//        //向中金发送报文获取响应结果
//        CPCN5021Resp response = CPCNUtils.cpcn5021Request(req);
//        log.info("中金返回信息---" + JSON.toJSONString(response));
//        return response;
        return null;
    }



}
