package com.elitesland.yst.production.sale.config.cas;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.provider.TenantDataIsolateProvider;
import com.elitescloud.boot.tenant.client.common.TenantProvider;
import com.elitescloud.cloudt.authorization.sdk.cas.model.AuthUserDTO;
import com.elitescloud.cloudt.common.common.CloudtOptional;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.yst.production.sale.api.service.ComSaleFileInfoService;
import com.elitesland.yst.production.sale.api.vo.resp.com.ComSaleFileComVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CustAccountVO;
import com.elitesland.yst.production.sale.common.constant.ConstantsSale;
import com.elitesland.yst.production.sale.entity.CustAccountDO;
import com.elitesland.yst.production.sale.repo.CustAccountRepo;
import com.elitesland.yst.production.sale.repo.CustAccountRepoProc;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysRoleService;
import lombok.extern.log4j.Log4j2;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

@Service
@Log4j2
public class UserSourceServiceImpl implements UserSourceService {

    @Autowired
    private CustAccountRepoProc custAccountRepoProc;

    @Autowired
    private CustAccountRepo custAccountRepo;

    @Autowired
    private TenantProvider tenantProvider;

    @Autowired
    private RmiSysRoleService rmiSysRoleService;

    @Autowired
    private TaskExecutor taskExecutor;

    @Autowired
    private TenantDataIsolateProvider tenantDataIsolateProvider;

    @Autowired
    private ComSaleFileInfoService ComSaleFileInfoService;


    @Override
    public SysUserDTO loadUserByUsername(String username) {
        if(StringUtils.isEmpty(username)){
            throw new BusinessException("账号/手机号为空");
        }
        CustAccountVO custAccount = custAccountRepoProc.getAccountByUserName(username);
        log.info("查看所登录的账号信息为:【"+custAccount+"】");
        if (custAccount == null) {
            return null;
        }
        SysUserDTO sysUser = new SysUserDTO();
        sysUser.setUsername(username);
        sysUser.setId(custAccount.getUserId());
        sysUser.setMobile(custAccount.getMobile());
        sysUser.setEnabled(true);
        // 数据处理
        if (!ObjectUtils.isEmpty(custAccount.getRoleId())){
            sysUser.setRoleIds(Set.of(custAccount.getRoleId()));
            sysUser.setRoleCodes(Set.of(custAccount.getRoleCode()));
        }
        sysUser.setLastName(custAccount.getNickName());
        // 处理头像
        List<ComSaleFileComVO> byBusinessId = ComSaleFileInfoService.findFileByBusinessId(ConstantsSale.FILE_SCENE, custAccount.getId());
        if (!ObjectUtils.isEmpty(byBusinessId)){
            sysUser.setAvatarUrl(byBusinessId.get(0).getFileCode());
        }
        // 获取租户
        CloudtOptional<SysTenantDTO> providerById = tenantProvider.getById(custAccount.getTenantId());
        if (providerById.isPresent()){
            sysUser.setSysTenantDTOList(Collections.singletonList(providerById.get()));
            sysUser.setSysTenantVO(providerById.get());
        }
        return sysUser;
    }

    @Override
    public SysUserDTO loadUserByMobile(String mobile) {
        if(StringUtils.isEmpty(mobile)){
            throw new BusinessException("账号/手机号为空");
        }
        CustAccountVO custAccount = custAccountRepoProc.getAccountByMobile(mobile);
        log.info("查看所登录的账号信息为:【"+custAccount+"】");
        if (custAccount == null) {
            return null;
        }
        SysUserDTO sysUser = new SysUserDTO();
        sysUser.setUsername(mobile);
        sysUser.setId(custAccount.getUserId());
        sysUser.setMobile(custAccount.getMobile());
        sysUser.setEnabled(true);
        // 数据处理
        if (!ObjectUtils.isEmpty(custAccount.getRoleId())){
            sysUser.setRoleIds(Set.of(custAccount.getRoleId()));
            sysUser.setRoleCodes(Set.of(custAccount.getRoleCode()));
        }
        sysUser.setLastName(custAccount.getNickName());
        // 处理头像
        List<ComSaleFileComVO> byBusinessId = ComSaleFileInfoService.findFileByBusinessId(ConstantsSale.FILE_SCENE, custAccount.getId());
        if (!ObjectUtils.isEmpty(byBusinessId)){
            sysUser.setAvatarUrl(byBusinessId.get(0).getFileCode());
        }
        // 获取租户
        CloudtOptional<SysTenantDTO> providerById = tenantProvider.getById(custAccount.getTenantId());
        if (providerById.isPresent()){
            sysUser.setSysTenantDTOList(Collections.singletonList(providerById.get()));
            sysUser.setSysTenantVO(providerById.get());
        }
        return sysUser;
    }


    @Override
    public SysUserDTO loadUserById(Long id) {
        if(ObjectUtils.isEmpty(id)){
            throw new BusinessException("账号/手机号为空");
        }
        CustAccountVO custAccount = custAccountRepoProc.getAccountByUserId(id);
        log.info("查看所登录的账号信息为:【"+custAccount+"】");
        if (custAccount == null) {
            return null;
        }
        SysUserDTO sysUser = new SysUserDTO();
        sysUser.setUsername(custAccount.getUserName());
        sysUser.setUserType(custAccount.getDealerType());
        sysUser.setId(custAccount.getUserId());
        sysUser.setMobile(custAccount.getMobile());
        sysUser.setEnabled(true);
        // 数据处理
        if (!ObjectUtils.isEmpty(custAccount.getRoleId())){
            sysUser.setRoleIds(Set.of(custAccount.getRoleId()));
            sysUser.setRoleCodes(Set.of(custAccount.getRoleCode()));
        }
        sysUser.setLastName(custAccount.getNickName());
        // 处理头像
        List<ComSaleFileComVO> byBusinessId = ComSaleFileInfoService.findFileByBusinessId(ConstantsSale.FILE_SCENE, custAccount.getId());
        if (!ObjectUtils.isEmpty(byBusinessId)){
            sysUser.setAvatarUrl(byBusinessId.get(0).getFileCode());
        }
        // 获取租户
        CloudtOptional<SysTenantDTO> providerById = tenantProvider.getById(custAccount.getTenantId());
        if (providerById.isPresent()){
            sysUser.setSysTenantDTOList(Collections.singletonList(providerById.get()));
            sysUser.setSysTenantVO(providerById.get());
        }
        return sysUser;
    }


    @Override
    public List<AuthUserDTO> queryUser(int size) {
        return null;
    }

    @Override
    public void updateCasUserId(String username, long userId) {
        CustAccountDO custAccountDO = custAccountRepoProc.getByUserName(username);
        custAccountDO.setUserId(userId);
        custAccountDO.setIsOpenAccount(true);
        custAccountDO.setCreateAccountTime(LocalDateTime.now());
        custAccountDO.setUserName(username);
        custAccountDO.setEnable(true);
        custAccountRepo.save(custAccountDO);
        // 异步构建
        CompletableFuture.runAsync(() ->{
            if(!ObjectUtils.isEmpty(custAccountDO.getRoleId())){
                rmiSysRoleService.generateCode(custAccountDO.getUserId(), Collections.singletonList(custAccountDO.getRoleId()));
            }
        }, taskExecutor);
    }


}
