package com.elitesland.yst.production.sale.controller.crm;

import com.elitesland.yst.production.sale.api.service.CrmCust2Service;
import com.elitesland.yst.production.sale.api.service.CrmCustService;
import com.elitesland.yst.production.sale.api.service.shop.BipCrmCustService;
import com.elitesland.yst.production.sale.api.vo.param.crm.*;
import com.elitesland.yst.production.sale.api.vo.resp.crm.*;
import com.elitesland.yst.production.sale.api.vo.resp.sal.RmiOuDetailVO;
import com.elitesland.yst.production.sale.api.vo.resp.sal.RmiOuInfoByAddr;
import com.elitesland.yst.production.sale.api.vo.save.CrmAddrImplSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.CrmCustImportSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.CrmCustSaveVO;
import com.elitesland.yst.production.sale.controller.BaseController;
import com.elitesland.yst.production.sale.core.util.excel.support.ExportColumnParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.common.param.ComSearchParam;
import com.elitescloud.boot.exception.BusinessException;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021-05-14
 */
@RestController
@RequestMapping(value = "/crm/cust", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(tags = "客户信息")
@ApiSupport(author = "wang shao", order = 1)
@Slf4j
public class CrmCustController extends BaseController {

    @Autowired
    private CrmCustService custService;

    @Autowired
    private BipCrmCustService bipCrmCustService;

    @Autowired
    private CrmCust2Service crmCust2Service;

//    @PostMapping(value = "/checkCustData")
//    @ApiOperation(value = "查询客户信息")
//    @ApiOperationSupport(order = 1)
//    public ApiResult<List<CheckCustResVO>> checkCustData(@RequestBody CheckCustParamVO param) {
//        return custService.checkCustData(param);
//    }


    @PostMapping(value = "/queryCustAddr")
    @ApiOperation(value = "查询客户地址信息")
    public ApiResult<List<CrmCustAddrRespVO>> queryCustAddr(){
        List<CrmCustAddrRespVO> res = custService.queryCustAddr();
        return ApiResult.ok(res);
    }


    @PostMapping(value = "/saveCustAddr")
    @ApiOperation(value = "新增/修改客户地址信息")
    public ApiResult<Object> saveCustAddr(@RequestBody OrgAddrAddressSaveParam param){
        Long res = custService.saveCustAddr(param);
        return ApiResult.ok(res);
    }

    @DeleteMapping(value = "/delCustAddr/{id}")
    @ApiOperation(value = "删除地址信息")
    public ApiResult<Object> delCustAddr(@PathVariable Long id){
        custService.delCustAddr(id);
        return ApiResult.ok();
    }


//    @PostMapping(value = "/saveCustAddr")
//    @ApiOperation(value = "修改客户地址信息")
//    public ApiResult<Object> saveCustAddr(@RequestBody List<CrmCustAddrSaveVO> addrList){
//        Long res = custService.saveCustAddr(addrList);
//        return ApiResult.ok(res);
//    }



    @PostMapping(value = "/query")
    @ApiOperation(value = "查询客户信息")
    @ApiOperationSupport(order = 1)
    public ApiResult<PagingVO<CrmCustSimpleVO>> query(@RequestBody ComSearchParam searchParam) {
        return custService.query(searchParam);
    }

    @PostMapping(value = "/queryCustPlugIn")
    @ApiOperation(value = "查询客户信息(客户弹框选择)")
    @ApiOperationSupport(order = 2)
    public ApiResult<PagingVO<CrmCustPlugInRespVO>> queryCustPlugIn(@RequestBody CrmCustPlugInParamVO searchParam) {
        return custService.queryCustPlugIn(searchParam);
    }

    @PostMapping(value = "/queryCustSalePrediction")
    @ApiOperation(value = "销售预测查询客户")
    public ApiResult<PagingVO<CustSalePredictionVO>> queryCustSalePrediction(@RequestBody CustPredictionParamVO param){
        return ApiResult.ok(custService.queryCustSalePrediction(param));
    }

    @GetMapping(value = "/{id}")
    @ApiOperation(value = "查询客户详情数据")
    @ApiOperationSupport(order = 2)
    public ApiResult<CrmCustDetailRespVO> get(@PathVariable Long id) {
        return ApiResult.ok(custService.get(id));
    }

    @GetMapping(value = "/getByUserName/{userId}")
    @ApiOperation(value = "通过用户名查询客户信息")
    @ApiOperationSupport(order = 2)
    public ApiResult<CrmCustDetailRespVO> getByUserName(@PathVariable Long userId) {
//        return ApiResult.ok(custService.getByUserName(userName));
        return ApiResult.ok(custService.getByUserId(userId));
    }




    @PostMapping("/switch")
    @ApiOperation("启用/禁用 客户")
    public ApiResult<Object> switchStatusByIds(@RequestBody CustSwitchStatusParamVO paramVO) {
        custService.switchStatusByIds(paramVO);
        return ApiResult.ok();
    }

    @PostMapping(value = "/search")
    @ApiOperation(value = "分页查询客户列表")
    @ApiOperationSupport(order = 3)
    public ApiResult<PagingVO<CrmCustPageRespVO>> search(@RequestBody CrmCustQueryParamVO searchParam) {
        PagingVO<CrmCustPageRespVO> result = custService.search(searchParam);
        return ApiResult.ok(result);
    }

    @PostMapping(value = "")
    @ApiOperation(value = "保存数据")
    @ApiOperationSupport(order = 4)
    public ApiResult<Long> save(@RequestBody CrmCustSaveVO saveVO) {
        CrmCustDetailRespVO crmCustDetailRespVO = custService.save(saveVO).getData();
        return ApiResult.ok(crmCustDetailRespVO.getId());
    }

    @PostMapping(value = "/save")
    @ApiOperation(value = "保存数据")
    @ApiOperationSupport(order = 4)
    public ApiResult<Long> bcSave(@RequestBody CrmCustSaveVO saveVO) {
        CrmCustDetailRespVO crmCustDetailRespVO = custService.bcSave(saveVO).getData();
        return ApiResult.ok(crmCustDetailRespVO.getId());
    }

    @PostMapping(value = "/ImportData")
    @ApiOperation(value = "解析导入客户信息数据")
    @ApiOperationSupport(order = 5)
    public ApiResult<List<CrmCustImportSaveVO>> parseImportData(MultipartFile file) {
        List<CrmCustImportSaveVO> parseData = null;
        try {
            parseData = (List<CrmCustImportSaveVO>) this.importExcel(file, CrmCustImportSaveVO.class, 2, 2);
        } catch (Exception e) {
            return ApiResult.fail("解析导入文件失败，请严格按照原始模板数据格式进行导入");
        }
        if (!CollectionUtils.isEmpty(parseData)) {
            return custService.custImportData(parseData);
        }
        return ApiResult.ok();
    }

    @PostMapping(value = "/ImportAddrData")
    @ApiOperation(value = "解析导入客户地址信息数据")
    @ApiOperationSupport(order = 6)
    public ApiResult<List<CrmAddrImplSaveVO>> parseImportAddrData(MultipartFile file) {
        List<CrmAddrImplSaveVO> parseData = null;
        try {
            parseData = (List<CrmAddrImplSaveVO>) this.importExcel(file, CrmAddrImplSaveVO.class, 2, 2);
        } catch (Exception e) {
            return ApiResult.fail("解析导入文件失败，请严格按照原始模板数据格式进行导入");
        }
        if (!CollectionUtils.isEmpty(parseData)) {
            return custService.custaddrImportData(parseData);
        }
        return ApiResult.ok();
    }

    @PostMapping(value = "/empAssign")
    @ApiOperation(value = "批量分配业务员")
    @ApiOperationSupport(order = 7)
    public ApiResult<Object> empAssign(@RequestBody CrmEmpAssignParamVO crmEmpAssignParamVO) {
        custService.empAssign(crmEmpAssignParamVO);
        return ApiResult.ok();
    }

    @PostMapping(value = "/findAddrsByParam")
    @ApiOperation(value = "通过查询条件查询地址信息")
    @ApiOperationSupport(order = 8)
    public ApiResult<List<CrmCustAddrRespVO>> findAddrsByAddrNo(@RequestBody CrmCustAddrParamVO crmCustAddrParamVO) {
        List<CrmCustAddrRespVO> crmCustAddrRespVOS = custService.findAddrsByParam(crmCustAddrParamVO);
        return ApiResult.ok(crmCustAddrRespVOS);
    }

    @GetMapping(value = "/custMdmSync/{id}")
    @ApiOperation(value = "通过id同Mdm系统同步数据")
    @ApiOperationSupport(order = 8)
    public ApiResult<Object> custMdmSync(@PathVariable Long id) {
        custService.custMdmSync(id);
        return ApiResult.ok();
    }

    @GetMapping(value = "/findCustByCode/{custCode}")
    @ApiOperation(value = "通过客户编码精确查询数据")
    @ApiOperationSupport(order = 9)
    public ApiResult<Object> findCustByCode(@PathVariable String custCode) {
        return ApiResult.ok(custService.findCustByCode(custCode));
    }

    @ApiOperation(value = "创建客户登陆账户")
    @ApiOperationSupport(order = 10)
    @PutMapping(value = "/createUserAccount/{ids}")
    public ApiResult<Object> createUserAccount(@PathVariable List<Long> ids) {
        String createInfo = bipCrmCustService.createUserAccount(ids);
        return StringUtils.isEmpty(createInfo) ? ApiResult.ok() : ApiResult.fail(createInfo);
    }

    @PostMapping(value = "/exportData")
    @ApiOperation(value = "客 户导出")
    @ApiOperationSupport(order = 11)
    public void exportCrm(HttpServletResponse response, @RequestBody CrmCustQueryParamVO pagingParamVO) {
        //导出列
        List<ExportColumnParam> columnParamList = new ArrayList<>(16);
        //确定导出字段
        columnParamList.add(new ExportColumnParam("custCode", "客户编码"));
        columnParamList.add(new ExportColumnParam("custName", "客户名称"));
        columnParamList.add(new ExportColumnParam("custAbbr", "客户简称"));
        columnParamList.add(new ExportColumnParam("custName2", "英文名称"));
        columnParamList.add(new ExportColumnParam("custCode2", "外部客户编码"));
        columnParamList.add(new ExportColumnParam("taxRegNo", "税务登记号"));
        columnParamList.add(new ExportColumnParam("custType2Name", "客户归类"));
        columnParamList.add(new ExportColumnParam("contactName", "B端商城联系人"));
        columnParamList.add(new ExportColumnParam("contactPhone", "B端商城联系人电话"));

        columnParamList.add(new ExportColumnParam("ouName", "公司"));
        columnParamList.add(new ExportColumnParam("buName", "组织"));
        columnParamList.add(new ExportColumnParam("regionName", "区域"));
        columnParamList.add(new ExportColumnParam("agentEmpName", "业务员"));
        columnParamList.add(new ExportColumnParam("custTypeName", "客户分类"));
        columnParamList.add(new ExportColumnParam("custIndustryName", "客户行业"));
        columnParamList.add(new ExportColumnParam("custLevel", "客户等级"));
        columnParamList.add(new ExportColumnParam("custStatusName", "客户状态"));
        columnParamList.add(new ExportColumnParam("custSourceName", "客户来源"));
        columnParamList.add(new ExportColumnParam("compScaleName", "客户规模"));

        columnParamList.add(new ExportColumnParam("compTurnover", "客户年营业额"));
        columnParamList.add(new ExportColumnParam("financialAttributeName", "财务属性1"));
        columnParamList.add(new ExportColumnParam("financialAttribute2Name", "财务属性2"));
        columnParamList.add(new ExportColumnParam("financialAttribute3Name", "财务属性3"));
        columnParamList.add(new ExportColumnParam("financialAttribute4Name", "财务属性4"));
        columnParamList.add(new ExportColumnParam("financialGroup", "财务属性组合"));
        columnParamList.add(new ExportColumnParam("custGroup2Name", "大B/小B"));
        columnParamList.add(new ExportColumnParam("invTypeName", "发票类型"));
        columnParamList.add(new ExportColumnParam("invTitle", "开票抬头"));
        columnParamList.add(new ExportColumnParam("taxerNo", "税号"));
        columnParamList.add(new ExportColumnParam("invAddress", "开票地址"));
        columnParamList.add(new ExportColumnParam("invTel", "开票电话"));
        columnParamList.add(new ExportColumnParam("invBankName", "开户银行"));
        columnParamList.add(new ExportColumnParam("invBankAcc", "银行账户"));
        columnParamList.add(new ExportColumnParam("invPicName", "联系人"));
        columnParamList.add(new ExportColumnParam("paymentTermName", "付款条款"));


        columnParamList.add(new ExportColumnParam("ardaysCheckTypeName", "账期检查类型"));
        columnParamList.add(new ExportColumnParam("creditCheckTypeName", "信贷检查类型"));
        columnParamList.add(new ExportColumnParam("creditLimit", "信贷额度"));

        columnParamList.add(new ExportColumnParam("contPerson", "客户地址联系人"));
        columnParamList.add(new ExportColumnParam("contPersonMobile", "客户地址联系人手机"));
        columnParamList.add(new ExportColumnParam("contPersonTel", "客户联系人电话"));
        columnParamList.add(new ExportColumnParam("contPersonFax", "客户联系人传真"));
        columnParamList.add(new ExportColumnParam("contPersonEmail", "客户联系人邮箱"));

        columnParamList.add(new ExportColumnParam("country", "国家"));
        columnParamList.add(new ExportColumnParam("contractCityName", "省/市/(区、县)"));
        columnParamList.add(new ExportColumnParam("street", "乡镇/街道"));
        columnParamList.add(new ExportColumnParam("addrDetail", "客户详细地址"));
        try {
            export(response, "发货单导出数据", columnParamList, paramVO -> crmCust2Service.searchForExport(paramVO).getData(), pagingParamVO);
        } catch (Exception e) {
            throw new BusinessException("导出失败");
        }
    }

//    @GetMapping(value = "/getMdmCustCode/{taxRegNo}")
//    @ApiOperation(value = "获取Mdm客户编码")
//    @ApiOperationSupport(order = 12)
//    public ApiResult<String> getMdmCustCode(@PathVariable String taxRegNo){
//        return ApiResult.ok(custService.getMdmCustCode(taxRegNo));
//    }

    @GetMapping(value = "/getOuByAddr/{addrNo}")
    @ApiOperation(value = "获取公司信息")
    @ApiOperationSupport(order = 13)
    public ApiResult<RmiOuInfoByAddr> getOuByAddr(@PathVariable Long addrNo){
        return ApiResult.ok(custService.getOuByAddr(addrNo));
    }

    @GetMapping(value = "/getOuDetail/{ouCode}")
    @ApiOperation(value = "获取公司信息2")
    @ApiOperationSupport(order = 14)
    public ApiResult<RmiOuDetailVO> getOuByCode(@PathVariable String ouCode){
        return ApiResult.ok(custService.getOuByCode(ouCode));
    }


    @PostMapping("/getCustBasePage")
    @ApiOperation(value = "门店专用客户信息分页")
    public ApiResult<PagingVO<CrmCustBasePageVO>> getCustBasePage(@RequestBody CrmCustBaseParamVO crmCustBaseParamVO){
        return ApiResult.ok(custService.getCustBasePage(crmCustBaseParamVO));
    }

    @GetMapping("/syncSyncToOu/{ids}")
    @ApiOperation("同步数据到公司")
    public ApiResult<Object> syncSyncToOu(@PathVariable List<Long> ids){
        return custService.syncSyncToOu(ids);
    }


}
