package com.elitesland.yst.production.sale.controller.crm;

import com.elitesland.yst.production.sale.api.service.shop.BipCustUserBindService;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipCustUserBindPageQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipCustUserBindPageRespVO;
import com.elitesland.yst.production.sale.controller.BaseController;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import lombok.val;
import netscape.javascript.JSObject;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 客户信息管理API
 * </p>
 *
 * @author ssy
 * @since 2021/9/7
 */
@Slf4j
@Api(value = "客户信息管理（管理端）", tags = "客户信息管理（管理端）")
@RestController
@RequestMapping(value = "/bip/custUserBind", produces = MediaType.APPLICATION_JSON_VALUE)
@RequiredArgsConstructor
public class CrmCustUserBindController extends BaseController {

    private final BipCustUserBindService bipCustUserBindService;

    @PostMapping("/search")
    @ApiOperation("(管理端)分页查询(主表)")
    @ApiOperationSupport(order = 1)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "param", value = "分页查询参数", required = true, dataType = "BipCustUserBindPageQueryVO")
    })
    public ApiResult<PagingVO<BipCustUserBindPageRespVO>> search(@RequestBody BipCustUserBindPageQueryVO param) {
        val ret = bipCustUserBindService.search(param);
        return ApiResult.ok(ret);
    }

    @PatchMapping(value = "/state/{ids}/{status}")
    @ApiOperation(value = "(管理端)状态修改")
    @ApiOperationSupport(order = 2)
    public ApiResult<JSObject> state(@PathVariable("ids") List<Long> ids, @PathVariable("status") String status) {
        bipCustUserBindService.updateState(ids, status);
        return ApiResult.ok();
    }

    @PatchMapping(value = "/stateApply/{ids}/{status}")
    @ApiOperation(value = "(管理端)审批状态修改")
    @ApiOperationSupport(order = 3)
    public ApiResult<JSObject> stateApply(@PathVariable("ids") List<Long> ids, @PathVariable("status") String status) {
        bipCustUserBindService.updateStateApply(ids, status);
        return ApiResult.ok();
    }
}
