package com.elitesland.yst.production.sale.controller.crm;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.yst.production.sale.api.service.ComSaleFileInfoService;
import com.elitesland.yst.production.sale.api.service.CrmCustService;
import com.elitesland.yst.production.sale.api.service.DeCustAccountService;
import com.elitesland.yst.production.sale.api.vo.param.crm.CrmCustAccountParam;
import com.elitesland.yst.production.sale.api.vo.param.crm.CustAccountQueryParam;
import com.elitesland.yst.production.sale.api.vo.param.crm.CustUpdateVO;
import com.elitesland.yst.production.sale.api.vo.resp.com.ComSaleFileComVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CustAccountVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.RemarkCustPwdVO;
import com.elitesland.yst.production.sale.api.vo.save.CustAccountUpdateVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.checkerframework.checker.units.qual.A;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2023/2/21 11:10
 */
@RestController
@RequestMapping(value = "dealer/account", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(tags = "经销商账户")
@Slf4j
public class DeCustAccountController {

    @Autowired
    private DeCustAccountService deCustAccountService;

    @Autowired
    private ComSaleFileInfoService comSaleFileInfoService;

    @Autowired
    private CrmCustService crmCustService;

    @PostMapping(value = "/create")
    @ApiOperation(value = "创建子账户账号")
    public ApiResult<Object> createCustAccount(@RequestBody CustUpdateVO param){
        try {
            return ApiResult.ok(deCustAccountService.createSonUser(param));
        } catch (BusinessException e) {
            return ApiResult.fail(e.getMessage());
        }
    }

    @PostMapping(value = "/search")
    @ApiOperation(value = "查询当前用户下的子账号")
    public ApiResult<PagingVO<CustAccountVO>> searchCustAccount(@RequestBody CustAccountQueryParam param){
        try {
            return ApiResult.ok(deCustAccountService.searchCustAccount(param));
        } catch (BusinessException e) {
            return ApiResult.fail(e.getMessage());
        }
    }

    @PostMapping(value = "/updateAccount")
    @ApiOperation(value = "修改子账户信息")
    public ApiResult<Object> updateCustAccount(@RequestBody CustUpdateVO param){
        try {
            return ApiResult.ok(deCustAccountService.updateSonAccount(param));
        } catch (BusinessException e) {
            return ApiResult.fail(e.getMessage());
        }
    }

    @PutMapping(value = "/updatePwd")
    @ApiOperation(value = "忘记密码")
    public ApiResult<Object> remakePwd(@RequestBody CustAccountUpdateVO custAccountUpdate){
        try {
            return ApiResult.ok(deCustAccountService.remakePwd(custAccountUpdate));
        } catch (BusinessException e) {
            return ApiResult.fail(e.getMessage());
        }
    }



    @PostMapping(value = "/delSonAccount")
    @ApiOperation(value = "删除子账号")
    public ApiResult<Object> delSonAccount(@RequestBody List<Long> accountIds){
        try {
            return ApiResult.ok(deCustAccountService.delSonAccount(accountIds));
        } catch (BusinessException e) {
            return ApiResult.fail(e.getMessage());
        }
    }

    @PostMapping("/updateImage")
    @ApiOperation("修改附件")
    public ApiResult<Object> updateComFile(@RequestBody ComSaleFileComVO param) {
        try {
            return ApiResult.ok(comSaleFileInfoService.updateComFile(param));
        } catch (BusinessException e) {
            return ApiResult.fail(e.getMessage());
        }
    }

    @GetMapping("/findCustInfo/{userId}")
    @ApiOperation("查询客户信息")
    public ApiResult<Object> findCustInfo(@PathVariable Long userId) {
        try {
            return ApiResult.ok(crmCustService.getCustSimpleByUserId(userId));
        } catch (BusinessException e) {
            return ApiResult.fail(e.getMessage());
        }
    }

    @GetMapping(value = "/sendVerificationCode/{phone}")
    @ApiOperation(value = "手机发送验证码")
    public ApiResult<String> sendSms(@PathVariable String phone) {
        try {
            return deCustAccountService.sendSms(phone);
        } catch (BusinessException e) {
            return ApiResult.fail(e.getMessage());
        }
    }


    @GetMapping(value = "/sendVerificationCode2/{phone}")
    @ApiOperation(value = "手机发送验证码")
    public ApiResult<List<RemarkCustPwdVO>> sendSms2(@PathVariable String phone) {
        try {
            return deCustAccountService.sendSms2(phone);
        } catch (BusinessException e) {
            return ApiResult.fail(e.getMessage());
        }
    }

    @GetMapping("/isModifyPwd/{userName}")
    public ApiResult<Boolean> isModifyPwd(@PathVariable String userName){
        return ApiResult.ok(deCustAccountService.isModifyPwd(userName));
    }

    @GetMapping("/modifyPwdStatus/{userId}")
    public ApiResult<String> modifyPwdStatus(@PathVariable Long userId){
        return deCustAccountService.modifyPwdStatus(userId);
    }

    @GetMapping("/isModifyPwdByUserId/{userId}")
    public ApiResult<Boolean> isModifyPwdByUserId(@PathVariable Long userId){
        return ApiResult.ok(deCustAccountService.isModifyPwdByUserId(userId));
    }


}
