package com.elitesland.yst.production.sale.controller.record;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.service.ExectRecordService;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.ExecutRecordQueryParam;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.ExecutRecordRespVO;
import com.elitesland.yst.production.sale.api.vo.save.ExecutRecordSaveVO;
import com.elitesland.yst.production.sale.controller.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 执行记录模板管理
 * @author wz
 * @date 2021-06-16 14:43:45
 */


@RestController
@RequestMapping(value = "/app/record", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(value = "APP执行记录管理", tags = {"APP执行记录管理"})
@RequiredArgsConstructor
public class ExecutionRecordAppController extends BaseController {

    private final ExectRecordService exectRecordService;

    @PostMapping(value = "/query")
    @ApiOperation(value = "执行记录-分页查询")
    public ApiResult<PagingVO<ExecutRecordRespVO>> query(@RequestBody ExecutRecordQueryParam param) {
        PagingVO<ExecutRecordRespVO> respVOPackage=exectRecordService.query(param);
        return ApiResult.ok(respVOPackage);
    }

    @PostMapping(value = "/save")
    @ApiOperation(value = "执行记录-新增/修改")
    public ApiResult<Long> save(@RequestBody ExecutRecordSaveVO saveVO) {
        Long id = exectRecordService.save(saveVO);
        return ApiResult.ok(id);
    }

    @PostMapping(value = "/queryDtl")
    @ApiOperation(value = "执行记录-明细查询")
    public ApiResult<ExecutRecordRespVO> queryDtl(@RequestBody ExecutRecordQueryParam param) {
        ExecutRecordRespVO executRecordRespVO = exectRecordService.queryDtl(param);
        return ApiResult.ok(executRecordRespVO);
    }

    @PostMapping(value = "/queryByLast")
    @ApiOperation(value = "执行记录-上次记录查询")
    public ApiResult<ExecutRecordRespVO> queryByLast(@RequestBody ExecutRecordQueryParam param) {
        ExecutRecordRespVO executRecordRespVO = exectRecordService.queryByLast(param);
        return ApiResult.ok(executRecordRespVO);
    }

    @PostMapping(value = "/submit")
    @ApiOperation(value = "执行记录-提交")
    public ApiResult<Long> submit(@RequestBody ExecutRecordSaveVO saveVO) {
        Long id = exectRecordService.submit(saveVO);
        return ApiResult.ok(id);
    }

    @PostMapping(value = "/approved")
    @ApiOperation(value = "执行记录-审核通过")
    public ApiResult<Long> approved(@RequestBody ExecutRecordSaveVO saveVO) {
        Long approved = exectRecordService.approved(saveVO);
        return ApiResult.ok(approved);
    }

    @PostMapping(value = "/refuse")
    @ApiOperation(value = "执行记录-审核拒绝")
    public ApiResult<Long> refuse(@RequestBody ExecutRecordSaveVO saveVO) {
        Long refuse = exectRecordService.refuse(saveVO);
        return ApiResult.ok(refuse);
    }

    @PostMapping(value = "/close")
    @ApiOperation(value = "执行记录-更新执行记录为已关闭")
    public ApiResult<Long> close(@RequestBody List<String> codes) {
        Long refuse = exectRecordService.close(codes);
        return ApiResult.ok(refuse);
    }

    @PostMapping(value = "/filterClose")
    @ApiOperation(value = "执行记录-非审核通过状态记录更新为已关闭")
    public ApiResult<Long> filterClose(@RequestBody List<String> codes) {
        Long refuse = exectRecordService.filterClose(codes);
        return ApiResult.ok(refuse);
    }

    @PostMapping(value = "/complete")
    @ApiOperation(value = "执行记录-更新执行记录为完成")
    public ApiResult<Long> complete(@RequestBody List<String> codes) {
        Long refuse = exectRecordService.complete(codes);
        return ApiResult.ok(refuse);
    }

}
