package com.elitesland.yst.production.sale.controller.sal;

import com.alibaba.fastjson.JSONObject;
//import com.elitesland.yst.production.sale.api.service.SalContractService;
import com.elitesland.yst.production.sale.api.service.SalContractService;
import com.elitesland.yst.production.sale.api.vo.param.pro.SalContractApprParam;
import com.elitesland.yst.production.sale.api.vo.param.pro.SalContractPagingParam;
import com.elitesland.yst.production.sale.api.vo.param.pro.SalContractQueryParam;
import com.elitesland.yst.production.sale.api.vo.param.pro.SalContractSaveParam;
import com.elitesland.yst.production.sale.api.vo.resp.pro.SalContractDetailRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.pro.SalContractItemRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.pro.SalContractPageRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.pro.SalContractSimpleRespVO;
import com.elitesland.yst.production.sale.api.vo.save.SalContractImportSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.SalContractItemImportSaveVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.controller.BaseController;
import com.elitesland.yst.production.sale.core.util.excel.support.ExportColumnParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import netscape.javascript.JSObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.util.ArrayList;
import java.util.List;

/**
 * 项目合同相关API
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/6/7 4:33 下午
 */
@RestController
@RequestMapping(value = "/proj/contract", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(tags = "销售合同")
public class SalContractController extends BaseController {

    @Autowired
    private SalContractService salContractService;

    @PostMapping(value = "/query")
    @ApiOperation(value = "项目合同分页查询")
    @ApiOperationSupport(order = 1)
    public ApiResult<PagingVO<SalContractPageRespVO>> query(@RequestBody SalContractPagingParam pageParam) {
        return ApiResult.ok(salContractService.query(pageParam));
    }

    @PostMapping(value = "/save")
    @ApiOperation(value = "项目合同保存")
    @ApiOperationSupport(order = 2)
    public ApiResult<JSONObject> save(@RequestBody @Valid SalContractSaveParam param) {
        JSONObject result = salContractService.saveOrSubmit(param, UdcEnum.SAL_CONTRACT_STATUS_DRAFT.getValueCode());
        return ApiResult.ok(result);
    }

    @PostMapping(value = "/submit")
    @ApiOperation(value = "项目合同提交")
    @ApiOperationSupport(order = 3)
    public ApiResult<JSONObject> submit(@RequestBody @Valid SalContractSaveParam param) {
        JSONObject result = salContractService.saveOrSubmit(param, UdcEnum.SAL_CONTRACT_STATUS_APPROVING.getValueCode());
        return ApiResult.ok(result);
    }



}
