package com.elitesland.yst.production.sale.controller.shop;

import com.elitesland.yst.production.sale.api.service.shop.BipCompanyManageService;
import com.elitesland.yst.production.sale.api.vo.param.sal.SalPayDepositApproveParamVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipCompanyManageParamVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipCompanyManageSwitchParamVO;
import com.elitesland.yst.production.sale.api.vo.resp.sal.SalPayDepositRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipCompanyManageRespVO;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/9/27 09:59
 */
@RestController
@RequestMapping("/bip/companyManage")
@Api(value = "商城公司管理", tags = {"商城公司管理"})
@RequiredArgsConstructor
public class BipCompanyManageController {

    private final BipCompanyManageService bipCompanyManageService;

    @PostMapping(value = "/search")
    @ApiOperation(value = "分页查询商城公司")
    @ApiOperationSupport(order = 1)
    public ApiResult<PagingVO<BipCompanyManageRespVO>> search(@RequestBody BipCompanyManageParamVO searchParam) {
        return ApiResult.ok(bipCompanyManageService.search(searchParam));
    }

    @PostMapping(value = "/searchForWx")
    @ApiOperation(value = "小程序查询商城公司")
    @ApiOperationSupport(order = 2)
    public ApiResult<Map<String, Object>> searchForWx(@RequestBody BipCompanyManageParamVO searchParam) {
        return ApiResult.ok(bipCompanyManageService.searchForWx(searchParam));
    }

    @GetMapping(value = "/get/{id}")
    @ApiOperation(value = "查询商城公司详细信息")
    @ApiOperationSupport(order = 3)
    public ApiResult<BipCompanyManageRespVO> getBipCompanyById(@PathVariable Long id) {
        return ApiResult.ok(bipCompanyManageService.findCompanyManageById(id));
    }

    @PostMapping(value = "/searchByOuIds")
    @ApiOperation(value = "通过公司ID查询商城公司信息")
    @ApiOperationSupport(order = 3)
    public ApiResult<List<BipCompanyManageRespVO>> getBipCompanyByOuIds(@RequestBody List<Long> ouIds) {
        return ApiResult.ok(bipCompanyManageService.findCompanyManageByOuIds(ouIds));
    }

    @PostMapping(value = "/save")
    @ApiOperation(value = "保存商城公司信息")
    @ApiOperationSupport(order = 4)
    public ApiResult<Long> createBipCompany(@RequestBody BipCompanyManageRespVO bipCompanyManageRespVO) {
        return ApiResult.ok(bipCompanyManageService.createCompanyManage(bipCompanyManageRespVO));
    }

    @PostMapping(value = "/switchStatus")
    @ApiOperation(value = "显示隐藏商城公司")
    @ApiOperationSupport(order = 5)
    public ApiResult<Object> switchBipCompany(@RequestBody BipCompanyManageSwitchParamVO bipCompanyManageSwitchParamVO) {
        bipCompanyManageService.approveCompanyManage(bipCompanyManageSwitchParamVO);
        return ApiResult.ok();
    }


    @PostMapping(value = "/delete")
    @ApiOperation(value = "删除商城公司")
    @ApiOperationSupport(order = 6)
    public ApiResult<Object> deleteBipCompany(@RequestBody List<Long> ids) {
        bipCompanyManageService.deleteCompanyManage(ids);
        return ApiResult.ok();
    }


    @PostMapping(value = "/searchFirst")
    @ApiOperation(value = "首页默认公司")
    @ApiOperationSupport(order = 7)
    public ApiResult<Long> searchFirst() {
        return ApiResult.ok(bipCompanyManageService.searchFirst());
    }
}
