package com.elitesland.yst.production.sale.controller.shop;
import com.elitesland.yst.production.sale.api.service.shop.BipHelpCenterService;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipHelpCreateParam;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipHelpQueryParam;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipHelpCenterRespVO;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author Joker (Xing Shixiang)
 * @create 2021-08-10 15:31
 */
@RestController
@RequestMapping(value = "/bip/helpCenter", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(tags = "帮助中心")
@ApiSupport(author = "Xing", order = 1)
@Slf4j
public class BipHelpCenterController {
    @Autowired
    private BipHelpCenterService bipHelpCenterService;
    @GetMapping(value = "/applets/findAll")
    @ApiOperation(value = "查询所有帮助文档title")
    @ApiOperationSupport(order = 1)
    public ApiResult<List<BipHelpCenterRespVO>> appfindAll() {
        List<BipHelpCenterRespVO> all = bipHelpCenterService.appfindAll();
        return ApiResult.ok(all);
    }
    @GetMapping(value = "/applets/getHelp/{id}")
    @ApiOperation(value = "根据文档id查询文档详情")
    @ApiOperationSupport(order = 2)
    public ApiResult<BipHelpCenterRespVO> getHelpById(@PathVariable Long id) {
        BipHelpCenterRespVO result = bipHelpCenterService.getHelpById(id);
        return ApiResult.ok(result);
    }
    @PostMapping(value = "/findAll")
    @ApiOperation(value = "管理端--查询所有帮助文档")
    @ApiOperationSupport(order = 3)
    public ApiResult<PagingVO<BipHelpCenterRespVO>> getHelpById(@RequestBody BipHelpQueryParam param) {
        PagingVO<BipHelpCenterRespVO> all = bipHelpCenterService.findAll(param);
        return ApiResult.ok(all);
    }
    @GetMapping(value = "/status/{id}/{status}")
    @ApiOperation(value = "管理端--更改状态")
    @ApiOperationSupport(order = 4)
    public ApiResult<Long> updateStatus(@PathVariable Long id , @PathVariable String status) {
        return ApiResult.ok(bipHelpCenterService.updateStatus(id,status));
    }

    @DeleteMapping(value = "/status/{id}/{deleteFlag}")
    @ApiOperation(value = "管理端--删除")
    @ApiOperationSupport(order = 5)
    public ApiResult<Long> updateDeleteFlag(@PathVariable Long id , @PathVariable Integer deleteFlag) {
        return ApiResult.ok(bipHelpCenterService.updateDeleteFlag(id,deleteFlag));
    }
    @PostMapping(value = "/save")
    @ApiOperation(value = "管理端--保存一条帮助文档")
    @ApiOperationSupport(order = 6)
    public ApiResult<Long> saveHelp(@RequestBody BipHelpCreateParam param) {
        return ApiResult.ok(bipHelpCenterService.saveHelp(param));
    }
}
