package com.elitesland.yst.production.sale.convert;

import com.elitescloud.cloudt.core.common.BaseMapperConfig;
import com.elitescloud.cloudt.system.dto.SysEmployeeDetailDTO;
import com.elitescloud.cloudt.system.dto.req.EmployeePageQueryDTO;
import com.elitescloud.cloudt.system.dto.req.EmployeeUpsertDTO;
import com.elitescloud.cloudt.system.dto.resp.EmployeePageRespDTO;
import com.elitescloud.cloudt.system.dto.resp.EmployeeUnderlingDTO;
import com.elitesland.yst.production.sale.api.vo.param.salesman.SalesmanInfoQueryVO;
import com.elitesland.yst.production.sale.api.vo.param.salesman.SalesmanRegionVO;
import com.elitesland.yst.production.sale.api.vo.resp.salesman.EmployeeDetailInfoRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.salesman.EmployeeInfoRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.salesman.SalesmanInfoDetailRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.salesman.SalesmanInfoStdVO;
import com.elitesland.yst.production.sale.api.vo.save.SalesmanImportSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.SalesmanInfoSaveVO;
import com.elitesland.yst.production.sale.dto.SalemanCustDTO;
import com.elitesland.yst.production.sale.dto.SalesmanLevelInfoDTO;
import com.elitesland.yst.production.sale.entity.SalesmanInfoDO;
import com.elitesland.yst.production.sale.entity.SalesmanRegionDO;
import com.elitesland.yst.production.sale.search.bean.SalesmanInfoSearchBean;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.factory.Mappers;

import java.util.List;

/**
 * @author Danny.Wang
 * @title SalesmanInfoConvert
 * @Date2023/2/21 16:12
 */
@Mapper(config = BaseMapperConfig.class)
public interface SalesmanInfoConvert {

    SalesmanInfoConvert INSTANCE = Mappers.getMapper(SalesmanInfoConvert.class);

    SalesmanInfoDO salesmanInfoSaveToDO(SalesmanInfoSaveVO salesmanInfoSaveVO);
    SalesmanInfoDO salesmanImportSaveToDO(SalesmanImportSaveVO salesmanInfoSaveVO);
    @Mapping(target = "jurisdiction", ignore = true)
    SalesmanInfoDetailRespVO salesmanInfoDOToDetailRespVO(SalesmanInfoDO salesmanInfoDO);

    @Mappings({
            @Mapping(source = "name",target = "fullName"),
            @Mapping(source = "loginAccount",target = "username"),
            @Mapping(source = "sex",target = "gender"),
            @Mapping(source = "idCardNo",target = "idCard"),
            @Mapping(source = "detailedAddress",target = "address"),
            @Mapping(target = "id", ignore = true),
            @Mapping(target = "joinTime", ignore = true),
    })
    EmployeeUpsertDTO salesmanInfoSaveVOToUpsertDTO(SalesmanInfoSaveVO salesmanInfoSaveVO);

    @Mappings({
            @Mapping(source = "name",target = "fullName"),
            @Mapping(source = "loginAccount",target = "username"),
            @Mapping(source = "sex",target = "gender"),
            @Mapping(source = "idCardNo",target = "idCard"),
            @Mapping(source = "detailedAddress",target = "address"),
            @Mapping(target = "id", ignore = true),
            @Mapping(target = "joinTime", ignore = true),
    })
    EmployeeUpsertDTO salesmanImportSaveVOToUpsertDTO(SalesmanImportSaveVO salesmanInfoSaveVO);

    @Mappings({
            @Mapping(source = "loginAccount",target = "username"),
    })
    EmployeePageQueryDTO salesmanInfoQueryVOToQueryDTO(SalesmanInfoQueryVO salesmanInfoQueryVO);

    List<EmployeeInfoRespVO> employeePageRespDTOToEmployeeInfoRespVO(List<EmployeePageRespDTO> employeePageRespDTO);

    EmployeeDetailInfoRespVO SysEmployeeDetailDTOToRespVO(SysEmployeeDetailDTO sysEmployeeDetailDTO);

    List<EmployeeInfoRespVO> employeeUnderlingDTOToRespVO(List<EmployeeUnderlingDTO> employeeInfoRespVO);

    List<SalesmanRegionVO> salesmanRegionDOToVo(List<SalesmanRegionDO> salesmanRegionDOS);

    SalemanCustDTO salesmanCoverLevel(SalesmanLevelInfoDTO salesmanLevelInfoDTO);

    SalesmanInfoDO searchBeanToDO(SalesmanInfoSearchBean param);

    SalesmanInfoStdVO doToVo(SalesmanInfoDO salesmanInfoDO);
}
