package com.elitesland.yst.production.sale.convert.shop;

import com.elitesland.yst.production.sale.api.vo.resp.shop.BipItemCategoryRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.ItemCatTreeAllRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.ItemCatTreeRespVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipItemCategorySaveVO;
import com.elitesland.yst.production.sale.core.mapstruct.CustomMapperConfig;
import com.elitesland.yst.production.sale.entity.BipItemCategoryDO;
import org.mapstruct.Mapper;
import org.mapstruct.MappingTarget;
import org.mapstruct.factory.Mappers;

import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021/08/18
 */
@Mapper(config = CustomMapperConfig.class)
public interface BipItemCategoryConvert {

    BipItemCategoryConvert INSTANCE = Mappers.getMapper(BipItemCategoryConvert.class);

    /**
     * vo转do
     *
     * @param saveVO vo
     * @return do
     */
    BipItemCategoryDO vo2DO(BipItemCategorySaveVO saveVO);

    /**
     * vo往do负责
     *
     * @param saveVO     vo
     * @param categoryDO do
     */
    void copyVO2DO(BipItemCategorySaveVO saveVO, @MappingTarget BipItemCategoryDO categoryDO);

    /**
     * do转vo
     *
     * @param doo do
     * @return vo
     */
    BipItemCategoryRespVO do2VO(BipItemCategoryDO doo);

    /**
     * do转树形vo
     *
     * @param doList do列表
     * @return 树形vo
     */
    List<ItemCatTreeRespVO> do2TreeVO(List<BipItemCategoryDO> doList);

    /**
     * do转树形vo
     *
     * @param doList do列表
     * @return 树形vo
     */
    List<ItemCatTreeAllRespVO> do2TreeAllVO(List<BipItemCategoryDO> doList);
}
