package com.elitesland.yst.production.sale.core.service;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.cloudt.system.provider.SysUserRpcService;
import com.elitesland.yst.production.sale.common.model.CurrentUserDTO;
import com.elitesland.yst.production.sale.common.model.UserDTO;
import com.elitesland.yst.production.sale.core.convert.UserConvert;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.vo.SysUserVO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 用户相关服务接口.
 *
 * @author Kaiser（wang shao）
 * @date 2021-05-08
 */
@Component
@Slf4j
public class UserService {

    @Autowired
    private SysUserRpcService sysUserService;


    /**
     * 获取当前用户信息
     *
     * @return 用户信息
     */
    public static CurrentUserDTO currentUser() {
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        if (userDetails == null) {
            return null;
        }
        CurrentUserDTO user = USER_CONVERT.convert(userDetails);
        user.setDetail(USER_CONVERT.convert(userDetails.getUser()));
        user.setUserId(userDetails.getUser().getId());

        return user;
    }

    /**
     * 获取用户信息
     *
     * @param sysUserId 系统用户ID
     * @return 用户信息
     */
    public UserDTO getUser(Long sysUserId) {
        Assert.notNull(sysUserId, "用户ID为空");

        var sysUserDTO = sysUserService.getById(sysUserId);
        if (sysUserDTO == null) {
            log.error("未查询到用户信息：{}", sysUserId);
            return null;
        }
        return USER_CONVERT.convert(sysUserDTO);
    }

    public List<SysUserVO> getUsers(List<Long> ids) {
        Assert.notNull(ids, "用户ID为空");

        var sysUserDTOS = sysUserService.getByIds(ids);
        if (sysUserDTOS == null || sysUserDTOS.size()<1) {
            log.error("未查询到用户信息：{}", ids);
            return null;
        }
        return sysUserDTOS;
    }

    /**
     * 根据登录号获取用户信息
     *
     * @param username 登录号
     * @return 用户信息
     */
    public UserDTO getUser(String username) {
        Assert.notBlank(username, "用户名为空");

        var sysUserDTO = sysUserService.getUserByUsername(username);
        if (sysUserDTO == null) {
            log.error("未查询到用户信息：{}", username);
            return null;
        }
        return USER_CONVERT.convert(sysUserDTO.getData());
    }

    private static final UserConvert USER_CONVERT = UserConvert.INSTANCE;
}
